/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.awt.KMHorizontalButtonPanel;
import com.ibm.gsk.ikeyman.basic.IkeymanConstants;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

public class KMInputFileDialog
extends JDialog
implements IkeymanConstants,
ActionListener {
    private KMButton okButton;
    private KMButton cancelButton;
    private KMButton helpButton;
    private KMButton browseButton;
    private JLabel fileNameLabel;
    private JTextField fileNameField;
    private JLabel dirNameLabel;
    private JTextField dirNameField;
    private KeyDatabase keyDb;
    private String currWorkingDirName;
    private int mode;
    private String browserFileName;
    private String browserDirName;
    FilenameFilter fileNameFilter;
    JPanel mainPanel = new JPanel();
    JPanel fileNamePanel = new JPanel();
    private String fileName;
    private String dirName;
    private JDialog diagInstance;

    public KMInputFileDialog(Frame frame, String string) {
        this(frame, string, null, 0);
    }

    public KMInputFileDialog(Frame frame, String string, KeyDatabase keyDatabase, int n) {
        this(frame, string, keyDatabase, Ikeyman.getNLSResString("GUI_LABEL_FILENAME"), n);
    }

    public KMInputFileDialog(Frame frame, String string, KeyDatabase keyDatabase, String string2, int n) {
        super(frame, string, true);
        this.keyDb = keyDatabase;
        this.mode = n;
        this.diagInstance = this;
        this.populateFields();
        this.fileNameLabel.setText(string2);
        this.mainPanel.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.fileNamePanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.fileNameLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.fileNameField, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 0, 5, 5);
        gridBagLayout.setConstraints(this.browseButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints(this.dirNameLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints(this.dirNameField, gridBagConstraints);
        this.fileNamePanel.add(this.fileNameLabel);
        this.fileNamePanel.add(this.fileNameField);
        this.fileNamePanel.add(this.browseButton);
        this.fileNamePanel.add(this.dirNameLabel);
        this.fileNamePanel.add(this.dirNameField);
        KMHorizontalButtonPanel kMHorizontalButtonPanel = new KMHorizontalButtonPanel();
        kMHorizontalButtonPanel.add(this.okButton);
        kMHorizontalButtonPanel.add(this.cancelButton);
        kMHorizontalButtonPanel.add(this.helpButton);
        kMHorizontalButtonPanel.equalizeButtons();
        this.mainPanel.add((Component)this.fileNamePanel, "Center");
        this.mainPanel.add((Component)kMHorizontalButtonPanel, "South");
        BevelBorder bevelBorder = new BevelBorder(0);
        this.mainPanel.setBorder(bevelBorder);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.mainPanel, "Center");
        this.addWindowListener(new DiagAdapter());
        this.pack();
        this.setResizable(false);
        this.fileNameField.requestFocus();
    }

    protected void populateFields() {
        this.populateInputFields();
        this.populateButtons();
        this.setToolTips();
    }

    protected void populateInputFields() {
        int n = 45;
        if (Ikeyman.screenSize.width < 800) {
            n = 25;
        } else if (Ikeyman.screenSize.width < 1024) {
            n = 35;
        }
        String string = Locale.getDefault().getLanguage();
        if (string.equals("ja")) {
            n *= 2;
        }
        this.fileNameLabel = new JLabel();
        this.fileNameField = new JTextField(n);
        new File(".");
        int n2 = 0;
        if (this.keyDb != null) {
            n2 = this.keyDb.getType();
        }
        this.currWorkingDirName = KeyDatabase.getDefaultKeyDbFileLocation(n2);
        this.dirNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_LOCATION"));
        this.dirNameField = new JTextField(this.currWorkingDirName, n);
        if (string.equals("ko") || string.equals("ja")) {
            this.fileNameField.setFont(Ikeyman.defaultMonospacedFont);
            this.dirNameField.setFont(Ikeyman.defaultMonospacedFont);
        }
    }

    protected void populateButtons() {
        this.browseButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_BROWSE"));
        this.okButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.cancelButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CANCEL"));
        this.helpButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_HELP"));
        this.browseButton.setActionCommand("Browse");
        this.okButton.setActionCommand("OK");
        this.cancelButton.setActionCommand("Cancel");
        this.helpButton.setActionCommand("Help");
        this.browseButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        if (!Ikeyman.isHelpAvailable()) {
            this.helpButton.setEnabled(false);
        }
    }

    protected void setToolTips() {
        this.fileNameField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_FILE_NAME"));
        this.dirNameField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_FILE_LOCATION"));
    }

    public String getFileName() {
        String string = this.fileName;
        return KMUtil.trimBlankSpace(string, true, true);
    }

    public String getDirName() {
        String string = this.dirName;
        return KMUtil.trimBlankSpace(string, true, true);
    }

    public void setFileName(String string) {
        this.fileNameField.setText(string);
    }

    public void setDirName(String string) {
        this.dirNameField.setText(string);
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.fileNameFilter = filenameFilter;
    }

    public void setFileNameLabelText(String string) {
        this.setResizable(true);
        this.fileNameLabel.setText(string);
        this.fileNameLabel.invalidate();
        this.fileNamePanel.validate();
        this.mainPanel.validate();
        this.pack();
        this.setResizable(false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void actionPerformed(ActionEvent var1_1) {
        block18: {
            block14: {
                block15: {
                    block13: {
                        block16: {
                            block17: {
                                block12: {
                                    var1_1.getSource();
                                    var2_2 = var1_1.getActionCommand();
                                    if (!var2_2.equals("OK")) break block15;
                                    this.fileName = this.fileNameField.getText();
                                    this.dirName = this.dirNameField.getText();
                                    if (this.fileName.equals("") || this.fileName.indexOf(42) >= 0 || KMUtil.trimBlankSpace((String)(var3_3 = this.fileName), true, true) == null) break block16;
                                    if (this.dirName == null) {
                                        this.dirName = this.currWorkingDirName;
                                    }
                                    if (!this.dirName.endsWith(File.separator)) {
                                        this.dirName = String.valueOf(this.dirName) + File.separator;
                                    }
                                    if (Ikeyman.isOverwriteConfirmedFileDialog() && this.fileName.equals(this.browserFileName) && this.dirName.equals(this.browserDirName) || this.mode != 1 || !(var3_3 = new File(this.dirName, this.fileName)).exists()) break block17;
                                    var4_5 /* !! */  = this;
                                    if (!(var4_5 /* !! */  instanceof Frame)) ** GOTO lbl20
                                    v0 = (Frame)var4_5 /* !! */ ;
                                    break block12;
lbl-1000:
                                    // 1 sources

                                    {
                                        if (!(var4_5 /* !! */  instanceof Frame)) continue;
                                        v0 = (Frame)var4_5 /* !! */ ;
                                        break block12;
lbl20:
                                        // 2 sources

                                        ** while ((var4_5 /* !! */  = var4_5 /* !! */ .getParent()) != null)
                                    }
lbl21:
                                    // 1 sources

                                    v0 = null;
                                }
                                var4_6 = KMFrame.showConfirmDialog(v0, Ikeyman.getNLSResString("GUI_DIALOG_QST_OVERWRITE_KDB_FILE"), 1);
                                if (var4_6 != 0) {
                                    this.fileNameField.requestFocus();
                                    return;
                                }
                            }
                            this.setVisible(false);
                            return;
                        }
                        var3_3 = this;
                        if (!(var3_3 instanceof Frame)) ** GOTO lbl38
                        v1 = (Frame)var3_3;
                        break block13;
lbl-1000:
                        // 1 sources

                        {
                            if (!(var3_3 instanceof Frame)) continue;
                            v1 = (Frame)var3_3;
                            break block13;
lbl38:
                            // 2 sources

                            ** while ((var3_3 = var3_3.getParent()) != null)
                        }
lbl39:
                        // 1 sources

                        v1 = null;
                    }
                    KMFrame.errorHandler(v1, KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
                    this.fileNameField.requestFocus();
                    return;
                }
                if (var2_2.equals("Cancel")) {
                    if (Ikeyman.printDebugMsg) {
                        Ikeyman.debugMsg("Cancel button is hit\n");
                    }
                    this.fileName = null;
                    this.dirName = null;
                    this.setVisible(false);
                    return;
                }
                if (!var2_2.equals("Browse")) break block18;
                if (Ikeyman.printDebugMsg) {
                    Ikeyman.debugMsg("Browse button is hit\n");
                }
                if (!((var3_4 = this) instanceof Frame)) ** GOTO lbl61
                v2 = (Frame)var3_4;
                break block14;
lbl-1000:
                // 1 sources

                {
                    if (!(var3_4 instanceof Frame)) continue;
                    v2 = (Frame)var3_4;
                    break block14;
lbl61:
                    // 2 sources

                    ** while ((var3_4 = var3_4.getParent()) != null)
                }
lbl62:
                // 1 sources

                v2 = null;
            }
            var3_4 = new FileDialog(v2, Ikeyman.getNLSResString("GUI_DIALOG_TITLE_KEYDBFILE"), this.mode);
            var3_4.setFile(this.fileNameField.getText());
            var3_4.setDirectory(this.dirNameField.getText());
            if (this.fileNameFilter != null) {
                var3_4.setFilenameFilter(this.fileNameFilter);
            }
            var4_7 = var3_4.getSize();
            var3_4.setLocation((Ikeyman.screenSize.width - var4_7.width) / 2, (Ikeyman.screenSize.height - var4_7.height) / 2);
            var3_4.setVisible(true);
            this.browserFileName = var3_4.getFile();
            if (this.browserFileName != null) {
                this.fileNameField.setText(this.browserFileName);
                this.browserDirName = var3_4.getDirectory();
                this.dirNameField.setText(this.browserDirName);
                this.fileName = this.browserFileName;
                this.dirName = this.browserDirName;
            }
            var3_4.dispose();
            return;
        }
        if (var2_2.equals("Help")) {
            Ikeyman.showHelpWindow(this, "packages.html");
        }
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.okButton.requestFocus();
    }

    static /* synthetic */ String access$0(KMInputFileDialog kMInputFileDialog) {
        return kMInputFileDialog.fileName;
    }

    static /* synthetic */ void access$1(KMInputFileDialog kMInputFileDialog, String string) {
        kMInputFileDialog.fileName = string;
    }

    static /* synthetic */ String access$2(KMInputFileDialog kMInputFileDialog) {
        return kMInputFileDialog.dirName;
    }

    static /* synthetic */ void access$3(KMInputFileDialog kMInputFileDialog, String string) {
        kMInputFileDialog.dirName = string;
    }

    class DiagAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            KMInputFileDialog kMInputFileDialog = KMInputFileDialog.this;
            kMInputFileDialog.fileName = null;
            kMInputFileDialog = KMInputFileDialog.this;
            kMInputFileDialog.dirName = null;
            ((Component)KMInputFileDialog.this).setVisible(false);
        }

        DiagAdapter() {
            KMInputFileDialog.this = KMInputFileDialog.this;
        }
    }
}

