/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.basic.BERObject;
import com.ibm.gsk.ikeyman.basic.BERObjectParser;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import java.util.Date;

public class CertificateItem
extends BERObject
implements BERObjectParser {
    public static final short X509V1 = 1;
    public static final short X509V2 = 2;
    public static final short X509V3 = 3;
    public static final String[] CERTIFICATE_VERSIONS = new String[]{"X509 V1", "X509 V2", "X509 V3"};
    private short version;
    private short keySize;
    private String serialNum;
    private DNItem issuer;
    private DNItem subject;
    private Date validNotBefore;
    private Date validNotAfter;
    private byte[] signature;
    private BERObject sigAlgIdBER;
    private String sigAlgIdOID;
    private String sigAlgIdOIDName;
    private BERObject spkiBER;
    private BERObject certExtensionsBER;
    private boolean isIssuerUniIdPresent;
    private boolean isSubjUniIdPresent;
    private boolean isExtsPresent;
    private byte[] unsignedCert;

    public CertificateItem(byte[] byArray) {
        super(byArray);
    }

    public CertificateItem() {
        this(1, 0, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public CertificateItem(short s, short s2, String string, DNItem dNItem, DNItem dNItem2, Date date, Date date2, BERObject bERObject, BERObject bERObject2, byte[] byArray, BERObject bERObject3, String string2, String string3) {
        this(s, s2, string, dNItem, dNItem2, date, date2, bERObject, bERObject2, byArray, bERObject3, string2, string3, null, null);
        this.collapse();
    }

    public CertificateItem(short s, short s2, String string, DNItem dNItem, DNItem dNItem2, Date date, Date date2, BERObject bERObject, BERObject bERObject2, byte[] byArray, BERObject bERObject3, String string2, String string3, byte[] byArray2) {
        this(s, s2, string, dNItem, dNItem2, date, date2, bERObject, bERObject2, byArray, bERObject3, string2, string3, null, byArray2);
    }

    public CertificateItem(short s, short s2, String string, DNItem dNItem, DNItem dNItem2, long l, long l2, BERObject bERObject, BERObject bERObject2, byte[] byArray, BERObject bERObject3, String string2, String string3, byte[] byArray2, byte[] byArray3) {
        this(s, s2, string, dNItem, dNItem2, new Date(l * 1000L), new Date(l2 * 1000L), bERObject, bERObject2, byArray, bERObject3, string2, string3, byArray2, byArray3);
    }

    public CertificateItem(short s, short s2, String string, DNItem dNItem, DNItem dNItem2, Date date, Date date2, BERObject bERObject, BERObject bERObject2, byte[] byArray, BERObject bERObject3, String string2, String string3, byte[] byArray2, byte[] byArray3) {
        this.version = s;
        this.keySize = s2;
        this.serialNum = string;
        this.issuer = dNItem;
        this.subject = dNItem2;
        this.validNotBefore = date != null ? new Date(date.getTime()) : null;
        this.validNotAfter = date2 != null ? new Date(date2.getTime()) : null;
        if (byArray == null) {
            this.signature = null;
        } else {
            this.signature = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.signature, 0, byArray.length);
        }
        this.sigAlgIdBER = bERObject3;
        this.sigAlgIdOID = string2;
        this.sigAlgIdOIDName = string3;
        this.spkiBER = bERObject;
        this.certExtensionsBER = bERObject2;
        this.isIssuerUniIdPresent = false;
        this.isSubjUniIdPresent = false;
        this.isExtsPresent = this.certExtensionsBER != null;
        if (byArray2 == null) {
            this.unsignedCert = null;
        } else {
            this.unsignedCert = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.unsignedCert, 0, byArray2.length);
        }
        this.setEncoded(byArray3);
    }

    public void expand() {
    }

    public void collapse() {
        this.berData = null;
    }

    public String getFingerPrint() {
        String string = "- not computed -";
        if (this.berData != null) {
            byte[] byArray = this.berData;
            string = KMUtil.getDigest(byArray, "MD5");
        }
        return string;
    }

    public short getVersion() {
        return this.version;
    }

    public short getKeySize() {
        return this.keySize;
    }

    public String getSerialNumber() {
        return this.serialNum;
    }

    public DNItem getIssuer() {
        return this.issuer;
    }

    public DNItem getSubject() {
        return this.subject;
    }

    public void setSubject(DNItem dNItem) {
        this.subject = dNItem;
    }

    public Date getValidNotBefore() {
        return this.validNotBefore;
    }

    public Date getValidNotAfter() {
        return this.validNotAfter;
    }

    public boolean isExpired() {
        boolean bl = false;
        if (this.validNotAfter != null && this.validNotAfter.before(new Date())) {
            bl = true;
        }
        return bl;
    }

    public BERObject getSubjectPublicKeyInfoBER() {
        return this.spkiBER;
    }

    public BERObject getCertificateExtensions() {
        return this.certExtensionsBER;
    }

    public byte[] getUnsignedCert() {
        return this.unsignedCert;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public String getSigAlgorithmIdOID() {
        return this.sigAlgIdOID;
    }

    public String getSigAlgorithmIdOIDName() {
        return this.sigAlgIdOIDName;
    }

    public boolean isIssuerUniqueIdPresent() {
        return this.isIssuerUniIdPresent;
    }

    public boolean isSubjUniqueIdPresent() {
        return this.isSubjUniIdPresent;
    }

    public boolean isExtensionsPresent() {
        return this.isExtsPresent;
    }

    public String toString() {
        return this.paramString();
    }

    public String paramString() {
        if (this.subject != null) {
            this.subject.toString();
        }
        if (this.issuer != null) {
            this.issuer.toString();
        }
        try {
            return String.valueOf(super.toString()) + ", version=" + CERTIFICATE_VERSIONS[this.version - 1] + ", serialNum=" + this.serialNum + ", keySize=" + this.keySize + ", subject" + this.subject + ", issuer=" + this.issuer + ", validity=[" + this.validNotBefore + ", " + this.validNotAfter + "], signatureAlgorithm=" + this.sigAlgIdOIDName + "(" + this.sigAlgIdOID + "), extensions=" + this.certExtensionsBER;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Error error) {
            error.printStackTrace();
        }
        return null;
    }
}

