/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.asn1.ASN1Exception;
import com.ibm.asn1.ASN1OID;
import com.ibm.asn1.BERDecoder;
import com.ibm.cfwk.pkcs.PKCS12PBE;
import com.ibm.cfwk.pkcs.PKCSException;
import com.ibm.cfwk.pki.X509Cert;
import com.ibm.cfwk.pki.X509Chain;
import com.ibm.cfwk.tools.PrivateKeyAndCertificateChain;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.PrivateKeyInfoItem;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class KMpkcs12 {
    private String filename;
    private String password;
    private boolean encoded = false;
    private boolean decoded = false;
    private int version;
    private int iterationCount = 1;
    private ASN1OID encodingAlgorithm = PKCS12PBE.SHA1_RC2_40;
    private byte[] encodedPKCS12Data;
    private KeyItem[] keyItemChain;
    private int numItems;
    private PrivateKeyInfoItem unencPvtKey;

    public KMpkcs12(String string, String string2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        int n = ((InputStream)fileInputStream).available();
        this.encodedPKCS12Data = new byte[n];
        ((InputStream)fileInputStream).read(this.encodedPKCS12Data);
        ((InputStream)fileInputStream).close();
        this.password = string2;
        this.encoded = true;
        this.decoded = false;
    }

    public KMpkcs12(String string, String string2, KeyItem[] keyItemArray, PrivateKeyInfoItem privateKeyInfoItem) {
        this.filename = string;
        this.password = string2;
        this.keyItemChain = keyItemArray;
        this.unencPvtKey = privateKeyInfoItem;
        this.encoded = false;
        this.encodedPKCS12Data = null;
        if (keyItemArray != null) {
            this.numItems = keyItemArray.length;
        }
        if (this.numItems > 0) {
            this.decoded = true;
            return;
        }
        this.decoded = false;
    }

    public void writeFile() throws IOException {
        if (this.encoded && this.encodedPKCS12Data != null && this.encodedPKCS12Data.length > 0) {
            FileOutputStream fileOutputStream = new FileOutputStream(this.filename);
            ((OutputStream)fileOutputStream).write(this.encodedPKCS12Data);
            ((OutputStream)fileOutputStream).close();
        }
    }

    public void encode() throws Exception {
        if (this.encoded) {
            return;
        }
        CertificateItem certificateItem = null;
        if (this.decoded && this.numItems > 0) {
            try {
                X509Cert[] x509CertArray = new X509Cert[this.numItems];
                String[] stringArray = new String[this.numItems];
                int n = 0;
                while (n < this.numItems) {
                    if (this.keyItemChain[n].hasCertificate()) {
                        certificateItem = (CertificateItem)this.keyItemChain[n].getCertificateChain().elementAt(0);
                        x509CertArray[n] = new X509Cert(certificateItem.getEncoded());
                    }
                    stringArray[n] = this.keyItemChain[n].getKeyLabel();
                    ++n;
                }
                X509Chain x509Chain = new X509Chain(x509CertArray);
                byte[] byArray = this.unencPvtKey.getEncoded();
                byte[] byArray2 = new byte[]{1, 2, 3};
                PrivateKeyAndCertificateChain privateKeyAndCertificateChain = new PrivateKeyAndCertificateChain(byArray, x509Chain, stringArray, byArray2);
                this.encodedPKCS12Data = privateKeyAndCertificateChain.makePKCS12PDU(this.password, this.encodingAlgorithm, null, this.iterationCount);
                this.encoded = true;
                return;
            }
            catch (Exception exception) {
                this.encoded = false;
                throw exception;
            }
        }
    }

    public void decode() throws Exception {
        if (this.decoded) {
            return;
        }
        CertificateItem certificateItem = null;
        if (this.encoded && this.encodedPKCS12Data != null && this.encodedPKCS12Data.length > 0) {
            try {
                PrivateKeyAndCertificateChain privateKeyAndCertificateChain = new PrivateKeyAndCertificateChain(this.encodedPKCS12Data, this.password);
                X509Chain x509Chain = privateKeyAndCertificateChain.getCertificateChain();
                String[] stringArray = privateKeyAndCertificateChain.getFriendlyNames();
                this.unencPvtKey = new PrivateKeyInfoItem(privateKeyAndCertificateChain.getPrivateKey());
                privateKeyAndCertificateChain.destroyPrivateKey();
                this.numItems = x509Chain.length();
                this.keyItemChain = new KeyItem[this.numItems];
                int n = 0;
                while (n < this.numItems) {
                    certificateItem = new CertificateItem(x509Chain.cert(n).encode());
                    this.keyItemChain[n] = new KeyItem();
                    if (stringArray[n] == null) {
                        if (x509Chain.cert(n).subject().attribute("cn") != null) {
                            String string = x509Chain.cert(n).subject().attribute("cn").valueToString();
                            this.keyItemChain[n].setKeyLabel(string);
                        } else {
                            this.keyItemChain[n].setKeyLabel(null);
                        }
                    } else {
                        this.keyItemChain[n].setKeyLabel(stringArray[n]);
                    }
                    this.keyItemChain[n].addCertificate(certificateItem);
                    ++n;
                }
                this.decoded = true;
                return;
            }
            catch (PKCSException pKCSException) {
                this.decoded = false;
                if (pKCSException.getErrorCode() == PKCSException.BAD_MAC) {
                    throw new CMSKeyDatabaseException(0, KMSystem.getNLSErrString("GSKKM_ERR_PKCS12_PWD_CORRUPTION"));
                }
                throw pKCSException;
            }
        }
    }

    public int version() {
        if (this.encoded && this.version == 0) {
            try {
                BERDecoder bERDecoder = new BERDecoder(this.encodedPKCS12Data);
                bERDecoder.decodeSequence();
                this.version = bERDecoder.decodeIntegerAsInt();
            }
            catch (ASN1Exception aSN1Exception) {
                this.version = 1;
            }
        }
        return this.version;
    }

    public KeyItem[] getKeyItemChain() {
        return this.keyItemChain;
    }

    public PrivateKeyInfoItem getPvtKey() {
        return this.unencPvtKey;
    }

    public void destroyPvtKey() {
        this.unencPvtKey.destroy();
        this.unencPvtKey = null;
    }

    public void setIteration(int n) {
        if (n > 0) {
            this.iterationCount = n;
            return;
        }
        this.iterationCount = 1;
    }

    public void setEncAlg(String string) {
        if (string.equals("SHA1_RC2_40")) {
            this.encodingAlgorithm = PKCS12PBE.SHA1_RC2_40;
            return;
        }
        if (string.equals("SHA1_RC2_128")) {
            this.encodingAlgorithm = PKCS12PBE.SHA1_RC2_128;
            return;
        }
        if (string.equals("SHA1_2DES3")) {
            this.encodingAlgorithm = PKCS12PBE.SHA1_2DES3;
            return;
        }
        if (string.equals("SHA1_3DES3")) {
            this.encodingAlgorithm = PKCS12PBE.SHA1_3DES3;
            return;
        }
        if (string.equals("SHA1_RC4_40")) {
            this.encodingAlgorithm = PKCS12PBE.SHA1_RC4_40;
            return;
        }
        if (string.equals("SHA1_RC4_128")) {
            this.encodingAlgorithm = PKCS12PBE.SHA1_RC4_128;
            return;
        }
        this.encodingAlgorithm = PKCS12PBE.SHA1_RC2_40;
    }
}

