/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.asn1.ASN1OID;
import com.ibm.asn1.DEREncoder;
import com.ibm.cfwk.CFWKException;
import com.ibm.cfwk.InterfaceErrorException;
import com.ibm.cfwk.KeyMaterial;
import com.ibm.cfwk.key.RSAKey;
import com.ibm.cfwk.pkcs.PKCS12PBE;
import com.ibm.cfwk.pki.AlgId;
import com.ibm.cfwk.pki.X509Cert;
import com.ibm.cfwk.pki.X509Chain;
import com.ibm.cfwk.pki.X509Exception;
import com.ibm.cfwk.pki.X509Extension;
import com.ibm.cfwk.pki.X509Extensions;
import com.ibm.cfwk.tools.KeyCertGen;
import com.ibm.cfwk.tools.PrivateKeyAndCertificateChain;
import com.ibm.cfwk.tools.cr.pkcs10.CertificationRequest;
import com.ibm.gsk.ikeyman.basic.BERObject;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabase;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.CertificateRequestItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.EncryptedPrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperator;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.SSLightKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.WEBDBKeyDatabase;
import com.ibm.gsk_sslight.KeyStore;
import com.ibm.gsk_sslight.KeyStoreException;
import com.ibm.gsk_sslight.SSLCert;
import com.ibm.gsk_sslight.SSLException;
import com.ibm.sslight.SSLightKeyRing;
import com.ibm.util.x500name.X500Name;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class SSLightKeyDatabase
extends KeyDatabase
implements KeyDatabaseOperator {
    static final String BASE64BEGINCERT = "-----BEGIN CERTIFICATE-----";
    static final String BASE64ENDCERT = "-----END CERTIFICATE-----";
    static final String Armored64RdChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    static final String Armored64WrChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    static final int Armored64PadIndx = 64;
    static final int Armored64MaxLine = 64;
    static final int[] nameComps = new int[]{3, 7, 11, 10, 6};
    static final String[] compLabs = new String[]{"CN=", "L=", "OU=", "O=", "C="};
    static String classPackage = KeyDatabase.DEFAULT_SSLIGHT_PACKAGE_NAME;
    private KeyStore ks;
    private Vector certList;
    static final String CLASS1_ROOT_LABEL = "Verisign Class 1 Public Primary Certification Authority";
    static byte[] CLASS1_ROOT_SELF_SIGNED_CERT;
    static final String CLASS2_ROOT_LABEL = "Verisign Class 2 Public Primary Certification Authority";
    static byte[] CLASS2_ROOT_SELF_SIGNED_CERT;
    static String CLASS3_ROOT_LABEL;
    static byte[] CLASS3_ROOT_SELF_SIGNED_CERT;
    static final String RSA_SECURE_SERVER_CA_LABEL = "RSA Secure Server Certification Authority";
    static final byte[] RSA_SECURE_SERVER_CA_SELF_SIGNED_CERT;
    static final String VERISIGN_TEST_CA_LABEL = "Verisign Test CA Root Certificate";
    static final byte[] VERISIGN_TEST_CA_SELF_SIGNED_CERT;
    static final String THAWTE_ROOT_SELF_SIGNED_CERT_LABEL = "Thawte Server CA";
    static final String THAWTE_SPR_ROOT_SELF_SIGNED_CERT_LABEL = "Thawte Premium Server CA";
    static final String THAWTE_PBASIC_ROOT_SELF_SIGNED_CERT_LABEL = "Thawte Personal Basic CA";
    static final String THAWTE_PFREE_ROOT_SELF_SIGNED_CERT_LABEL = "Thawte Personal Freemail CA";
    static final String THAWTE_PPR_ROOT_SELF_SIGNED_CERT_LABEL = "Thawte Personal Premium CA";
    static final byte[] THAWTE_ROOT_SELF_SIGNED_CERT;
    static final byte[] THAWTE_SPR_ROOT_SELF_SIGNED_CERT;
    static final byte[] THAWTE_PBASIC_ROOT_SELF_SIGNED_CERT;
    static final byte[] THAWTE_PFREE_ROOT_SELF_SIGNED_CERT;
    static final byte[] THAWTE_PPR_ROOT_SELF_SIGNED_CERT;

    public SSLightKeyDatabase() {
        this.type = 3;
        this.op = this;
        this.ks = new KeyStore();
    }

    public SSLightKeyDatabase(KeyDatabase keyDatabase) {
        super(keyDatabase);
        this.type = 3;
        this.op = this;
        this.ks = new KeyStore();
    }

    public SSLightKeyDatabase(String string, String string2) {
        super(3, string, string2);
        this.op = this;
        this.ks = new KeyStore();
    }

    public SSLightKeyDatabase(String string, String string2, long l) {
        super(3, string, string2, l);
        this.op = this;
        this.ks = new KeyStore();
    }

    public void setPackageName(String string) {
        classPackage = string;
    }

    public void create() throws SSLightKeyDatabaseException {
        this.create(true);
    }

    private void create(boolean bl) throws SSLightKeyDatabaseException {
        try {
            this.ssltCreateNewKeyDb(this.keyDbFileName, this.keyDbPwd, this.keyDbPwdExpireTime);
            if (bl) {
                this.ssltAddDefaultRootCertificates();
            }
            this.save();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            try {
                this.delete();
            }
            catch (IOException iOException2) {}
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
        }
        catch (X509Exception x509Exception) {
            x509Exception.printStackTrace();
            try {
                this.delete();
            }
            catch (IOException iOException) {}
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        this.buildKeyLabelList();
    }

    public void open() throws SSLightKeyDatabaseException {
        try {
            LocalClassLoader localClassLoader = new LocalClassLoader(this.keyDbFileName);
            Class clazz = localClassLoader.loadClass(this.getFullyQualifiedClassName(this.keyDbFileName), false);
            SSLightKeyRing sSLightKeyRing = (SSLightKeyRing)clazz.newInstance();
            String string = sSLightKeyRing.getKeyRingData();
            this.ks = new KeyStore();
            this.ks.engineLoad(string, this.keyDbPwd.toCharArray());
        }
        catch (SSLException sSLException) {
            if (sSLException.getCategory() == 7 && sSLException.getError() == 1012) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_INVALID_PASSWORD"));
            }
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
        }
        catch (IOException iOException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
        }
        catch (X509Exception x509Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (Exception exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OPEN"));
        }
        this.buildKeyLabelList();
    }

    public void close() {
        this.save();
    }

    public void save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.keyDbFileName);
            this.ks.engineStore((OutputStream)fileOutputStream, this.keyDbPwd.toCharArray(), this.getFullyQualifiedClassName(this.keyDbFileName));
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        catch (X509Exception x509Exception) {
            x509Exception.printStackTrace();
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void reCreate(KeyDatabase var1_1) throws SSLightKeyDatabaseException {
        if (this.keyDbFileName == null || this.keyDbFileName.equals(var1_1.getKeyDbFileName())) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
        }
        try {
            block36: {
                block37: {
                    if (this.type == var1_1.getType()) break block36;
                    if (var1_1.getType() != 1 && var1_1.getType() != 2) break block37;
                    var2_2 = (KeyDatabaseOperator)var1_1;
                    var2_2.open();
                    this.create(false);
                    var3_5 = null;
                    var4_7 = new Enumeration[3];
                    var5_9 = var1_1.getCaCertLabelList();
                    if (var5_9 != null) {
                        var4_7[0] = var5_9.elements();
                    }
                    if ((var5_9 = var1_1.getMyCertLabelList()) != null) {
                        var4_7[1] = var5_9.elements();
                    }
                    if ((var5_9 = var1_1.getReqKeyLabelList()) != null) {
                        var4_7[2] = var5_9.elements();
                    }
                    var6_11 = 0;
                    while (var6_11 < 3) {
                        block38: {
                            if (var4_7[var6_11] != null) ** GOTO lbl48
                            break block38;
lbl-1000:
                            // 1 sources

                            {
                                var7_16 = (String)var4_7[var6_11].nextElement();
                                var8_21 = var2_2.getKeyItemByLabel(var7_16);
                                if (var6_11 == 1) {
                                    var9_23 /* !! */  = var2_2.getKeyItemListByLabel(var7_16);
                                    var10_25 = var9_23 /* !! */ .length - 1;
                                    while (var10_25 > 0) {
                                        var8_21.addCertificate((CertificateItem)var9_23 /* !! */ [var10_25].getCertificateChain().elementAt(0));
                                        --var10_25;
                                    }
                                }
                                if (var8_21.isDefault()) {
                                    var3_5 = var8_21.getKeyLabel();
                                }
                                if (var8_21.hasPrivateKey()) {
                                    var9_23 /* !! */  = var8_21.getEncryptedPrivateKeyInfoItem();
                                    var10_26 = null;
                                    if (var1_1.getType() == 1) {
                                        var10_26 = ((CMSKeyDatabase)var1_1).decryptPrivateKey((EncryptedPrivateKeyInfoItem)var9_23 /* !! */ );
                                    } else if (var1_1.getType() == 2) {
                                        var10_26 = ((WEBDBKeyDatabase)var1_1).decryptPrivateKey((EncryptedPrivateKeyInfoItem)var9_23 /* !! */ );
                                    } else {
                                        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"));
                                    }
                                    var11_28 = KeyCertGen.generateEncryptedPrivateKeyInfo((byte[])var10_26.getEncoded(), (String)this.keyDbPwd, (ASN1OID)PKCS12PBE.SHA1_3DES3);
                                    var12_29 = new EncryptedPrivateKeyInfoItem(var11_28);
                                    var8_21.setEncryptedPrivateKeyInfoItem(var12_29);
                                }
                                this.insertKey(var8_21);
lbl48:
                                // 2 sources

                                ** while (var4_7[var6_11].hasMoreElements())
                            }
                        }
                        ++var6_11;
                    }
                    var2_2.close();
                    this.save();
                    if (var3_5 != null) {
                        this.setDefaultKey(var3_5);
                    }
                    this.buildKeyLabelList();
                    return;
                }
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"));
            }
            var2_3 = new KeyStore();
            var3_6 = new File(this.keyDbFileName);
            var4_8 = var3_6.exists();
            var5_10 = null;
            try {
                var6_12 = var1_1.getKeyDbFileName();
                var7_17 = new LocalClassLoader(var6_12);
                var8_22 = var7_17.loadClass(this.getFullyQualifiedClassName(var6_12), false);
                var9_24 = (SSLightKeyRing)var8_22.newInstance();
                var10_27 = var9_24.getKeyRingData();
                var2_3.engineLoad(var10_27, var1_1.getKeyDbPwd().toCharArray());
                var5_10 = new FileOutputStream(var3_6);
                var2_3.engineStore((OutputStream)var5_10, this.keyDbPwd.toCharArray(), this.getFullyQualifiedClassName(this.keyDbFileName));
                var5_10.close();
                this.buildKeyLabelList();
                return;
            }
            catch (IOException var6_13) {
                try {
                    if (var5_10 != null) {
                        var5_10.close();
                    }
                }
                catch (IOException var7_18) {
                    var7_18.printStackTrace();
                    throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
                }
                if (!var4_8 && var3_6.exists()) {
                    var3_6.delete();
                }
                var6_13.printStackTrace();
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
            }
            catch (X509Exception var6_14) {
                try {
                    if (var5_10 != null) {
                        var5_10.close();
                    }
                }
                catch (IOException var7_19) {
                    var7_19.printStackTrace();
                    throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
                }
                if (!var4_8 && var3_6.exists()) {
                    var3_6.delete();
                }
                var6_14.printStackTrace();
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
            }
            catch (Exception var6_15) {
                try {
                    if (var5_10 != null) {
                        var5_10.close();
                    }
                }
                catch (IOException var7_20) {
                    var7_20.printStackTrace();
                    throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
                }
                if (!var4_8 && var3_6.exists()) {
                    var3_6.delete();
                }
                var6_15.printStackTrace();
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
            }
        }
        catch (InterfaceErrorException v0) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
        }
        catch (CFWKException v1) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (ASN1Exception v2) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        catch (KeyDatabaseException var2_4) {
            var2_4.printStackTrace();
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SAVEAS"));
        }
    }

    public void changeKeyDbPwd(String string, long l) throws SSLightKeyDatabaseException {
        this.changeKeyDbPwd(null, string, l);
    }

    public void changeKeyDbPwd(String string, String string2, long l) throws SSLightKeyDatabaseException {
        if (string != null && !string.equals(this.keyDbPwd)) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_OLD_PASSWORD"));
        }
        this.keyDbPwd = string2;
        this.keyDbPwdExpireTime = l;
        this.save();
    }

    public static boolean stashKeyDbPwd(String string, String string2) {
        if (string == null || string2 == null || string2.length() == 0 || string.length() == 0) {
            return false;
        }
        String string3 = KMUtil.changeFileNameExtension(string, ".sth");
        byte[] byArray = new byte[129];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)n;
            ++n;
        }
        byte[] byArray2 = string2.getBytes();
        n = 0;
        while (n < byArray2.length && n < byArray.length) {
            byArray[n] = byArray2[n];
            ++n;
        }
        n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(n ^ 0xFFFFFFF5);
            ++n;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void buildKeyLabelList() throws SSLightKeyDatabaseException {
        this.keyLabelList = new Vector();
        this.certList = new Vector();
        this.myCertLabelList = null;
        this.caCertLabelList = null;
        this.siteCertLabelList = null;
        this.reqKeyLabelList = null;
        String string = "";
        try {
            Enumeration enumeration = this.ks.engineAliases();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                this.keyLabelList.addElement(string);
                if (this.ks.engineIsKeyEntry(string)) {
                    X509Cert[] x509CertArray = this.ks.engineGetCertificateChain(string);
                    this.certList.addElement(x509CertArray[0]);
                    X509Extensions x509Extensions = x509CertArray[0].extensions();
                    X509Extension x509Extension = x509Extensions.findExtension(KeyCertGen.GSKCertificationRequestOID);
                    if (x509Extension != null) {
                        this.addReqKeyLabel(string);
                        continue;
                    }
                    this.addMyCertLabel(string);
                    continue;
                }
                if (this.ks.engineIsSiteCertificateEntry(string)) {
                    this.addSiteCertLabel(string);
                    this.certList.addElement(this.ks.engineGetCertificate(string));
                    continue;
                }
                if (this.ks.engineIsCertificateEntry(string)) {
                    this.addCaCertLabel(string);
                    this.certList.addElement(this.ks.engineGetCertificate(string));
                    continue;
                }
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_BUILD_KEYLIST"));
            }
            return;
        }
        catch (ASN1Exception aSN1Exception) {
            aSN1Exception.printStackTrace();
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
    }

    public void createNewSelfSignedCertificate(int n, String string, boolean bl, int n2, DNItem dNItem, int n3, String string2, boolean bl2) throws SSLightKeyDatabaseException {
        if (n2 != 512 && n2 != 1024) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO_UNSUPPORTED_KEY_SIZE"));
        }
        if (this.ks.engineContainsAlias(string)) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY"));
        }
        try {
            X500Name x500Name = new X500Name(dNItem.getRFC1779String());
            String string3 = "RSA/512";
            if (n2 == 1024) {
                string3 = "RSA/1024";
            }
            KeyMaterial keyMaterial = KeyCertGen.generateKeyPair((String)string3);
            X509Cert x509Cert = KeyCertGen.generateCertificate((KeyMaterial)keyMaterial, (X500Name)x500Name, (int)(n - 1), (int)n3, null);
            X509Cert[] x509CertArray = new X509Cert[]{x509Cert};
            this.ks.engineSetKeyEntry(string, keyMaterial, this.keyDbPwd.toCharArray(), x509CertArray);
            if (bl) {
                this.ks.engineSetDefaultKeyEntry(string);
            }
            keyMaterial.destroy();
            if (string2 != null) {
                boolean bl3 = true;
                File file = new File(string2);
                try {
                    bl3 = file.exists();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    if (bl2) {
                        String string4 = x509Cert.getEncoded("base64");
                        fileOutputStream.write(string4.getBytes());
                    } else {
                        byte[] byArray = x509Cert.getEncoded();
                        fileOutputStream.write(byArray);
                    }
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.ks.engineDeleteEntry(string);
                    if (!bl3 && file.exists()) {
                        file.delete();
                    }
                    throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_WRITE"));
                }
            }
            this.addKeyLabelAt(string, 0);
            this.addMyCertLabelAt(string, 0);
            this.certList.insertElementAt(x509Cert, 0);
            return;
        }
        catch (InterfaceErrorException interfaceErrorException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_INVALID_DN_INPUT"));
        }
        catch (CFWKException cFWKException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
    }

    public void createNewCertRequest(String string, int n, DNItem dNItem, String string2, boolean bl) throws SSLightKeyDatabaseException {
        if (n != 512 && n != 1024) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO_UNSUPPORTED_KEY_SIZE"));
        }
        if (this.ks.engineContainsAlias(string)) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY"));
        }
        try {
            if (bl) {
                X500Name x500Name = new X500Name(dNItem.getRFC1779String());
                String string3 = "RSA/512";
                if (n == 1024) {
                    string3 = "RSA/1024";
                }
                KeyMaterial keyMaterial = KeyCertGen.generateKeyPair((String)string3);
                CertificationRequest certificationRequest = KeyCertGen.generateCertificationRequest((KeyMaterial)keyMaterial, (X500Name)x500Name, null);
                X509Extension x509Extension = new X509Extension(KeyCertGen.GSKCertificationRequestOID, false);
                X509Extension[] x509ExtensionArray = new X509Extension[]{x509Extension};
                X509Cert x509Cert = KeyCertGen.generateCertificate((KeyMaterial)keyMaterial, (X500Name)x500Name, (int)2, (int)365, (X509Extension[])x509ExtensionArray);
                X509Cert[] x509CertArray = new X509Cert[]{x509Cert};
                this.ks.engineSetKeyEntry(string, keyMaterial, this.keyDbPwd.toCharArray(), x509CertArray);
                keyMaterial.destroy();
                if (string2 != null) {
                    File file = new File(string2);
                    boolean bl2 = file.exists();
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        String string4 = certificationRequest.getEncoded("base64");
                        fileOutputStream.write(string4.getBytes());
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        this.ks.engineDeleteEntry(string);
                        if (!bl2 && file.exists()) {
                            file.delete();
                        }
                        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_WRITE"));
                    }
                }
                this.addKeyLabelAt(string, 0);
                this.addReqKeyLabelAt(string, 0);
                return;
            }
            this.extractCertificateRequest(string, string2);
            return;
        }
        catch (InterfaceErrorException interfaceErrorException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_INVALID_DN_INPUT"));
        }
        catch (CFWKException cFWKException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
    }

    public void issueCertificate(String string, int n, String string2, int n2, String string3, String string4, boolean bl) throws SSLightKeyDatabaseException {
        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_ISSUE_CERT"));
    }

    public boolean isPrivateKeyPresent(String string) {
        return this.ks.engineIsKeyEntry(string);
    }

    public void refreshKeyLabelList() throws SSLightKeyDatabaseException {
        this.buildKeyLabelList();
    }

    public KeyItem getKeyItemByLabel(String string) throws SSLightKeyDatabaseException {
        if (string == null || !this.ks.engineContainsAlias(string)) {
            return null;
        }
        String string2 = this.ks.engineGetDefaultKeyEntry();
        try {
            KeyItem keyItem = new KeyItem();
            keyItem.setKeyLabel(string);
            X509Cert x509Cert = this.ks.engineGetCertificate(string);
            if (this.ks.engineIsKeyEntry(string)) {
                KeyMaterial keyMaterial = this.ks.engineGetKey(string, this.keyDbPwd.toCharArray());
                byte[] byArray = KeyCertGen.generateEncryptedPrivateKeyInfo((KeyMaterial)keyMaterial, (String)this.keyDbPwd, (ASN1OID)PKCS12PBE.SHA1_RC4_128);
                EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = new EncryptedPrivateKeyInfoItem(byArray);
                keyItem.setEncryptedPrivateKeyInfoItem(encryptedPrivateKeyInfoItem);
                if (x509Cert == null) {
                    return keyItem;
                }
                X500Name x500Name = x509Cert.subject();
                X509Extensions x509Extensions = x509Cert.extensions();
                if (x509Extensions == null || x509Extensions.findExtension(KeyCertGen.GSKCertificationRequestOID) == null) {
                    keyMaterial.destroy();
                    X509Cert[] x509CertArray = this.ks.engineGetCertificateChain(string);
                    keyItem.setKeySize((short)x509CertArray[0].subjectKeySize());
                    int n = 0;
                    while (n < x509CertArray.length) {
                        byte[] byArray2 = x509CertArray[n].getEncoded();
                        CertificateItem certificateItem = this.parseCertificate(x509CertArray[n], byArray2);
                        keyItem.addCertificate(certificateItem);
                        ++n;
                    }
                    keyItem.setTrusted(true);
                    if (string2 != null && string.equals(string2)) {
                        keyItem.setDefault(true);
                    }
                    return keyItem;
                }
                CertificationRequest certificationRequest = KeyCertGen.generateCertificationRequest((KeyMaterial)keyMaterial, (X500Name)x500Name, null);
                keyMaterial.destroy();
                byte[] byArray3 = certificationRequest.getEncoded();
                CertificateRequestItem certificateRequestItem = this.parseCertRequest(x509Cert, byArray3);
                return new KeyItem(string, 0, (short)x509Cert.subjectKeySize(), encryptedPrivateKeyInfoItem, certificateRequestItem, null);
            }
            if (x509Cert != null) {
                byte[] byArray = x509Cert.getEncoded();
                new CertificateItem(byArray);
                keyItem.setKeySize((short)x509Cert.subjectKeySize());
                CertificateItem certificateItem = this.parseCertificate(x509Cert, byArray);
                keyItem.addCertificate(certificateItem);
                if (this.ks.engineIsCertificateEntry(string)) {
                    keyItem.setTrusted(true);
                    return keyItem;
                }
                if (this.ks.engineIsSiteCertificateEntry(string)) {
                    keyItem.setSiteCertificate(true);
                    return keyItem;
                }
                return null;
            }
        }
        catch (InterfaceErrorException interfaceErrorException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
        }
        catch (CFWKException cFWKException) {
            cFWKException.printStackTrace();
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        return null;
    }

    public KeyItem[] getKeyItemListByLabel(String string) throws SSLightKeyDatabaseException {
        return this.getKeyItemByLabel(string).getKeyItemsForCertChain();
    }

    public KeyItem[] getKeyItemChain(KeyItem keyItem) throws SSLightKeyDatabaseException {
        Vector vector = keyItem.getCertificateChain();
        if (vector == null) {
            KeyItem[] keyItemArray = new KeyItem[]{keyItem};
            return keyItemArray;
        }
        int n = vector.size();
        KeyItem[] keyItemArray = new KeyItem[n];
        int n2 = 0;
        while (n2 < n) {
            CertificateItem certificateItem = (CertificateItem)vector.elementAt(n2);
            KeyItem keyItem2 = new KeyItem(null, 0, 0, null, null, new BERObject(certificateItem.getEncoded()), true, false);
            keyItem2.addCertificate(certificateItem);
            keyItem2.setKeySize(certificateItem.getKeySize());
            if (n2 == 0) {
                keyItem2.setKeyLabel(keyItem.getKeyLabel());
                keyItem2.setEncryptedPrivateKeyInfoItem(keyItem.getEncryptedPrivateKeyInfoItem());
            }
            keyItemArray[n2] = keyItem2;
            ++n2;
        }
        return keyItemArray;
    }

    public CertificateItem parseCertificate(X509Cert x509Cert, byte[] byArray) throws SSLightKeyDatabaseException {
        try {
            if (x509Cert == null) {
                return null;
            }
            x509Cert.subjectKeySize();
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            if (x509Cert.issuer().attribute(X500Name.COMMON_NAME) != null) {
                string = x509Cert.issuer().attribute(X500Name.COMMON_NAME).valueToString();
            }
            if (x509Cert.issuer().attribute(X500Name.ORGANIZATIONAL_UNIT) != null) {
                string2 = x509Cert.issuer().attribute(X500Name.ORGANIZATIONAL_UNIT).valueToString();
            }
            if (x509Cert.issuer().attribute(X500Name.ORGANIZATION) != null) {
                string3 = x509Cert.issuer().attribute(X500Name.ORGANIZATION).valueToString();
            }
            if (x509Cert.issuer().attribute(X500Name.COUNTRY) != null) {
                string4 = x509Cert.issuer().attribute(X500Name.COUNTRY).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.COMMON_NAME) != null) {
                string5 = x509Cert.subject().attribute(X500Name.COMMON_NAME).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.ORGANIZATIONAL_UNIT) != null) {
                string6 = x509Cert.subject().attribute(X500Name.ORGANIZATIONAL_UNIT).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.ORGANIZATION) != null) {
                string7 = x509Cert.subject().attribute(X500Name.ORGANIZATION).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.COUNTRY) != null) {
                string8 = x509Cert.subject().attribute(X500Name.COUNTRY).valueToString();
            }
            DNItem dNItem = new DNItem(string, string2, string3, string4);
            DNItem dNItem2 = new DNItem(string5, string6, string7, string8);
            Date date = new Date(x509Cert.notBefore());
            Date date2 = new Date(x509Cert.notAfter());
            byte[] byArray2 = null;
            DEREncoder dEREncoder = new DEREncoder();
            x509Cert.extensions().encode((ASN1Encoder)dEREncoder);
            byArray2 = dEREncoder.toByteArray();
            AlgId algId = x509Cert.signatureKeyAlgId();
            byte[] byArray3 = null;
            DEREncoder dEREncoder2 = new DEREncoder();
            algId.encode((ASN1Encoder)dEREncoder2);
            byArray3 = dEREncoder2.toByteArray();
            CertificateItem certificateItem = new CertificateItem((short)x509Cert.version(), (short)x509Cert.subjectKeySize(), x509Cert.serialNo().toString(), dNItem, dNItem2, date, date2, new BERObject(x509Cert.subjectPublicKeyInfo()), new BERObject(byArray2), x509Cert.signature(), new BERObject(byArray3), algId.toString(), algId.asn1oid().name(), byArray);
            return certificateItem;
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
    }

    public CertificateRequestItem parseCertRequest(X509Cert x509Cert, byte[] byArray) throws SSLightKeyDatabaseException {
        try {
            if (x509Cert == null) {
                return null;
            }
            x509Cert.subjectKeySize();
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            if (x509Cert.subject().attribute(X500Name.COMMON_NAME) != null) {
                string = x509Cert.subject().attribute(X500Name.COMMON_NAME).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.ORGANIZATIONAL_UNIT) != null) {
                string2 = x509Cert.subject().attribute(X500Name.ORGANIZATIONAL_UNIT).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.ORGANIZATION) != null) {
                string3 = x509Cert.subject().attribute(X500Name.ORGANIZATION).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.COUNTRY) != null) {
                string4 = x509Cert.subject().attribute(X500Name.COUNTRY).valueToString();
            }
            DNItem dNItem = new DNItem(string, string2, string3, string4);
            byte[] byArray2 = null;
            DEREncoder dEREncoder = new DEREncoder();
            x509Cert.extensions().encode((ASN1Encoder)dEREncoder);
            byArray2 = dEREncoder.toByteArray();
            AlgId algId = x509Cert.signatureKeyAlgId();
            byte[] byArray3 = null;
            DEREncoder dEREncoder2 = new DEREncoder();
            algId.encode((ASN1Encoder)dEREncoder2);
            byArray3 = dEREncoder2.toByteArray();
            CertificateRequestItem certificateRequestItem = new CertificateRequestItem((short)x509Cert.subjectKeySize(), dNItem, new BERObject(x509Cert.subjectPublicKeyInfo()), new BERObject(byArray2), x509Cert.signature(), new BERObject(byArray3), algId.toString(), algId.asn1oid().name(), byArray, null);
            return certificateRequestItem;
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
    }

    public Vector getKeyItemsByPublicKey(BERObject bERObject) throws SSLightKeyDatabaseException {
        Enumeration enumeration = this.ks.engineAliases();
        Vector<KeyItem> vector = null;
        while (enumeration.hasMoreElements()) {
            KeyMaterial keyMaterial;
            String string = (String)enumeration.nextElement();
            X509Cert x509Cert = this.ks.engineGetCertificate(string);
            if (x509Cert == null || !(keyMaterial = x509Cert.subjectKeyMaterial()).equals((Object)bERObject)) continue;
            KeyItem keyItem = this.getKeyItemByLabel(string);
            if (vector == null) {
                vector = new Vector<KeyItem>();
            }
            vector.addElement(keyItem);
        }
        return vector;
    }

    public KeyItem getDefaultKeyItem() throws SSLightKeyDatabaseException {
        String string = this.ks.engineGetDefaultKeyEntry();
        if (string == null) {
            return null;
        }
        return this.getKeyItemByLabel(string);
    }

    public synchronized KeyItem getFirstKeyItem() throws SSLightKeyDatabaseException {
        this.currentKeyIndex = 0;
        if (this.keyLabelList == null) {
            return null;
        }
        String string = (String)this.keyLabelList.elementAt(0);
        if (string == null) {
            return null;
        }
        return this.getKeyItemByLabel(string);
    }

    public synchronized KeyItem getNextKeyItem() throws SSLightKeyDatabaseException {
        ++this.currentKeyIndex;
        if (this.currentKeyIndex < this.keyLabelList.size()) {
            String string = (String)this.keyLabelList.elementAt(this.currentKeyIndex);
            if (string == null) {
                return null;
            }
            return this.getKeyItemByLabel(string);
        }
        return null;
    }

    public void deleteKeyByLabel(String string) throws SSLightKeyDatabaseException {
        if (string == null) {
            return;
        }
        int n = this.keyLabelList.indexOf(string);
        if (n == -1) {
            return;
        }
        try {
            this.ks.engineDeleteEntry(string);
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_DELETE"));
        }
        this.keyLabelList.removeElementAt(n);
        this.certList.removeElementAt(n);
        if (this.caCertLabelList != null && this.caCertLabelList.contains(string)) {
            this.caCertLabelList.removeElement(string);
            return;
        }
        if (this.myCertLabelList != null && this.myCertLabelList.contains(string)) {
            this.myCertLabelList.removeElement(string);
            return;
        }
        if (this.siteCertLabelList != null && this.siteCertLabelList.contains(string)) {
            this.siteCertLabelList.removeElement(string);
        }
    }

    public void insertKey(KeyItem keyItem) throws SSLightKeyDatabaseException {
        block19: {
            if (keyItem == null) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
            }
            String string = keyItem.getKeyLabel();
            if (this.ks.engineContainsAlias(string)) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_LABEL"));
            }
            try {
                if (!keyItem.hasPrivateKey() && keyItem.hasCertificate()) {
                    X509Cert x509Cert = new X509Cert(((CertificateItem)keyItem.getCertificateChain().elementAt(0)).getEncoded());
                    if (keyItem.isTrusted() && !keyItem.isSiteCertificate()) {
                        this.ks.engineSetCertificateEntry(string, x509Cert);
                        return;
                    }
                    if (keyItem.isSiteCertificate()) {
                        this.ks.engineSetSiteCertificateEntry(string, x509Cert);
                        return;
                    }
                } else {
                    if (!keyItem.hasPrivateKey()) break block19;
                    byte[] byArray = keyItem.getEncryptedPrivateKeyInfoItem().getEncoded();
                    KeyMaterial keyMaterial = KeyCertGen.generateKeyMaterial((byte[])byArray, (String)this.keyDbPwd);
                    CertificateRequestItem certificateRequestItem = keyItem.getCertificateRequestItem();
                    if (certificateRequestItem != null) {
                        CertificationRequest certificationRequest = KeyCertGen.generateCertificationRequest((byte[])certificateRequestItem.getEncoded());
                        X500Name x500Name = certificationRequest.certificationRequestInfo.subject;
                        X509Extension x509Extension = new X509Extension(KeyCertGen.GSKCertificationRequestOID, false);
                        X509Extension[] x509ExtensionArray = new X509Extension[]{x509Extension};
                        X509Cert x509Cert = null;
                        x509Cert = KeyCertGen.generateCertificate((KeyMaterial)keyMaterial, (X500Name)x500Name, (int)2, (int)365, (X509Extension[])x509ExtensionArray);
                        X509Cert[] x509CertArray = new X509Cert[]{x509Cert};
                        this.ks.engineSetKeyEntry(string, keyMaterial, this.keyDbPwd.toCharArray(), x509CertArray);
                    } else if (keyItem.hasCertificate()) {
                        Vector vector = keyItem.getCertificateChain();
                        int n = vector.size();
                        X509Cert[] x509CertArray = new X509Cert[n];
                        int n2 = 0;
                        while (n2 < n) {
                            x509CertArray[n2] = new X509Cert(((CertificateItem)vector.elementAt(n2)).getEncoded());
                            ++n2;
                        }
                        this.ks.engineSetKeyEntry(string, keyMaterial, this.keyDbPwd.toCharArray(), x509CertArray);
                        if (keyItem.isDefault()) {
                            this.ks.engineSetDefaultKeyEntry(string);
                        }
                    }
                    keyMaterial.destroy();
                }
                return;
            }
            catch (InterfaceErrorException interfaceErrorException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
            }
            catch (X509Exception x509Exception) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
            }
            catch (CFWKException cFWKException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
            }
            catch (ASN1Exception aSN1Exception) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
            }
            catch (KeyStoreException keyStoreException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
            }
        }
    }

    public void setDefaultKey(String string) throws SSLightKeyDatabaseException {
        try {
            this.ks.engineSetDefaultKeyEntry(string);
            return;
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SET_DEFAULT_KEY"));
        }
    }

    public void setKeyTrust(String string, boolean bl) throws SSLightKeyDatabaseException {
    }

    public void exportToPFXFile(String string, String string2, String[] stringArray) throws SSLightKeyDatabaseException {
        block11: {
            if (stringArray == null || string == null || string2 == null || stringArray.length < 1) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
            }
            String string3 = stringArray[0];
            try {
                if (this.ks.engineIsKeyEntry(string3)) {
                    X509Cert[] x509CertArray;
                    KeyMaterial keyMaterial = this.ks.engineGetKey(string3, this.keyDbPwd.toCharArray());
                    if (keyMaterial != null && (x509CertArray = this.ks.engineGetCertificateChain(string3)) != null && x509CertArray.length > 0) {
                        X509Chain x509Chain = new X509Chain(x509CertArray);
                        String[] stringArray2 = new String[x509CertArray.length];
                        stringArray2[0] = string3;
                        byte[] byArray = string3.getBytes();
                        PrivateKeyAndCertificateChain privateKeyAndCertificateChain = new PrivateKeyAndCertificateChain((RSAKey)keyMaterial, x509Chain, stringArray2, byArray);
                        ASN1OID aSN1OID = PKCS12PBE.SHA1_RC2_40;
                        byte[] byArray2 = privateKeyAndCertificateChain.makePKCS12PDU(string2, aSN1OID, null, 1);
                        keyMaterial.destroy();
                        if (byArray2 != null && byArray2.length > 0) {
                            File file = new File(string);
                            boolean bl = file.exists();
                            try {
                                FileOutputStream fileOutputStream = new FileOutputStream(file);
                                fileOutputStream.write(byArray2);
                                fileOutputStream.close();
                                return;
                            }
                            catch (IOException iOException) {
                                if (!bl && file.exists()) {
                                    file.delete();
                                }
                                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_WRITE"));
                            }
                        }
                    }
                    break block11;
                }
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_EXPORT_KEY_TO_PFX"));
            }
            catch (InterfaceErrorException interfaceErrorException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
            }
            catch (CFWKException cFWKException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
            }
            catch (ASN1Exception aSN1Exception) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importFromPFXFile(String string, String string2) throws SSLightKeyDatabaseException {
        byte[] byArray = SSLightKeyDatabase.fileToBuf(string);
        if (byArray == null || byArray.length <= 0) return;
        try {
            PrivateKeyAndCertificateChain privateKeyAndCertificateChain = new PrivateKeyAndCertificateChain(byArray, string2);
            X509Chain x509Chain = privateKeyAndCertificateChain.getCertificateChain();
            String[] stringArray = privateKeyAndCertificateChain.getFriendlyNames();
            if (stringArray == null || stringArray.length <= 0) throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_IMPORT_KEY_FROM_PFX"));
            X509Cert[] x509CertArray = x509Chain.getCertArray();
            if (this.ks.engineGetCertificateAlias(x509CertArray[0]) != null) throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY"));
            String string3 = stringArray[0];
            if (string3 == null) {
                string3 = x509CertArray[0].subject().attribute(X500Name.COMMON_NAME).valueToString();
            }
            if (string3 == null || this.ks.engineContainsAlias(string3)) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_LABEL"));
            }
            RSAKey rSAKey = privateKeyAndCertificateChain.getPrivateRSAKey();
            this.ks.engineSetKeyEntry(string3, (KeyMaterial)rSAKey, this.keyDbPwd.toCharArray(), x509CertArray);
            this.keyLabelList.addElement(string3);
            this.certList.addElement(x509CertArray[0]);
            this.addMyCertLabel(string3);
            privateKeyAndCertificateChain.destroyPrivateKey();
            return;
        }
        catch (InterfaceErrorException interfaceErrorException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
        }
        catch (X509Exception x509Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (CFWKException cFWKException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
    }

    public void receiveCertificate(String string, boolean bl, boolean bl2) throws SSLightKeyDatabaseException {
        block20: {
            if (string == null) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
            }
            try {
                String string2 = null;
                string2 = bl ? "base64" : "unknown";
                FileInputStream fileInputStream = new FileInputStream(string);
                X509Cert[] x509CertArray = KeyCertGen.generateCertificates((InputStream)fileInputStream, (String)string2);
                fileInputStream.close();
                if (x509CertArray != null && x509CertArray[0] != null) {
                    KeyMaterial keyMaterial = x509CertArray[0].subjectKeyMaterial();
                    String string3 = "";
                    boolean bl3 = false;
                    Enumeration enumeration = this.ks.engineAliases();
                    while (enumeration.hasMoreElements() && !bl3) {
                        KeyMaterial keyMaterial2;
                        X509Cert[] x509CertArray2;
                        X509Extensions x509Extensions;
                        string3 = (String)enumeration.nextElement();
                        if (!this.ks.engineIsKeyEntry(string3) || (x509Extensions = (x509CertArray2 = this.ks.engineGetCertificateChain(string3))[0].extensions()) == null) continue;
                        KeyMaterial keyMaterial3 = x509CertArray2[0].subjectKeyMaterial();
                        X509Extension x509Extension = x509Extensions.findExtension(KeyCertGen.GSKCertificationRequestOID);
                        if (x509Extension != null) {
                            if (keyMaterial.equals((Object)keyMaterial3)) {
                                keyMaterial2 = this.ks.engineGetKey(string3, this.keyDbPwd.toCharArray());
                                this.ks.engineSetKeyEntry(string3, keyMaterial2, this.keyDbPwd.toCharArray(), x509CertArray);
                                if (bl2) {
                                    this.ks.engineSetDefaultKeyEntry(string3);
                                }
                                this.certList.addElement(x509CertArray[0]);
                                this.addMyCertLabel(string3);
                                if (this.reqKeyLabelList != null && this.reqKeyLabelList.contains(string3)) {
                                    this.reqKeyLabelList.removeElement(string3);
                                }
                                keyMaterial2.destroy();
                                bl3 = true;
                            }
                        } else if (keyMaterial.equals((Object)keyMaterial3)) {
                            keyMaterial2 = this.ks.engineGetKey(string3, this.keyDbPwd.toCharArray());
                            if (x509CertArray[0].notAfter() >= x509CertArray2[0].notAfter()) {
                                this.ks.engineSetKeyEntry(string3, keyMaterial2, this.keyDbPwd.toCharArray(), x509CertArray);
                                if (bl2) {
                                    this.ks.engineSetDefaultKeyEntry(string3);
                                }
                                keyMaterial2.destroy();
                                bl3 = true;
                            } else {
                                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_RECV"));
                            }
                        }
                        keyMaterial3.destroy();
                    }
                    keyMaterial.destroy();
                    if (!bl3) {
                        throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEY_FOR_CERT_NULL"));
                    }
                    break block20;
                }
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_RECV"));
            }
            catch (InterfaceErrorException interfaceErrorException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
            }
            catch (X509Exception x509Exception) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
            }
            catch (CFWKException cFWKException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
            }
            catch (ASN1Exception aSN1Exception) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
            }
            catch (IOException iOException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_OPEN_TO_READ"));
            }
            catch (KeyStoreException keyStoreException) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
            }
        }
    }

    public void addCACertificate(String string, String string2, boolean bl) throws SSLightKeyDatabaseException {
        if (string == null || string2 == null) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
        }
        if (this.ks.engineContainsAlias(string)) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_LABEL"));
        }
        try {
            String string3 = null;
            string3 = bl ? "base64" : "unknown";
            FileInputStream fileInputStream = new FileInputStream(string2);
            X509Cert[] x509CertArray = KeyCertGen.generateCertificates((InputStream)fileInputStream, (String)string3);
            fileInputStream.close();
            if (x509CertArray != null && x509CertArray[0] != null) {
                this.ks.engineSetCertificateEntry(string, x509CertArray[0]);
                this.keyLabelList.addElement(string);
                this.certList.addElement(x509CertArray[0]);
                this.addCaCertLabel(string);
                return;
            }
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_STORE"));
        }
        catch (InterfaceErrorException interfaceErrorException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
        }
        catch (X509Exception x509Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (CFWKException cFWKException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
        catch (IOException iOException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_OPEN_TO_READ"));
        }
    }

    public void addSiteCertificate(String string, String string2, boolean bl) throws SSLightKeyDatabaseException {
        if (string == null || string2 == null) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
        }
        if (this.ks.engineContainsAlias(string)) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_LABEL"));
        }
        try {
            String string3 = null;
            string3 = bl ? "base64" : "unknown";
            FileInputStream fileInputStream = new FileInputStream(string2);
            X509Cert[] x509CertArray = KeyCertGen.generateCertificates((InputStream)fileInputStream, (String)string3);
            fileInputStream.close();
            if (x509CertArray != null && x509CertArray[0] != null) {
                this.ks.engineSetSiteCertificateEntry(string, x509CertArray[0]);
                this.keyLabelList.addElement(string);
                this.certList.addElement(x509CertArray[0]);
                this.addSiteCertLabel(string);
                return;
            }
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_STORE"));
        }
        catch (InterfaceErrorException interfaceErrorException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
        }
        catch (X509Exception x509Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (CFWKException cFWKException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
        catch (IOException iOException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_OPEN_TO_READ"));
        }
    }

    public void extractCertificate(String string, String string2, boolean bl) throws SSLightKeyDatabaseException {
        if (string == null || string2 == null) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
        }
        try {
            X509Cert x509Cert = this.ks.engineGetCertificate(string);
            if (x509Cert == null) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEYREC_CERTIFICATE_NULL"));
            }
            File file = new File(string2);
            boolean bl2 = file.exists();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                if (bl) {
                    String string3 = x509Cert.getEncoded("base64");
                    fileOutputStream.write(string3.getBytes());
                } else {
                    byte[] byArray = x509Cert.getEncoded();
                    fileOutputStream.write(byArray);
                }
                fileOutputStream.close();
                return;
            }
            catch (IOException iOException) {
                if (!bl2 && file.exists()) {
                    file.delete();
                }
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_WRITE"));
            }
        }
        catch (CFWKException cFWKException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
    }

    public void extractCertificateRequest(String string, String string2) throws SSLightKeyDatabaseException {
        if (string == null || string2 == null) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
        }
        File file = new File(string2);
        boolean bl = file.exists();
        try {
            if (!this.ks.engineIsKeyEntry(string)) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
            }
            X509Cert[] x509CertArray = this.ks.engineGetCertificateChain(string);
            if (x509CertArray == null || x509CertArray[0] == null) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEYREC_CERTIFICATE_NULL"));
            }
            X509Extensions x509Extensions = x509CertArray[0].extensions();
            if (x509Extensions == null) {
                throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
            }
            X500Name x500Name = x509CertArray[0].subject();
            KeyMaterial keyMaterial = this.ks.engineGetKey(string, this.keyDbPwd.toCharArray());
            CertificationRequest certificationRequest = KeyCertGen.generateCertificationRequest((KeyMaterial)keyMaterial, (X500Name)x500Name, (X509Extension[])x509Extensions.extensions());
            keyMaterial.destroy();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            String string3 = certificationRequest.getEncoded("base64");
            fileOutputStream.write(string3.getBytes());
            fileOutputStream.close();
            return;
        }
        catch (X509Exception x509Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (CFWKException cFWKException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        catch (IOException iOException) {
            if (!bl && file.exists()) {
                file.delete();
            }
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_WRITE"));
        }
    }

    public static boolean promptForPW() {
        return true;
    }

    public static boolean promptForLabel() {
        return true;
    }

    static long msbf(byte[] byArray, int n, int n2) {
        long l = 0L;
        do {
            l |= (long)(byArray[n++] & 0xFF) << --n2 * 8;
        } while (n2 > 0);
        return l;
    }

    static byte getBits(byte[] byArray, int n, int n2) {
        int n3 = n / 7;
        byte by = byArray[n3];
        int n4 = n % 7;
        by = (byte)(by & 127 >>> n4);
        if ((n4 = n2 - (7 - n4)) > 0) {
            return (byte)(by << n4 | (byte)(byArray[n3 + 1] >>> 7 - n4));
        }
        if (n4 < 0) {
            return (byte)(by >>> -n4);
        }
        return by;
    }

    private static int putByte(byte[] byArray, int n, int n2) {
        byArray[n2++] = (byte)n;
        return n2;
    }

    private static int putShort(byte[] byArray, int n, int n2) {
        int n3 = 8;
        while (n3 >= 0) {
            byArray[n2++] = (byte)(n >> n3);
            n3 -= 8;
        }
        return n2;
    }

    private static int putLong(byte[] byArray, long l, int n) {
        int n2 = 56;
        while (n2 >= 0) {
            byArray[n++] = (byte)(l >> n2);
            n2 -= 8;
        }
        return n;
    }

    private static int putLong(byte[] byArray, long l, int n, int n2) {
        int n3 = n * 8 - 8;
        while (n3 >= 0) {
            byArray[n2++] = (byte)(l >> n3);
            n3 -= 8;
        }
        return n2;
    }

    private static int putString(byte[] byArray, String string, int n) {
        int n2 = string.length();
        byte[] byArray2 = string.getBytes();
        try {
            System.arraycopy(byArray2, 0, byArray, n, n2);
        }
        catch (Exception exception) {
            return n;
        }
        return n + n2;
    }

    public static byte[] fileToBuf(String string) throws SSLightKeyDatabaseException {
        int n;
        File file = new File(string);
        if (!file.exists()) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_FILE_NOT_FOUND"));
        }
        int n2 = (int)file.length();
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[n2];
        try {
            fileInputStream = new FileInputStream(file);
            n = 0;
            int n3 = 0;
            while (n < byArray.length && (n3 = fileInputStream.read(byArray, n, byArray.length - n)) != -1) {
                n += n3;
            }
            fileInputStream.close();
            fileInputStream = null;
        }
        catch (IOException iOException) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2) {}
            }
            fileInputStream = null;
            n = 0;
        }
        if (n != byArray.length) {
            return null;
        }
        return byArray;
    }

    public static byte[] base64DearmorFileToBuf(String string) throws SSLightKeyDatabaseException {
        byte[] byArray;
        int n;
        byte[] byArray2 = SSLightKeyDatabase.fileToBuf(string);
        if (byArray2 == null) {
            return null;
        }
        byte by = (byte)BASE64BEGINCERT.charAt(0);
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < byArray2.length && n2 == -1) {
            if (byArray2[n4] == by) {
                n = 0;
                while (n + n4 < byArray2.length && n < BASE64BEGINCERT.length() && Character.toUpperCase((char)byArray2[n4 + n]) == BASE64BEGINCERT.charAt(n)) {
                    ++n;
                }
                if (n == BASE64BEGINCERT.length()) {
                    n2 = n4 + BASE64BEGINCERT.length();
                }
            }
            ++n4;
        }
        if (n2 == -1) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_BASE64_INVALID_DATA"));
        }
        by = (byte)BASE64ENDCERT.charAt(0);
        n4 = n2;
        while (n4 < byArray2.length && n3 == -1) {
            if (byArray2[n4] == by) {
                n = 0;
                while (n + n4 < byArray2.length && n < BASE64ENDCERT.length() && Character.toUpperCase((char)byArray2[n4 + n]) == BASE64ENDCERT.charAt(n)) {
                    ++n;
                }
                if (n == BASE64ENDCERT.length()) {
                    n3 = n4;
                }
            }
            ++n4;
        }
        if (n3 == -1) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_BASE64_INVALID_DATA"));
        }
        n = n3 - n2;
        byte[] byArray3 = new byte[n];
        int n5 = n2;
        int n6 = 0;
        while (n5 < n + n2) {
            int n7 = Armored64RdChars.indexOf(byArray2[n5]);
            if (n7 != -1) {
                byArray3[n6] = (byte)n7;
                ++n6;
            }
            ++n5;
        }
        int n8 = n6;
        int n9 = n8 % 4;
        int n10 = (n8 - n9) * 3 / 4;
        if (n9 == 1) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_BASE64_INVALID_DATA"));
        }
        if (n9 == 2) {
            byArray = new byte[++n10];
            byArray[n10 - 1] = (byte)(byArray3[n6 - 2] << 2 | byArray3[n6 - 1] >>> 4);
        } else if (n9 == 3) {
            byArray = new byte[n10 += 2];
            byArray[n10 - 2] = (byte)(byArray3[n6 - 3] << 2 | byArray3[n6 - 2] >>> 4);
            byArray[n10 - 1] = (byte)(byArray3[n6 - 2] << 4 | byArray3[n6 - 1] >>> 2);
        } else {
            byArray = new byte[n10];
        }
        int n11 = 0;
        n6 = 0;
        n11 = 0;
        while (n6 + 3 < n8) {
            byArray[n11] = (byte)(byArray3[n6] << 2 | byArray3[n6 + 1] >>> 4);
            byArray[n11 + 1] = (byte)(byArray3[n6 + 1] << 4 | byArray3[n6 + 2] >>> 2);
            byArray[n11 + 2] = (byte)(byArray3[n6 + 2] << 6 | byArray3[n6 + 3]);
            n6 += 4;
            n11 += 3;
        }
        return byArray;
    }

    private static int PutSextWithNL(PrintWriter printWriter, int n, int n2) {
        printWriter.print(Armored64WrChars.charAt(n));
        if (++n2 == 64) {
            printWriter.println();
            n2 = 0;
        }
        return n2;
    }

    private static byte[] BufToBase64ArmorBuf(byte[] byArray) {
        int n;
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.println(BASE64BEGINCERT);
        int n3 = 0;
        int n4 = 0;
        while (n3 + 2 < byArray.length) {
            n2 = byArray[n3] >>> 2 & 0x3F;
            n = n4;
            printWriter.print(Armored64WrChars.charAt(n2));
            if (++n == 64) {
                printWriter.println();
                n = 0;
            }
            n4 = n;
            n2 = byArray[n3] << 4 & 0x30 | byArray[n3 + 1] >>> 4 & 0xF;
            n = n4;
            printWriter.print(Armored64WrChars.charAt(n2));
            if (++n == 64) {
                printWriter.println();
                n = 0;
            }
            n4 = n;
            n2 = byArray[n3 + 1] << 2 & 0x3C | byArray[n3 + 2] >>> 6 & 3;
            n = n4;
            printWriter.print(Armored64WrChars.charAt(n2));
            if (++n == 64) {
                printWriter.println();
                n = 0;
            }
            n4 = n;
            n2 = byArray[n3 + 2] & 0x3F;
            n = n4;
            printWriter.print(Armored64WrChars.charAt(n2));
            if (++n == 64) {
                printWriter.println();
                n = 0;
            }
            n4 = n;
            n3 += 3;
        }
        n2 = byArray.length % 3;
        if (n2 == 1) {
            n = byArray[byArray.length - 1] >>> 2 & 0x3F;
            int n5 = n4;
            printWriter.print(Armored64WrChars.charAt(n));
            if (++n5 == 64) {
                printWriter.println();
                n5 = 0;
            }
            n4 = n5;
            n = byArray[byArray.length - 1] << 4 & 0x30;
            n5 = n4;
            printWriter.print(Armored64WrChars.charAt(n));
            if (++n5 == 64) {
                printWriter.println();
                n5 = 0;
            }
            n = n4 = n5;
            printWriter.print(Armored64WrChars.charAt(64));
            if (++n == 64) {
                printWriter.println();
                n = 0;
            }
            n = n4 = n;
            printWriter.print(Armored64WrChars.charAt(64));
            if (++n == 64) {
                printWriter.println();
                n = 0;
            }
            n4 = n;
        } else {
            n = byArray[byArray.length - 2] >>> 2 & 0x3F;
            int n6 = n4;
            printWriter.print(Armored64WrChars.charAt(n));
            if (++n6 == 64) {
                printWriter.println();
                n6 = 0;
            }
            n4 = n6;
            n = byArray[byArray.length - 2] << 4 & 0x30 | byArray[byArray.length - 1] >>> 4 & 0xF;
            n6 = n4;
            printWriter.print(Armored64WrChars.charAt(n));
            if (++n6 == 64) {
                printWriter.println();
                n6 = 0;
            }
            n4 = n6;
            n = byArray[byArray.length - 1] << 2 & 0x3C;
            n6 = n4;
            printWriter.print(Armored64WrChars.charAt(n));
            if (++n6 == 64) {
                printWriter.println();
                n6 = 0;
            }
            n = n4 = n6;
            printWriter.print(Armored64WrChars.charAt(64));
            if (++n == 64) {
                printWriter.println();
                n = 0;
            }
            n4 = n;
        }
        if (n4 != 0) {
            printWriter.println();
        }
        printWriter.println(BASE64ENDCERT);
        printWriter.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private static String getLabel(SSLCert sSLCert) {
        StringBuffer stringBuffer = new StringBuffer(20);
        boolean bl = true;
        int n = 0;
        while (n < nameComps.length) {
            String string = sSLCert.getNameComponent(1, nameComps[n]);
            if (string != null) {
                if (!bl) {
                    stringBuffer.append(", ");
                }
                bl = false;
                stringBuffer.append(compLabs[n]);
                stringBuffer.append(string);
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    private void ssltCheckName(String string) throws SSLightKeyDatabaseException {
        File file = new File(string);
        String string2 = file.getName();
        if (!string2.endsWith(KeyDatabase.DEFAULT_KEYDB_NAME_EXT_SSLIGHT)) {
            String string3 = KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_EXT");
            Object[] objectArray = new Object[]{KeyDatabase.DEFAULT_KEYDB_NAME_EXT_SSLIGHT};
            String string4 = MessageFormat.format(string3, objectArray);
            throw new SSLightKeyDatabaseException(string4);
        }
        String string5 = string2.substring(0, string2.lastIndexOf(KeyDatabase.DEFAULT_KEYDB_NAME_EXT_SSLIGHT));
        int n = string5.length();
        while (--n >= 0) {
            char c = string2.charAt(n);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || (c >= '0' && c <= '9' || c == '.') && n > 0) continue;
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
        }
    }

    private String getFullyQualifiedClassName(String string) {
        File file = new File(string);
        String string2 = file.getName();
        if (classPackage != null) {
            string2 = String.valueOf(classPackage) + "." + file.getName();
        }
        return string2.substring(0, string2.lastIndexOf(KeyDatabase.DEFAULT_KEYDB_NAME_EXT_SSLIGHT));
    }

    private void ssltCreateNewKeyDb(String string, String string2, long l) throws SSLightKeyDatabaseException, X509Exception, IOException {
        this.ssltCheckName(string);
        File file = new File(string);
        if (file.exists()) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_ALREADY_EXISTS"));
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.ks = new KeyStore();
        this.ks.engineStore((OutputStream)fileOutputStream, string2.toCharArray(), this.getFullyQualifiedClassName(string));
        fileOutputStream.close();
    }

    private void ssltAddDefaultRootCertificates() throws SSLightKeyDatabaseException {
        try {
            this.ks.engineSetCertificateEntry(CLASS3_ROOT_LABEL, new X509Cert(CLASS3_ROOT_SELF_SIGNED_CERT));
            this.ks.engineSetCertificateEntry(CLASS2_ROOT_LABEL, new X509Cert(CLASS2_ROOT_SELF_SIGNED_CERT));
            this.ks.engineSetCertificateEntry(CLASS1_ROOT_LABEL, new X509Cert(CLASS1_ROOT_SELF_SIGNED_CERT));
            this.ks.engineSetCertificateEntry(RSA_SECURE_SERVER_CA_LABEL, new X509Cert(RSA_SECURE_SERVER_CA_SELF_SIGNED_CERT));
            this.ks.engineSetCertificateEntry(VERISIGN_TEST_CA_LABEL, new X509Cert(VERISIGN_TEST_CA_SELF_SIGNED_CERT));
            this.ks.engineSetCertificateEntry(THAWTE_ROOT_SELF_SIGNED_CERT_LABEL, new X509Cert(THAWTE_ROOT_SELF_SIGNED_CERT));
            this.ks.engineSetCertificateEntry(THAWTE_SPR_ROOT_SELF_SIGNED_CERT_LABEL, new X509Cert(THAWTE_SPR_ROOT_SELF_SIGNED_CERT));
            this.ks.engineSetCertificateEntry(THAWTE_PBASIC_ROOT_SELF_SIGNED_CERT_LABEL, new X509Cert(THAWTE_PBASIC_ROOT_SELF_SIGNED_CERT));
            this.ks.engineSetCertificateEntry(THAWTE_PFREE_ROOT_SELF_SIGNED_CERT_LABEL, new X509Cert(THAWTE_PFREE_ROOT_SELF_SIGNED_CERT));
            this.ks.engineSetCertificateEntry(THAWTE_PPR_ROOT_SELF_SIGNED_CERT_LABEL, new X509Cert(THAWTE_PPR_ROOT_SELF_SIGNED_CERT));
            return;
        }
        catch (InterfaceErrorException interfaceErrorException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLightKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
    }

    /*
     * Opcode count of 27458 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        byte[] byArray = new byte[576];
        byArray[0] = 48;
        byArray[1] = -126;
        byArray[2] = 2;
        byArray[3] = 60;
        byArray[4] = 48;
        byArray[5] = -126;
        byArray[6] = 1;
        byArray[7] = -91;
        byArray[8] = 2;
        byArray[9] = 16;
        byArray[10] = 50;
        byArray[11] = 80;
        byArray[12] = 51;
        byArray[13] = -49;
        byArray[14] = 80;
        byArray[15] = -47;
        byArray[16] = 86;
        byArray[17] = -13;
        byArray[18] = 92;
        byArray[19] = -127;
        byArray[20] = -83;
        byArray[21] = 101;
        byArray[22] = 92;
        byArray[23] = 79;
        byArray[24] = -56;
        byArray[25] = 37;
        byArray[26] = 48;
        byArray[27] = 13;
        byArray[28] = 6;
        byArray[29] = 9;
        byArray[30] = 42;
        byArray[31] = -122;
        byArray[32] = 72;
        byArray[33] = -122;
        byArray[34] = -9;
        byArray[35] = 13;
        byArray[36] = 1;
        byArray[37] = 1;
        byArray[38] = 2;
        byArray[39] = 5;
        byArray[41] = 48;
        byArray[42] = 95;
        byArray[43] = 49;
        byArray[44] = 11;
        byArray[45] = 48;
        byArray[46] = 9;
        byArray[47] = 6;
        byArray[48] = 3;
        byArray[49] = 85;
        byArray[50] = 4;
        byArray[51] = 6;
        byArray[52] = 19;
        byArray[53] = 2;
        byArray[54] = 85;
        byArray[55] = 83;
        byArray[56] = 49;
        byArray[57] = 23;
        byArray[58] = 48;
        byArray[59] = 21;
        byArray[60] = 6;
        byArray[61] = 3;
        byArray[62] = 85;
        byArray[63] = 4;
        byArray[64] = 10;
        byArray[65] = 19;
        byArray[66] = 14;
        byArray[67] = 86;
        byArray[68] = 101;
        byArray[69] = 114;
        byArray[70] = 105;
        byArray[71] = 83;
        byArray[72] = 105;
        byArray[73] = 103;
        byArray[74] = 110;
        byArray[75] = 44;
        byArray[76] = 32;
        byArray[77] = 73;
        byArray[78] = 110;
        byArray[79] = 99;
        byArray[80] = 46;
        byArray[81] = 49;
        byArray[82] = 55;
        byArray[83] = 48;
        byArray[84] = 53;
        byArray[85] = 6;
        byArray[86] = 3;
        byArray[87] = 85;
        byArray[88] = 4;
        byArray[89] = 11;
        byArray[90] = 19;
        byArray[91] = 46;
        byArray[92] = 67;
        byArray[93] = 108;
        byArray[94] = 97;
        byArray[95] = 115;
        byArray[96] = 115;
        byArray[97] = 32;
        byArray[98] = 49;
        byArray[99] = 32;
        byArray[100] = 80;
        byArray[101] = 117;
        byArray[102] = 98;
        byArray[103] = 108;
        byArray[104] = 105;
        byArray[105] = 99;
        byArray[106] = 32;
        byArray[107] = 80;
        byArray[108] = 114;
        byArray[109] = 105;
        byArray[110] = 109;
        byArray[111] = 97;
        byArray[112] = 114;
        byArray[113] = 121;
        byArray[114] = 32;
        byArray[115] = 67;
        byArray[116] = 101;
        byArray[117] = 114;
        byArray[118] = 116;
        byArray[119] = 105;
        byArray[120] = 102;
        byArray[121] = 105;
        byArray[122] = 99;
        byArray[123] = 97;
        byArray[124] = 116;
        byArray[125] = 105;
        byArray[126] = 111;
        byArray[127] = 110;
        byArray[128] = 32;
        byArray[129] = 65;
        byArray[130] = 117;
        byArray[131] = 116;
        byArray[132] = 104;
        byArray[133] = 111;
        byArray[134] = 114;
        byArray[135] = 105;
        byArray[136] = 116;
        byArray[137] = 121;
        byArray[138] = 48;
        byArray[139] = 30;
        byArray[140] = 23;
        byArray[141] = 13;
        byArray[142] = 57;
        byArray[143] = 54;
        byArray[144] = 48;
        byArray[145] = 49;
        byArray[146] = 50;
        byArray[147] = 57;
        byArray[148] = 48;
        byArray[149] = 48;
        byArray[150] = 48;
        byArray[151] = 48;
        byArray[152] = 48;
        byArray[153] = 48;
        byArray[154] = 90;
        byArray[155] = 23;
        byArray[156] = 13;
        byArray[157] = 50;
        byArray[158] = 48;
        byArray[159] = 48;
        byArray[160] = 49;
        byArray[161] = 48;
        byArray[162] = 55;
        byArray[163] = 50;
        byArray[164] = 51;
        byArray[165] = 53;
        byArray[166] = 57;
        byArray[167] = 53;
        byArray[168] = 57;
        byArray[169] = 90;
        byArray[170] = 48;
        byArray[171] = 95;
        byArray[172] = 49;
        byArray[173] = 11;
        byArray[174] = 48;
        byArray[175] = 9;
        byArray[176] = 6;
        byArray[177] = 3;
        byArray[178] = 85;
        byArray[179] = 4;
        byArray[180] = 6;
        byArray[181] = 19;
        byArray[182] = 2;
        byArray[183] = 85;
        byArray[184] = 83;
        byArray[185] = 49;
        byArray[186] = 23;
        byArray[187] = 48;
        byArray[188] = 21;
        byArray[189] = 6;
        byArray[190] = 3;
        byArray[191] = 85;
        byArray[192] = 4;
        byArray[193] = 10;
        byArray[194] = 19;
        byArray[195] = 14;
        byArray[196] = 86;
        byArray[197] = 101;
        byArray[198] = 114;
        byArray[199] = 105;
        byArray[200] = 83;
        byArray[201] = 105;
        byArray[202] = 103;
        byArray[203] = 110;
        byArray[204] = 44;
        byArray[205] = 32;
        byArray[206] = 73;
        byArray[207] = 110;
        byArray[208] = 99;
        byArray[209] = 46;
        byArray[210] = 49;
        byArray[211] = 55;
        byArray[212] = 48;
        byArray[213] = 53;
        byArray[214] = 6;
        byArray[215] = 3;
        byArray[216] = 85;
        byArray[217] = 4;
        byArray[218] = 11;
        byArray[219] = 19;
        byArray[220] = 46;
        byArray[221] = 67;
        byArray[222] = 108;
        byArray[223] = 97;
        byArray[224] = 115;
        byArray[225] = 115;
        byArray[226] = 32;
        byArray[227] = 49;
        byArray[228] = 32;
        byArray[229] = 80;
        byArray[230] = 117;
        byArray[231] = 98;
        byArray[232] = 108;
        byArray[233] = 105;
        byArray[234] = 99;
        byArray[235] = 32;
        byArray[236] = 80;
        byArray[237] = 114;
        byArray[238] = 105;
        byArray[239] = 109;
        byArray[240] = 97;
        byArray[241] = 114;
        byArray[242] = 121;
        byArray[243] = 32;
        byArray[244] = 67;
        byArray[245] = 101;
        byArray[246] = 114;
        byArray[247] = 116;
        byArray[248] = 105;
        byArray[249] = 102;
        byArray[250] = 105;
        byArray[251] = 99;
        byArray[252] = 97;
        byArray[253] = 116;
        byArray[254] = 105;
        byArray[255] = 111;
        byArray[256] = 110;
        byArray[257] = 32;
        byArray[258] = 65;
        byArray[259] = 117;
        byArray[260] = 116;
        byArray[261] = 104;
        byArray[262] = 111;
        byArray[263] = 114;
        byArray[264] = 105;
        byArray[265] = 116;
        byArray[266] = 121;
        byArray[267] = 48;
        byArray[268] = -127;
        byArray[269] = -97;
        byArray[270] = 48;
        byArray[271] = 13;
        byArray[272] = 6;
        byArray[273] = 9;
        byArray[274] = 42;
        byArray[275] = -122;
        byArray[276] = 72;
        byArray[277] = -122;
        byArray[278] = -9;
        byArray[279] = 13;
        byArray[280] = 1;
        byArray[281] = 1;
        byArray[282] = 1;
        byArray[283] = 5;
        byArray[285] = 3;
        byArray[286] = -127;
        byArray[287] = -115;
        byArray[289] = 48;
        byArray[290] = -127;
        byArray[291] = -119;
        byArray[292] = 2;
        byArray[293] = -127;
        byArray[294] = -127;
        byArray[296] = -27;
        byArray[297] = 25;
        byArray[298] = -65;
        byArray[299] = 109;
        byArray[300] = -93;
        byArray[301] = 86;
        byArray[302] = 97;
        byArray[303] = 45;
        byArray[304] = -103;
        byArray[305] = 72;
        byArray[306] = 113;
        byArray[307] = -10;
        byArray[308] = 103;
        byArray[309] = -34;
        byArray[310] = -71;
        byArray[311] = -115;
        byArray[312] = -21;
        byArray[313] = -73;
        byArray[314] = -98;
        byArray[315] = -122;
        byArray[316] = -128;
        byArray[317] = 10;
        byArray[318] = -111;
        byArray[319] = 14;
        byArray[320] = -6;
        byArray[321] = 56;
        byArray[322] = 37;
        byArray[323] = -81;
        byArray[324] = 70;
        byArray[325] = -120;
        byArray[326] = -126;
        byArray[327] = -27;
        byArray[328] = 115;
        byArray[329] = -88;
        byArray[330] = -96;
        byArray[331] = -101;
        byArray[332] = 36;
        byArray[333] = 93;
        byArray[334] = 13;
        byArray[335] = 31;
        byArray[336] = -52;
        byArray[337] = 101;
        byArray[338] = 110;
        byArray[339] = 12;
        byArray[340] = -80;
        byArray[341] = -48;
        byArray[342] = 86;
        byArray[343] = -124;
        byArray[344] = 24;
        byArray[345] = -121;
        byArray[346] = -102;
        byArray[347] = 6;
        byArray[348] = -101;
        byArray[349] = 16;
        byArray[350] = -95;
        byArray[351] = 115;
        byArray[352] = -33;
        byArray[353] = -76;
        byArray[354] = 88;
        byArray[355] = 57;
        byArray[356] = 107;
        byArray[357] = 110;
        byArray[358] = -63;
        byArray[359] = -10;
        byArray[360] = 21;
        byArray[361] = -43;
        byArray[362] = -88;
        byArray[363] = -88;
        byArray[364] = 63;
        byArray[365] = -86;
        byArray[366] = 18;
        byArray[367] = 6;
        byArray[368] = -115;
        byArray[369] = 49;
        byArray[370] = -84;
        byArray[371] = 127;
        byArray[372] = -80;
        byArray[373] = 52;
        byArray[374] = -41;
        byArray[375] = -113;
        byArray[376] = 52;
        byArray[377] = 103;
        byArray[378] = -120;
        byArray[379] = 9;
        byArray[380] = -51;
        byArray[381] = 20;
        byArray[382] = 17;
        byArray[383] = -30;
        byArray[384] = 78;
        byArray[385] = 69;
        byArray[386] = 86;
        byArray[387] = 105;
        byArray[388] = 31;
        byArray[389] = 120;
        byArray[390] = 2;
        byArray[391] = -128;
        byArray[392] = -38;
        byArray[393] = -36;
        byArray[394] = 71;
        byArray[395] = -111;
        byArray[396] = 41;
        byArray[397] = -69;
        byArray[398] = 54;
        byArray[399] = -55;
        byArray[400] = 99;
        byArray[401] = 92;
        byArray[402] = -59;
        byArray[403] = -32;
        byArray[404] = -41;
        byArray[405] = 45;
        byArray[406] = -121;
        byArray[407] = 123;
        byArray[408] = -95;
        byArray[409] = -73;
        byArray[410] = 50;
        byArray[411] = -80;
        byArray[412] = 123;
        byArray[413] = 48;
        byArray[414] = -70;
        byArray[415] = 42;
        byArray[416] = 47;
        byArray[417] = 49;
        byArray[418] = -86;
        byArray[419] = -18;
        byArray[420] = -93;
        byArray[421] = 103;
        byArray[422] = -38;
        byArray[423] = -37;
        byArray[424] = 2;
        byArray[425] = 3;
        byArray[426] = 1;
        byArray[428] = 1;
        byArray[429] = 48;
        byArray[430] = 13;
        byArray[431] = 6;
        byArray[432] = 9;
        byArray[433] = 42;
        byArray[434] = -122;
        byArray[435] = 72;
        byArray[436] = -122;
        byArray[437] = -9;
        byArray[438] = 13;
        byArray[439] = 1;
        byArray[440] = 1;
        byArray[441] = 2;
        byArray[442] = 5;
        byArray[444] = 3;
        byArray[445] = -127;
        byArray[446] = -127;
        byArray[448] = 75;
        byArray[449] = 68;
        byArray[450] = 102;
        byArray[451] = 96;
        byArray[452] = 104;
        byArray[453] = 100;
        byArray[454] = -28;
        byArray[455] = -104;
        byArray[456] = 27;
        byArray[457] = -13;
        byArray[458] = -80;
        byArray[459] = 114;
        byArray[460] = -26;
        byArray[461] = -107;
        byArray[462] = -119;
        byArray[463] = 124;
        byArray[464] = -35;
        byArray[465] = 123;
        byArray[466] = -77;
        byArray[467] = -107;
        byArray[468] = -64;
        byArray[469] = 29;
        byArray[470] = 46;
        byArray[471] = -40;
        byArray[472] = -40;
        byArray[473] = 25;
        byArray[474] = -48;
        byArray[475] = 45;
        byArray[476] = 52;
        byArray[477] = 61;
        byArray[478] = -58;
        byArray[479] = 80;
        byArray[480] = -102;
        byArray[481] = 16;
        byArray[482] = -122;
        byArray[483] = -116;
        byArray[484] = -86;
        byArray[485] = 63;
        byArray[486] = 59;
        byArray[487] = -88;
        byArray[488] = 4;
        byArray[489] = -4;
        byArray[490] = 55;
        byArray[491] = 82;
        byArray[492] = -107;
        byArray[493] = -61;
        byArray[494] = -39;
        byArray[495] = -55;
        byArray[496] = -37;
        byArray[497] = -51;
        byArray[498] = -14;
        byArray[499] = -122;
        byArray[500] = 6;
        byArray[501] = -60;
        byArray[502] = -79;
        byArray[503] = 27;
        byArray[504] = -16;
        byArray[505] = -126;
        byArray[506] = -120;
        byArray[507] = 48;
        byArray[508] = 66;
        byArray[509] = -114;
        byArray[510] = 23;
        byArray[511] = 80;
        byArray[512] = 28;
        byArray[513] = 100;
        byArray[514] = 122;
        byArray[515] = -72;
        byArray[516] = 62;
        byArray[517] = -103;
        byArray[518] = 73;
        byArray[519] = 116;
        byArray[520] = -105;
        byArray[521] = -4;
        byArray[522] = -84;
        byArray[523] = 2;
        byArray[524] = 67;
        byArray[525] = -5;
        byArray[526] = -106;
        byArray[527] = 12;
        byArray[528] = 86;
        byArray[529] = 4;
        byArray[530] = 37;
        byArray[531] = 12;
        byArray[532] = 124;
        byArray[533] = 124;
        byArray[534] = -121;
        byArray[535] = -99;
        byArray[536] = 36;
        byArray[537] = -89;
        byArray[538] = -40;
        byArray[539] = -16;
        byArray[540] = 50;
        byArray[541] = 41;
        byArray[542] = -75;
        byArray[543] = -92;
        byArray[544] = -33;
        byArray[545] = 93;
        byArray[546] = -94;
        byArray[547] = 76;
        byArray[548] = -59;
        byArray[549] = 22;
        byArray[550] = 50;
        byArray[551] = -88;
        byArray[552] = 66;
        byArray[553] = -10;
        byArray[554] = 69;
        byArray[555] = -90;
        byArray[556] = -74;
        byArray[557] = 54;
        byArray[558] = -71;
        byArray[559] = -32;
        byArray[560] = -65;
        byArray[561] = 101;
        byArray[562] = 54;
        byArray[563] = -109;
        byArray[564] = -62;
        byArray[565] = -46;
        byArray[566] = -41;
        byArray[567] = 107;
        byArray[568] = -36;
        byArray[569] = -34;
        byArray[570] = 89;
        byArray[571] = -42;
        byArray[572] = -94;
        byArray[573] = 53;
        byArray[574] = -8;
        byArray[575] = 69;
        CLASS1_ROOT_SELF_SIGNED_CERT = byArray;
        byte[] byArray2 = new byte[577];
        byArray2[0] = 48;
        byArray2[1] = -126;
        byArray2[2] = 2;
        byArray2[3] = 61;
        byArray2[4] = 48;
        byArray2[5] = -126;
        byArray2[6] = 1;
        byArray2[7] = -90;
        byArray2[8] = 2;
        byArray2[9] = 17;
        byArray2[11] = -70;
        byArray2[12] = 90;
        byArray2[13] = -55;
        byArray2[14] = 76;
        byArray2[15] = 5;
        byArray2[16] = 59;
        byArray2[17] = -110;
        byArray2[18] = -42;
        byArray2[19] = -89;
        byArray2[20] = -74;
        byArray2[21] = -33;
        byArray2[22] = 78;
        byArray2[23] = -48;
        byArray2[24] = 83;
        byArray2[25] = -110;
        byArray2[26] = 13;
        byArray2[27] = 48;
        byArray2[28] = 13;
        byArray2[29] = 6;
        byArray2[30] = 9;
        byArray2[31] = 42;
        byArray2[32] = -122;
        byArray2[33] = 72;
        byArray2[34] = -122;
        byArray2[35] = -9;
        byArray2[36] = 13;
        byArray2[37] = 1;
        byArray2[38] = 1;
        byArray2[39] = 2;
        byArray2[40] = 5;
        byArray2[42] = 48;
        byArray2[43] = 95;
        byArray2[44] = 49;
        byArray2[45] = 11;
        byArray2[46] = 48;
        byArray2[47] = 9;
        byArray2[48] = 6;
        byArray2[49] = 3;
        byArray2[50] = 85;
        byArray2[51] = 4;
        byArray2[52] = 6;
        byArray2[53] = 19;
        byArray2[54] = 2;
        byArray2[55] = 85;
        byArray2[56] = 83;
        byArray2[57] = 49;
        byArray2[58] = 23;
        byArray2[59] = 48;
        byArray2[60] = 21;
        byArray2[61] = 6;
        byArray2[62] = 3;
        byArray2[63] = 85;
        byArray2[64] = 4;
        byArray2[65] = 10;
        byArray2[66] = 19;
        byArray2[67] = 14;
        byArray2[68] = 86;
        byArray2[69] = 101;
        byArray2[70] = 114;
        byArray2[71] = 105;
        byArray2[72] = 83;
        byArray2[73] = 105;
        byArray2[74] = 103;
        byArray2[75] = 110;
        byArray2[76] = 44;
        byArray2[77] = 32;
        byArray2[78] = 73;
        byArray2[79] = 110;
        byArray2[80] = 99;
        byArray2[81] = 46;
        byArray2[82] = 49;
        byArray2[83] = 55;
        byArray2[84] = 48;
        byArray2[85] = 53;
        byArray2[86] = 6;
        byArray2[87] = 3;
        byArray2[88] = 85;
        byArray2[89] = 4;
        byArray2[90] = 11;
        byArray2[91] = 19;
        byArray2[92] = 46;
        byArray2[93] = 67;
        byArray2[94] = 108;
        byArray2[95] = 97;
        byArray2[96] = 115;
        byArray2[97] = 115;
        byArray2[98] = 32;
        byArray2[99] = 50;
        byArray2[100] = 32;
        byArray2[101] = 80;
        byArray2[102] = 117;
        byArray2[103] = 98;
        byArray2[104] = 108;
        byArray2[105] = 105;
        byArray2[106] = 99;
        byArray2[107] = 32;
        byArray2[108] = 80;
        byArray2[109] = 114;
        byArray2[110] = 105;
        byArray2[111] = 109;
        byArray2[112] = 97;
        byArray2[113] = 114;
        byArray2[114] = 121;
        byArray2[115] = 32;
        byArray2[116] = 67;
        byArray2[117] = 101;
        byArray2[118] = 114;
        byArray2[119] = 116;
        byArray2[120] = 105;
        byArray2[121] = 102;
        byArray2[122] = 105;
        byArray2[123] = 99;
        byArray2[124] = 97;
        byArray2[125] = 116;
        byArray2[126] = 105;
        byArray2[127] = 111;
        byArray2[128] = 110;
        byArray2[129] = 32;
        byArray2[130] = 65;
        byArray2[131] = 117;
        byArray2[132] = 116;
        byArray2[133] = 104;
        byArray2[134] = 111;
        byArray2[135] = 114;
        byArray2[136] = 105;
        byArray2[137] = 116;
        byArray2[138] = 121;
        byArray2[139] = 48;
        byArray2[140] = 30;
        byArray2[141] = 23;
        byArray2[142] = 13;
        byArray2[143] = 57;
        byArray2[144] = 54;
        byArray2[145] = 48;
        byArray2[146] = 49;
        byArray2[147] = 50;
        byArray2[148] = 57;
        byArray2[149] = 48;
        byArray2[150] = 48;
        byArray2[151] = 48;
        byArray2[152] = 48;
        byArray2[153] = 48;
        byArray2[154] = 48;
        byArray2[155] = 90;
        byArray2[156] = 23;
        byArray2[157] = 13;
        byArray2[158] = 48;
        byArray2[159] = 52;
        byArray2[160] = 48;
        byArray2[161] = 49;
        byArray2[162] = 48;
        byArray2[163] = 55;
        byArray2[164] = 50;
        byArray2[165] = 51;
        byArray2[166] = 53;
        byArray2[167] = 57;
        byArray2[168] = 53;
        byArray2[169] = 57;
        byArray2[170] = 90;
        byArray2[171] = 48;
        byArray2[172] = 95;
        byArray2[173] = 49;
        byArray2[174] = 11;
        byArray2[175] = 48;
        byArray2[176] = 9;
        byArray2[177] = 6;
        byArray2[178] = 3;
        byArray2[179] = 85;
        byArray2[180] = 4;
        byArray2[181] = 6;
        byArray2[182] = 19;
        byArray2[183] = 2;
        byArray2[184] = 85;
        byArray2[185] = 83;
        byArray2[186] = 49;
        byArray2[187] = 23;
        byArray2[188] = 48;
        byArray2[189] = 21;
        byArray2[190] = 6;
        byArray2[191] = 3;
        byArray2[192] = 85;
        byArray2[193] = 4;
        byArray2[194] = 10;
        byArray2[195] = 19;
        byArray2[196] = 14;
        byArray2[197] = 86;
        byArray2[198] = 101;
        byArray2[199] = 114;
        byArray2[200] = 105;
        byArray2[201] = 83;
        byArray2[202] = 105;
        byArray2[203] = 103;
        byArray2[204] = 110;
        byArray2[205] = 44;
        byArray2[206] = 32;
        byArray2[207] = 73;
        byArray2[208] = 110;
        byArray2[209] = 99;
        byArray2[210] = 46;
        byArray2[211] = 49;
        byArray2[212] = 55;
        byArray2[213] = 48;
        byArray2[214] = 53;
        byArray2[215] = 6;
        byArray2[216] = 3;
        byArray2[217] = 85;
        byArray2[218] = 4;
        byArray2[219] = 11;
        byArray2[220] = 19;
        byArray2[221] = 46;
        byArray2[222] = 67;
        byArray2[223] = 108;
        byArray2[224] = 97;
        byArray2[225] = 115;
        byArray2[226] = 115;
        byArray2[227] = 32;
        byArray2[228] = 50;
        byArray2[229] = 32;
        byArray2[230] = 80;
        byArray2[231] = 117;
        byArray2[232] = 98;
        byArray2[233] = 108;
        byArray2[234] = 105;
        byArray2[235] = 99;
        byArray2[236] = 32;
        byArray2[237] = 80;
        byArray2[238] = 114;
        byArray2[239] = 105;
        byArray2[240] = 109;
        byArray2[241] = 97;
        byArray2[242] = 114;
        byArray2[243] = 121;
        byArray2[244] = 32;
        byArray2[245] = 67;
        byArray2[246] = 101;
        byArray2[247] = 114;
        byArray2[248] = 116;
        byArray2[249] = 105;
        byArray2[250] = 102;
        byArray2[251] = 105;
        byArray2[252] = 99;
        byArray2[253] = 97;
        byArray2[254] = 116;
        byArray2[255] = 105;
        byArray2[256] = 111;
        byArray2[257] = 110;
        byArray2[258] = 32;
        byArray2[259] = 65;
        byArray2[260] = 117;
        byArray2[261] = 116;
        byArray2[262] = 104;
        byArray2[263] = 111;
        byArray2[264] = 114;
        byArray2[265] = 105;
        byArray2[266] = 116;
        byArray2[267] = 121;
        byArray2[268] = 48;
        byArray2[269] = -127;
        byArray2[270] = -97;
        byArray2[271] = 48;
        byArray2[272] = 13;
        byArray2[273] = 6;
        byArray2[274] = 9;
        byArray2[275] = 42;
        byArray2[276] = -122;
        byArray2[277] = 72;
        byArray2[278] = -122;
        byArray2[279] = -9;
        byArray2[280] = 13;
        byArray2[281] = 1;
        byArray2[282] = 1;
        byArray2[283] = 1;
        byArray2[284] = 5;
        byArray2[286] = 3;
        byArray2[287] = -127;
        byArray2[288] = -115;
        byArray2[290] = 48;
        byArray2[291] = -127;
        byArray2[292] = -119;
        byArray2[293] = 2;
        byArray2[294] = -127;
        byArray2[295] = -127;
        byArray2[297] = -74;
        byArray2[298] = 90;
        byArray2[299] = -117;
        byArray2[300] = -93;
        byArray2[301] = 13;
        byArray2[302] = 106;
        byArray2[303] = 35;
        byArray2[304] = -125;
        byArray2[305] = -128;
        byArray2[306] = 107;
        byArray2[307] = -49;
        byArray2[308] = 57;
        byArray2[309] = -121;
        byArray2[310] = -12;
        byArray2[311] = 33;
        byArray2[312] = 19;
        byArray2[313] = 51;
        byArray2[314] = 6;
        byArray2[315] = 76;
        byArray2[316] = 37;
        byArray2[317] = -94;
        byArray2[318] = -19;
        byArray2[319] = 85;
        byArray2[320] = 18;
        byArray2[321] = -105;
        byArray2[322] = -59;
        byArray2[323] = -89;
        byArray2[324] = -128;
        byArray2[325] = -71;
        byArray2[326] = -6;
        byArray2[327] = -125;
        byArray2[328] = -63;
        byArray2[329] = 32;
        byArray2[330] = -96;
        byArray2[331] = -6;
        byArray2[332] = 47;
        byArray2[333] = 21;
        byArray2[334] = 13;
        byArray2[335] = 124;
        byArray2[336] = -95;
        byArray2[337] = 96;
        byArray2[338] = 107;
        byArray2[339] = 126;
        byArray2[340] = 121;
        byArray2[341] = 44;
        byArray2[342] = -6;
        byArray2[343] = 6;
        byArray2[344] = 15;
        byArray2[345] = 58;
        byArray2[346] = -82;
        byArray2[347] = -10;
        byArray2[348] = 27;
        byArray2[349] = 111;
        byArray2[350] = -79;
        byArray2[351] = -46;
        byArray2[352] = -1;
        byArray2[353] = 47;
        byArray2[354] = 40;
        byArray2[355] = 82;
        byArray2[356] = 95;
        byArray2[357] = -125;
        byArray2[358] = 125;
        byArray2[359] = 75;
        byArray2[360] = -60;
        byArray2[361] = 122;
        byArray2[362] = -73;
        byArray2[363] = -8;
        byArray2[364] = 102;
        byArray2[365] = 31;
        byArray2[366] = -128;
        byArray2[367] = 84;
        byArray2[368] = -4;
        byArray2[369] = -73;
        byArray2[370] = -62;
        byArray2[371] = -114;
        byArray2[372] = 89;
        byArray2[373] = 74;
        byArray2[374] = 20;
        byArray2[375] = 87;
        byArray2[376] = 70;
        byArray2[377] = -47;
        byArray2[378] = -102;
        byArray2[379] = -109;
        byArray2[380] = -66;
        byArray2[381] = 65;
        byArray2[382] = -111;
        byArray2[383] = 3;
        byArray2[384] = -69;
        byArray2[385] = 21;
        byArray2[386] = -128;
        byArray2[387] = -109;
        byArray2[388] = 92;
        byArray2[389] = -21;
        byArray2[390] = -25;
        byArray2[391] = -52;
        byArray2[392] = 8;
        byArray2[393] = 108;
        byArray2[394] = 63;
        byArray2[395] = 62;
        byArray2[396] = -77;
        byArray2[397] = 74;
        byArray2[398] = -4;
        byArray2[399] = -1;
        byArray2[400] = 75;
        byArray2[401] = 108;
        byArray2[402] = 35;
        byArray2[403] = -43;
        byArray2[404] = 80;
        byArray2[405] = -126;
        byArray2[406] = 38;
        byArray2[407] = 68;
        byArray2[408] = 25;
        byArray2[409] = -114;
        byArray2[410] = 35;
        byArray2[411] = -61;
        byArray2[412] = 113;
        byArray2[413] = -22;
        byArray2[414] = 25;
        byArray2[415] = 36;
        byArray2[416] = 71;
        byArray2[417] = 4;
        byArray2[418] = -98;
        byArray2[419] = 117;
        byArray2[420] = -65;
        byArray2[421] = -56;
        byArray2[422] = -90;
        byArray2[424] = 31;
        byArray2[425] = 2;
        byArray2[426] = 3;
        byArray2[427] = 1;
        byArray2[429] = 1;
        byArray2[430] = 48;
        byArray2[431] = 13;
        byArray2[432] = 6;
        byArray2[433] = 9;
        byArray2[434] = 42;
        byArray2[435] = -122;
        byArray2[436] = 72;
        byArray2[437] = -122;
        byArray2[438] = -9;
        byArray2[439] = 13;
        byArray2[440] = 1;
        byArray2[441] = 1;
        byArray2[442] = 2;
        byArray2[443] = 5;
        byArray2[445] = 3;
        byArray2[446] = -127;
        byArray2[447] = -127;
        byArray2[449] = -74;
        byArray2[451] = 31;
        byArray2[452] = -109;
        byArray2[453] = 87;
        byArray2[454] = -92;
        byArray2[455] = 7;
        byArray2[456] = -89;
        byArray2[457] = 64;
        byArray2[458] = -50;
        byArray2[459] = 101;
        byArray2[460] = 64;
        byArray2[461] = 63;
        byArray2[462] = 85;
        byArray2[463] = 94;
        byArray2[464] = -19;
        byArray2[465] = -17;
        byArray2[466] = -6;
        byArray2[467] = 84;
        byArray2[468] = 73;
        byArray2[469] = -91;
        byArray2[470] = 48;
        byArray2[471] = -42;
        byArray2[472] = 33;
        byArray2[473] = 124;
        byArray2[474] = 97;
        byArray2[475] = -121;
        byArray2[476] = -18;
        byArray2[477] = -125;
        byArray2[478] = -109;
        byArray2[479] = 11;
        byArray2[480] = -65;
        byArray2[481] = -76;
        byArray2[482] = 51;
        byArray2[483] = -14;
        byArray2[484] = -104;
        byArray2[485] = -84;
        byArray2[486] = -97;
        byArray2[487] = 6;
        byArray2[488] = -65;
        byArray2[489] = 78;
        byArray2[490] = -88;
        byArray2[491] = -50;
        byArray2[492] = 20;
        byArray2[493] = -127;
        byArray2[494] = 76;
        byArray2[495] = -53;
        byArray2[496] = 4;
        byArray2[497] = 78;
        byArray2[498] = 88;
        byArray2[499] = -61;
        byArray2[500] = -49;
        byArray2[501] = 95;
        byArray2[502] = -18;
        byArray2[503] = 124;
        byArray2[504] = -41;
        byArray2[505] = -102;
        byArray2[506] = 111;
        byArray2[507] = -53;
        byArray2[508] = 65;
        byArray2[509] = -118;
        byArray2[510] = -73;
        byArray2[511] = 127;
        byArray2[512] = -127;
        byArray2[513] = -72;
        byArray2[514] = -1;
        byArray2[515] = -124;
        byArray2[516] = 97;
        byArray2[517] = -58;
        byArray2[518] = 39;
        byArray2[519] = 67;
        byArray2[520] = 101;
        byArray2[521] = 29;
        byArray2[522] = 12;
        byArray2[523] = -20;
        byArray2[524] = -79;
        byArray2[526] = 10;
        byArray2[527] = -35;
        byArray2[528] = 27;
        byArray2[529] = -92;
        byArray2[530] = -69;
        byArray2[531] = -57;
        byArray2[532] = 120;
        byArray2[533] = 32;
        byArray2[534] = 40;
        byArray2[535] = -78;
        byArray2[536] = -94;
        byArray2[537] = -35;
        byArray2[538] = 54;
        byArray2[539] = -107;
        byArray2[540] = 46;
        byArray2[541] = -31;
        byArray2[542] = 84;
        byArray2[543] = 79;
        byArray2[544] = -65;
        byArray2[545] = 96;
        byArray2[546] = -71;
        byArray2[547] = 119;
        byArray2[548] = 104;
        byArray2[549] = 17;
        byArray2[550] = -103;
        byArray2[551] = 35;
        byArray2[552] = -24;
        byArray2[553] = -22;
        byArray2[554] = 82;
        byArray2[555] = -24;
        byArray2[556] = -86;
        byArray2[558] = 78;
        byArray2[559] = 103;
        byArray2[560] = 78;
        byArray2[561] = -69;
        byArray2[562] = -112;
        byArray2[563] = -75;
        byArray2[564] = 69;
        byArray2[565] = -101;
        byArray2[566] = 70;
        byArray2[567] = -21;
        byArray2[568] = -114;
        byArray2[569] = 22;
        byArray2[570] = -17;
        byArray2[571] = -60;
        byArray2[572] = 51;
        byArray2[573] = 91;
        byArray2[574] = 51;
        byArray2[575] = 61;
        byArray2[576] = -43;
        CLASS2_ROOT_SELF_SIGNED_CERT = byArray2;
        CLASS3_ROOT_LABEL = "Verisign Class 3 Public Primary Certification Authority";
        byte[] byArray3 = new byte[577];
        byArray3[0] = 48;
        byArray3[1] = -126;
        byArray3[2] = 2;
        byArray3[3] = 61;
        byArray3[4] = 48;
        byArray3[5] = -126;
        byArray3[6] = 1;
        byArray3[7] = -90;
        byArray3[8] = 2;
        byArray3[9] = 17;
        byArray3[11] = -28;
        byArray3[12] = -98;
        byArray3[13] = -3;
        byArray3[14] = -13;
        byArray3[15] = 58;
        byArray3[16] = -24;
        byArray3[17] = 14;
        byArray3[18] = -49;
        byArray3[19] = -91;
        byArray3[20] = 17;
        byArray3[21] = 62;
        byArray3[22] = 25;
        byArray3[23] = -92;
        byArray3[24] = 36;
        byArray3[25] = 2;
        byArray3[26] = 50;
        byArray3[27] = 48;
        byArray3[28] = 13;
        byArray3[29] = 6;
        byArray3[30] = 9;
        byArray3[31] = 42;
        byArray3[32] = -122;
        byArray3[33] = 72;
        byArray3[34] = -122;
        byArray3[35] = -9;
        byArray3[36] = 13;
        byArray3[37] = 1;
        byArray3[38] = 1;
        byArray3[39] = 2;
        byArray3[40] = 5;
        byArray3[42] = 48;
        byArray3[43] = 95;
        byArray3[44] = 49;
        byArray3[45] = 11;
        byArray3[46] = 48;
        byArray3[47] = 9;
        byArray3[48] = 6;
        byArray3[49] = 3;
        byArray3[50] = 85;
        byArray3[51] = 4;
        byArray3[52] = 6;
        byArray3[53] = 19;
        byArray3[54] = 2;
        byArray3[55] = 85;
        byArray3[56] = 83;
        byArray3[57] = 49;
        byArray3[58] = 23;
        byArray3[59] = 48;
        byArray3[60] = 21;
        byArray3[61] = 6;
        byArray3[62] = 3;
        byArray3[63] = 85;
        byArray3[64] = 4;
        byArray3[65] = 10;
        byArray3[66] = 19;
        byArray3[67] = 14;
        byArray3[68] = 86;
        byArray3[69] = 101;
        byArray3[70] = 114;
        byArray3[71] = 105;
        byArray3[72] = 83;
        byArray3[73] = 105;
        byArray3[74] = 103;
        byArray3[75] = 110;
        byArray3[76] = 44;
        byArray3[77] = 32;
        byArray3[78] = 73;
        byArray3[79] = 110;
        byArray3[80] = 99;
        byArray3[81] = 46;
        byArray3[82] = 49;
        byArray3[83] = 55;
        byArray3[84] = 48;
        byArray3[85] = 53;
        byArray3[86] = 6;
        byArray3[87] = 3;
        byArray3[88] = 85;
        byArray3[89] = 4;
        byArray3[90] = 11;
        byArray3[91] = 19;
        byArray3[92] = 46;
        byArray3[93] = 67;
        byArray3[94] = 108;
        byArray3[95] = 97;
        byArray3[96] = 115;
        byArray3[97] = 115;
        byArray3[98] = 32;
        byArray3[99] = 51;
        byArray3[100] = 32;
        byArray3[101] = 80;
        byArray3[102] = 117;
        byArray3[103] = 98;
        byArray3[104] = 108;
        byArray3[105] = 105;
        byArray3[106] = 99;
        byArray3[107] = 32;
        byArray3[108] = 80;
        byArray3[109] = 114;
        byArray3[110] = 105;
        byArray3[111] = 109;
        byArray3[112] = 97;
        byArray3[113] = 114;
        byArray3[114] = 121;
        byArray3[115] = 32;
        byArray3[116] = 67;
        byArray3[117] = 101;
        byArray3[118] = 114;
        byArray3[119] = 116;
        byArray3[120] = 105;
        byArray3[121] = 102;
        byArray3[122] = 105;
        byArray3[123] = 99;
        byArray3[124] = 97;
        byArray3[125] = 116;
        byArray3[126] = 105;
        byArray3[127] = 111;
        byArray3[128] = 110;
        byArray3[129] = 32;
        byArray3[130] = 65;
        byArray3[131] = 117;
        byArray3[132] = 116;
        byArray3[133] = 104;
        byArray3[134] = 111;
        byArray3[135] = 114;
        byArray3[136] = 105;
        byArray3[137] = 116;
        byArray3[138] = 121;
        byArray3[139] = 48;
        byArray3[140] = 30;
        byArray3[141] = 23;
        byArray3[142] = 13;
        byArray3[143] = 57;
        byArray3[144] = 54;
        byArray3[145] = 48;
        byArray3[146] = 49;
        byArray3[147] = 50;
        byArray3[148] = 57;
        byArray3[149] = 48;
        byArray3[150] = 48;
        byArray3[151] = 48;
        byArray3[152] = 48;
        byArray3[153] = 48;
        byArray3[154] = 48;
        byArray3[155] = 90;
        byArray3[156] = 23;
        byArray3[157] = 13;
        byArray3[158] = 48;
        byArray3[159] = 52;
        byArray3[160] = 48;
        byArray3[161] = 49;
        byArray3[162] = 48;
        byArray3[163] = 55;
        byArray3[164] = 50;
        byArray3[165] = 51;
        byArray3[166] = 53;
        byArray3[167] = 57;
        byArray3[168] = 53;
        byArray3[169] = 57;
        byArray3[170] = 90;
        byArray3[171] = 48;
        byArray3[172] = 95;
        byArray3[173] = 49;
        byArray3[174] = 11;
        byArray3[175] = 48;
        byArray3[176] = 9;
        byArray3[177] = 6;
        byArray3[178] = 3;
        byArray3[179] = 85;
        byArray3[180] = 4;
        byArray3[181] = 6;
        byArray3[182] = 19;
        byArray3[183] = 2;
        byArray3[184] = 85;
        byArray3[185] = 83;
        byArray3[186] = 49;
        byArray3[187] = 23;
        byArray3[188] = 48;
        byArray3[189] = 21;
        byArray3[190] = 6;
        byArray3[191] = 3;
        byArray3[192] = 85;
        byArray3[193] = 4;
        byArray3[194] = 10;
        byArray3[195] = 19;
        byArray3[196] = 14;
        byArray3[197] = 86;
        byArray3[198] = 101;
        byArray3[199] = 114;
        byArray3[200] = 105;
        byArray3[201] = 83;
        byArray3[202] = 105;
        byArray3[203] = 103;
        byArray3[204] = 110;
        byArray3[205] = 44;
        byArray3[206] = 32;
        byArray3[207] = 73;
        byArray3[208] = 110;
        byArray3[209] = 99;
        byArray3[210] = 46;
        byArray3[211] = 49;
        byArray3[212] = 55;
        byArray3[213] = 48;
        byArray3[214] = 53;
        byArray3[215] = 6;
        byArray3[216] = 3;
        byArray3[217] = 85;
        byArray3[218] = 4;
        byArray3[219] = 11;
        byArray3[220] = 19;
        byArray3[221] = 46;
        byArray3[222] = 67;
        byArray3[223] = 108;
        byArray3[224] = 97;
        byArray3[225] = 115;
        byArray3[226] = 115;
        byArray3[227] = 32;
        byArray3[228] = 51;
        byArray3[229] = 32;
        byArray3[230] = 80;
        byArray3[231] = 117;
        byArray3[232] = 98;
        byArray3[233] = 108;
        byArray3[234] = 105;
        byArray3[235] = 99;
        byArray3[236] = 32;
        byArray3[237] = 80;
        byArray3[238] = 114;
        byArray3[239] = 105;
        byArray3[240] = 109;
        byArray3[241] = 97;
        byArray3[242] = 114;
        byArray3[243] = 121;
        byArray3[244] = 32;
        byArray3[245] = 67;
        byArray3[246] = 101;
        byArray3[247] = 114;
        byArray3[248] = 116;
        byArray3[249] = 105;
        byArray3[250] = 102;
        byArray3[251] = 105;
        byArray3[252] = 99;
        byArray3[253] = 97;
        byArray3[254] = 116;
        byArray3[255] = 105;
        byArray3[256] = 111;
        byArray3[257] = 110;
        byArray3[258] = 32;
        byArray3[259] = 65;
        byArray3[260] = 117;
        byArray3[261] = 116;
        byArray3[262] = 104;
        byArray3[263] = 111;
        byArray3[264] = 114;
        byArray3[265] = 105;
        byArray3[266] = 116;
        byArray3[267] = 121;
        byArray3[268] = 48;
        byArray3[269] = -127;
        byArray3[270] = -97;
        byArray3[271] = 48;
        byArray3[272] = 13;
        byArray3[273] = 6;
        byArray3[274] = 9;
        byArray3[275] = 42;
        byArray3[276] = -122;
        byArray3[277] = 72;
        byArray3[278] = -122;
        byArray3[279] = -9;
        byArray3[280] = 13;
        byArray3[281] = 1;
        byArray3[282] = 1;
        byArray3[283] = 1;
        byArray3[284] = 5;
        byArray3[286] = 3;
        byArray3[287] = -127;
        byArray3[288] = -115;
        byArray3[290] = 48;
        byArray3[291] = -127;
        byArray3[292] = -119;
        byArray3[293] = 2;
        byArray3[294] = -127;
        byArray3[295] = -127;
        byArray3[297] = -55;
        byArray3[298] = 92;
        byArray3[299] = 89;
        byArray3[300] = -98;
        byArray3[301] = -14;
        byArray3[302] = 27;
        byArray3[303] = -118;
        byArray3[304] = 1;
        byArray3[305] = 20;
        byArray3[306] = -76;
        byArray3[307] = 16;
        byArray3[308] = -33;
        byArray3[309] = 4;
        byArray3[310] = 64;
        byArray3[311] = -37;
        byArray3[312] = -29;
        byArray3[313] = 87;
        byArray3[314] = -81;
        byArray3[315] = 106;
        byArray3[316] = 69;
        byArray3[317] = 64;
        byArray3[318] = -113;
        byArray3[319] = -124;
        byArray3[320] = 12;
        byArray3[321] = 11;
        byArray3[322] = -47;
        byArray3[323] = 51;
        byArray3[324] = -39;
        byArray3[325] = -39;
        byArray3[326] = 17;
        byArray3[327] = -49;
        byArray3[328] = -18;
        byArray3[329] = 2;
        byArray3[330] = 88;
        byArray3[331] = 31;
        byArray3[332] = 37;
        byArray3[333] = -9;
        byArray3[334] = 42;
        byArray3[335] = -88;
        byArray3[336] = 68;
        byArray3[337] = 5;
        byArray3[338] = -86;
        byArray3[339] = -20;
        byArray3[340] = 3;
        byArray3[341] = 31;
        byArray3[342] = 120;
        byArray3[343] = 127;
        byArray3[344] = -98;
        byArray3[345] = -109;
        byArray3[346] = -71;
        byArray3[347] = -102;
        byArray3[349] = -86;
        byArray3[350] = 35;
        byArray3[351] = 125;
        byArray3[352] = -42;
        byArray3[353] = -84;
        byArray3[354] = -123;
        byArray3[355] = -94;
        byArray3[356] = 99;
        byArray3[357] = 69;
        byArray3[358] = -57;
        byArray3[359] = 114;
        byArray3[360] = 39;
        byArray3[361] = -52;
        byArray3[362] = -12;
        byArray3[363] = 76;
        byArray3[364] = -58;
        byArray3[365] = 117;
        byArray3[366] = 113;
        byArray3[367] = -46;
        byArray3[368] = 57;
        byArray3[369] = -17;
        byArray3[370] = 79;
        byArray3[371] = 66;
        byArray3[372] = -16;
        byArray3[373] = 117;
        byArray3[374] = -33;
        byArray3[375] = 10;
        byArray3[376] = -112;
        byArray3[377] = -58;
        byArray3[378] = -114;
        byArray3[379] = 32;
        byArray3[380] = 111;
        byArray3[381] = -104;
        byArray3[382] = 15;
        byArray3[383] = -8;
        byArray3[384] = -84;
        byArray3[385] = 35;
        byArray3[386] = 95;
        byArray3[387] = 112;
        byArray3[388] = 41;
        byArray3[389] = 54;
        byArray3[390] = -92;
        byArray3[391] = -55;
        byArray3[392] = -122;
        byArray3[393] = -25;
        byArray3[394] = -79;
        byArray3[395] = -102;
        byArray3[396] = 32;
        byArray3[397] = -53;
        byArray3[398] = 83;
        byArray3[399] = -91;
        byArray3[400] = -123;
        byArray3[401] = -25;
        byArray3[402] = 61;
        byArray3[403] = -66;
        byArray3[404] = 125;
        byArray3[405] = -102;
        byArray3[406] = -2;
        byArray3[407] = 36;
        byArray3[408] = 69;
        byArray3[409] = 51;
        byArray3[410] = -36;
        byArray3[411] = 118;
        byArray3[412] = 21;
        byArray3[413] = -19;
        byArray3[414] = 15;
        byArray3[415] = -94;
        byArray3[416] = 113;
        byArray3[417] = 100;
        byArray3[418] = 76;
        byArray3[419] = 101;
        byArray3[420] = 46;
        byArray3[421] = -127;
        byArray3[422] = 104;
        byArray3[423] = 69;
        byArray3[424] = -89;
        byArray3[425] = 2;
        byArray3[426] = 3;
        byArray3[427] = 1;
        byArray3[429] = 1;
        byArray3[430] = 48;
        byArray3[431] = 13;
        byArray3[432] = 6;
        byArray3[433] = 9;
        byArray3[434] = 42;
        byArray3[435] = -122;
        byArray3[436] = 72;
        byArray3[437] = -122;
        byArray3[438] = -9;
        byArray3[439] = 13;
        byArray3[440] = 1;
        byArray3[441] = 1;
        byArray3[442] = 2;
        byArray3[443] = 5;
        byArray3[445] = 3;
        byArray3[446] = -127;
        byArray3[447] = -127;
        byArray3[449] = 97;
        byArray3[450] = 112;
        byArray3[451] = -20;
        byArray3[452] = 47;
        byArray3[453] = 63;
        byArray3[454] = -98;
        byArray3[455] = -3;
        byArray3[456] = 43;
        byArray3[457] = -26;
        byArray3[458] = 104;
        byArray3[459] = 84;
        byArray3[460] = 33;
        byArray3[461] = -80;
        byArray3[462] = 103;
        byArray3[463] = 121;
        byArray3[464] = 8;
        byArray3[465] = 12;
        byArray3[466] = 32;
        byArray3[467] = -106;
        byArray3[468] = 49;
        byArray3[469] = -118;
        byArray3[470] = 13;
        byArray3[471] = 122;
        byArray3[472] = -66;
        byArray3[473] = -74;
        byArray3[474] = 38;
        byArray3[475] = -33;
        byArray3[476] = 121;
        byArray3[477] = 44;
        byArray3[478] = 34;
        byArray3[479] = 105;
        byArray3[480] = 73;
        byArray3[481] = 54;
        byArray3[482] = -29;
        byArray3[483] = -105;
        byArray3[484] = 119;
        byArray3[485] = 98;
        byArray3[486] = 97;
        byArray3[487] = -94;
        byArray3[488] = 50;
        byArray3[489] = -41;
        byArray3[490] = 122;
        byArray3[491] = 84;
        byArray3[492] = 33;
        byArray3[493] = 54;
        byArray3[494] = -70;
        byArray3[495] = 2;
        byArray3[496] = -55;
        byArray3[497] = 52;
        byArray3[498] = -25;
        byArray3[499] = 37;
        byArray3[500] = -38;
        byArray3[501] = 68;
        byArray3[502] = 53;
        byArray3[503] = -80;
        byArray3[504] = -46;
        byArray3[505] = 92;
        byArray3[506] = -128;
        byArray3[507] = 93;
        byArray3[508] = -77;
        byArray3[509] = -108;
        byArray3[510] = -8;
        byArray3[511] = -7;
        byArray3[512] = -84;
        byArray3[513] = -18;
        byArray3[514] = -92;
        byArray3[515] = 96;
        byArray3[516] = 117;
        byArray3[517] = 42;
        byArray3[518] = 31;
        byArray3[519] = -107;
        byArray3[520] = 73;
        byArray3[521] = 35;
        byArray3[522] = -79;
        byArray3[523] = 74;
        byArray3[524] = 124;
        byArray3[525] = -12;
        byArray3[526] = -77;
        byArray3[527] = 71;
        byArray3[528] = 114;
        byArray3[529] = 33;
        byArray3[530] = 91;
        byArray3[531] = 126;
        byArray3[532] = -105;
        byArray3[533] = -85;
        byArray3[534] = 84;
        byArray3[535] = -84;
        byArray3[536] = 98;
        byArray3[537] = -25;
        byArray3[538] = 93;
        byArray3[539] = -20;
        byArray3[540] = -82;
        byArray3[541] = -101;
        byArray3[542] = -46;
        byArray3[543] = -55;
        byArray3[544] = -78;
        byArray3[545] = 36;
        byArray3[546] = -5;
        byArray3[547] = -126;
        byArray3[548] = -83;
        byArray3[549] = -23;
        byArray3[550] = 103;
        byArray3[551] = 21;
        byArray3[552] = 75;
        byArray3[553] = -70;
        byArray3[554] = -86;
        byArray3[555] = -90;
        byArray3[556] = -16;
        byArray3[557] = -105;
        byArray3[558] = -96;
        byArray3[559] = -10;
        byArray3[560] = -80;
        byArray3[561] = -105;
        byArray3[562] = 87;
        byArray3[564] = -56;
        byArray3[565] = 12;
        byArray3[566] = 60;
        byArray3[567] = 9;
        byArray3[568] = -96;
        byArray3[569] = -126;
        byArray3[570] = 4;
        byArray3[571] = -70;
        byArray3[572] = 65;
        byArray3[573] = -38;
        byArray3[574] = -9;
        byArray3[575] = -103;
        byArray3[576] = -92;
        CLASS3_ROOT_SELF_SIGNED_CERT = byArray3;
        byte[] byArray4 = new byte[568];
        byArray4[0] = 48;
        byArray4[1] = -126;
        byArray4[2] = 2;
        byArray4[3] = 52;
        byArray4[4] = 48;
        byArray4[5] = -126;
        byArray4[6] = 1;
        byArray4[7] = -95;
        byArray4[8] = 2;
        byArray4[9] = 16;
        byArray4[10] = 2;
        byArray4[11] = -83;
        byArray4[12] = 102;
        byArray4[13] = 126;
        byArray4[14] = 78;
        byArray4[15] = 69;
        byArray4[16] = -2;
        byArray4[17] = 94;
        byArray4[18] = 87;
        byArray4[19] = 111;
        byArray4[20] = 60;
        byArray4[21] = -104;
        byArray4[22] = 25;
        byArray4[23] = 94;
        byArray4[24] = -35;
        byArray4[25] = -64;
        byArray4[26] = 48;
        byArray4[27] = 13;
        byArray4[28] = 6;
        byArray4[29] = 9;
        byArray4[30] = 42;
        byArray4[31] = -122;
        byArray4[32] = 72;
        byArray4[33] = -122;
        byArray4[34] = -9;
        byArray4[35] = 13;
        byArray4[36] = 1;
        byArray4[37] = 1;
        byArray4[38] = 2;
        byArray4[39] = 5;
        byArray4[41] = 48;
        byArray4[42] = 95;
        byArray4[43] = 49;
        byArray4[44] = 11;
        byArray4[45] = 48;
        byArray4[46] = 9;
        byArray4[47] = 6;
        byArray4[48] = 3;
        byArray4[49] = 85;
        byArray4[50] = 4;
        byArray4[51] = 6;
        byArray4[52] = 19;
        byArray4[53] = 2;
        byArray4[54] = 85;
        byArray4[55] = 83;
        byArray4[56] = 49;
        byArray4[57] = 32;
        byArray4[58] = 48;
        byArray4[59] = 30;
        byArray4[60] = 6;
        byArray4[61] = 3;
        byArray4[62] = 85;
        byArray4[63] = 4;
        byArray4[64] = 10;
        byArray4[65] = 19;
        byArray4[66] = 23;
        byArray4[67] = 82;
        byArray4[68] = 83;
        byArray4[69] = 65;
        byArray4[70] = 32;
        byArray4[71] = 68;
        byArray4[72] = 97;
        byArray4[73] = 116;
        byArray4[74] = 97;
        byArray4[75] = 32;
        byArray4[76] = 83;
        byArray4[77] = 101;
        byArray4[78] = 99;
        byArray4[79] = 117;
        byArray4[80] = 114;
        byArray4[81] = 105;
        byArray4[82] = 116;
        byArray4[83] = 121;
        byArray4[84] = 44;
        byArray4[85] = 32;
        byArray4[86] = 73;
        byArray4[87] = 110;
        byArray4[88] = 99;
        byArray4[89] = 46;
        byArray4[90] = 49;
        byArray4[91] = 46;
        byArray4[92] = 48;
        byArray4[93] = 44;
        byArray4[94] = 6;
        byArray4[95] = 3;
        byArray4[96] = 85;
        byArray4[97] = 4;
        byArray4[98] = 11;
        byArray4[99] = 19;
        byArray4[100] = 37;
        byArray4[101] = 83;
        byArray4[102] = 101;
        byArray4[103] = 99;
        byArray4[104] = 117;
        byArray4[105] = 114;
        byArray4[106] = 101;
        byArray4[107] = 32;
        byArray4[108] = 83;
        byArray4[109] = 101;
        byArray4[110] = 114;
        byArray4[111] = 118;
        byArray4[112] = 101;
        byArray4[113] = 114;
        byArray4[114] = 32;
        byArray4[115] = 67;
        byArray4[116] = 101;
        byArray4[117] = 114;
        byArray4[118] = 116;
        byArray4[119] = 105;
        byArray4[120] = 102;
        byArray4[121] = 105;
        byArray4[122] = 99;
        byArray4[123] = 97;
        byArray4[124] = 116;
        byArray4[125] = 105;
        byArray4[126] = 111;
        byArray4[127] = 110;
        byArray4[128] = 32;
        byArray4[129] = 65;
        byArray4[130] = 117;
        byArray4[131] = 116;
        byArray4[132] = 104;
        byArray4[133] = 111;
        byArray4[134] = 114;
        byArray4[135] = 105;
        byArray4[136] = 116;
        byArray4[137] = 121;
        byArray4[138] = 48;
        byArray4[139] = 30;
        byArray4[140] = 23;
        byArray4[141] = 13;
        byArray4[142] = 57;
        byArray4[143] = 52;
        byArray4[144] = 49;
        byArray4[145] = 49;
        byArray4[146] = 48;
        byArray4[147] = 57;
        byArray4[148] = 48;
        byArray4[149] = 48;
        byArray4[150] = 48;
        byArray4[151] = 48;
        byArray4[152] = 48;
        byArray4[153] = 48;
        byArray4[154] = 90;
        byArray4[155] = 23;
        byArray4[156] = 13;
        byArray4[157] = 49;
        byArray4[158] = 48;
        byArray4[159] = 48;
        byArray4[160] = 49;
        byArray4[161] = 48;
        byArray4[162] = 55;
        byArray4[163] = 50;
        byArray4[164] = 51;
        byArray4[165] = 53;
        byArray4[166] = 57;
        byArray4[167] = 53;
        byArray4[168] = 57;
        byArray4[169] = 90;
        byArray4[170] = 48;
        byArray4[171] = 95;
        byArray4[172] = 49;
        byArray4[173] = 11;
        byArray4[174] = 48;
        byArray4[175] = 9;
        byArray4[176] = 6;
        byArray4[177] = 3;
        byArray4[178] = 85;
        byArray4[179] = 4;
        byArray4[180] = 6;
        byArray4[181] = 19;
        byArray4[182] = 2;
        byArray4[183] = 85;
        byArray4[184] = 83;
        byArray4[185] = 49;
        byArray4[186] = 32;
        byArray4[187] = 48;
        byArray4[188] = 30;
        byArray4[189] = 6;
        byArray4[190] = 3;
        byArray4[191] = 85;
        byArray4[192] = 4;
        byArray4[193] = 10;
        byArray4[194] = 19;
        byArray4[195] = 23;
        byArray4[196] = 82;
        byArray4[197] = 83;
        byArray4[198] = 65;
        byArray4[199] = 32;
        byArray4[200] = 68;
        byArray4[201] = 97;
        byArray4[202] = 116;
        byArray4[203] = 97;
        byArray4[204] = 32;
        byArray4[205] = 83;
        byArray4[206] = 101;
        byArray4[207] = 99;
        byArray4[208] = 117;
        byArray4[209] = 114;
        byArray4[210] = 105;
        byArray4[211] = 116;
        byArray4[212] = 121;
        byArray4[213] = 44;
        byArray4[214] = 32;
        byArray4[215] = 73;
        byArray4[216] = 110;
        byArray4[217] = 99;
        byArray4[218] = 46;
        byArray4[219] = 49;
        byArray4[220] = 46;
        byArray4[221] = 48;
        byArray4[222] = 44;
        byArray4[223] = 6;
        byArray4[224] = 3;
        byArray4[225] = 85;
        byArray4[226] = 4;
        byArray4[227] = 11;
        byArray4[228] = 19;
        byArray4[229] = 37;
        byArray4[230] = 83;
        byArray4[231] = 101;
        byArray4[232] = 99;
        byArray4[233] = 117;
        byArray4[234] = 114;
        byArray4[235] = 101;
        byArray4[236] = 32;
        byArray4[237] = 83;
        byArray4[238] = 101;
        byArray4[239] = 114;
        byArray4[240] = 118;
        byArray4[241] = 101;
        byArray4[242] = 114;
        byArray4[243] = 32;
        byArray4[244] = 67;
        byArray4[245] = 101;
        byArray4[246] = 114;
        byArray4[247] = 116;
        byArray4[248] = 105;
        byArray4[249] = 102;
        byArray4[250] = 105;
        byArray4[251] = 99;
        byArray4[252] = 97;
        byArray4[253] = 116;
        byArray4[254] = 105;
        byArray4[255] = 111;
        byArray4[256] = 110;
        byArray4[257] = 32;
        byArray4[258] = 65;
        byArray4[259] = 117;
        byArray4[260] = 116;
        byArray4[261] = 104;
        byArray4[262] = 111;
        byArray4[263] = 114;
        byArray4[264] = 105;
        byArray4[265] = 116;
        byArray4[266] = 121;
        byArray4[267] = 48;
        byArray4[268] = -127;
        byArray4[269] = -101;
        byArray4[270] = 48;
        byArray4[271] = 13;
        byArray4[272] = 6;
        byArray4[273] = 9;
        byArray4[274] = 42;
        byArray4[275] = -122;
        byArray4[276] = 72;
        byArray4[277] = -122;
        byArray4[278] = -9;
        byArray4[279] = 13;
        byArray4[280] = 1;
        byArray4[281] = 1;
        byArray4[282] = 1;
        byArray4[283] = 5;
        byArray4[285] = 3;
        byArray4[286] = -127;
        byArray4[287] = -119;
        byArray4[289] = 48;
        byArray4[290] = -127;
        byArray4[291] = -123;
        byArray4[292] = 2;
        byArray4[293] = 126;
        byArray4[295] = -110;
        byArray4[296] = -50;
        byArray4[297] = 122;
        byArray4[298] = -63;
        byArray4[299] = -82;
        byArray4[300] = -125;
        byArray4[301] = 62;
        byArray4[302] = 90;
        byArray4[303] = -86;
        byArray4[304] = -119;
        byArray4[305] = -125;
        byArray4[306] = 87;
        byArray4[307] = -84;
        byArray4[308] = 37;
        byArray4[309] = 1;
        byArray4[310] = 118;
        byArray4[311] = 12;
        byArray4[312] = -83;
        byArray4[313] = -82;
        byArray4[314] = -114;
        byArray4[315] = 44;
        byArray4[316] = 55;
        byArray4[317] = -50;
        byArray4[318] = -21;
        byArray4[319] = 53;
        byArray4[320] = 120;
        byArray4[321] = 100;
        byArray4[322] = 84;
        byArray4[323] = 3;
        byArray4[324] = -27;
        byArray4[325] = -124;
        byArray4[326] = 64;
        byArray4[327] = 81;
        byArray4[328] = -55;
        byArray4[329] = -65;
        byArray4[330] = -113;
        byArray4[331] = 8;
        byArray4[332] = -30;
        byArray4[333] = -118;
        byArray4[334] = -126;
        byArray4[335] = 8;
        byArray4[336] = -46;
        byArray4[337] = 22;
        byArray4[338] = -122;
        byArray4[339] = 55;
        byArray4[340] = 85;
        byArray4[341] = -23;
        byArray4[342] = -79;
        byArray4[343] = 33;
        byArray4[344] = 2;
        byArray4[345] = -83;
        byArray4[346] = 118;
        byArray4[347] = 104;
        byArray4[348] = -127;
        byArray4[349] = -102;
        byArray4[350] = 5;
        byArray4[351] = -94;
        byArray4[352] = 75;
        byArray4[353] = -55;
        byArray4[354] = 75;
        byArray4[355] = 37;
        byArray4[356] = 102;
        byArray4[357] = 34;
        byArray4[358] = 86;
        byArray4[359] = 108;
        byArray4[360] = -120;
        byArray4[361] = 7;
        byArray4[362] = -113;
        byArray4[363] = -9;
        byArray4[364] = -127;
        byArray4[365] = 89;
        byArray4[366] = 109;
        byArray4[367] = -124;
        byArray4[368] = 7;
        byArray4[369] = 101;
        byArray4[370] = 112;
        byArray4[371] = 19;
        byArray4[372] = 113;
        byArray4[373] = 118;
        byArray4[374] = 62;
        byArray4[375] = -101;
        byArray4[376] = 119;
        byArray4[377] = 76;
        byArray4[378] = -29;
        byArray4[379] = 80;
        byArray4[380] = -119;
        byArray4[381] = 86;
        byArray4[382] = -104;
        byArray4[383] = 72;
        byArray4[384] = -71;
        byArray4[385] = 29;
        byArray4[386] = -89;
        byArray4[387] = 41;
        byArray4[388] = 26;
        byArray4[389] = 19;
        byArray4[390] = 46;
        byArray4[391] = 74;
        byArray4[392] = 17;
        byArray4[393] = 89;
        byArray4[394] = -100;
        byArray4[395] = 30;
        byArray4[396] = 21;
        byArray4[397] = -43;
        byArray4[398] = 73;
        byArray4[399] = 84;
        byArray4[400] = 44;
        byArray4[401] = 115;
        byArray4[402] = 58;
        byArray4[403] = 105;
        byArray4[404] = -126;
        byArray4[405] = -79;
        byArray4[406] = -105;
        byArray4[407] = 57;
        byArray4[408] = -100;
        byArray4[409] = 109;
        byArray4[410] = 112;
        byArray4[411] = 103;
        byArray4[412] = 72;
        byArray4[413] = -27;
        byArray4[414] = -35;
        byArray4[415] = 45;
        byArray4[416] = -42;
        byArray4[417] = -56;
        byArray4[418] = 30;
        byArray4[419] = 123;
        byArray4[420] = 2;
        byArray4[421] = 3;
        byArray4[422] = 1;
        byArray4[424] = 1;
        byArray4[425] = 48;
        byArray4[426] = 13;
        byArray4[427] = 6;
        byArray4[428] = 9;
        byArray4[429] = 42;
        byArray4[430] = -122;
        byArray4[431] = 72;
        byArray4[432] = -122;
        byArray4[433] = -9;
        byArray4[434] = 13;
        byArray4[435] = 1;
        byArray4[436] = 1;
        byArray4[437] = 2;
        byArray4[438] = 5;
        byArray4[440] = 3;
        byArray4[441] = 126;
        byArray4[443] = 101;
        byArray4[444] = -35;
        byArray4[445] = 126;
        byArray4[446] = -31;
        byArray4[447] = -78;
        byArray4[448] = -20;
        byArray4[449] = -80;
        byArray4[450] = -30;
        byArray4[451] = 58;
        byArray4[452] = -32;
        byArray4[453] = -20;
        byArray4[454] = 113;
        byArray4[455] = 70;
        byArray4[456] = -102;
        byArray4[457] = 25;
        byArray4[458] = 17;
        byArray4[459] = -72;
        byArray4[460] = -45;
        byArray4[461] = -57;
        byArray4[462] = -96;
        byArray4[463] = -76;
        byArray4[464] = 3;
        byArray4[465] = 64;
        byArray4[466] = 38;
        byArray4[467] = 2;
        byArray4[468] = 62;
        byArray4[469] = 9;
        byArray4[470] = -100;
        byArray4[471] = -31;
        byArray4[472] = 18;
        byArray4[473] = -77;
        byArray4[474] = -47;
        byArray4[475] = 90;
        byArray4[476] = -10;
        byArray4[477] = 55;
        byArray4[478] = -91;
        byArray4[479] = -73;
        byArray4[480] = 97;
        byArray4[481] = 3;
        byArray4[482] = -74;
        byArray4[483] = 91;
        byArray4[484] = 22;
        byArray4[485] = 105;
        byArray4[486] = 59;
        byArray4[487] = -58;
        byArray4[488] = 68;
        byArray4[489] = 8;
        byArray4[490] = 12;
        byArray4[491] = -120;
        byArray4[492] = 83;
        byArray4[493] = 12;
        byArray4[494] = 107;
        byArray4[495] = -105;
        byArray4[496] = 73;
        byArray4[497] = -57;
        byArray4[498] = 62;
        byArray4[499] = 53;
        byArray4[500] = -36;
        byArray4[501] = 108;
        byArray4[502] = -71;
        byArray4[503] = -69;
        byArray4[504] = -86;
        byArray4[505] = -33;
        byArray4[506] = 92;
        byArray4[507] = -69;
        byArray4[508] = 58;
        byArray4[509] = 47;
        byArray4[510] = -109;
        byArray4[511] = 96;
        byArray4[512] = -74;
        byArray4[513] = -87;
        byArray4[514] = 75;
        byArray4[515] = 77;
        byArray4[516] = -14;
        byArray4[517] = 32;
        byArray4[518] = -9;
        byArray4[519] = -51;
        byArray4[520] = 95;
        byArray4[521] = 127;
        byArray4[522] = 100;
        byArray4[523] = 123;
        byArray4[524] = -114;
        byArray4[525] = -36;
        byArray4[527] = 92;
        byArray4[528] = -41;
        byArray4[529] = -6;
        byArray4[530] = 119;
        byArray4[531] = -54;
        byArray4[532] = 57;
        byArray4[533] = 22;
        byArray4[534] = 89;
        byArray4[535] = 111;
        byArray4[536] = 14;
        byArray4[537] = -22;
        byArray4[538] = -45;
        byArray4[539] = -75;
        byArray4[540] = -125;
        byArray4[541] = 127;
        byArray4[542] = 77;
        byArray4[543] = 77;
        byArray4[544] = 66;
        byArray4[545] = 86;
        byArray4[546] = 118;
        byArray4[547] = -76;
        byArray4[548] = -55;
        byArray4[549] = 95;
        byArray4[550] = 4;
        byArray4[551] = -8;
        byArray4[552] = 56;
        byArray4[553] = -8;
        byArray4[554] = -21;
        byArray4[555] = -46;
        byArray4[556] = 95;
        byArray4[557] = 117;
        byArray4[558] = 95;
        byArray4[559] = -51;
        byArray4[560] = 123;
        byArray4[561] = -4;
        byArray4[562] = -27;
        byArray4[563] = -114;
        byArray4[564] = -128;
        byArray4[565] = 124;
        byArray4[566] = -4;
        byArray4[567] = 80;
        RSA_SECURE_SERVER_CA_SELF_SIGNED_CERT = byArray4;
        byte[] byArray5 = new byte[598];
        byArray5[0] = 48;
        byArray5[1] = -126;
        byArray5[2] = 2;
        byArray5[3] = 82;
        byArray5[4] = 48;
        byArray5[5] = -126;
        byArray5[6] = 1;
        byArray5[7] = -4;
        byArray5[8] = -96;
        byArray5[9] = 3;
        byArray5[10] = 2;
        byArray5[11] = 1;
        byArray5[12] = 2;
        byArray5[13] = 2;
        byArray5[14] = 16;
        byArray5[15] = 2;
        byArray5[16] = -59;
        byArray5[17] = -15;
        byArray5[18] = 98;
        byArray5[19] = 57;
        byArray5[20] = -11;
        byArray5[21] = -31;
        byArray5[22] = 9;
        byArray5[23] = -68;
        byArray5[24] = -6;
        byArray5[25] = -58;
        byArray5[26] = 92;
        byArray5[27] = -124;
        byArray5[28] = 26;
        byArray5[29] = 98;
        byArray5[30] = 102;
        byArray5[31] = 48;
        byArray5[32] = 13;
        byArray5[33] = 6;
        byArray5[34] = 9;
        byArray5[35] = 42;
        byArray5[36] = -122;
        byArray5[37] = 72;
        byArray5[38] = -122;
        byArray5[39] = -9;
        byArray5[40] = 13;
        byArray5[41] = 1;
        byArray5[42] = 1;
        byArray5[43] = 4;
        byArray5[44] = 5;
        byArray5[46] = 48;
        byArray5[47] = -127;
        byArray5[48] = -87;
        byArray5[49] = 49;
        byArray5[50] = 22;
        byArray5[51] = 48;
        byArray5[52] = 20;
        byArray5[53] = 6;
        byArray5[54] = 3;
        byArray5[55] = 85;
        byArray5[56] = 4;
        byArray5[57] = 10;
        byArray5[58] = 19;
        byArray5[59] = 13;
        byArray5[60] = 86;
        byArray5[61] = 101;
        byArray5[62] = 114;
        byArray5[63] = 105;
        byArray5[64] = 83;
        byArray5[65] = 105;
        byArray5[66] = 103;
        byArray5[67] = 110;
        byArray5[68] = 44;
        byArray5[69] = 32;
        byArray5[70] = 73;
        byArray5[71] = 110;
        byArray5[72] = 99;
        byArray5[73] = 49;
        byArray5[74] = 71;
        byArray5[75] = 48;
        byArray5[76] = 69;
        byArray5[77] = 6;
        byArray5[78] = 3;
        byArray5[79] = 85;
        byArray5[80] = 4;
        byArray5[81] = 11;
        byArray5[82] = 19;
        byArray5[83] = 62;
        byArray5[84] = 119;
        byArray5[85] = 119;
        byArray5[86] = 119;
        byArray5[87] = 46;
        byArray5[88] = 118;
        byArray5[89] = 101;
        byArray5[90] = 114;
        byArray5[91] = 105;
        byArray5[92] = 115;
        byArray5[93] = 105;
        byArray5[94] = 103;
        byArray5[95] = 110;
        byArray5[96] = 46;
        byArray5[97] = 99;
        byArray5[98] = 111;
        byArray5[99] = 109;
        byArray5[100] = 47;
        byArray5[101] = 114;
        byArray5[102] = 101;
        byArray5[103] = 112;
        byArray5[104] = 111;
        byArray5[105] = 115;
        byArray5[106] = 105;
        byArray5[107] = 116;
        byArray5[108] = 111;
        byArray5[109] = 114;
        byArray5[110] = 121;
        byArray5[111] = 47;
        byArray5[112] = 84;
        byArray5[113] = 101;
        byArray5[114] = 115;
        byArray5[115] = 116;
        byArray5[116] = 67;
        byArray5[117] = 80;
        byArray5[118] = 83;
        byArray5[119] = 32;
        byArray5[120] = 73;
        byArray5[121] = 110;
        byArray5[122] = 99;
        byArray5[123] = 111;
        byArray5[124] = 114;
        byArray5[125] = 112;
        byArray5[126] = 46;
        byArray5[127] = 32;
        byArray5[128] = 66;
        byArray5[129] = 121;
        byArray5[130] = 32;
        byArray5[131] = 82;
        byArray5[132] = 101;
        byArray5[133] = 102;
        byArray5[134] = 46;
        byArray5[135] = 32;
        byArray5[136] = 76;
        byArray5[137] = 105;
        byArray5[138] = 97;
        byArray5[139] = 98;
        byArray5[140] = 46;
        byArray5[141] = 32;
        byArray5[142] = 76;
        byArray5[143] = 84;
        byArray5[144] = 68;
        byArray5[145] = 46;
        byArray5[146] = 49;
        byArray5[147] = 70;
        byArray5[148] = 48;
        byArray5[149] = 68;
        byArray5[150] = 6;
        byArray5[151] = 3;
        byArray5[152] = 85;
        byArray5[153] = 4;
        byArray5[154] = 11;
        byArray5[155] = 19;
        byArray5[156] = 61;
        byArray5[157] = 70;
        byArray5[158] = 111;
        byArray5[159] = 114;
        byArray5[160] = 32;
        byArray5[161] = 86;
        byArray5[162] = 101;
        byArray5[163] = 114;
        byArray5[164] = 105;
        byArray5[165] = 83;
        byArray5[166] = 105;
        byArray5[167] = 103;
        byArray5[168] = 110;
        byArray5[169] = 32;
        byArray5[170] = 97;
        byArray5[171] = 117;
        byArray5[172] = 116;
        byArray5[173] = 104;
        byArray5[174] = 111;
        byArray5[175] = 114;
        byArray5[176] = 105;
        byArray5[177] = 122;
        byArray5[178] = 101;
        byArray5[179] = 100;
        byArray5[180] = 32;
        byArray5[181] = 116;
        byArray5[182] = 101;
        byArray5[183] = 115;
        byArray5[184] = 116;
        byArray5[185] = 105;
        byArray5[186] = 110;
        byArray5[187] = 103;
        byArray5[188] = 32;
        byArray5[189] = 111;
        byArray5[190] = 110;
        byArray5[191] = 108;
        byArray5[192] = 121;
        byArray5[193] = 46;
        byArray5[194] = 32;
        byArray5[195] = 78;
        byArray5[196] = 111;
        byArray5[197] = 32;
        byArray5[198] = 97;
        byArray5[199] = 115;
        byArray5[200] = 115;
        byArray5[201] = 117;
        byArray5[202] = 114;
        byArray5[203] = 97;
        byArray5[204] = 110;
        byArray5[205] = 99;
        byArray5[206] = 101;
        byArray5[207] = 115;
        byArray5[208] = 32;
        byArray5[209] = 40;
        byArray5[210] = 67;
        byArray5[211] = 41;
        byArray5[212] = 86;
        byArray5[213] = 83;
        byArray5[214] = 49;
        byArray5[215] = 57;
        byArray5[216] = 57;
        byArray5[217] = 55;
        byArray5[218] = 48;
        byArray5[219] = 30;
        byArray5[220] = 23;
        byArray5[221] = 13;
        byArray5[222] = 57;
        byArray5[223] = 56;
        byArray5[224] = 48;
        byArray5[225] = 50;
        byArray5[226] = 48;
        byArray5[227] = 52;
        byArray5[228] = 48;
        byArray5[229] = 48;
        byArray5[230] = 48;
        byArray5[231] = 48;
        byArray5[232] = 48;
        byArray5[233] = 48;
        byArray5[234] = 90;
        byArray5[235] = 23;
        byArray5[236] = 13;
        byArray5[237] = 48;
        byArray5[238] = 51;
        byArray5[239] = 48;
        byArray5[240] = 51;
        byArray5[241] = 48;
        byArray5[242] = 52;
        byArray5[243] = 50;
        byArray5[244] = 51;
        byArray5[245] = 53;
        byArray5[246] = 57;
        byArray5[247] = 53;
        byArray5[248] = 57;
        byArray5[249] = 90;
        byArray5[250] = 48;
        byArray5[251] = -127;
        byArray5[252] = -87;
        byArray5[253] = 49;
        byArray5[254] = 22;
        byArray5[255] = 48;
        byArray5[256] = 20;
        byArray5[257] = 6;
        byArray5[258] = 3;
        byArray5[259] = 85;
        byArray5[260] = 4;
        byArray5[261] = 10;
        byArray5[262] = 19;
        byArray5[263] = 13;
        byArray5[264] = 86;
        byArray5[265] = 101;
        byArray5[266] = 114;
        byArray5[267] = 105;
        byArray5[268] = 83;
        byArray5[269] = 105;
        byArray5[270] = 103;
        byArray5[271] = 110;
        byArray5[272] = 44;
        byArray5[273] = 32;
        byArray5[274] = 73;
        byArray5[275] = 110;
        byArray5[276] = 99;
        byArray5[277] = 49;
        byArray5[278] = 71;
        byArray5[279] = 48;
        byArray5[280] = 69;
        byArray5[281] = 6;
        byArray5[282] = 3;
        byArray5[283] = 85;
        byArray5[284] = 4;
        byArray5[285] = 11;
        byArray5[286] = 19;
        byArray5[287] = 62;
        byArray5[288] = 119;
        byArray5[289] = 119;
        byArray5[290] = 119;
        byArray5[291] = 46;
        byArray5[292] = 118;
        byArray5[293] = 101;
        byArray5[294] = 114;
        byArray5[295] = 105;
        byArray5[296] = 115;
        byArray5[297] = 105;
        byArray5[298] = 103;
        byArray5[299] = 110;
        byArray5[300] = 46;
        byArray5[301] = 99;
        byArray5[302] = 111;
        byArray5[303] = 109;
        byArray5[304] = 47;
        byArray5[305] = 114;
        byArray5[306] = 101;
        byArray5[307] = 112;
        byArray5[308] = 111;
        byArray5[309] = 115;
        byArray5[310] = 105;
        byArray5[311] = 116;
        byArray5[312] = 111;
        byArray5[313] = 114;
        byArray5[314] = 121;
        byArray5[315] = 47;
        byArray5[316] = 84;
        byArray5[317] = 101;
        byArray5[318] = 115;
        byArray5[319] = 116;
        byArray5[320] = 67;
        byArray5[321] = 80;
        byArray5[322] = 83;
        byArray5[323] = 32;
        byArray5[324] = 73;
        byArray5[325] = 110;
        byArray5[326] = 99;
        byArray5[327] = 111;
        byArray5[328] = 114;
        byArray5[329] = 112;
        byArray5[330] = 46;
        byArray5[331] = 32;
        byArray5[332] = 66;
        byArray5[333] = 121;
        byArray5[334] = 32;
        byArray5[335] = 82;
        byArray5[336] = 101;
        byArray5[337] = 102;
        byArray5[338] = 46;
        byArray5[339] = 32;
        byArray5[340] = 76;
        byArray5[341] = 105;
        byArray5[342] = 97;
        byArray5[343] = 98;
        byArray5[344] = 46;
        byArray5[345] = 32;
        byArray5[346] = 76;
        byArray5[347] = 84;
        byArray5[348] = 68;
        byArray5[349] = 46;
        byArray5[350] = 49;
        byArray5[351] = 70;
        byArray5[352] = 48;
        byArray5[353] = 68;
        byArray5[354] = 6;
        byArray5[355] = 3;
        byArray5[356] = 85;
        byArray5[357] = 4;
        byArray5[358] = 11;
        byArray5[359] = 19;
        byArray5[360] = 61;
        byArray5[361] = 70;
        byArray5[362] = 111;
        byArray5[363] = 114;
        byArray5[364] = 32;
        byArray5[365] = 86;
        byArray5[366] = 101;
        byArray5[367] = 114;
        byArray5[368] = 105;
        byArray5[369] = 83;
        byArray5[370] = 105;
        byArray5[371] = 103;
        byArray5[372] = 110;
        byArray5[373] = 32;
        byArray5[374] = 97;
        byArray5[375] = 117;
        byArray5[376] = 116;
        byArray5[377] = 104;
        byArray5[378] = 111;
        byArray5[379] = 114;
        byArray5[380] = 105;
        byArray5[381] = 122;
        byArray5[382] = 101;
        byArray5[383] = 100;
        byArray5[384] = 32;
        byArray5[385] = 116;
        byArray5[386] = 101;
        byArray5[387] = 115;
        byArray5[388] = 116;
        byArray5[389] = 105;
        byArray5[390] = 110;
        byArray5[391] = 103;
        byArray5[392] = 32;
        byArray5[393] = 111;
        byArray5[394] = 110;
        byArray5[395] = 108;
        byArray5[396] = 121;
        byArray5[397] = 46;
        byArray5[398] = 32;
        byArray5[399] = 78;
        byArray5[400] = 111;
        byArray5[401] = 32;
        byArray5[402] = 97;
        byArray5[403] = 115;
        byArray5[404] = 115;
        byArray5[405] = 117;
        byArray5[406] = 114;
        byArray5[407] = 97;
        byArray5[408] = 110;
        byArray5[409] = 99;
        byArray5[410] = 101;
        byArray5[411] = 115;
        byArray5[412] = 32;
        byArray5[413] = 40;
        byArray5[414] = 67;
        byArray5[415] = 41;
        byArray5[416] = 86;
        byArray5[417] = 83;
        byArray5[418] = 49;
        byArray5[419] = 57;
        byArray5[420] = 57;
        byArray5[421] = 55;
        byArray5[422] = 48;
        byArray5[423] = 92;
        byArray5[424] = 48;
        byArray5[425] = 13;
        byArray5[426] = 6;
        byArray5[427] = 9;
        byArray5[428] = 42;
        byArray5[429] = -122;
        byArray5[430] = 72;
        byArray5[431] = -122;
        byArray5[432] = -9;
        byArray5[433] = 13;
        byArray5[434] = 1;
        byArray5[435] = 1;
        byArray5[436] = 1;
        byArray5[437] = 5;
        byArray5[439] = 3;
        byArray5[440] = 75;
        byArray5[442] = 48;
        byArray5[443] = 72;
        byArray5[444] = 2;
        byArray5[445] = 65;
        byArray5[447] = -58;
        byArray5[448] = -92;
        byArray5[449] = -21;
        byArray5[450] = 18;
        byArray5[451] = 38;
        byArray5[452] = 39;
        byArray5[453] = 30;
        byArray5[454] = 56;
        byArray5[455] = -116;
        byArray5[456] = -62;
        byArray5[457] = -100;
        byArray5[458] = 110;
        byArray5[459] = 64;
        byArray5[460] = 2;
        byArray5[461] = -53;
        byArray5[462] = -97;
        byArray5[463] = -62;
        byArray5[464] = -56;
        byArray5[465] = -64;
        byArray5[466] = 54;
        byArray5[467] = 126;
        byArray5[468] = -91;
        byArray5[469] = -54;
        byArray5[470] = -32;
        byArray5[471] = -7;
        byArray5[472] = 115;
        byArray5[473] = 78;
        byArray5[474] = -48;
        byArray5[475] = -79;
        byArray5[476] = 70;
        byArray5[477] = -82;
        byArray5[478] = 109;
        byArray5[479] = 22;
        byArray5[480] = 64;
        byArray5[481] = -13;
        byArray5[482] = -99;
        byArray5[483] = -18;
        byArray5[484] = -20;
        byArray5[485] = 112;
        byArray5[486] = -113;
        byArray5[487] = 40;
        byArray5[488] = 20;
        byArray5[489] = -81;
        byArray5[490] = -55;
        byArray5[491] = -6;
        byArray5[492] = 1;
        byArray5[493] = 89;
        byArray5[494] = 52;
        byArray5[495] = 77;
        byArray5[496] = -37;
        byArray5[497] = -114;
        byArray5[498] = 39;
        byArray5[499] = 67;
        byArray5[500] = -59;
        byArray5[501] = -3;
        byArray5[502] = 59;
        byArray5[503] = 59;
        byArray5[504] = 114;
        byArray5[505] = 78;
        byArray5[506] = 96;
        byArray5[507] = 111;
        byArray5[508] = 81;
        byArray5[509] = 27;
        byArray5[510] = 31;
        byArray5[511] = 2;
        byArray5[512] = 3;
        byArray5[513] = 1;
        byArray5[515] = 1;
        byArray5[516] = 48;
        byArray5[517] = 13;
        byArray5[518] = 6;
        byArray5[519] = 9;
        byArray5[520] = 42;
        byArray5[521] = -122;
        byArray5[522] = 72;
        byArray5[523] = -122;
        byArray5[524] = -9;
        byArray5[525] = 13;
        byArray5[526] = 1;
        byArray5[527] = 1;
        byArray5[528] = 4;
        byArray5[529] = 5;
        byArray5[531] = 3;
        byArray5[532] = 65;
        byArray5[534] = 109;
        byArray5[535] = 36;
        byArray5[536] = 103;
        byArray5[537] = 36;
        byArray5[538] = -46;
        byArray5[539] = 93;
        byArray5[540] = 127;
        byArray5[541] = -7;
        byArray5[542] = 117;
        byArray5[543] = 112;
        byArray5[544] = -123;
        byArray5[545] = -24;
        byArray5[546] = -72;
        byArray5[547] = 121;
        byArray5[548] = 8;
        byArray5[549] = -85;
        byArray5[550] = 59;
        byArray5[551] = -108;
        byArray5[552] = 16;
        byArray5[553] = -10;
        byArray5[554] = 19;
        byArray5[555] = 78;
        byArray5[556] = 52;
        byArray5[557] = -57;
        byArray5[558] = 12;
        byArray5[559] = -127;
        byArray5[560] = -46;
        byArray5[561] = -40;
        byArray5[562] = -81;
        byArray5[563] = -62;
        byArray5[564] = -81;
        byArray5[565] = -38;
        byArray5[566] = -29;
        byArray5[567] = -57;
        byArray5[568] = -118;
        byArray5[569] = -22;
        byArray5[570] = 103;
        byArray5[571] = -23;
        byArray5[572] = 11;
        byArray5[573] = -120;
        byArray5[574] = 123;
        byArray5[575] = 114;
        byArray5[576] = -6;
        byArray5[577] = -105;
        byArray5[578] = 71;
        byArray5[579] = 99;
        byArray5[580] = 123;
        byArray5[581] = 72;
        byArray5[582] = 76;
        byArray5[583] = -118;
        byArray5[584] = 47;
        byArray5[585] = -39;
        byArray5[586] = -120;
        byArray5[587] = 81;
        byArray5[588] = 57;
        byArray5[589] = -125;
        byArray5[590] = -4;
        byArray5[591] = -118;
        byArray5[592] = 32;
        byArray5[593] = 117;
        byArray5[594] = -81;
        byArray5[595] = -23;
        byArray5[596] = -12;
        byArray5[597] = -17;
        VERISIGN_TEST_CA_SELF_SIGNED_CERT = byArray5;
        byte[] byArray6 = new byte[791];
        byArray6[0] = 48;
        byArray6[1] = -126;
        byArray6[2] = 3;
        byArray6[3] = 19;
        byArray6[4] = 48;
        byArray6[5] = -126;
        byArray6[6] = 2;
        byArray6[7] = 124;
        byArray6[8] = -96;
        byArray6[9] = 3;
        byArray6[10] = 2;
        byArray6[11] = 1;
        byArray6[12] = 2;
        byArray6[13] = 2;
        byArray6[14] = 1;
        byArray6[15] = 1;
        byArray6[16] = 48;
        byArray6[17] = 13;
        byArray6[18] = 6;
        byArray6[19] = 9;
        byArray6[20] = 42;
        byArray6[21] = -122;
        byArray6[22] = 72;
        byArray6[23] = -122;
        byArray6[24] = -9;
        byArray6[25] = 13;
        byArray6[26] = 1;
        byArray6[27] = 1;
        byArray6[28] = 4;
        byArray6[29] = 5;
        byArray6[31] = 48;
        byArray6[32] = -127;
        byArray6[33] = -60;
        byArray6[34] = 49;
        byArray6[35] = 11;
        byArray6[36] = 48;
        byArray6[37] = 9;
        byArray6[38] = 6;
        byArray6[39] = 3;
        byArray6[40] = 85;
        byArray6[41] = 4;
        byArray6[42] = 6;
        byArray6[43] = 19;
        byArray6[44] = 2;
        byArray6[45] = 90;
        byArray6[46] = 65;
        byArray6[47] = 49;
        byArray6[48] = 21;
        byArray6[49] = 48;
        byArray6[50] = 19;
        byArray6[51] = 6;
        byArray6[52] = 3;
        byArray6[53] = 85;
        byArray6[54] = 4;
        byArray6[55] = 8;
        byArray6[56] = 19;
        byArray6[57] = 12;
        byArray6[58] = 87;
        byArray6[59] = 101;
        byArray6[60] = 115;
        byArray6[61] = 116;
        byArray6[62] = 101;
        byArray6[63] = 114;
        byArray6[64] = 110;
        byArray6[65] = 32;
        byArray6[66] = 67;
        byArray6[67] = 97;
        byArray6[68] = 112;
        byArray6[69] = 101;
        byArray6[70] = 49;
        byArray6[71] = 18;
        byArray6[72] = 48;
        byArray6[73] = 16;
        byArray6[74] = 6;
        byArray6[75] = 3;
        byArray6[76] = 85;
        byArray6[77] = 4;
        byArray6[78] = 7;
        byArray6[79] = 19;
        byArray6[80] = 9;
        byArray6[81] = 67;
        byArray6[82] = 97;
        byArray6[83] = 112;
        byArray6[84] = 101;
        byArray6[85] = 32;
        byArray6[86] = 84;
        byArray6[87] = 111;
        byArray6[88] = 119;
        byArray6[89] = 110;
        byArray6[90] = 49;
        byArray6[91] = 29;
        byArray6[92] = 48;
        byArray6[93] = 27;
        byArray6[94] = 6;
        byArray6[95] = 3;
        byArray6[96] = 85;
        byArray6[97] = 4;
        byArray6[98] = 10;
        byArray6[99] = 19;
        byArray6[100] = 20;
        byArray6[101] = 84;
        byArray6[102] = 104;
        byArray6[103] = 97;
        byArray6[104] = 119;
        byArray6[105] = 116;
        byArray6[106] = 101;
        byArray6[107] = 32;
        byArray6[108] = 67;
        byArray6[109] = 111;
        byArray6[110] = 110;
        byArray6[111] = 115;
        byArray6[112] = 117;
        byArray6[113] = 108;
        byArray6[114] = 116;
        byArray6[115] = 105;
        byArray6[116] = 110;
        byArray6[117] = 103;
        byArray6[118] = 32;
        byArray6[119] = 99;
        byArray6[120] = 99;
        byArray6[121] = 49;
        byArray6[122] = 40;
        byArray6[123] = 48;
        byArray6[124] = 38;
        byArray6[125] = 6;
        byArray6[126] = 3;
        byArray6[127] = 85;
        byArray6[128] = 4;
        byArray6[129] = 11;
        byArray6[130] = 19;
        byArray6[131] = 31;
        byArray6[132] = 67;
        byArray6[133] = 101;
        byArray6[134] = 114;
        byArray6[135] = 116;
        byArray6[136] = 105;
        byArray6[137] = 102;
        byArray6[138] = 105;
        byArray6[139] = 99;
        byArray6[140] = 97;
        byArray6[141] = 116;
        byArray6[142] = 105;
        byArray6[143] = 111;
        byArray6[144] = 110;
        byArray6[145] = 32;
        byArray6[146] = 83;
        byArray6[147] = 101;
        byArray6[148] = 114;
        byArray6[149] = 118;
        byArray6[150] = 105;
        byArray6[151] = 99;
        byArray6[152] = 101;
        byArray6[153] = 115;
        byArray6[154] = 32;
        byArray6[155] = 68;
        byArray6[156] = 105;
        byArray6[157] = 118;
        byArray6[158] = 105;
        byArray6[159] = 115;
        byArray6[160] = 105;
        byArray6[161] = 111;
        byArray6[162] = 110;
        byArray6[163] = 49;
        byArray6[164] = 25;
        byArray6[165] = 48;
        byArray6[166] = 23;
        byArray6[167] = 6;
        byArray6[168] = 3;
        byArray6[169] = 85;
        byArray6[170] = 4;
        byArray6[171] = 3;
        byArray6[172] = 19;
        byArray6[173] = 16;
        byArray6[174] = 84;
        byArray6[175] = 104;
        byArray6[176] = 97;
        byArray6[177] = 119;
        byArray6[178] = 116;
        byArray6[179] = 101;
        byArray6[180] = 32;
        byArray6[181] = 83;
        byArray6[182] = 101;
        byArray6[183] = 114;
        byArray6[184] = 118;
        byArray6[185] = 101;
        byArray6[186] = 114;
        byArray6[187] = 32;
        byArray6[188] = 67;
        byArray6[189] = 65;
        byArray6[190] = 49;
        byArray6[191] = 38;
        byArray6[192] = 48;
        byArray6[193] = 36;
        byArray6[194] = 6;
        byArray6[195] = 9;
        byArray6[196] = 42;
        byArray6[197] = -122;
        byArray6[198] = 72;
        byArray6[199] = -122;
        byArray6[200] = -9;
        byArray6[201] = 13;
        byArray6[202] = 1;
        byArray6[203] = 9;
        byArray6[204] = 1;
        byArray6[205] = 22;
        byArray6[206] = 23;
        byArray6[207] = 115;
        byArray6[208] = 101;
        byArray6[209] = 114;
        byArray6[210] = 118;
        byArray6[211] = 101;
        byArray6[212] = 114;
        byArray6[213] = 45;
        byArray6[214] = 99;
        byArray6[215] = 101;
        byArray6[216] = 114;
        byArray6[217] = 116;
        byArray6[218] = 115;
        byArray6[219] = 64;
        byArray6[220] = 116;
        byArray6[221] = 104;
        byArray6[222] = 97;
        byArray6[223] = 119;
        byArray6[224] = 116;
        byArray6[225] = 101;
        byArray6[226] = 46;
        byArray6[227] = 99;
        byArray6[228] = 111;
        byArray6[229] = 109;
        byArray6[230] = 48;
        byArray6[231] = 30;
        byArray6[232] = 23;
        byArray6[233] = 13;
        byArray6[234] = 57;
        byArray6[235] = 54;
        byArray6[236] = 48;
        byArray6[237] = 56;
        byArray6[238] = 48;
        byArray6[239] = 49;
        byArray6[240] = 48;
        byArray6[241] = 48;
        byArray6[242] = 48;
        byArray6[243] = 48;
        byArray6[244] = 48;
        byArray6[245] = 48;
        byArray6[246] = 90;
        byArray6[247] = 23;
        byArray6[248] = 13;
        byArray6[249] = 50;
        byArray6[250] = 48;
        byArray6[251] = 49;
        byArray6[252] = 50;
        byArray6[253] = 51;
        byArray6[254] = 49;
        byArray6[255] = 50;
        byArray6[256] = 51;
        byArray6[257] = 53;
        byArray6[258] = 57;
        byArray6[259] = 53;
        byArray6[260] = 57;
        byArray6[261] = 90;
        byArray6[262] = 48;
        byArray6[263] = -127;
        byArray6[264] = -60;
        byArray6[265] = 49;
        byArray6[266] = 11;
        byArray6[267] = 48;
        byArray6[268] = 9;
        byArray6[269] = 6;
        byArray6[270] = 3;
        byArray6[271] = 85;
        byArray6[272] = 4;
        byArray6[273] = 6;
        byArray6[274] = 19;
        byArray6[275] = 2;
        byArray6[276] = 90;
        byArray6[277] = 65;
        byArray6[278] = 49;
        byArray6[279] = 21;
        byArray6[280] = 48;
        byArray6[281] = 19;
        byArray6[282] = 6;
        byArray6[283] = 3;
        byArray6[284] = 85;
        byArray6[285] = 4;
        byArray6[286] = 8;
        byArray6[287] = 19;
        byArray6[288] = 12;
        byArray6[289] = 87;
        byArray6[290] = 101;
        byArray6[291] = 115;
        byArray6[292] = 116;
        byArray6[293] = 101;
        byArray6[294] = 114;
        byArray6[295] = 110;
        byArray6[296] = 32;
        byArray6[297] = 67;
        byArray6[298] = 97;
        byArray6[299] = 112;
        byArray6[300] = 101;
        byArray6[301] = 49;
        byArray6[302] = 18;
        byArray6[303] = 48;
        byArray6[304] = 16;
        byArray6[305] = 6;
        byArray6[306] = 3;
        byArray6[307] = 85;
        byArray6[308] = 4;
        byArray6[309] = 7;
        byArray6[310] = 19;
        byArray6[311] = 9;
        byArray6[312] = 67;
        byArray6[313] = 97;
        byArray6[314] = 112;
        byArray6[315] = 101;
        byArray6[316] = 32;
        byArray6[317] = 84;
        byArray6[318] = 111;
        byArray6[319] = 119;
        byArray6[320] = 110;
        byArray6[321] = 49;
        byArray6[322] = 29;
        byArray6[323] = 48;
        byArray6[324] = 27;
        byArray6[325] = 6;
        byArray6[326] = 3;
        byArray6[327] = 85;
        byArray6[328] = 4;
        byArray6[329] = 10;
        byArray6[330] = 19;
        byArray6[331] = 20;
        byArray6[332] = 84;
        byArray6[333] = 104;
        byArray6[334] = 97;
        byArray6[335] = 119;
        byArray6[336] = 116;
        byArray6[337] = 101;
        byArray6[338] = 32;
        byArray6[339] = 67;
        byArray6[340] = 111;
        byArray6[341] = 110;
        byArray6[342] = 115;
        byArray6[343] = 117;
        byArray6[344] = 108;
        byArray6[345] = 116;
        byArray6[346] = 105;
        byArray6[347] = 110;
        byArray6[348] = 103;
        byArray6[349] = 32;
        byArray6[350] = 99;
        byArray6[351] = 99;
        byArray6[352] = 49;
        byArray6[353] = 40;
        byArray6[354] = 48;
        byArray6[355] = 38;
        byArray6[356] = 6;
        byArray6[357] = 3;
        byArray6[358] = 85;
        byArray6[359] = 4;
        byArray6[360] = 11;
        byArray6[361] = 19;
        byArray6[362] = 31;
        byArray6[363] = 67;
        byArray6[364] = 101;
        byArray6[365] = 114;
        byArray6[366] = 116;
        byArray6[367] = 105;
        byArray6[368] = 102;
        byArray6[369] = 105;
        byArray6[370] = 99;
        byArray6[371] = 97;
        byArray6[372] = 116;
        byArray6[373] = 105;
        byArray6[374] = 111;
        byArray6[375] = 110;
        byArray6[376] = 32;
        byArray6[377] = 83;
        byArray6[378] = 101;
        byArray6[379] = 114;
        byArray6[380] = 118;
        byArray6[381] = 105;
        byArray6[382] = 99;
        byArray6[383] = 101;
        byArray6[384] = 115;
        byArray6[385] = 32;
        byArray6[386] = 68;
        byArray6[387] = 105;
        byArray6[388] = 118;
        byArray6[389] = 105;
        byArray6[390] = 115;
        byArray6[391] = 105;
        byArray6[392] = 111;
        byArray6[393] = 110;
        byArray6[394] = 49;
        byArray6[395] = 25;
        byArray6[396] = 48;
        byArray6[397] = 23;
        byArray6[398] = 6;
        byArray6[399] = 3;
        byArray6[400] = 85;
        byArray6[401] = 4;
        byArray6[402] = 3;
        byArray6[403] = 19;
        byArray6[404] = 16;
        byArray6[405] = 84;
        byArray6[406] = 104;
        byArray6[407] = 97;
        byArray6[408] = 119;
        byArray6[409] = 116;
        byArray6[410] = 101;
        byArray6[411] = 32;
        byArray6[412] = 83;
        byArray6[413] = 101;
        byArray6[414] = 114;
        byArray6[415] = 118;
        byArray6[416] = 101;
        byArray6[417] = 114;
        byArray6[418] = 32;
        byArray6[419] = 67;
        byArray6[420] = 65;
        byArray6[421] = 49;
        byArray6[422] = 38;
        byArray6[423] = 48;
        byArray6[424] = 36;
        byArray6[425] = 6;
        byArray6[426] = 9;
        byArray6[427] = 42;
        byArray6[428] = -122;
        byArray6[429] = 72;
        byArray6[430] = -122;
        byArray6[431] = -9;
        byArray6[432] = 13;
        byArray6[433] = 1;
        byArray6[434] = 9;
        byArray6[435] = 1;
        byArray6[436] = 22;
        byArray6[437] = 23;
        byArray6[438] = 115;
        byArray6[439] = 101;
        byArray6[440] = 114;
        byArray6[441] = 118;
        byArray6[442] = 101;
        byArray6[443] = 114;
        byArray6[444] = 45;
        byArray6[445] = 99;
        byArray6[446] = 101;
        byArray6[447] = 114;
        byArray6[448] = 116;
        byArray6[449] = 115;
        byArray6[450] = 64;
        byArray6[451] = 116;
        byArray6[452] = 104;
        byArray6[453] = 97;
        byArray6[454] = 119;
        byArray6[455] = 116;
        byArray6[456] = 101;
        byArray6[457] = 46;
        byArray6[458] = 99;
        byArray6[459] = 111;
        byArray6[460] = 109;
        byArray6[461] = 48;
        byArray6[462] = -127;
        byArray6[463] = -97;
        byArray6[464] = 48;
        byArray6[465] = 13;
        byArray6[466] = 6;
        byArray6[467] = 9;
        byArray6[468] = 42;
        byArray6[469] = -122;
        byArray6[470] = 72;
        byArray6[471] = -122;
        byArray6[472] = -9;
        byArray6[473] = 13;
        byArray6[474] = 1;
        byArray6[475] = 1;
        byArray6[476] = 1;
        byArray6[477] = 5;
        byArray6[479] = 3;
        byArray6[480] = -127;
        byArray6[481] = -115;
        byArray6[483] = 48;
        byArray6[484] = -127;
        byArray6[485] = -119;
        byArray6[486] = 2;
        byArray6[487] = -127;
        byArray6[488] = -127;
        byArray6[490] = -45;
        byArray6[491] = -92;
        byArray6[492] = 80;
        byArray6[493] = 110;
        byArray6[494] = -56;
        byArray6[495] = -1;
        byArray6[496] = 86;
        byArray6[497] = 107;
        byArray6[498] = -26;
        byArray6[499] = -49;
        byArray6[500] = 93;
        byArray6[501] = -74;
        byArray6[502] = -22;
        byArray6[503] = 12;
        byArray6[504] = 104;
        byArray6[505] = 117;
        byArray6[506] = 71;
        byArray6[507] = -94;
        byArray6[508] = -86;
        byArray6[509] = -62;
        byArray6[510] = -38;
        byArray6[511] = -124;
        byArray6[512] = 37;
        byArray6[513] = -4;
        byArray6[514] = -88;
        byArray6[515] = -12;
        byArray6[516] = 71;
        byArray6[517] = 81;
        byArray6[518] = -38;
        byArray6[519] = -123;
        byArray6[520] = -75;
        byArray6[521] = 32;
        byArray6[522] = 116;
        byArray6[523] = -108;
        byArray6[524] = -122;
        byArray6[525] = 30;
        byArray6[526] = 15;
        byArray6[527] = 117;
        byArray6[528] = -55;
        byArray6[529] = -23;
        byArray6[530] = 8;
        byArray6[531] = 97;
        byArray6[532] = -11;
        byArray6[533] = 6;
        byArray6[534] = 109;
        byArray6[535] = 48;
        byArray6[536] = 110;
        byArray6[537] = 21;
        byArray6[538] = 25;
        byArray6[539] = 2;
        byArray6[540] = -23;
        byArray6[541] = 82;
        byArray6[542] = -64;
        byArray6[543] = 98;
        byArray6[544] = -37;
        byArray6[545] = 77;
        byArray6[546] = -103;
        byArray6[547] = -98;
        byArray6[548] = -30;
        byArray6[549] = 106;
        byArray6[550] = 12;
        byArray6[551] = 68;
        byArray6[552] = 56;
        byArray6[553] = -51;
        byArray6[554] = -2;
        byArray6[555] = -66;
        byArray6[556] = -29;
        byArray6[557] = 100;
        byArray6[558] = 9;
        byArray6[559] = 112;
        byArray6[560] = -59;
        byArray6[561] = -2;
        byArray6[562] = -79;
        byArray6[563] = 107;
        byArray6[564] = 41;
        byArray6[565] = -74;
        byArray6[566] = 47;
        byArray6[567] = 73;
        byArray6[568] = -56;
        byArray6[569] = 59;
        byArray6[570] = -44;
        byArray6[571] = 39;
        byArray6[572] = 4;
        byArray6[573] = 37;
        byArray6[574] = 16;
        byArray6[575] = -105;
        byArray6[576] = 47;
        byArray6[577] = -25;
        byArray6[578] = -112;
        byArray6[579] = 109;
        byArray6[580] = -64;
        byArray6[581] = 40;
        byArray6[582] = 66;
        byArray6[583] = -103;
        byArray6[584] = -41;
        byArray6[585] = 76;
        byArray6[586] = 67;
        byArray6[587] = -34;
        byArray6[588] = -61;
        byArray6[589] = -11;
        byArray6[590] = 33;
        byArray6[591] = 109;
        byArray6[592] = 84;
        byArray6[593] = -97;
        byArray6[594] = 93;
        byArray6[595] = -61;
        byArray6[596] = 88;
        byArray6[597] = -31;
        byArray6[598] = -64;
        byArray6[599] = -28;
        byArray6[600] = -39;
        byArray6[601] = 91;
        byArray6[602] = -80;
        byArray6[603] = -72;
        byArray6[604] = -36;
        byArray6[605] = -76;
        byArray6[606] = 123;
        byArray6[607] = -33;
        byArray6[608] = 54;
        byArray6[609] = 58;
        byArray6[610] = -62;
        byArray6[611] = -75;
        byArray6[612] = 102;
        byArray6[613] = 34;
        byArray6[614] = 18;
        byArray6[615] = -42;
        byArray6[616] = -121;
        byArray6[617] = 13;
        byArray6[618] = 2;
        byArray6[619] = 3;
        byArray6[620] = 1;
        byArray6[622] = 1;
        byArray6[623] = -93;
        byArray6[624] = 19;
        byArray6[625] = 48;
        byArray6[626] = 17;
        byArray6[627] = 48;
        byArray6[628] = 15;
        byArray6[629] = 6;
        byArray6[630] = 3;
        byArray6[631] = 85;
        byArray6[632] = 29;
        byArray6[633] = 19;
        byArray6[634] = 1;
        byArray6[635] = 1;
        byArray6[636] = -1;
        byArray6[637] = 4;
        byArray6[638] = 5;
        byArray6[639] = 48;
        byArray6[640] = 3;
        byArray6[641] = 1;
        byArray6[642] = 1;
        byArray6[643] = -1;
        byArray6[644] = 48;
        byArray6[645] = 13;
        byArray6[646] = 6;
        byArray6[647] = 9;
        byArray6[648] = 42;
        byArray6[649] = -122;
        byArray6[650] = 72;
        byArray6[651] = -122;
        byArray6[652] = -9;
        byArray6[653] = 13;
        byArray6[654] = 1;
        byArray6[655] = 1;
        byArray6[656] = 4;
        byArray6[657] = 5;
        byArray6[659] = 3;
        byArray6[660] = -127;
        byArray6[661] = -127;
        byArray6[663] = 7;
        byArray6[664] = -6;
        byArray6[665] = 76;
        byArray6[666] = 105;
        byArray6[667] = 92;
        byArray6[668] = -5;
        byArray6[669] = -107;
        byArray6[670] = -52;
        byArray6[671] = 70;
        byArray6[672] = -18;
        byArray6[673] = -123;
        byArray6[674] = -125;
        byArray6[675] = 77;
        byArray6[676] = 33;
        byArray6[677] = 48;
        byArray6[678] = -114;
        byArray6[679] = -54;
        byArray6[680] = -39;
        byArray6[681] = -88;
        byArray6[682] = 111;
        byArray6[683] = 73;
        byArray6[684] = 26;
        byArray6[685] = -26;
        byArray6[686] = -38;
        byArray6[687] = 81;
        byArray6[688] = -29;
        byArray6[689] = 96;
        byArray6[690] = 112;
        byArray6[691] = 108;
        byArray6[692] = -124;
        byArray6[693] = 97;
        byArray6[694] = 17;
        byArray6[695] = -95;
        byArray6[696] = 26;
        byArray6[697] = -56;
        byArray6[698] = 72;
        byArray6[699] = 62;
        byArray6[700] = 89;
        byArray6[701] = 67;
        byArray6[702] = 125;
        byArray6[703] = 79;
        byArray6[704] = -107;
        byArray6[705] = 61;
        byArray6[706] = -95;
        byArray6[707] = -117;
        byArray6[708] = -73;
        byArray6[709] = 11;
        byArray6[710] = 98;
        byArray6[711] = -104;
        byArray6[712] = 122;
        byArray6[713] = 117;
        byArray6[714] = -118;
        byArray6[715] = -35;
        byArray6[716] = -120;
        byArray6[717] = 78;
        byArray6[718] = 78;
        byArray6[719] = -98;
        byArray6[720] = 64;
        byArray6[721] = -37;
        byArray6[722] = -88;
        byArray6[723] = -52;
        byArray6[724] = 50;
        byArray6[725] = 116;
        byArray6[726] = -71;
        byArray6[727] = 111;
        byArray6[728] = 13;
        byArray6[729] = -58;
        byArray6[730] = -29;
        byArray6[731] = -77;
        byArray6[732] = 68;
        byArray6[733] = 11;
        byArray6[734] = -39;
        byArray6[735] = -118;
        byArray6[736] = 111;
        byArray6[737] = -102;
        byArray6[738] = 41;
        byArray6[739] = -101;
        byArray6[740] = -103;
        byArray6[741] = 24;
        byArray6[742] = 40;
        byArray6[743] = 59;
        byArray6[744] = -47;
        byArray6[745] = -29;
        byArray6[746] = 64;
        byArray6[747] = 40;
        byArray6[748] = -102;
        byArray6[749] = 90;
        byArray6[750] = 60;
        byArray6[751] = -43;
        byArray6[752] = -75;
        byArray6[753] = -25;
        byArray6[754] = 32;
        byArray6[755] = 27;
        byArray6[756] = -117;
        byArray6[757] = -54;
        byArray6[758] = -92;
        byArray6[759] = -85;
        byArray6[760] = -115;
        byArray6[761] = -23;
        byArray6[762] = 81;
        byArray6[763] = -39;
        byArray6[764] = -30;
        byArray6[765] = 76;
        byArray6[766] = 44;
        byArray6[767] = 89;
        byArray6[768] = -87;
        byArray6[769] = -38;
        byArray6[770] = -71;
        byArray6[771] = -78;
        byArray6[772] = 117;
        byArray6[773] = 27;
        byArray6[774] = -10;
        byArray6[775] = 66;
        byArray6[776] = -14;
        byArray6[777] = -17;
        byArray6[778] = -57;
        byArray6[779] = -14;
        byArray6[780] = 24;
        byArray6[781] = -7;
        byArray6[782] = -119;
        byArray6[783] = -68;
        byArray6[784] = -93;
        byArray6[785] = -1;
        byArray6[786] = -118;
        byArray6[787] = 35;
        byArray6[788] = 46;
        byArray6[789] = 112;
        byArray6[790] = 71;
        THAWTE_ROOT_SELF_SIGNED_CERT = byArray6;
        byte[] byArray7 = new byte[811];
        byArray7[0] = 48;
        byArray7[1] = -126;
        byArray7[2] = 3;
        byArray7[3] = 39;
        byArray7[4] = 48;
        byArray7[5] = -126;
        byArray7[6] = 2;
        byArray7[7] = -112;
        byArray7[8] = -96;
        byArray7[9] = 3;
        byArray7[10] = 2;
        byArray7[11] = 1;
        byArray7[12] = 2;
        byArray7[13] = 2;
        byArray7[14] = 1;
        byArray7[15] = 1;
        byArray7[16] = 48;
        byArray7[17] = 13;
        byArray7[18] = 6;
        byArray7[19] = 9;
        byArray7[20] = 42;
        byArray7[21] = -122;
        byArray7[22] = 72;
        byArray7[23] = -122;
        byArray7[24] = -9;
        byArray7[25] = 13;
        byArray7[26] = 1;
        byArray7[27] = 1;
        byArray7[28] = 4;
        byArray7[29] = 5;
        byArray7[31] = 48;
        byArray7[32] = -127;
        byArray7[33] = -50;
        byArray7[34] = 49;
        byArray7[35] = 11;
        byArray7[36] = 48;
        byArray7[37] = 9;
        byArray7[38] = 6;
        byArray7[39] = 3;
        byArray7[40] = 85;
        byArray7[41] = 4;
        byArray7[42] = 6;
        byArray7[43] = 19;
        byArray7[44] = 2;
        byArray7[45] = 90;
        byArray7[46] = 65;
        byArray7[47] = 49;
        byArray7[48] = 21;
        byArray7[49] = 48;
        byArray7[50] = 19;
        byArray7[51] = 6;
        byArray7[52] = 3;
        byArray7[53] = 85;
        byArray7[54] = 4;
        byArray7[55] = 8;
        byArray7[56] = 19;
        byArray7[57] = 12;
        byArray7[58] = 87;
        byArray7[59] = 101;
        byArray7[60] = 115;
        byArray7[61] = 116;
        byArray7[62] = 101;
        byArray7[63] = 114;
        byArray7[64] = 110;
        byArray7[65] = 32;
        byArray7[66] = 67;
        byArray7[67] = 97;
        byArray7[68] = 112;
        byArray7[69] = 101;
        byArray7[70] = 49;
        byArray7[71] = 18;
        byArray7[72] = 48;
        byArray7[73] = 16;
        byArray7[74] = 6;
        byArray7[75] = 3;
        byArray7[76] = 85;
        byArray7[77] = 4;
        byArray7[78] = 7;
        byArray7[79] = 19;
        byArray7[80] = 9;
        byArray7[81] = 67;
        byArray7[82] = 97;
        byArray7[83] = 112;
        byArray7[84] = 101;
        byArray7[85] = 32;
        byArray7[86] = 84;
        byArray7[87] = 111;
        byArray7[88] = 119;
        byArray7[89] = 110;
        byArray7[90] = 49;
        byArray7[91] = 29;
        byArray7[92] = 48;
        byArray7[93] = 27;
        byArray7[94] = 6;
        byArray7[95] = 3;
        byArray7[96] = 85;
        byArray7[97] = 4;
        byArray7[98] = 10;
        byArray7[99] = 19;
        byArray7[100] = 20;
        byArray7[101] = 84;
        byArray7[102] = 104;
        byArray7[103] = 97;
        byArray7[104] = 119;
        byArray7[105] = 116;
        byArray7[106] = 101;
        byArray7[107] = 32;
        byArray7[108] = 67;
        byArray7[109] = 111;
        byArray7[110] = 110;
        byArray7[111] = 115;
        byArray7[112] = 117;
        byArray7[113] = 108;
        byArray7[114] = 116;
        byArray7[115] = 105;
        byArray7[116] = 110;
        byArray7[117] = 103;
        byArray7[118] = 32;
        byArray7[119] = 99;
        byArray7[120] = 99;
        byArray7[121] = 49;
        byArray7[122] = 40;
        byArray7[123] = 48;
        byArray7[124] = 38;
        byArray7[125] = 6;
        byArray7[126] = 3;
        byArray7[127] = 85;
        byArray7[128] = 4;
        byArray7[129] = 11;
        byArray7[130] = 19;
        byArray7[131] = 31;
        byArray7[132] = 67;
        byArray7[133] = 101;
        byArray7[134] = 114;
        byArray7[135] = 116;
        byArray7[136] = 105;
        byArray7[137] = 102;
        byArray7[138] = 105;
        byArray7[139] = 99;
        byArray7[140] = 97;
        byArray7[141] = 116;
        byArray7[142] = 105;
        byArray7[143] = 111;
        byArray7[144] = 110;
        byArray7[145] = 32;
        byArray7[146] = 83;
        byArray7[147] = 101;
        byArray7[148] = 114;
        byArray7[149] = 118;
        byArray7[150] = 105;
        byArray7[151] = 99;
        byArray7[152] = 101;
        byArray7[153] = 115;
        byArray7[154] = 32;
        byArray7[155] = 68;
        byArray7[156] = 105;
        byArray7[157] = 118;
        byArray7[158] = 105;
        byArray7[159] = 115;
        byArray7[160] = 105;
        byArray7[161] = 111;
        byArray7[162] = 110;
        byArray7[163] = 49;
        byArray7[164] = 33;
        byArray7[165] = 48;
        byArray7[166] = 31;
        byArray7[167] = 6;
        byArray7[168] = 3;
        byArray7[169] = 85;
        byArray7[170] = 4;
        byArray7[171] = 3;
        byArray7[172] = 19;
        byArray7[173] = 24;
        byArray7[174] = 84;
        byArray7[175] = 104;
        byArray7[176] = 97;
        byArray7[177] = 119;
        byArray7[178] = 116;
        byArray7[179] = 101;
        byArray7[180] = 32;
        byArray7[181] = 80;
        byArray7[182] = 114;
        byArray7[183] = 101;
        byArray7[184] = 109;
        byArray7[185] = 105;
        byArray7[186] = 117;
        byArray7[187] = 109;
        byArray7[188] = 32;
        byArray7[189] = 83;
        byArray7[190] = 101;
        byArray7[191] = 114;
        byArray7[192] = 118;
        byArray7[193] = 101;
        byArray7[194] = 114;
        byArray7[195] = 32;
        byArray7[196] = 67;
        byArray7[197] = 65;
        byArray7[198] = 49;
        byArray7[199] = 40;
        byArray7[200] = 48;
        byArray7[201] = 38;
        byArray7[202] = 6;
        byArray7[203] = 9;
        byArray7[204] = 42;
        byArray7[205] = -122;
        byArray7[206] = 72;
        byArray7[207] = -122;
        byArray7[208] = -9;
        byArray7[209] = 13;
        byArray7[210] = 1;
        byArray7[211] = 9;
        byArray7[212] = 1;
        byArray7[213] = 22;
        byArray7[214] = 25;
        byArray7[215] = 112;
        byArray7[216] = 114;
        byArray7[217] = 101;
        byArray7[218] = 109;
        byArray7[219] = 105;
        byArray7[220] = 117;
        byArray7[221] = 109;
        byArray7[222] = 45;
        byArray7[223] = 115;
        byArray7[224] = 101;
        byArray7[225] = 114;
        byArray7[226] = 118;
        byArray7[227] = 101;
        byArray7[228] = 114;
        byArray7[229] = 64;
        byArray7[230] = 116;
        byArray7[231] = 104;
        byArray7[232] = 97;
        byArray7[233] = 119;
        byArray7[234] = 116;
        byArray7[235] = 101;
        byArray7[236] = 46;
        byArray7[237] = 99;
        byArray7[238] = 111;
        byArray7[239] = 109;
        byArray7[240] = 48;
        byArray7[241] = 30;
        byArray7[242] = 23;
        byArray7[243] = 13;
        byArray7[244] = 57;
        byArray7[245] = 54;
        byArray7[246] = 48;
        byArray7[247] = 56;
        byArray7[248] = 48;
        byArray7[249] = 49;
        byArray7[250] = 48;
        byArray7[251] = 48;
        byArray7[252] = 48;
        byArray7[253] = 48;
        byArray7[254] = 48;
        byArray7[255] = 48;
        byArray7[256] = 90;
        byArray7[257] = 23;
        byArray7[258] = 13;
        byArray7[259] = 50;
        byArray7[260] = 48;
        byArray7[261] = 49;
        byArray7[262] = 50;
        byArray7[263] = 51;
        byArray7[264] = 49;
        byArray7[265] = 50;
        byArray7[266] = 51;
        byArray7[267] = 53;
        byArray7[268] = 57;
        byArray7[269] = 53;
        byArray7[270] = 57;
        byArray7[271] = 90;
        byArray7[272] = 48;
        byArray7[273] = -127;
        byArray7[274] = -50;
        byArray7[275] = 49;
        byArray7[276] = 11;
        byArray7[277] = 48;
        byArray7[278] = 9;
        byArray7[279] = 6;
        byArray7[280] = 3;
        byArray7[281] = 85;
        byArray7[282] = 4;
        byArray7[283] = 6;
        byArray7[284] = 19;
        byArray7[285] = 2;
        byArray7[286] = 90;
        byArray7[287] = 65;
        byArray7[288] = 49;
        byArray7[289] = 21;
        byArray7[290] = 48;
        byArray7[291] = 19;
        byArray7[292] = 6;
        byArray7[293] = 3;
        byArray7[294] = 85;
        byArray7[295] = 4;
        byArray7[296] = 8;
        byArray7[297] = 19;
        byArray7[298] = 12;
        byArray7[299] = 87;
        byArray7[300] = 101;
        byArray7[301] = 115;
        byArray7[302] = 116;
        byArray7[303] = 101;
        byArray7[304] = 114;
        byArray7[305] = 110;
        byArray7[306] = 32;
        byArray7[307] = 67;
        byArray7[308] = 97;
        byArray7[309] = 112;
        byArray7[310] = 101;
        byArray7[311] = 49;
        byArray7[312] = 18;
        byArray7[313] = 48;
        byArray7[314] = 16;
        byArray7[315] = 6;
        byArray7[316] = 3;
        byArray7[317] = 85;
        byArray7[318] = 4;
        byArray7[319] = 7;
        byArray7[320] = 19;
        byArray7[321] = 9;
        byArray7[322] = 67;
        byArray7[323] = 97;
        byArray7[324] = 112;
        byArray7[325] = 101;
        byArray7[326] = 32;
        byArray7[327] = 84;
        byArray7[328] = 111;
        byArray7[329] = 119;
        byArray7[330] = 110;
        byArray7[331] = 49;
        byArray7[332] = 29;
        byArray7[333] = 48;
        byArray7[334] = 27;
        byArray7[335] = 6;
        byArray7[336] = 3;
        byArray7[337] = 85;
        byArray7[338] = 4;
        byArray7[339] = 10;
        byArray7[340] = 19;
        byArray7[341] = 20;
        byArray7[342] = 84;
        byArray7[343] = 104;
        byArray7[344] = 97;
        byArray7[345] = 119;
        byArray7[346] = 116;
        byArray7[347] = 101;
        byArray7[348] = 32;
        byArray7[349] = 67;
        byArray7[350] = 111;
        byArray7[351] = 110;
        byArray7[352] = 115;
        byArray7[353] = 117;
        byArray7[354] = 108;
        byArray7[355] = 116;
        byArray7[356] = 105;
        byArray7[357] = 110;
        byArray7[358] = 103;
        byArray7[359] = 32;
        byArray7[360] = 99;
        byArray7[361] = 99;
        byArray7[362] = 49;
        byArray7[363] = 40;
        byArray7[364] = 48;
        byArray7[365] = 38;
        byArray7[366] = 6;
        byArray7[367] = 3;
        byArray7[368] = 85;
        byArray7[369] = 4;
        byArray7[370] = 11;
        byArray7[371] = 19;
        byArray7[372] = 31;
        byArray7[373] = 67;
        byArray7[374] = 101;
        byArray7[375] = 114;
        byArray7[376] = 116;
        byArray7[377] = 105;
        byArray7[378] = 102;
        byArray7[379] = 105;
        byArray7[380] = 99;
        byArray7[381] = 97;
        byArray7[382] = 116;
        byArray7[383] = 105;
        byArray7[384] = 111;
        byArray7[385] = 110;
        byArray7[386] = 32;
        byArray7[387] = 83;
        byArray7[388] = 101;
        byArray7[389] = 114;
        byArray7[390] = 118;
        byArray7[391] = 105;
        byArray7[392] = 99;
        byArray7[393] = 101;
        byArray7[394] = 115;
        byArray7[395] = 32;
        byArray7[396] = 68;
        byArray7[397] = 105;
        byArray7[398] = 118;
        byArray7[399] = 105;
        byArray7[400] = 115;
        byArray7[401] = 105;
        byArray7[402] = 111;
        byArray7[403] = 110;
        byArray7[404] = 49;
        byArray7[405] = 33;
        byArray7[406] = 48;
        byArray7[407] = 31;
        byArray7[408] = 6;
        byArray7[409] = 3;
        byArray7[410] = 85;
        byArray7[411] = 4;
        byArray7[412] = 3;
        byArray7[413] = 19;
        byArray7[414] = 24;
        byArray7[415] = 84;
        byArray7[416] = 104;
        byArray7[417] = 97;
        byArray7[418] = 119;
        byArray7[419] = 116;
        byArray7[420] = 101;
        byArray7[421] = 32;
        byArray7[422] = 80;
        byArray7[423] = 114;
        byArray7[424] = 101;
        byArray7[425] = 109;
        byArray7[426] = 105;
        byArray7[427] = 117;
        byArray7[428] = 109;
        byArray7[429] = 32;
        byArray7[430] = 83;
        byArray7[431] = 101;
        byArray7[432] = 114;
        byArray7[433] = 118;
        byArray7[434] = 101;
        byArray7[435] = 114;
        byArray7[436] = 32;
        byArray7[437] = 67;
        byArray7[438] = 65;
        byArray7[439] = 49;
        byArray7[440] = 40;
        byArray7[441] = 48;
        byArray7[442] = 38;
        byArray7[443] = 6;
        byArray7[444] = 9;
        byArray7[445] = 42;
        byArray7[446] = -122;
        byArray7[447] = 72;
        byArray7[448] = -122;
        byArray7[449] = -9;
        byArray7[450] = 13;
        byArray7[451] = 1;
        byArray7[452] = 9;
        byArray7[453] = 1;
        byArray7[454] = 22;
        byArray7[455] = 25;
        byArray7[456] = 112;
        byArray7[457] = 114;
        byArray7[458] = 101;
        byArray7[459] = 109;
        byArray7[460] = 105;
        byArray7[461] = 117;
        byArray7[462] = 109;
        byArray7[463] = 45;
        byArray7[464] = 115;
        byArray7[465] = 101;
        byArray7[466] = 114;
        byArray7[467] = 118;
        byArray7[468] = 101;
        byArray7[469] = 114;
        byArray7[470] = 64;
        byArray7[471] = 116;
        byArray7[472] = 104;
        byArray7[473] = 97;
        byArray7[474] = 119;
        byArray7[475] = 116;
        byArray7[476] = 101;
        byArray7[477] = 46;
        byArray7[478] = 99;
        byArray7[479] = 111;
        byArray7[480] = 109;
        byArray7[481] = 48;
        byArray7[482] = -127;
        byArray7[483] = -97;
        byArray7[484] = 48;
        byArray7[485] = 13;
        byArray7[486] = 6;
        byArray7[487] = 9;
        byArray7[488] = 42;
        byArray7[489] = -122;
        byArray7[490] = 72;
        byArray7[491] = -122;
        byArray7[492] = -9;
        byArray7[493] = 13;
        byArray7[494] = 1;
        byArray7[495] = 1;
        byArray7[496] = 1;
        byArray7[497] = 5;
        byArray7[499] = 3;
        byArray7[500] = -127;
        byArray7[501] = -115;
        byArray7[503] = 48;
        byArray7[504] = -127;
        byArray7[505] = -119;
        byArray7[506] = 2;
        byArray7[507] = -127;
        byArray7[508] = -127;
        byArray7[510] = -46;
        byArray7[511] = 54;
        byArray7[512] = 54;
        byArray7[513] = 106;
        byArray7[514] = -117;
        byArray7[515] = -41;
        byArray7[516] = -62;
        byArray7[517] = 91;
        byArray7[518] = -98;
        byArray7[519] = -38;
        byArray7[520] = -127;
        byArray7[521] = 65;
        byArray7[522] = 98;
        byArray7[523] = -113;
        byArray7[524] = 56;
        byArray7[525] = -18;
        byArray7[526] = 73;
        byArray7[527] = 4;
        byArray7[528] = 85;
        byArray7[529] = -42;
        byArray7[530] = -48;
        byArray7[531] = -17;
        byArray7[532] = 28;
        byArray7[533] = 27;
        byArray7[534] = -107;
        byArray7[535] = 22;
        byArray7[536] = 71;
        byArray7[537] = -17;
        byArray7[538] = 24;
        byArray7[539] = 72;
        byArray7[540] = 53;
        byArray7[541] = 58;
        byArray7[542] = 82;
        byArray7[543] = -12;
        byArray7[544] = 43;
        byArray7[545] = 106;
        byArray7[546] = 6;
        byArray7[547] = -113;
        byArray7[548] = 59;
        byArray7[549] = 47;
        byArray7[550] = -22;
        byArray7[551] = 86;
        byArray7[552] = -29;
        byArray7[553] = -81;
        byArray7[554] = -122;
        byArray7[555] = -115;
        byArray7[556] = -98;
        byArray7[557] = 23;
        byArray7[558] = -9;
        byArray7[559] = -98;
        byArray7[560] = -76;
        byArray7[561] = 101;
        byArray7[562] = 117;
        byArray7[563] = 2;
        byArray7[564] = 77;
        byArray7[565] = -17;
        byArray7[566] = -53;
        byArray7[567] = 9;
        byArray7[568] = -94;
        byArray7[569] = 33;
        byArray7[570] = 81;
        byArray7[571] = -40;
        byArray7[572] = -101;
        byArray7[573] = -48;
        byArray7[574] = 103;
        byArray7[575] = -48;
        byArray7[576] = -70;
        byArray7[577] = 13;
        byArray7[578] = -110;
        byArray7[579] = 6;
        byArray7[580] = 20;
        byArray7[581] = 115;
        byArray7[582] = -44;
        byArray7[583] = -109;
        byArray7[584] = -53;
        byArray7[585] = -105;
        byArray7[586] = 42;
        byArray7[588] = -100;
        byArray7[589] = 92;
        byArray7[590] = 78;
        byArray7[591] = 12;
        byArray7[592] = -68;
        byArray7[593] = -6;
        byArray7[594] = 21;
        byArray7[595] = 82;
        byArray7[596] = -4;
        byArray7[597] = -14;
        byArray7[598] = 68;
        byArray7[599] = 110;
        byArray7[600] = -38;
        byArray7[601] = 17;
        byArray7[602] = 74;
        byArray7[603] = 110;
        byArray7[604] = 8;
        byArray7[605] = -97;
        byArray7[606] = 47;
        byArray7[607] = 45;
        byArray7[608] = -29;
        byArray7[609] = -7;
        byArray7[610] = -86;
        byArray7[611] = 58;
        byArray7[612] = -122;
        byArray7[613] = 115;
        byArray7[614] = -74;
        byArray7[615] = 70;
        byArray7[616] = 83;
        byArray7[617] = 88;
        byArray7[618] = -56;
        byArray7[619] = -119;
        byArray7[620] = 5;
        byArray7[621] = -67;
        byArray7[622] = -125;
        byArray7[623] = 17;
        byArray7[624] = -72;
        byArray7[625] = 115;
        byArray7[626] = 63;
        byArray7[627] = -86;
        byArray7[628] = 7;
        byArray7[629] = -115;
        byArray7[630] = -12;
        byArray7[631] = 66;
        byArray7[632] = 77;
        byArray7[633] = -25;
        byArray7[634] = 64;
        byArray7[635] = -99;
        byArray7[636] = 28;
        byArray7[637] = 55;
        byArray7[638] = 2;
        byArray7[639] = 3;
        byArray7[640] = 1;
        byArray7[642] = 1;
        byArray7[643] = -93;
        byArray7[644] = 19;
        byArray7[645] = 48;
        byArray7[646] = 17;
        byArray7[647] = 48;
        byArray7[648] = 15;
        byArray7[649] = 6;
        byArray7[650] = 3;
        byArray7[651] = 85;
        byArray7[652] = 29;
        byArray7[653] = 19;
        byArray7[654] = 1;
        byArray7[655] = 1;
        byArray7[656] = -1;
        byArray7[657] = 4;
        byArray7[658] = 5;
        byArray7[659] = 48;
        byArray7[660] = 3;
        byArray7[661] = 1;
        byArray7[662] = 1;
        byArray7[663] = -1;
        byArray7[664] = 48;
        byArray7[665] = 13;
        byArray7[666] = 6;
        byArray7[667] = 9;
        byArray7[668] = 42;
        byArray7[669] = -122;
        byArray7[670] = 72;
        byArray7[671] = -122;
        byArray7[672] = -9;
        byArray7[673] = 13;
        byArray7[674] = 1;
        byArray7[675] = 1;
        byArray7[676] = 4;
        byArray7[677] = 5;
        byArray7[679] = 3;
        byArray7[680] = -127;
        byArray7[681] = -127;
        byArray7[683] = 38;
        byArray7[684] = 72;
        byArray7[685] = 44;
        byArray7[686] = 22;
        byArray7[687] = -62;
        byArray7[688] = 88;
        byArray7[689] = -6;
        byArray7[690] = -24;
        byArray7[691] = 22;
        byArray7[692] = 116;
        byArray7[693] = 12;
        byArray7[694] = -86;
        byArray7[695] = -86;
        byArray7[696] = 95;
        byArray7[697] = 84;
        byArray7[698] = 63;
        byArray7[699] = -14;
        byArray7[700] = -41;
        byArray7[701] = -55;
        byArray7[702] = 120;
        byArray7[703] = 96;
        byArray7[704] = 94;
        byArray7[705] = 94;
        byArray7[706] = 110;
        byArray7[707] = 55;
        byArray7[708] = 99;
        byArray7[709] = 34;
        byArray7[710] = 119;
        byArray7[711] = 54;
        byArray7[712] = 126;
        byArray7[713] = -78;
        byArray7[714] = 23;
        byArray7[715] = -60;
        byArray7[716] = 52;
        byArray7[717] = -71;
        byArray7[718] = -11;
        byArray7[719] = 8;
        byArray7[720] = -123;
        byArray7[721] = -4;
        byArray7[722] = -55;
        byArray7[723] = 1;
        byArray7[724] = 56;
        byArray7[725] = -1;
        byArray7[726] = 77;
        byArray7[727] = -66;
        byArray7[728] = -14;
        byArray7[729] = 22;
        byArray7[730] = 66;
        byArray7[731] = 67;
        byArray7[732] = -25;
        byArray7[733] = -69;
        byArray7[734] = 90;
        byArray7[735] = 70;
        byArray7[736] = -5;
        byArray7[737] = -63;
        byArray7[738] = -58;
        byArray7[739] = 17;
        byArray7[740] = 31;
        byArray7[741] = -15;
        byArray7[742] = 74;
        byArray7[743] = -80;
        byArray7[744] = 40;
        byArray7[745] = 70;
        byArray7[746] = -55;
        byArray7[747] = -61;
        byArray7[748] = -60;
        byArray7[749] = 66;
        byArray7[750] = 125;
        byArray7[751] = -68;
        byArray7[752] = -6;
        byArray7[753] = -85;
        byArray7[754] = 89;
        byArray7[755] = 110;
        byArray7[756] = -43;
        byArray7[757] = -73;
        byArray7[758] = 81;
        byArray7[759] = -120;
        byArray7[760] = 17;
        byArray7[761] = -29;
        byArray7[762] = -92;
        byArray7[763] = -123;
        byArray7[764] = 25;
        byArray7[765] = 107;
        byArray7[766] = -126;
        byArray7[767] = 76;
        byArray7[768] = -92;
        byArray7[769] = 12;
        byArray7[770] = 18;
        byArray7[771] = -83;
        byArray7[772] = -23;
        byArray7[773] = -92;
        byArray7[774] = -82;
        byArray7[775] = 63;
        byArray7[776] = -15;
        byArray7[777] = -61;
        byArray7[778] = 73;
        byArray7[779] = 101;
        byArray7[780] = -102;
        byArray7[781] = -116;
        byArray7[782] = -59;
        byArray7[783] = -56;
        byArray7[784] = 62;
        byArray7[785] = 37;
        byArray7[786] = -73;
        byArray7[787] = -108;
        byArray7[788] = -103;
        byArray7[789] = -69;
        byArray7[790] = -110;
        byArray7[791] = 50;
        byArray7[792] = 113;
        byArray7[793] = 7;
        byArray7[794] = -16;
        byArray7[795] = -122;
        byArray7[796] = 94;
        byArray7[797] = -19;
        byArray7[798] = 80;
        byArray7[799] = 39;
        byArray7[800] = -90;
        byArray7[801] = 13;
        byArray7[802] = -90;
        byArray7[803] = 35;
        byArray7[804] = -7;
        byArray7[805] = -69;
        byArray7[806] = -53;
        byArray7[807] = -90;
        byArray7[808] = 7;
        byArray7[809] = 20;
        byArray7[810] = 66;
        THAWTE_SPR_ROOT_SELF_SIGNED_CERT = byArray7;
        byte[] byArray8 = new byte[805];
        byArray8[0] = 48;
        byArray8[1] = -126;
        byArray8[2] = 3;
        byArray8[3] = 33;
        byArray8[4] = 48;
        byArray8[5] = -126;
        byArray8[6] = 2;
        byArray8[7] = -118;
        byArray8[8] = -96;
        byArray8[9] = 3;
        byArray8[10] = 2;
        byArray8[11] = 1;
        byArray8[12] = 2;
        byArray8[13] = 2;
        byArray8[14] = 1;
        byArray8[16] = 48;
        byArray8[17] = 13;
        byArray8[18] = 6;
        byArray8[19] = 9;
        byArray8[20] = 42;
        byArray8[21] = -122;
        byArray8[22] = 72;
        byArray8[23] = -122;
        byArray8[24] = -9;
        byArray8[25] = 13;
        byArray8[26] = 1;
        byArray8[27] = 1;
        byArray8[28] = 4;
        byArray8[29] = 5;
        byArray8[31] = 48;
        byArray8[32] = -127;
        byArray8[33] = -53;
        byArray8[34] = 49;
        byArray8[35] = 11;
        byArray8[36] = 48;
        byArray8[37] = 9;
        byArray8[38] = 6;
        byArray8[39] = 3;
        byArray8[40] = 85;
        byArray8[41] = 4;
        byArray8[42] = 6;
        byArray8[43] = 19;
        byArray8[44] = 2;
        byArray8[45] = 90;
        byArray8[46] = 65;
        byArray8[47] = 49;
        byArray8[48] = 21;
        byArray8[49] = 48;
        byArray8[50] = 19;
        byArray8[51] = 6;
        byArray8[52] = 3;
        byArray8[53] = 85;
        byArray8[54] = 4;
        byArray8[55] = 8;
        byArray8[56] = 19;
        byArray8[57] = 12;
        byArray8[58] = 87;
        byArray8[59] = 101;
        byArray8[60] = 115;
        byArray8[61] = 116;
        byArray8[62] = 101;
        byArray8[63] = 114;
        byArray8[64] = 110;
        byArray8[65] = 32;
        byArray8[66] = 67;
        byArray8[67] = 97;
        byArray8[68] = 112;
        byArray8[69] = 101;
        byArray8[70] = 49;
        byArray8[71] = 18;
        byArray8[72] = 48;
        byArray8[73] = 16;
        byArray8[74] = 6;
        byArray8[75] = 3;
        byArray8[76] = 85;
        byArray8[77] = 4;
        byArray8[78] = 7;
        byArray8[79] = 19;
        byArray8[80] = 9;
        byArray8[81] = 67;
        byArray8[82] = 97;
        byArray8[83] = 112;
        byArray8[84] = 101;
        byArray8[85] = 32;
        byArray8[86] = 84;
        byArray8[87] = 111;
        byArray8[88] = 119;
        byArray8[89] = 110;
        byArray8[90] = 49;
        byArray8[91] = 26;
        byArray8[92] = 48;
        byArray8[93] = 24;
        byArray8[94] = 6;
        byArray8[95] = 3;
        byArray8[96] = 85;
        byArray8[97] = 4;
        byArray8[98] = 10;
        byArray8[99] = 19;
        byArray8[100] = 17;
        byArray8[101] = 84;
        byArray8[102] = 104;
        byArray8[103] = 97;
        byArray8[104] = 119;
        byArray8[105] = 116;
        byArray8[106] = 101;
        byArray8[107] = 32;
        byArray8[108] = 67;
        byArray8[109] = 111;
        byArray8[110] = 110;
        byArray8[111] = 115;
        byArray8[112] = 117;
        byArray8[113] = 108;
        byArray8[114] = 116;
        byArray8[115] = 105;
        byArray8[116] = 110;
        byArray8[117] = 103;
        byArray8[118] = 49;
        byArray8[119] = 40;
        byArray8[120] = 48;
        byArray8[121] = 38;
        byArray8[122] = 6;
        byArray8[123] = 3;
        byArray8[124] = 85;
        byArray8[125] = 4;
        byArray8[126] = 11;
        byArray8[127] = 19;
        byArray8[128] = 31;
        byArray8[129] = 67;
        byArray8[130] = 101;
        byArray8[131] = 114;
        byArray8[132] = 116;
        byArray8[133] = 105;
        byArray8[134] = 102;
        byArray8[135] = 105;
        byArray8[136] = 99;
        byArray8[137] = 97;
        byArray8[138] = 116;
        byArray8[139] = 105;
        byArray8[140] = 111;
        byArray8[141] = 110;
        byArray8[142] = 32;
        byArray8[143] = 83;
        byArray8[144] = 101;
        byArray8[145] = 114;
        byArray8[146] = 118;
        byArray8[147] = 105;
        byArray8[148] = 99;
        byArray8[149] = 101;
        byArray8[150] = 115;
        byArray8[151] = 32;
        byArray8[152] = 68;
        byArray8[153] = 105;
        byArray8[154] = 118;
        byArray8[155] = 105;
        byArray8[156] = 115;
        byArray8[157] = 105;
        byArray8[158] = 111;
        byArray8[159] = 110;
        byArray8[160] = 49;
        byArray8[161] = 33;
        byArray8[162] = 48;
        byArray8[163] = 31;
        byArray8[164] = 6;
        byArray8[165] = 3;
        byArray8[166] = 85;
        byArray8[167] = 4;
        byArray8[168] = 3;
        byArray8[169] = 19;
        byArray8[170] = 24;
        byArray8[171] = 84;
        byArray8[172] = 104;
        byArray8[173] = 97;
        byArray8[174] = 119;
        byArray8[175] = 116;
        byArray8[176] = 101;
        byArray8[177] = 32;
        byArray8[178] = 80;
        byArray8[179] = 101;
        byArray8[180] = 114;
        byArray8[181] = 115;
        byArray8[182] = 111;
        byArray8[183] = 110;
        byArray8[184] = 97;
        byArray8[185] = 108;
        byArray8[186] = 32;
        byArray8[187] = 66;
        byArray8[188] = 97;
        byArray8[189] = 115;
        byArray8[190] = 105;
        byArray8[191] = 99;
        byArray8[192] = 32;
        byArray8[193] = 67;
        byArray8[194] = 65;
        byArray8[195] = 49;
        byArray8[196] = 40;
        byArray8[197] = 48;
        byArray8[198] = 38;
        byArray8[199] = 6;
        byArray8[200] = 9;
        byArray8[201] = 42;
        byArray8[202] = -122;
        byArray8[203] = 72;
        byArray8[204] = -122;
        byArray8[205] = -9;
        byArray8[206] = 13;
        byArray8[207] = 1;
        byArray8[208] = 9;
        byArray8[209] = 1;
        byArray8[210] = 22;
        byArray8[211] = 25;
        byArray8[212] = 112;
        byArray8[213] = 101;
        byArray8[214] = 114;
        byArray8[215] = 115;
        byArray8[216] = 111;
        byArray8[217] = 110;
        byArray8[218] = 97;
        byArray8[219] = 108;
        byArray8[220] = 45;
        byArray8[221] = 98;
        byArray8[222] = 97;
        byArray8[223] = 115;
        byArray8[224] = 105;
        byArray8[225] = 99;
        byArray8[226] = 64;
        byArray8[227] = 116;
        byArray8[228] = 104;
        byArray8[229] = 97;
        byArray8[230] = 119;
        byArray8[231] = 116;
        byArray8[232] = 101;
        byArray8[233] = 46;
        byArray8[234] = 99;
        byArray8[235] = 111;
        byArray8[236] = 109;
        byArray8[237] = 48;
        byArray8[238] = 30;
        byArray8[239] = 23;
        byArray8[240] = 13;
        byArray8[241] = 57;
        byArray8[242] = 54;
        byArray8[243] = 48;
        byArray8[244] = 49;
        byArray8[245] = 48;
        byArray8[246] = 49;
        byArray8[247] = 48;
        byArray8[248] = 48;
        byArray8[249] = 48;
        byArray8[250] = 48;
        byArray8[251] = 48;
        byArray8[252] = 48;
        byArray8[253] = 90;
        byArray8[254] = 23;
        byArray8[255] = 13;
        byArray8[256] = 50;
        byArray8[257] = 48;
        byArray8[258] = 49;
        byArray8[259] = 50;
        byArray8[260] = 51;
        byArray8[261] = 49;
        byArray8[262] = 50;
        byArray8[263] = 51;
        byArray8[264] = 53;
        byArray8[265] = 57;
        byArray8[266] = 53;
        byArray8[267] = 57;
        byArray8[268] = 90;
        byArray8[269] = 48;
        byArray8[270] = -127;
        byArray8[271] = -53;
        byArray8[272] = 49;
        byArray8[273] = 11;
        byArray8[274] = 48;
        byArray8[275] = 9;
        byArray8[276] = 6;
        byArray8[277] = 3;
        byArray8[278] = 85;
        byArray8[279] = 4;
        byArray8[280] = 6;
        byArray8[281] = 19;
        byArray8[282] = 2;
        byArray8[283] = 90;
        byArray8[284] = 65;
        byArray8[285] = 49;
        byArray8[286] = 21;
        byArray8[287] = 48;
        byArray8[288] = 19;
        byArray8[289] = 6;
        byArray8[290] = 3;
        byArray8[291] = 85;
        byArray8[292] = 4;
        byArray8[293] = 8;
        byArray8[294] = 19;
        byArray8[295] = 12;
        byArray8[296] = 87;
        byArray8[297] = 101;
        byArray8[298] = 115;
        byArray8[299] = 116;
        byArray8[300] = 101;
        byArray8[301] = 114;
        byArray8[302] = 110;
        byArray8[303] = 32;
        byArray8[304] = 67;
        byArray8[305] = 97;
        byArray8[306] = 112;
        byArray8[307] = 101;
        byArray8[308] = 49;
        byArray8[309] = 18;
        byArray8[310] = 48;
        byArray8[311] = 16;
        byArray8[312] = 6;
        byArray8[313] = 3;
        byArray8[314] = 85;
        byArray8[315] = 4;
        byArray8[316] = 7;
        byArray8[317] = 19;
        byArray8[318] = 9;
        byArray8[319] = 67;
        byArray8[320] = 97;
        byArray8[321] = 112;
        byArray8[322] = 101;
        byArray8[323] = 32;
        byArray8[324] = 84;
        byArray8[325] = 111;
        byArray8[326] = 119;
        byArray8[327] = 110;
        byArray8[328] = 49;
        byArray8[329] = 26;
        byArray8[330] = 48;
        byArray8[331] = 24;
        byArray8[332] = 6;
        byArray8[333] = 3;
        byArray8[334] = 85;
        byArray8[335] = 4;
        byArray8[336] = 10;
        byArray8[337] = 19;
        byArray8[338] = 17;
        byArray8[339] = 84;
        byArray8[340] = 104;
        byArray8[341] = 97;
        byArray8[342] = 119;
        byArray8[343] = 116;
        byArray8[344] = 101;
        byArray8[345] = 32;
        byArray8[346] = 67;
        byArray8[347] = 111;
        byArray8[348] = 110;
        byArray8[349] = 115;
        byArray8[350] = 117;
        byArray8[351] = 108;
        byArray8[352] = 116;
        byArray8[353] = 105;
        byArray8[354] = 110;
        byArray8[355] = 103;
        byArray8[356] = 49;
        byArray8[357] = 40;
        byArray8[358] = 48;
        byArray8[359] = 38;
        byArray8[360] = 6;
        byArray8[361] = 3;
        byArray8[362] = 85;
        byArray8[363] = 4;
        byArray8[364] = 11;
        byArray8[365] = 19;
        byArray8[366] = 31;
        byArray8[367] = 67;
        byArray8[368] = 101;
        byArray8[369] = 114;
        byArray8[370] = 116;
        byArray8[371] = 105;
        byArray8[372] = 102;
        byArray8[373] = 105;
        byArray8[374] = 99;
        byArray8[375] = 97;
        byArray8[376] = 116;
        byArray8[377] = 105;
        byArray8[378] = 111;
        byArray8[379] = 110;
        byArray8[380] = 32;
        byArray8[381] = 83;
        byArray8[382] = 101;
        byArray8[383] = 114;
        byArray8[384] = 118;
        byArray8[385] = 105;
        byArray8[386] = 99;
        byArray8[387] = 101;
        byArray8[388] = 115;
        byArray8[389] = 32;
        byArray8[390] = 68;
        byArray8[391] = 105;
        byArray8[392] = 118;
        byArray8[393] = 105;
        byArray8[394] = 115;
        byArray8[395] = 105;
        byArray8[396] = 111;
        byArray8[397] = 110;
        byArray8[398] = 49;
        byArray8[399] = 33;
        byArray8[400] = 48;
        byArray8[401] = 31;
        byArray8[402] = 6;
        byArray8[403] = 3;
        byArray8[404] = 85;
        byArray8[405] = 4;
        byArray8[406] = 3;
        byArray8[407] = 19;
        byArray8[408] = 24;
        byArray8[409] = 84;
        byArray8[410] = 104;
        byArray8[411] = 97;
        byArray8[412] = 119;
        byArray8[413] = 116;
        byArray8[414] = 101;
        byArray8[415] = 32;
        byArray8[416] = 80;
        byArray8[417] = 101;
        byArray8[418] = 114;
        byArray8[419] = 115;
        byArray8[420] = 111;
        byArray8[421] = 110;
        byArray8[422] = 97;
        byArray8[423] = 108;
        byArray8[424] = 32;
        byArray8[425] = 66;
        byArray8[426] = 97;
        byArray8[427] = 115;
        byArray8[428] = 105;
        byArray8[429] = 99;
        byArray8[430] = 32;
        byArray8[431] = 67;
        byArray8[432] = 65;
        byArray8[433] = 49;
        byArray8[434] = 40;
        byArray8[435] = 48;
        byArray8[436] = 38;
        byArray8[437] = 6;
        byArray8[438] = 9;
        byArray8[439] = 42;
        byArray8[440] = -122;
        byArray8[441] = 72;
        byArray8[442] = -122;
        byArray8[443] = -9;
        byArray8[444] = 13;
        byArray8[445] = 1;
        byArray8[446] = 9;
        byArray8[447] = 1;
        byArray8[448] = 22;
        byArray8[449] = 25;
        byArray8[450] = 112;
        byArray8[451] = 101;
        byArray8[452] = 114;
        byArray8[453] = 115;
        byArray8[454] = 111;
        byArray8[455] = 110;
        byArray8[456] = 97;
        byArray8[457] = 108;
        byArray8[458] = 45;
        byArray8[459] = 98;
        byArray8[460] = 97;
        byArray8[461] = 115;
        byArray8[462] = 105;
        byArray8[463] = 99;
        byArray8[464] = 64;
        byArray8[465] = 116;
        byArray8[466] = 104;
        byArray8[467] = 97;
        byArray8[468] = 119;
        byArray8[469] = 116;
        byArray8[470] = 101;
        byArray8[471] = 46;
        byArray8[472] = 99;
        byArray8[473] = 111;
        byArray8[474] = 109;
        byArray8[475] = 48;
        byArray8[476] = -127;
        byArray8[477] = -97;
        byArray8[478] = 48;
        byArray8[479] = 13;
        byArray8[480] = 6;
        byArray8[481] = 9;
        byArray8[482] = 42;
        byArray8[483] = -122;
        byArray8[484] = 72;
        byArray8[485] = -122;
        byArray8[486] = -9;
        byArray8[487] = 13;
        byArray8[488] = 1;
        byArray8[489] = 1;
        byArray8[490] = 1;
        byArray8[491] = 5;
        byArray8[493] = 3;
        byArray8[494] = -127;
        byArray8[495] = -115;
        byArray8[497] = 48;
        byArray8[498] = -127;
        byArray8[499] = -119;
        byArray8[500] = 2;
        byArray8[501] = -127;
        byArray8[502] = -127;
        byArray8[504] = -68;
        byArray8[505] = -68;
        byArray8[506] = -109;
        byArray8[507] = 83;
        byArray8[508] = 109;
        byArray8[509] = -64;
        byArray8[510] = 80;
        byArray8[511] = 79;
        byArray8[512] = -126;
        byArray8[513] = 21;
        byArray8[514] = -26;
        byArray8[515] = 72;
        byArray8[516] = -108;
        byArray8[517] = 53;
        byArray8[518] = -90;
        byArray8[519] = 90;
        byArray8[520] = -66;
        byArray8[521] = 111;
        byArray8[522] = 66;
        byArray8[523] = -6;
        byArray8[524] = 15;
        byArray8[525] = 71;
        byArray8[526] = -18;
        byArray8[527] = 119;
        byArray8[528] = 117;
        byArray8[529] = 114;
        byArray8[530] = -35;
        byArray8[531] = -115;
        byArray8[532] = 73;
        byArray8[533] = -101;
        byArray8[534] = -106;
        byArray8[535] = 87;
        byArray8[536] = -96;
        byArray8[537] = 120;
        byArray8[538] = -44;
        byArray8[539] = -54;
        byArray8[540] = 63;
        byArray8[541] = 81;
        byArray8[542] = -77;
        byArray8[543] = 105;
        byArray8[544] = 11;
        byArray8[545] = -111;
        byArray8[546] = 118;
        byArray8[547] = 23;
        byArray8[548] = 34;
        byArray8[549] = 7;
        byArray8[550] = -105;
        byArray8[551] = 106;
        byArray8[552] = -60;
        byArray8[553] = 81;
        byArray8[554] = -109;
        byArray8[555] = 75;
        byArray8[556] = -32;
        byArray8[557] = -115;
        byArray8[558] = -17;
        byArray8[559] = 55;
        byArray8[560] = -107;
        byArray8[561] = -95;
        byArray8[562] = 12;
        byArray8[563] = 77;
        byArray8[564] = -38;
        byArray8[565] = 52;
        byArray8[566] = -112;
        byArray8[567] = 29;
        byArray8[568] = 23;
        byArray8[569] = -119;
        byArray8[570] = -105;
        byArray8[571] = -32;
        byArray8[572] = 53;
        byArray8[573] = 56;
        byArray8[574] = 87;
        byArray8[575] = 74;
        byArray8[576] = -64;
        byArray8[577] = -12;
        byArray8[578] = 8;
        byArray8[579] = 112;
        byArray8[580] = -23;
        byArray8[581] = 60;
        byArray8[582] = 68;
        byArray8[583] = 123;
        byArray8[584] = 80;
        byArray8[585] = 126;
        byArray8[586] = 97;
        byArray8[587] = -102;
        byArray8[588] = -112;
        byArray8[589] = -29;
        byArray8[590] = 35;
        byArray8[591] = -45;
        byArray8[592] = -120;
        byArray8[593] = 17;
        byArray8[594] = 70;
        byArray8[595] = 39;
        byArray8[596] = -11;
        byArray8[597] = 11;
        byArray8[598] = 7;
        byArray8[599] = 14;
        byArray8[600] = -69;
        byArray8[601] = -35;
        byArray8[602] = -47;
        byArray8[603] = 127;
        byArray8[604] = 32;
        byArray8[605] = 10;
        byArray8[606] = -120;
        byArray8[607] = -71;
        byArray8[608] = 86;
        byArray8[609] = 11;
        byArray8[610] = 46;
        byArray8[611] = 28;
        byArray8[612] = -128;
        byArray8[613] = -38;
        byArray8[614] = -15;
        byArray8[615] = -29;
        byArray8[616] = -98;
        byArray8[617] = 41;
        byArray8[618] = -17;
        byArray8[619] = 20;
        byArray8[620] = -67;
        byArray8[621] = 10;
        byArray8[622] = 68;
        byArray8[623] = -5;
        byArray8[624] = 27;
        byArray8[625] = 91;
        byArray8[626] = 24;
        byArray8[627] = -47;
        byArray8[628] = -65;
        byArray8[629] = 35;
        byArray8[630] = -109;
        byArray8[631] = 33;
        byArray8[632] = 2;
        byArray8[633] = 3;
        byArray8[634] = 1;
        byArray8[636] = 1;
        byArray8[637] = -93;
        byArray8[638] = 19;
        byArray8[639] = 48;
        byArray8[640] = 17;
        byArray8[641] = 48;
        byArray8[642] = 15;
        byArray8[643] = 6;
        byArray8[644] = 3;
        byArray8[645] = 85;
        byArray8[646] = 29;
        byArray8[647] = 19;
        byArray8[648] = 1;
        byArray8[649] = 1;
        byArray8[650] = -1;
        byArray8[651] = 4;
        byArray8[652] = 5;
        byArray8[653] = 48;
        byArray8[654] = 3;
        byArray8[655] = 1;
        byArray8[656] = 1;
        byArray8[657] = -1;
        byArray8[658] = 48;
        byArray8[659] = 13;
        byArray8[660] = 6;
        byArray8[661] = 9;
        byArray8[662] = 42;
        byArray8[663] = -122;
        byArray8[664] = 72;
        byArray8[665] = -122;
        byArray8[666] = -9;
        byArray8[667] = 13;
        byArray8[668] = 1;
        byArray8[669] = 1;
        byArray8[670] = 4;
        byArray8[671] = 5;
        byArray8[673] = 3;
        byArray8[674] = -127;
        byArray8[675] = -127;
        byArray8[677] = 45;
        byArray8[678] = -30;
        byArray8[679] = -103;
        byArray8[680] = 107;
        byArray8[681] = -80;
        byArray8[682] = 61;
        byArray8[683] = 122;
        byArray8[684] = -119;
        byArray8[685] = -41;
        byArray8[686] = 89;
        byArray8[687] = -94;
        byArray8[688] = -108;
        byArray8[689] = 1;
        byArray8[690] = 31;
        byArray8[691] = 43;
        byArray8[692] = -35;
        byArray8[693] = 18;
        byArray8[694] = 75;
        byArray8[695] = 83;
        byArray8[696] = -62;
        byArray8[697] = -83;
        byArray8[698] = 127;
        byArray8[699] = -86;
        byArray8[700] = -89;
        byArray8[702] = 92;
        byArray8[703] = -111;
        byArray8[704] = 64;
        byArray8[705] = 87;
        byArray8[706] = 37;
        byArray8[707] = 74;
        byArray8[708] = 56;
        byArray8[709] = -86;
        byArray8[710] = -124;
        byArray8[711] = 112;
        byArray8[712] = -71;
        byArray8[713] = -39;
        byArray8[714] = -128;
        byArray8[715] = 15;
        byArray8[716] = -91;
        byArray8[717] = 123;
        byArray8[718] = 92;
        byArray8[719] = -5;
        byArray8[720] = 115;
        byArray8[721] = -58;
        byArray8[722] = -67;
        byArray8[723] = -41;
        byArray8[724] = -118;
        byArray8[725] = 97;
        byArray8[726] = 92;
        byArray8[727] = 3;
        byArray8[728] = -29;
        byArray8[729] = 45;
        byArray8[730] = 39;
        byArray8[731] = -88;
        byArray8[732] = 23;
        byArray8[733] = -32;
        byArray8[734] = -124;
        byArray8[735] = -123;
        byArray8[736] = 66;
        byArray8[737] = -36;
        byArray8[738] = 94;
        byArray8[739] = -101;
        byArray8[740] = -58;
        byArray8[741] = -73;
        byArray8[742] = -78;
        byArray8[743] = 109;
        byArray8[744] = -69;
        byArray8[745] = 116;
        byArray8[746] = -81;
        byArray8[747] = -28;
        byArray8[748] = 63;
        byArray8[749] = -53;
        byArray8[750] = -89;
        byArray8[751] = -73;
        byArray8[752] = -80;
        byArray8[753] = -32;
        byArray8[754] = 93;
        byArray8[755] = -66;
        byArray8[756] = 120;
        byArray8[757] = -125;
        byArray8[758] = 37;
        byArray8[759] = -108;
        byArray8[760] = -46;
        byArray8[761] = -37;
        byArray8[762] = -127;
        byArray8[763] = 15;
        byArray8[764] = 121;
        byArray8[765] = 7;
        byArray8[766] = 109;
        byArray8[767] = 79;
        byArray8[768] = -12;
        byArray8[769] = 57;
        byArray8[770] = 21;
        byArray8[771] = 90;
        byArray8[772] = 82;
        byArray8[773] = 1;
        byArray8[774] = 123;
        byArray8[775] = -34;
        byArray8[776] = 50;
        byArray8[777] = -42;
        byArray8[778] = 77;
        byArray8[779] = 56;
        byArray8[780] = -10;
        byArray8[781] = 18;
        byArray8[782] = 92;
        byArray8[783] = 6;
        byArray8[784] = 80;
        byArray8[785] = -33;
        byArray8[786] = 5;
        byArray8[787] = 91;
        byArray8[788] = -67;
        byArray8[789] = 20;
        byArray8[790] = 75;
        byArray8[791] = -95;
        byArray8[792] = -33;
        byArray8[793] = 41;
        byArray8[794] = -70;
        byArray8[795] = 59;
        byArray8[796] = 65;
        byArray8[797] = -115;
        byArray8[798] = -9;
        byArray8[799] = 99;
        byArray8[800] = 86;
        byArray8[801] = -95;
        byArray8[802] = -33;
        byArray8[803] = 34;
        byArray8[804] = -79;
        THAWTE_PBASIC_ROOT_SELF_SIGNED_CERT = byArray8;
        byte[] byArray9 = new byte[817];
        byArray9[0] = 48;
        byArray9[1] = -126;
        byArray9[2] = 3;
        byArray9[3] = 45;
        byArray9[4] = 48;
        byArray9[5] = -126;
        byArray9[6] = 2;
        byArray9[7] = -106;
        byArray9[8] = -96;
        byArray9[9] = 3;
        byArray9[10] = 2;
        byArray9[11] = 1;
        byArray9[12] = 2;
        byArray9[13] = 2;
        byArray9[14] = 1;
        byArray9[16] = 48;
        byArray9[17] = 13;
        byArray9[18] = 6;
        byArray9[19] = 9;
        byArray9[20] = 42;
        byArray9[21] = -122;
        byArray9[22] = 72;
        byArray9[23] = -122;
        byArray9[24] = -9;
        byArray9[25] = 13;
        byArray9[26] = 1;
        byArray9[27] = 1;
        byArray9[28] = 4;
        byArray9[29] = 5;
        byArray9[31] = 48;
        byArray9[32] = -127;
        byArray9[33] = -47;
        byArray9[34] = 49;
        byArray9[35] = 11;
        byArray9[36] = 48;
        byArray9[37] = 9;
        byArray9[38] = 6;
        byArray9[39] = 3;
        byArray9[40] = 85;
        byArray9[41] = 4;
        byArray9[42] = 6;
        byArray9[43] = 19;
        byArray9[44] = 2;
        byArray9[45] = 90;
        byArray9[46] = 65;
        byArray9[47] = 49;
        byArray9[48] = 21;
        byArray9[49] = 48;
        byArray9[50] = 19;
        byArray9[51] = 6;
        byArray9[52] = 3;
        byArray9[53] = 85;
        byArray9[54] = 4;
        byArray9[55] = 8;
        byArray9[56] = 19;
        byArray9[57] = 12;
        byArray9[58] = 87;
        byArray9[59] = 101;
        byArray9[60] = 115;
        byArray9[61] = 116;
        byArray9[62] = 101;
        byArray9[63] = 114;
        byArray9[64] = 110;
        byArray9[65] = 32;
        byArray9[66] = 67;
        byArray9[67] = 97;
        byArray9[68] = 112;
        byArray9[69] = 101;
        byArray9[70] = 49;
        byArray9[71] = 18;
        byArray9[72] = 48;
        byArray9[73] = 16;
        byArray9[74] = 6;
        byArray9[75] = 3;
        byArray9[76] = 85;
        byArray9[77] = 4;
        byArray9[78] = 7;
        byArray9[79] = 19;
        byArray9[80] = 9;
        byArray9[81] = 67;
        byArray9[82] = 97;
        byArray9[83] = 112;
        byArray9[84] = 101;
        byArray9[85] = 32;
        byArray9[86] = 84;
        byArray9[87] = 111;
        byArray9[88] = 119;
        byArray9[89] = 110;
        byArray9[90] = 49;
        byArray9[91] = 26;
        byArray9[92] = 48;
        byArray9[93] = 24;
        byArray9[94] = 6;
        byArray9[95] = 3;
        byArray9[96] = 85;
        byArray9[97] = 4;
        byArray9[98] = 10;
        byArray9[99] = 19;
        byArray9[100] = 17;
        byArray9[101] = 84;
        byArray9[102] = 104;
        byArray9[103] = 97;
        byArray9[104] = 119;
        byArray9[105] = 116;
        byArray9[106] = 101;
        byArray9[107] = 32;
        byArray9[108] = 67;
        byArray9[109] = 111;
        byArray9[110] = 110;
        byArray9[111] = 115;
        byArray9[112] = 117;
        byArray9[113] = 108;
        byArray9[114] = 116;
        byArray9[115] = 105;
        byArray9[116] = 110;
        byArray9[117] = 103;
        byArray9[118] = 49;
        byArray9[119] = 40;
        byArray9[120] = 48;
        byArray9[121] = 38;
        byArray9[122] = 6;
        byArray9[123] = 3;
        byArray9[124] = 85;
        byArray9[125] = 4;
        byArray9[126] = 11;
        byArray9[127] = 19;
        byArray9[128] = 31;
        byArray9[129] = 67;
        byArray9[130] = 101;
        byArray9[131] = 114;
        byArray9[132] = 116;
        byArray9[133] = 105;
        byArray9[134] = 102;
        byArray9[135] = 105;
        byArray9[136] = 99;
        byArray9[137] = 97;
        byArray9[138] = 116;
        byArray9[139] = 105;
        byArray9[140] = 111;
        byArray9[141] = 110;
        byArray9[142] = 32;
        byArray9[143] = 83;
        byArray9[144] = 101;
        byArray9[145] = 114;
        byArray9[146] = 118;
        byArray9[147] = 105;
        byArray9[148] = 99;
        byArray9[149] = 101;
        byArray9[150] = 115;
        byArray9[151] = 32;
        byArray9[152] = 68;
        byArray9[153] = 105;
        byArray9[154] = 118;
        byArray9[155] = 105;
        byArray9[156] = 115;
        byArray9[157] = 105;
        byArray9[158] = 111;
        byArray9[159] = 110;
        byArray9[160] = 49;
        byArray9[161] = 36;
        byArray9[162] = 48;
        byArray9[163] = 34;
        byArray9[164] = 6;
        byArray9[165] = 3;
        byArray9[166] = 85;
        byArray9[167] = 4;
        byArray9[168] = 3;
        byArray9[169] = 19;
        byArray9[170] = 27;
        byArray9[171] = 84;
        byArray9[172] = 104;
        byArray9[173] = 97;
        byArray9[174] = 119;
        byArray9[175] = 116;
        byArray9[176] = 101;
        byArray9[177] = 32;
        byArray9[178] = 80;
        byArray9[179] = 101;
        byArray9[180] = 114;
        byArray9[181] = 115;
        byArray9[182] = 111;
        byArray9[183] = 110;
        byArray9[184] = 97;
        byArray9[185] = 108;
        byArray9[186] = 32;
        byArray9[187] = 70;
        byArray9[188] = 114;
        byArray9[189] = 101;
        byArray9[190] = 101;
        byArray9[191] = 109;
        byArray9[192] = 97;
        byArray9[193] = 105;
        byArray9[194] = 108;
        byArray9[195] = 32;
        byArray9[196] = 67;
        byArray9[197] = 65;
        byArray9[198] = 49;
        byArray9[199] = 43;
        byArray9[200] = 48;
        byArray9[201] = 41;
        byArray9[202] = 6;
        byArray9[203] = 9;
        byArray9[204] = 42;
        byArray9[205] = -122;
        byArray9[206] = 72;
        byArray9[207] = -122;
        byArray9[208] = -9;
        byArray9[209] = 13;
        byArray9[210] = 1;
        byArray9[211] = 9;
        byArray9[212] = 1;
        byArray9[213] = 22;
        byArray9[214] = 28;
        byArray9[215] = 112;
        byArray9[216] = 101;
        byArray9[217] = 114;
        byArray9[218] = 115;
        byArray9[219] = 111;
        byArray9[220] = 110;
        byArray9[221] = 97;
        byArray9[222] = 108;
        byArray9[223] = 45;
        byArray9[224] = 102;
        byArray9[225] = 114;
        byArray9[226] = 101;
        byArray9[227] = 101;
        byArray9[228] = 109;
        byArray9[229] = 97;
        byArray9[230] = 105;
        byArray9[231] = 108;
        byArray9[232] = 64;
        byArray9[233] = 116;
        byArray9[234] = 104;
        byArray9[235] = 97;
        byArray9[236] = 119;
        byArray9[237] = 116;
        byArray9[238] = 101;
        byArray9[239] = 46;
        byArray9[240] = 99;
        byArray9[241] = 111;
        byArray9[242] = 109;
        byArray9[243] = 48;
        byArray9[244] = 30;
        byArray9[245] = 23;
        byArray9[246] = 13;
        byArray9[247] = 57;
        byArray9[248] = 54;
        byArray9[249] = 48;
        byArray9[250] = 49;
        byArray9[251] = 48;
        byArray9[252] = 49;
        byArray9[253] = 48;
        byArray9[254] = 48;
        byArray9[255] = 48;
        byArray9[256] = 48;
        byArray9[257] = 48;
        byArray9[258] = 48;
        byArray9[259] = 90;
        byArray9[260] = 23;
        byArray9[261] = 13;
        byArray9[262] = 50;
        byArray9[263] = 48;
        byArray9[264] = 49;
        byArray9[265] = 50;
        byArray9[266] = 51;
        byArray9[267] = 49;
        byArray9[268] = 50;
        byArray9[269] = 51;
        byArray9[270] = 53;
        byArray9[271] = 57;
        byArray9[272] = 53;
        byArray9[273] = 57;
        byArray9[274] = 90;
        byArray9[275] = 48;
        byArray9[276] = -127;
        byArray9[277] = -47;
        byArray9[278] = 49;
        byArray9[279] = 11;
        byArray9[280] = 48;
        byArray9[281] = 9;
        byArray9[282] = 6;
        byArray9[283] = 3;
        byArray9[284] = 85;
        byArray9[285] = 4;
        byArray9[286] = 6;
        byArray9[287] = 19;
        byArray9[288] = 2;
        byArray9[289] = 90;
        byArray9[290] = 65;
        byArray9[291] = 49;
        byArray9[292] = 21;
        byArray9[293] = 48;
        byArray9[294] = 19;
        byArray9[295] = 6;
        byArray9[296] = 3;
        byArray9[297] = 85;
        byArray9[298] = 4;
        byArray9[299] = 8;
        byArray9[300] = 19;
        byArray9[301] = 12;
        byArray9[302] = 87;
        byArray9[303] = 101;
        byArray9[304] = 115;
        byArray9[305] = 116;
        byArray9[306] = 101;
        byArray9[307] = 114;
        byArray9[308] = 110;
        byArray9[309] = 32;
        byArray9[310] = 67;
        byArray9[311] = 97;
        byArray9[312] = 112;
        byArray9[313] = 101;
        byArray9[314] = 49;
        byArray9[315] = 18;
        byArray9[316] = 48;
        byArray9[317] = 16;
        byArray9[318] = 6;
        byArray9[319] = 3;
        byArray9[320] = 85;
        byArray9[321] = 4;
        byArray9[322] = 7;
        byArray9[323] = 19;
        byArray9[324] = 9;
        byArray9[325] = 67;
        byArray9[326] = 97;
        byArray9[327] = 112;
        byArray9[328] = 101;
        byArray9[329] = 32;
        byArray9[330] = 84;
        byArray9[331] = 111;
        byArray9[332] = 119;
        byArray9[333] = 110;
        byArray9[334] = 49;
        byArray9[335] = 26;
        byArray9[336] = 48;
        byArray9[337] = 24;
        byArray9[338] = 6;
        byArray9[339] = 3;
        byArray9[340] = 85;
        byArray9[341] = 4;
        byArray9[342] = 10;
        byArray9[343] = 19;
        byArray9[344] = 17;
        byArray9[345] = 84;
        byArray9[346] = 104;
        byArray9[347] = 97;
        byArray9[348] = 119;
        byArray9[349] = 116;
        byArray9[350] = 101;
        byArray9[351] = 32;
        byArray9[352] = 67;
        byArray9[353] = 111;
        byArray9[354] = 110;
        byArray9[355] = 115;
        byArray9[356] = 117;
        byArray9[357] = 108;
        byArray9[358] = 116;
        byArray9[359] = 105;
        byArray9[360] = 110;
        byArray9[361] = 103;
        byArray9[362] = 49;
        byArray9[363] = 40;
        byArray9[364] = 48;
        byArray9[365] = 38;
        byArray9[366] = 6;
        byArray9[367] = 3;
        byArray9[368] = 85;
        byArray9[369] = 4;
        byArray9[370] = 11;
        byArray9[371] = 19;
        byArray9[372] = 31;
        byArray9[373] = 67;
        byArray9[374] = 101;
        byArray9[375] = 114;
        byArray9[376] = 116;
        byArray9[377] = 105;
        byArray9[378] = 102;
        byArray9[379] = 105;
        byArray9[380] = 99;
        byArray9[381] = 97;
        byArray9[382] = 116;
        byArray9[383] = 105;
        byArray9[384] = 111;
        byArray9[385] = 110;
        byArray9[386] = 32;
        byArray9[387] = 83;
        byArray9[388] = 101;
        byArray9[389] = 114;
        byArray9[390] = 118;
        byArray9[391] = 105;
        byArray9[392] = 99;
        byArray9[393] = 101;
        byArray9[394] = 115;
        byArray9[395] = 32;
        byArray9[396] = 68;
        byArray9[397] = 105;
        byArray9[398] = 118;
        byArray9[399] = 105;
        byArray9[400] = 115;
        byArray9[401] = 105;
        byArray9[402] = 111;
        byArray9[403] = 110;
        byArray9[404] = 49;
        byArray9[405] = 36;
        byArray9[406] = 48;
        byArray9[407] = 34;
        byArray9[408] = 6;
        byArray9[409] = 3;
        byArray9[410] = 85;
        byArray9[411] = 4;
        byArray9[412] = 3;
        byArray9[413] = 19;
        byArray9[414] = 27;
        byArray9[415] = 84;
        byArray9[416] = 104;
        byArray9[417] = 97;
        byArray9[418] = 119;
        byArray9[419] = 116;
        byArray9[420] = 101;
        byArray9[421] = 32;
        byArray9[422] = 80;
        byArray9[423] = 101;
        byArray9[424] = 114;
        byArray9[425] = 115;
        byArray9[426] = 111;
        byArray9[427] = 110;
        byArray9[428] = 97;
        byArray9[429] = 108;
        byArray9[430] = 32;
        byArray9[431] = 70;
        byArray9[432] = 114;
        byArray9[433] = 101;
        byArray9[434] = 101;
        byArray9[435] = 109;
        byArray9[436] = 97;
        byArray9[437] = 105;
        byArray9[438] = 108;
        byArray9[439] = 32;
        byArray9[440] = 67;
        byArray9[441] = 65;
        byArray9[442] = 49;
        byArray9[443] = 43;
        byArray9[444] = 48;
        byArray9[445] = 41;
        byArray9[446] = 6;
        byArray9[447] = 9;
        byArray9[448] = 42;
        byArray9[449] = -122;
        byArray9[450] = 72;
        byArray9[451] = -122;
        byArray9[452] = -9;
        byArray9[453] = 13;
        byArray9[454] = 1;
        byArray9[455] = 9;
        byArray9[456] = 1;
        byArray9[457] = 22;
        byArray9[458] = 28;
        byArray9[459] = 112;
        byArray9[460] = 101;
        byArray9[461] = 114;
        byArray9[462] = 115;
        byArray9[463] = 111;
        byArray9[464] = 110;
        byArray9[465] = 97;
        byArray9[466] = 108;
        byArray9[467] = 45;
        byArray9[468] = 102;
        byArray9[469] = 114;
        byArray9[470] = 101;
        byArray9[471] = 101;
        byArray9[472] = 109;
        byArray9[473] = 97;
        byArray9[474] = 105;
        byArray9[475] = 108;
        byArray9[476] = 64;
        byArray9[477] = 116;
        byArray9[478] = 104;
        byArray9[479] = 97;
        byArray9[480] = 119;
        byArray9[481] = 116;
        byArray9[482] = 101;
        byArray9[483] = 46;
        byArray9[484] = 99;
        byArray9[485] = 111;
        byArray9[486] = 109;
        byArray9[487] = 48;
        byArray9[488] = -127;
        byArray9[489] = -97;
        byArray9[490] = 48;
        byArray9[491] = 13;
        byArray9[492] = 6;
        byArray9[493] = 9;
        byArray9[494] = 42;
        byArray9[495] = -122;
        byArray9[496] = 72;
        byArray9[497] = -122;
        byArray9[498] = -9;
        byArray9[499] = 13;
        byArray9[500] = 1;
        byArray9[501] = 1;
        byArray9[502] = 1;
        byArray9[503] = 5;
        byArray9[505] = 3;
        byArray9[506] = -127;
        byArray9[507] = -115;
        byArray9[509] = 48;
        byArray9[510] = -127;
        byArray9[511] = -119;
        byArray9[512] = 2;
        byArray9[513] = -127;
        byArray9[514] = -127;
        byArray9[516] = -44;
        byArray9[517] = 105;
        byArray9[518] = -41;
        byArray9[519] = -44;
        byArray9[520] = -80;
        byArray9[521] = -108;
        byArray9[522] = 100;
        byArray9[523] = 91;
        byArray9[524] = 113;
        byArray9[525] = -23;
        byArray9[526] = 71;
        byArray9[527] = -40;
        byArray9[528] = 12;
        byArray9[529] = 81;
        byArray9[530] = -74;
        byArray9[531] = -22;
        byArray9[532] = 114;
        byArray9[533] = -111;
        byArray9[534] = -80;
        byArray9[535] = -124;
        byArray9[536] = 94;
        byArray9[537] = 125;
        byArray9[538] = 45;
        byArray9[539] = 13;
        byArray9[540] = -113;
        byArray9[541] = 123;
        byArray9[542] = 18;
        byArray9[543] = -33;
        byArray9[544] = -123;
        byArray9[545] = 37;
        byArray9[546] = 117;
        byArray9[547] = 40;
        byArray9[548] = 116;
        byArray9[549] = 58;
        byArray9[550] = 66;
        byArray9[551] = 44;
        byArray9[552] = 99;
        byArray9[553] = 39;
        byArray9[554] = -97;
        byArray9[555] = -107;
        byArray9[556] = 123;
        byArray9[557] = 75;
        byArray9[558] = -17;
        byArray9[559] = 126;
        byArray9[560] = 25;
        byArray9[561] = -121;
        byArray9[562] = 29;
        byArray9[563] = -122;
        byArray9[564] = -22;
        byArray9[565] = -93;
        byArray9[566] = -35;
        byArray9[567] = -71;
        byArray9[568] = -50;
        byArray9[569] = -106;
        byArray9[570] = 100;
        byArray9[571] = 26;
        byArray9[572] = -62;
        byArray9[573] = 20;
        byArray9[574] = 110;
        byArray9[575] = 68;
        byArray9[576] = -84;
        byArray9[577] = 124;
        byArray9[578] = -26;
        byArray9[579] = -113;
        byArray9[580] = -24;
        byArray9[581] = 77;
        byArray9[582] = 15;
        byArray9[583] = 113;
        byArray9[584] = 31;
        byArray9[585] = 64;
        byArray9[586] = 56;
        byArray9[587] = -90;
        byArray9[589] = -93;
        byArray9[590] = -121;
        byArray9[591] = 120;
        byArray9[592] = -10;
        byArray9[593] = -7;
        byArray9[594] = -108;
        byArray9[595] = -122;
        byArray9[596] = 94;
        byArray9[597] = -83;
        byArray9[598] = -22;
        byArray9[599] = -64;
        byArray9[600] = 94;
        byArray9[601] = 118;
        byArray9[602] = -21;
        byArray9[603] = -39;
        byArray9[604] = 20;
        byArray9[605] = -93;
        byArray9[606] = 93;
        byArray9[607] = 110;
        byArray9[608] = 122;
        byArray9[609] = 124;
        byArray9[610] = 12;
        byArray9[611] = -91;
        byArray9[612] = 75;
        byArray9[613] = 85;
        byArray9[614] = 127;
        byArray9[615] = 6;
        byArray9[616] = 25;
        byArray9[617] = 41;
        byArray9[618] = 127;
        byArray9[619] = -98;
        byArray9[620] = -102;
        byArray9[621] = 38;
        byArray9[622] = -43;
        byArray9[623] = 106;
        byArray9[624] = -69;
        byArray9[625] = 56;
        byArray9[626] = 36;
        byArray9[627] = 8;
        byArray9[628] = 106;
        byArray9[629] = -104;
        byArray9[630] = -57;
        byArray9[631] = -79;
        byArray9[632] = -38;
        byArray9[633] = -93;
        byArray9[634] = -104;
        byArray9[635] = -111;
        byArray9[636] = -3;
        byArray9[637] = 121;
        byArray9[638] = -37;
        byArray9[639] = -27;
        byArray9[640] = 90;
        byArray9[641] = -60;
        byArray9[642] = 28;
        byArray9[643] = -71;
        byArray9[644] = 2;
        byArray9[645] = 3;
        byArray9[646] = 1;
        byArray9[648] = 1;
        byArray9[649] = -93;
        byArray9[650] = 19;
        byArray9[651] = 48;
        byArray9[652] = 17;
        byArray9[653] = 48;
        byArray9[654] = 15;
        byArray9[655] = 6;
        byArray9[656] = 3;
        byArray9[657] = 85;
        byArray9[658] = 29;
        byArray9[659] = 19;
        byArray9[660] = 1;
        byArray9[661] = 1;
        byArray9[662] = -1;
        byArray9[663] = 4;
        byArray9[664] = 5;
        byArray9[665] = 48;
        byArray9[666] = 3;
        byArray9[667] = 1;
        byArray9[668] = 1;
        byArray9[669] = -1;
        byArray9[670] = 48;
        byArray9[671] = 13;
        byArray9[672] = 6;
        byArray9[673] = 9;
        byArray9[674] = 42;
        byArray9[675] = -122;
        byArray9[676] = 72;
        byArray9[677] = -122;
        byArray9[678] = -9;
        byArray9[679] = 13;
        byArray9[680] = 1;
        byArray9[681] = 1;
        byArray9[682] = 4;
        byArray9[683] = 5;
        byArray9[685] = 3;
        byArray9[686] = -127;
        byArray9[687] = -127;
        byArray9[689] = -57;
        byArray9[690] = -20;
        byArray9[691] = -110;
        byArray9[692] = 126;
        byArray9[693] = 78;
        byArray9[694] = -8;
        byArray9[695] = -11;
        byArray9[696] = -106;
        byArray9[697] = -91;
        byArray9[698] = 103;
        byArray9[699] = 98;
        byArray9[700] = 42;
        byArray9[701] = -92;
        byArray9[702] = -16;
        byArray9[703] = 77;
        byArray9[704] = 17;
        byArray9[705] = 96;
        byArray9[706] = -48;
        byArray9[707] = 111;
        byArray9[708] = -115;
        byArray9[709] = 96;
        byArray9[710] = 88;
        byArray9[711] = 97;
        byArray9[712] = -84;
        byArray9[713] = 38;
        byArray9[714] = -69;
        byArray9[715] = 82;
        byArray9[716] = 53;
        byArray9[717] = 92;
        byArray9[718] = 8;
        byArray9[719] = -49;
        byArray9[720] = 48;
        byArray9[721] = -5;
        byArray9[722] = -88;
        byArray9[723] = 74;
        byArray9[724] = -106;
        byArray9[725] = -118;
        byArray9[726] = 31;
        byArray9[727] = 98;
        byArray9[728] = 66;
        byArray9[729] = 35;
        byArray9[730] = -116;
        byArray9[731] = 23;
        byArray9[732] = 15;
        byArray9[733] = -12;
        byArray9[734] = -70;
        byArray9[735] = 100;
        byArray9[736] = -100;
        byArray9[737] = 23;
        byArray9[738] = -84;
        byArray9[739] = 71;
        byArray9[740] = 41;
        byArray9[741] = -33;
        byArray9[742] = -99;
        byArray9[743] = -104;
        byArray9[744] = 94;
        byArray9[745] = -46;
        byArray9[746] = 108;
        byArray9[747] = 96;
        byArray9[748] = 113;
        byArray9[749] = 92;
        byArray9[750] = -94;
        byArray9[751] = -84;
        byArray9[752] = -36;
        byArray9[753] = 121;
        byArray9[754] = -29;
        byArray9[755] = -25;
        byArray9[756] = 110;
        byArray9[758] = 71;
        byArray9[759] = 31;
        byArray9[760] = -75;
        byArray9[761] = 13;
        byArray9[762] = 40;
        byArray9[763] = -24;
        byArray9[764] = 2;
        byArray9[765] = -99;
        byArray9[766] = -28;
        byArray9[767] = -102;
        byArray9[768] = -3;
        byArray9[769] = 19;
        byArray9[770] = -12;
        byArray9[771] = -90;
        byArray9[772] = -39;
        byArray9[773] = 124;
        byArray9[774] = -79;
        byArray9[775] = -8;
        byArray9[776] = -36;
        byArray9[777] = 95;
        byArray9[778] = 35;
        byArray9[779] = 38;
        byArray9[780] = 9;
        byArray9[781] = -111;
        byArray9[782] = -128;
        byArray9[783] = 115;
        byArray9[784] = -48;
        byArray9[785] = 20;
        byArray9[786] = 27;
        byArray9[787] = -34;
        byArray9[788] = 67;
        byArray9[789] = -87;
        byArray9[790] = -125;
        byArray9[791] = 37;
        byArray9[792] = -14;
        byArray9[793] = -26;
        byArray9[794] = -100;
        byArray9[795] = 47;
        byArray9[796] = 21;
        byArray9[797] = -54;
        byArray9[798] = -2;
        byArray9[799] = -90;
        byArray9[800] = -85;
        byArray9[801] = -118;
        byArray9[802] = 7;
        byArray9[803] = 117;
        byArray9[804] = -117;
        byArray9[805] = 12;
        byArray9[806] = -35;
        byArray9[807] = 81;
        byArray9[808] = -124;
        byArray9[809] = 107;
        byArray9[810] = -28;
        byArray9[811] = -8;
        byArray9[812] = -47;
        byArray9[813] = -50;
        byArray9[814] = 119;
        byArray9[815] = -94;
        byArray9[816] = -127;
        THAWTE_PFREE_ROOT_SELF_SIGNED_CERT = byArray9;
        byte[] byArray10 = new byte[813];
        byArray10[0] = 48;
        byArray10[1] = -126;
        byArray10[2] = 3;
        byArray10[3] = 41;
        byArray10[4] = 48;
        byArray10[5] = -126;
        byArray10[6] = 2;
        byArray10[7] = -110;
        byArray10[8] = -96;
        byArray10[9] = 3;
        byArray10[10] = 2;
        byArray10[11] = 1;
        byArray10[12] = 2;
        byArray10[13] = 2;
        byArray10[14] = 1;
        byArray10[16] = 48;
        byArray10[17] = 13;
        byArray10[18] = 6;
        byArray10[19] = 9;
        byArray10[20] = 42;
        byArray10[21] = -122;
        byArray10[22] = 72;
        byArray10[23] = -122;
        byArray10[24] = -9;
        byArray10[25] = 13;
        byArray10[26] = 1;
        byArray10[27] = 1;
        byArray10[28] = 4;
        byArray10[29] = 5;
        byArray10[31] = 48;
        byArray10[32] = -127;
        byArray10[33] = -49;
        byArray10[34] = 49;
        byArray10[35] = 11;
        byArray10[36] = 48;
        byArray10[37] = 9;
        byArray10[38] = 6;
        byArray10[39] = 3;
        byArray10[40] = 85;
        byArray10[41] = 4;
        byArray10[42] = 6;
        byArray10[43] = 19;
        byArray10[44] = 2;
        byArray10[45] = 90;
        byArray10[46] = 65;
        byArray10[47] = 49;
        byArray10[48] = 21;
        byArray10[49] = 48;
        byArray10[50] = 19;
        byArray10[51] = 6;
        byArray10[52] = 3;
        byArray10[53] = 85;
        byArray10[54] = 4;
        byArray10[55] = 8;
        byArray10[56] = 19;
        byArray10[57] = 12;
        byArray10[58] = 87;
        byArray10[59] = 101;
        byArray10[60] = 115;
        byArray10[61] = 116;
        byArray10[62] = 101;
        byArray10[63] = 114;
        byArray10[64] = 110;
        byArray10[65] = 32;
        byArray10[66] = 67;
        byArray10[67] = 97;
        byArray10[68] = 112;
        byArray10[69] = 101;
        byArray10[70] = 49;
        byArray10[71] = 18;
        byArray10[72] = 48;
        byArray10[73] = 16;
        byArray10[74] = 6;
        byArray10[75] = 3;
        byArray10[76] = 85;
        byArray10[77] = 4;
        byArray10[78] = 7;
        byArray10[79] = 19;
        byArray10[80] = 9;
        byArray10[81] = 67;
        byArray10[82] = 97;
        byArray10[83] = 112;
        byArray10[84] = 101;
        byArray10[85] = 32;
        byArray10[86] = 84;
        byArray10[87] = 111;
        byArray10[88] = 119;
        byArray10[89] = 110;
        byArray10[90] = 49;
        byArray10[91] = 26;
        byArray10[92] = 48;
        byArray10[93] = 24;
        byArray10[94] = 6;
        byArray10[95] = 3;
        byArray10[96] = 85;
        byArray10[97] = 4;
        byArray10[98] = 10;
        byArray10[99] = 19;
        byArray10[100] = 17;
        byArray10[101] = 84;
        byArray10[102] = 104;
        byArray10[103] = 97;
        byArray10[104] = 119;
        byArray10[105] = 116;
        byArray10[106] = 101;
        byArray10[107] = 32;
        byArray10[108] = 67;
        byArray10[109] = 111;
        byArray10[110] = 110;
        byArray10[111] = 115;
        byArray10[112] = 117;
        byArray10[113] = 108;
        byArray10[114] = 116;
        byArray10[115] = 105;
        byArray10[116] = 110;
        byArray10[117] = 103;
        byArray10[118] = 49;
        byArray10[119] = 40;
        byArray10[120] = 48;
        byArray10[121] = 38;
        byArray10[122] = 6;
        byArray10[123] = 3;
        byArray10[124] = 85;
        byArray10[125] = 4;
        byArray10[126] = 11;
        byArray10[127] = 19;
        byArray10[128] = 31;
        byArray10[129] = 67;
        byArray10[130] = 101;
        byArray10[131] = 114;
        byArray10[132] = 116;
        byArray10[133] = 105;
        byArray10[134] = 102;
        byArray10[135] = 105;
        byArray10[136] = 99;
        byArray10[137] = 97;
        byArray10[138] = 116;
        byArray10[139] = 105;
        byArray10[140] = 111;
        byArray10[141] = 110;
        byArray10[142] = 32;
        byArray10[143] = 83;
        byArray10[144] = 101;
        byArray10[145] = 114;
        byArray10[146] = 118;
        byArray10[147] = 105;
        byArray10[148] = 99;
        byArray10[149] = 101;
        byArray10[150] = 115;
        byArray10[151] = 32;
        byArray10[152] = 68;
        byArray10[153] = 105;
        byArray10[154] = 118;
        byArray10[155] = 105;
        byArray10[156] = 115;
        byArray10[157] = 105;
        byArray10[158] = 111;
        byArray10[159] = 110;
        byArray10[160] = 49;
        byArray10[161] = 35;
        byArray10[162] = 48;
        byArray10[163] = 33;
        byArray10[164] = 6;
        byArray10[165] = 3;
        byArray10[166] = 85;
        byArray10[167] = 4;
        byArray10[168] = 3;
        byArray10[169] = 19;
        byArray10[170] = 26;
        byArray10[171] = 84;
        byArray10[172] = 104;
        byArray10[173] = 97;
        byArray10[174] = 119;
        byArray10[175] = 116;
        byArray10[176] = 101;
        byArray10[177] = 32;
        byArray10[178] = 80;
        byArray10[179] = 101;
        byArray10[180] = 114;
        byArray10[181] = 115;
        byArray10[182] = 111;
        byArray10[183] = 110;
        byArray10[184] = 97;
        byArray10[185] = 108;
        byArray10[186] = 32;
        byArray10[187] = 80;
        byArray10[188] = 114;
        byArray10[189] = 101;
        byArray10[190] = 109;
        byArray10[191] = 105;
        byArray10[192] = 117;
        byArray10[193] = 109;
        byArray10[194] = 32;
        byArray10[195] = 67;
        byArray10[196] = 65;
        byArray10[197] = 49;
        byArray10[198] = 42;
        byArray10[199] = 48;
        byArray10[200] = 40;
        byArray10[201] = 6;
        byArray10[202] = 9;
        byArray10[203] = 42;
        byArray10[204] = -122;
        byArray10[205] = 72;
        byArray10[206] = -122;
        byArray10[207] = -9;
        byArray10[208] = 13;
        byArray10[209] = 1;
        byArray10[210] = 9;
        byArray10[211] = 1;
        byArray10[212] = 22;
        byArray10[213] = 27;
        byArray10[214] = 112;
        byArray10[215] = 101;
        byArray10[216] = 114;
        byArray10[217] = 115;
        byArray10[218] = 111;
        byArray10[219] = 110;
        byArray10[220] = 97;
        byArray10[221] = 108;
        byArray10[222] = 45;
        byArray10[223] = 112;
        byArray10[224] = 114;
        byArray10[225] = 101;
        byArray10[226] = 109;
        byArray10[227] = 105;
        byArray10[228] = 117;
        byArray10[229] = 109;
        byArray10[230] = 64;
        byArray10[231] = 116;
        byArray10[232] = 104;
        byArray10[233] = 97;
        byArray10[234] = 119;
        byArray10[235] = 116;
        byArray10[236] = 101;
        byArray10[237] = 46;
        byArray10[238] = 99;
        byArray10[239] = 111;
        byArray10[240] = 109;
        byArray10[241] = 48;
        byArray10[242] = 30;
        byArray10[243] = 23;
        byArray10[244] = 13;
        byArray10[245] = 57;
        byArray10[246] = 54;
        byArray10[247] = 48;
        byArray10[248] = 49;
        byArray10[249] = 48;
        byArray10[250] = 49;
        byArray10[251] = 48;
        byArray10[252] = 48;
        byArray10[253] = 48;
        byArray10[254] = 48;
        byArray10[255] = 48;
        byArray10[256] = 48;
        byArray10[257] = 90;
        byArray10[258] = 23;
        byArray10[259] = 13;
        byArray10[260] = 50;
        byArray10[261] = 48;
        byArray10[262] = 49;
        byArray10[263] = 50;
        byArray10[264] = 51;
        byArray10[265] = 49;
        byArray10[266] = 50;
        byArray10[267] = 51;
        byArray10[268] = 53;
        byArray10[269] = 57;
        byArray10[270] = 53;
        byArray10[271] = 57;
        byArray10[272] = 90;
        byArray10[273] = 48;
        byArray10[274] = -127;
        byArray10[275] = -49;
        byArray10[276] = 49;
        byArray10[277] = 11;
        byArray10[278] = 48;
        byArray10[279] = 9;
        byArray10[280] = 6;
        byArray10[281] = 3;
        byArray10[282] = 85;
        byArray10[283] = 4;
        byArray10[284] = 6;
        byArray10[285] = 19;
        byArray10[286] = 2;
        byArray10[287] = 90;
        byArray10[288] = 65;
        byArray10[289] = 49;
        byArray10[290] = 21;
        byArray10[291] = 48;
        byArray10[292] = 19;
        byArray10[293] = 6;
        byArray10[294] = 3;
        byArray10[295] = 85;
        byArray10[296] = 4;
        byArray10[297] = 8;
        byArray10[298] = 19;
        byArray10[299] = 12;
        byArray10[300] = 87;
        byArray10[301] = 101;
        byArray10[302] = 115;
        byArray10[303] = 116;
        byArray10[304] = 101;
        byArray10[305] = 114;
        byArray10[306] = 110;
        byArray10[307] = 32;
        byArray10[308] = 67;
        byArray10[309] = 97;
        byArray10[310] = 112;
        byArray10[311] = 101;
        byArray10[312] = 49;
        byArray10[313] = 18;
        byArray10[314] = 48;
        byArray10[315] = 16;
        byArray10[316] = 6;
        byArray10[317] = 3;
        byArray10[318] = 85;
        byArray10[319] = 4;
        byArray10[320] = 7;
        byArray10[321] = 19;
        byArray10[322] = 9;
        byArray10[323] = 67;
        byArray10[324] = 97;
        byArray10[325] = 112;
        byArray10[326] = 101;
        byArray10[327] = 32;
        byArray10[328] = 84;
        byArray10[329] = 111;
        byArray10[330] = 119;
        byArray10[331] = 110;
        byArray10[332] = 49;
        byArray10[333] = 26;
        byArray10[334] = 48;
        byArray10[335] = 24;
        byArray10[336] = 6;
        byArray10[337] = 3;
        byArray10[338] = 85;
        byArray10[339] = 4;
        byArray10[340] = 10;
        byArray10[341] = 19;
        byArray10[342] = 17;
        byArray10[343] = 84;
        byArray10[344] = 104;
        byArray10[345] = 97;
        byArray10[346] = 119;
        byArray10[347] = 116;
        byArray10[348] = 101;
        byArray10[349] = 32;
        byArray10[350] = 67;
        byArray10[351] = 111;
        byArray10[352] = 110;
        byArray10[353] = 115;
        byArray10[354] = 117;
        byArray10[355] = 108;
        byArray10[356] = 116;
        byArray10[357] = 105;
        byArray10[358] = 110;
        byArray10[359] = 103;
        byArray10[360] = 49;
        byArray10[361] = 40;
        byArray10[362] = 48;
        byArray10[363] = 38;
        byArray10[364] = 6;
        byArray10[365] = 3;
        byArray10[366] = 85;
        byArray10[367] = 4;
        byArray10[368] = 11;
        byArray10[369] = 19;
        byArray10[370] = 31;
        byArray10[371] = 67;
        byArray10[372] = 101;
        byArray10[373] = 114;
        byArray10[374] = 116;
        byArray10[375] = 105;
        byArray10[376] = 102;
        byArray10[377] = 105;
        byArray10[378] = 99;
        byArray10[379] = 97;
        byArray10[380] = 116;
        byArray10[381] = 105;
        byArray10[382] = 111;
        byArray10[383] = 110;
        byArray10[384] = 32;
        byArray10[385] = 83;
        byArray10[386] = 101;
        byArray10[387] = 114;
        byArray10[388] = 118;
        byArray10[389] = 105;
        byArray10[390] = 99;
        byArray10[391] = 101;
        byArray10[392] = 115;
        byArray10[393] = 32;
        byArray10[394] = 68;
        byArray10[395] = 105;
        byArray10[396] = 118;
        byArray10[397] = 105;
        byArray10[398] = 115;
        byArray10[399] = 105;
        byArray10[400] = 111;
        byArray10[401] = 110;
        byArray10[402] = 49;
        byArray10[403] = 35;
        byArray10[404] = 48;
        byArray10[405] = 33;
        byArray10[406] = 6;
        byArray10[407] = 3;
        byArray10[408] = 85;
        byArray10[409] = 4;
        byArray10[410] = 3;
        byArray10[411] = 19;
        byArray10[412] = 26;
        byArray10[413] = 84;
        byArray10[414] = 104;
        byArray10[415] = 97;
        byArray10[416] = 119;
        byArray10[417] = 116;
        byArray10[418] = 101;
        byArray10[419] = 32;
        byArray10[420] = 80;
        byArray10[421] = 101;
        byArray10[422] = 114;
        byArray10[423] = 115;
        byArray10[424] = 111;
        byArray10[425] = 110;
        byArray10[426] = 97;
        byArray10[427] = 108;
        byArray10[428] = 32;
        byArray10[429] = 80;
        byArray10[430] = 114;
        byArray10[431] = 101;
        byArray10[432] = 109;
        byArray10[433] = 105;
        byArray10[434] = 117;
        byArray10[435] = 109;
        byArray10[436] = 32;
        byArray10[437] = 67;
        byArray10[438] = 65;
        byArray10[439] = 49;
        byArray10[440] = 42;
        byArray10[441] = 48;
        byArray10[442] = 40;
        byArray10[443] = 6;
        byArray10[444] = 9;
        byArray10[445] = 42;
        byArray10[446] = -122;
        byArray10[447] = 72;
        byArray10[448] = -122;
        byArray10[449] = -9;
        byArray10[450] = 13;
        byArray10[451] = 1;
        byArray10[452] = 9;
        byArray10[453] = 1;
        byArray10[454] = 22;
        byArray10[455] = 27;
        byArray10[456] = 112;
        byArray10[457] = 101;
        byArray10[458] = 114;
        byArray10[459] = 115;
        byArray10[460] = 111;
        byArray10[461] = 110;
        byArray10[462] = 97;
        byArray10[463] = 108;
        byArray10[464] = 45;
        byArray10[465] = 112;
        byArray10[466] = 114;
        byArray10[467] = 101;
        byArray10[468] = 109;
        byArray10[469] = 105;
        byArray10[470] = 117;
        byArray10[471] = 109;
        byArray10[472] = 64;
        byArray10[473] = 116;
        byArray10[474] = 104;
        byArray10[475] = 97;
        byArray10[476] = 119;
        byArray10[477] = 116;
        byArray10[478] = 101;
        byArray10[479] = 46;
        byArray10[480] = 99;
        byArray10[481] = 111;
        byArray10[482] = 109;
        byArray10[483] = 48;
        byArray10[484] = -127;
        byArray10[485] = -97;
        byArray10[486] = 48;
        byArray10[487] = 13;
        byArray10[488] = 6;
        byArray10[489] = 9;
        byArray10[490] = 42;
        byArray10[491] = -122;
        byArray10[492] = 72;
        byArray10[493] = -122;
        byArray10[494] = -9;
        byArray10[495] = 13;
        byArray10[496] = 1;
        byArray10[497] = 1;
        byArray10[498] = 1;
        byArray10[499] = 5;
        byArray10[501] = 3;
        byArray10[502] = -127;
        byArray10[503] = -115;
        byArray10[505] = 48;
        byArray10[506] = -127;
        byArray10[507] = -119;
        byArray10[508] = 2;
        byArray10[509] = -127;
        byArray10[510] = -127;
        byArray10[512] = -55;
        byArray10[513] = 102;
        byArray10[514] = -39;
        byArray10[515] = -8;
        byArray10[516] = 7;
        byArray10[517] = 68;
        byArray10[518] = -49;
        byArray10[519] = -71;
        byArray10[520] = -116;
        byArray10[521] = 46;
        byArray10[522] = -16;
        byArray10[523] = -95;
        byArray10[524] = -17;
        byArray10[525] = 19;
        byArray10[526] = 69;
        byArray10[527] = 108;
        byArray10[528] = 5;
        byArray10[529] = -33;
        byArray10[530] = -34;
        byArray10[531] = 39;
        byArray10[532] = 22;
        byArray10[533] = 81;
        byArray10[534] = 54;
        byArray10[535] = 65;
        byArray10[536] = 17;
        byArray10[537] = 108;
        byArray10[538] = 108;
        byArray10[539] = 59;
        byArray10[540] = -19;
        byArray10[541] = -2;
        byArray10[542] = 16;
        byArray10[543] = 125;
        byArray10[544] = 18;
        byArray10[545] = -98;
        byArray10[546] = -27;
        byArray10[547] = -101;
        byArray10[548] = 66;
        byArray10[549] = -102;
        byArray10[550] = -2;
        byArray10[551] = 96;
        byArray10[552] = 49;
        byArray10[553] = -61;
        byArray10[554] = 102;
        byArray10[555] = -73;
        byArray10[556] = 115;
        byArray10[557] = 58;
        byArray10[558] = 72;
        byArray10[559] = -82;
        byArray10[560] = 78;
        byArray10[561] = -48;
        byArray10[562] = 50;
        byArray10[563] = 55;
        byArray10[564] = -108;
        byArray10[565] = -120;
        byArray10[566] = -75;
        byArray10[567] = 13;
        byArray10[568] = -74;
        byArray10[569] = -39;
        byArray10[570] = -13;
        byArray10[571] = -14;
        byArray10[572] = 68;
        byArray10[573] = -39;
        byArray10[574] = -43;
        byArray10[575] = -120;
        byArray10[576] = 18;
        byArray10[577] = -35;
        byArray10[578] = 118;
        byArray10[579] = 77;
        byArray10[580] = -14;
        byArray10[581] = 26;
        byArray10[582] = -4;
        byArray10[583] = 111;
        byArray10[584] = 35;
        byArray10[585] = 30;
        byArray10[586] = 122;
        byArray10[587] = -15;
        byArray10[588] = -40;
        byArray10[589] = -104;
        byArray10[590] = 69;
        byArray10[591] = 78;
        byArray10[592] = 7;
        byArray10[593] = 16;
        byArray10[594] = -17;
        byArray10[595] = 22;
        byArray10[596] = 66;
        byArray10[597] = -48;
        byArray10[598] = 67;
        byArray10[599] = 117;
        byArray10[600] = 109;
        byArray10[601] = 74;
        byArray10[602] = -34;
        byArray10[603] = -30;
        byArray10[604] = -86;
        byArray10[605] = -55;
        byArray10[606] = 49;
        byArray10[607] = -1;
        byArray10[608] = 31;
        byArray10[610] = 112;
        byArray10[611] = 124;
        byArray10[612] = 102;
        byArray10[613] = -49;
        byArray10[614] = 16;
        byArray10[615] = 37;
        byArray10[616] = 8;
        byArray10[617] = -70;
        byArray10[618] = -6;
        byArray10[619] = -18;
        byArray10[621] = -23;
        byArray10[622] = 70;
        byArray10[623] = 3;
        byArray10[624] = 102;
        byArray10[625] = 39;
        byArray10[626] = 17;
        byArray10[627] = 21;
        byArray10[628] = 59;
        byArray10[629] = -86;
        byArray10[630] = 91;
        byArray10[631] = -14;
        byArray10[632] = -104;
        byArray10[633] = -35;
        byArray10[634] = 54;
        byArray10[635] = 66;
        byArray10[636] = -78;
        byArray10[637] = -38;
        byArray10[638] = -120;
        byArray10[639] = 117;
        byArray10[640] = 2;
        byArray10[641] = 3;
        byArray10[642] = 1;
        byArray10[644] = 1;
        byArray10[645] = -93;
        byArray10[646] = 19;
        byArray10[647] = 48;
        byArray10[648] = 17;
        byArray10[649] = 48;
        byArray10[650] = 15;
        byArray10[651] = 6;
        byArray10[652] = 3;
        byArray10[653] = 85;
        byArray10[654] = 29;
        byArray10[655] = 19;
        byArray10[656] = 1;
        byArray10[657] = 1;
        byArray10[658] = -1;
        byArray10[659] = 4;
        byArray10[660] = 5;
        byArray10[661] = 48;
        byArray10[662] = 3;
        byArray10[663] = 1;
        byArray10[664] = 1;
        byArray10[665] = -1;
        byArray10[666] = 48;
        byArray10[667] = 13;
        byArray10[668] = 6;
        byArray10[669] = 9;
        byArray10[670] = 42;
        byArray10[671] = -122;
        byArray10[672] = 72;
        byArray10[673] = -122;
        byArray10[674] = -9;
        byArray10[675] = 13;
        byArray10[676] = 1;
        byArray10[677] = 1;
        byArray10[678] = 4;
        byArray10[679] = 5;
        byArray10[681] = 3;
        byArray10[682] = -127;
        byArray10[683] = -127;
        byArray10[685] = 105;
        byArray10[686] = 54;
        byArray10[687] = -119;
        byArray10[688] = -9;
        byArray10[689] = 52;
        byArray10[690] = 42;
        byArray10[691] = 51;
        byArray10[692] = 114;
        byArray10[693] = 47;
        byArray10[694] = 109;
        byArray10[695] = 59;
        byArray10[696] = -44;
        byArray10[697] = 34;
        byArray10[698] = -78;
        byArray10[699] = -72;
        byArray10[700] = 111;
        byArray10[701] = -102;
        byArray10[702] = -59;
        byArray10[703] = 54;
        byArray10[704] = 102;
        byArray10[705] = 14;
        byArray10[706] = 27;
        byArray10[707] = 60;
        byArray10[708] = -95;
        byArray10[709] = -79;
        byArray10[710] = 117;
        byArray10[711] = 90;
        byArray10[712] = -26;
        byArray10[713] = -3;
        byArray10[714] = 53;
        byArray10[715] = -45;
        byArray10[716] = -8;
        byArray10[717] = -88;
        byArray10[718] = -14;
        byArray10[719] = 7;
        byArray10[720] = 111;
        byArray10[721] = -123;
        byArray10[722] = 103;
        byArray10[723] = -114;
        byArray10[724] = -34;
        byArray10[725] = 43;
        byArray10[726] = -71;
        byArray10[727] = -30;
        byArray10[728] = 23;
        byArray10[729] = -80;
        byArray10[730] = 58;
        byArray10[731] = -96;
        byArray10[732] = -16;
        byArray10[733] = 14;
        byArray10[734] = -94;
        byArray10[736] = -102;
        byArray10[737] = -33;
        byArray10[738] = -13;
        byArray10[739] = 20;
        byArray10[740] = 21;
        byArray10[741] = 110;
        byArray10[742] = -69;
        byArray10[743] = -56;
        byArray10[744] = -123;
        byArray10[745] = 90;
        byArray10[746] = -104;
        byArray10[747] = -128;
        byArray10[748] = -7;
        byArray10[749] = -1;
        byArray10[750] = -66;
        byArray10[751] = 116;
        byArray10[752] = 29;
        byArray10[753] = 61;
        byArray10[754] = -13;
        byArray10[755] = -2;
        byArray10[756] = 48;
        byArray10[757] = 37;
        byArray10[758] = -47;
        byArray10[759] = 55;
        byArray10[760] = 52;
        byArray10[761] = 103;
        byArray10[762] = -6;
        byArray10[763] = -91;
        byArray10[764] = 113;
        byArray10[765] = 121;
        byArray10[766] = 48;
        byArray10[767] = 97;
        byArray10[768] = 41;
        byArray10[769] = 114;
        byArray10[770] = -64;
        byArray10[771] = -32;
        byArray10[772] = 44;
        byArray10[773] = 76;
        byArray10[774] = -5;
        byArray10[775] = 86;
        byArray10[776] = -28;
        byArray10[777] = 58;
        byArray10[778] = -88;
        byArray10[779] = 111;
        byArray10[780] = -27;
        byArray10[781] = 50;
        byArray10[782] = 89;
        byArray10[783] = 82;
        byArray10[784] = -37;
        byArray10[785] = 117;
        byArray10[786] = 40;
        byArray10[787] = 80;
        byArray10[788] = 89;
        byArray10[789] = 12;
        byArray10[790] = -8;
        byArray10[791] = 11;
        byArray10[792] = 25;
        byArray10[793] = -28;
        byArray10[794] = -84;
        byArray10[795] = -39;
        byArray10[796] = -81;
        byArray10[797] = -106;
        byArray10[798] = -115;
        byArray10[799] = 47;
        byArray10[800] = 80;
        byArray10[801] = -37;
        byArray10[802] = 7;
        byArray10[803] = -61;
        byArray10[804] = -22;
        byArray10[805] = 31;
        byArray10[806] = -85;
        byArray10[807] = 51;
        byArray10[808] = -32;
        byArray10[809] = -11;
        byArray10[810] = 43;
        byArray10[811] = 49;
        byArray10[812] = -119;
        THAWTE_PPR_ROOT_SELF_SIGNED_CERT = byArray10;
    }

    public static class LocalClassLoader
    extends ClassLoader {
        String fullPathFileName;

        public LocalClassLoader(String string) {
            this.fullPathFileName = string;
        }

        public Class loadClass(String string) throws ClassNotFoundException {
            return this.loadClass(string, true);
        }

        public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            try {
                Class<?> clazz = this.findLoadedClass(string);
                if (clazz == null) {
                    try {
                        clazz = this.findSystemClass(string);
                    }
                    catch (Exception exception) {}
                }
                if (clazz == null) {
                    File file = new File(this.fullPathFileName);
                    int n = (int)file.length();
                    byte[] byArray = new byte[n];
                    DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
                    dataInputStream.readFully(byArray);
                    dataInputStream.close();
                    clazz = this.defineClass(string, byArray, 0, n);
                }
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassNotFoundException(classFormatError.toString());
            }
            catch (Exception exception) {
                throw new ClassNotFoundException(exception.toString());
            }
        }
    }
}

