/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.basic.BERObject;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabase;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.EncryptedPrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperator;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.PrivateKeyInfoItem;
import java.io.File;
import java.util.Vector;

public class WEBDBKeyDatabase
extends KeyDatabase
implements KeyDatabaseOperator {
    CMSKeyDatabase cmsKeyDbCopy;

    public WEBDBKeyDatabase() {
        this.type = 2;
        this.op = this;
        this.cmsKeyDbCopy = this.getTmpCMSKeyDatabaseCopy();
    }

    public WEBDBKeyDatabase(KeyDatabase keyDatabase) {
        super(keyDatabase);
        this.type = 2;
        this.op = this;
        this.cmsKeyDbCopy = this.getTmpCMSKeyDatabaseCopy();
    }

    public WEBDBKeyDatabase(String string, String string2) {
        super(2, string, string2);
        this.op = this;
        this.cmsKeyDbCopy = this.getTmpCMSKeyDatabaseCopy();
    }

    public WEBDBKeyDatabase(String string, String string2, long l) {
        super(2, string, string2, l);
        this.op = this;
        this.cmsKeyDbCopy = this.getTmpCMSKeyDatabaseCopy();
    }

    private CMSKeyDatabase getTmpCMSKeyDatabaseCopy() {
        String string = KMUtil.getTmpFileName(this.keyDbFileName, "_tmp" + KeyDatabase.DEFAULT_KEYDB_NAME_EXT_CMS, ".rdb");
        if (string == null) {
            string = this.getKeyDbFileNameWithType(1);
        }
        return new CMSKeyDatabase(string, this.keyDbPwd, this.keyDbPwdExpireTime);
    }

    public CMSKeyDatabase getCMSKeyDatabaseCopy() {
        return this.cmsKeyDbCopy;
    }

    public void create() throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.create();
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void open() throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.makeCopyFromKyr(this);
        this.cmsKeyDbCopy.open();
        this.copyKeyLabelLists(this.cmsKeyDbCopy);
    }

    public void close() {
        String string;
        File file;
        String string2;
        File file2;
        File file3 = new File(this.cmsKeyDbCopy.getKeyDbFileName());
        if (file3.exists()) {
            file3.delete();
        }
        if ((file2 = new File(string2 = KMUtil.changeFileNameExtension(this.cmsKeyDbCopy.getKeyDbFileName(), KeyDatabase.DEFAULT_KEYDB_NAME_EXT_CMS, ".rdb"))).exists()) {
            file2.delete();
        }
        if ((file = new File(string = KMUtil.changeFileNameExtension(this.cmsKeyDbCopy.getKeyDbFileName(), KeyDatabase.DEFAULT_KEYDB_NAME_EXT_CMS, ".crl"))).exists()) {
            file.delete();
        }
    }

    public void save() {
    }

    public void makeCopyFromKdb(CMSKeyDatabase cMSKeyDatabase) throws CMSKeyDatabaseException {
        String string = KMUtil.getTmpFileName(this.keyDbFileName, "_tmp");
        int n = CMSKeyDatabase.c_Kdb2Kyr(cMSKeyDatabase.getKeyDbFileName(), cMSKeyDatabase.getKeyDbPwd(), string, this.keyDbPwd);
        File file = new File(string);
        File file2 = new File(this.keyDbFileName);
        if (n != 0) {
            if (file.exists()) {
                file.delete();
            }
            throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KDB2KYR"));
        }
        file2.delete();
        file.renameTo(file2);
        this.buildKeyLabelList();
    }

    public void reCreate(KeyDatabase keyDatabase) throws CMSKeyDatabaseException {
        if (this.keyDbFileName == null || this.keyDbFileName.equals(keyDatabase.getKeyDbFileName())) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
        }
        KeyDatabaseOperator cfr_ignored_0 = (KeyDatabaseOperator)((Object)keyDatabase);
        try {
            if (this.type != keyDatabase.getType()) {
                if (keyDatabase.getType() == 3) {
                    this.cmsKeyDbCopy.reCreate(keyDatabase);
                    this.reCreate(this.cmsKeyDbCopy);
                } else if (keyDatabase.getType() == 1) {
                    int n = CMSKeyDatabase.c_Kdb2Kyr(keyDatabase.getKeyDbFileName(), keyDatabase.getKeyDbPwd(), this.keyDbFileName, this.keyDbPwd);
                    if (n != 0) {
                        throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_KDB2KYR"));
                    }
                } else {
                    throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"));
                }
                this.copyKeyLabelLists(keyDatabase);
                return;
            }
            this.copyKeyLabelLists(keyDatabase);
            return;
        }
        catch (CMSKeyDatabaseException cMSKeyDatabaseException) {
            throw cMSKeyDatabaseException;
        }
        catch (KeyDatabaseException keyDatabaseException) {
            throw new CMSKeyDatabaseException();
        }
    }

    private void reCreateOld(KeyDatabase keyDatabase) throws CMSKeyDatabaseException {
        if (this.keyDbFileName == null) {
            throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
        }
        KeyDatabaseOperator keyDatabaseOperator = (KeyDatabaseOperator)((Object)keyDatabase);
        try {
            if (keyDatabase.getType() == 3) {
                this.cmsKeyDbCopy.reCreate(keyDatabase);
                this.reCreate(this.cmsKeyDbCopy);
                return;
            }
            if (this.keyDbFileName.equals(keyDatabase.getKeyDbFileName()) && this.type != keyDatabase.getType()) {
                if (keyDatabase.getType() == 1) {
                    String string = KMUtil.getTmpFileName(this.keyDbFileName, "_tmp");
                    int n = CMSKeyDatabase.c_Kdb2Kyr(keyDatabase.getKeyDbFileName(), keyDatabase.getKeyDbPwd(), string, this.keyDbPwd);
                    File file = new File(string);
                    File file2 = new File(this.keyDbFileName);
                    if (n != 0) {
                        if (file.exists()) {
                            file.delete();
                        }
                        throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_CMN_KDB2KYR"));
                    }
                    file2.delete();
                    file.renameTo(file2);
                } else {
                    Vector<KeyItem> vector = new Vector<KeyItem>();
                    KeyItem keyItem = keyDatabaseOperator.getFirstKeyItem();
                    while (keyItem != null) {
                        vector.addElement(keyItem);
                        keyItem = keyDatabaseOperator.getNextKeyItem();
                    }
                    File file = new File(this.keyDbFileName);
                    file.delete();
                    this.create();
                    int n = vector.size();
                    int n2 = 0;
                    while (n2 < n) {
                        this.insertKey((KeyItem)vector.elementAt(n2));
                        ++n2;
                    }
                }
                this.copyKeyLabelLists(keyDatabase);
                return;
            }
            if (!this.keyDbFileName.equals(keyDatabase.getKeyDbFileName())) {
                if (keyDatabase.getType() == 1) {
                    int n = CMSKeyDatabase.c_Kdb2Kyr(keyDatabase.getKeyDbFileName(), keyDatabase.getKeyDbPwd(), this.keyDbFileName, this.keyDbPwd);
                    if (n != 0) {
                        throw new CMSKeyDatabaseException(n, KMSystem.getNLSErrString("GSKKM_ERR_KDB2KYR"));
                    }
                } else {
                    this.create();
                    KeyItem keyItem = keyDatabaseOperator.getFirstKeyItem();
                    while (keyItem != null) {
                        this.insertKey(keyItem);
                        keyItem = keyDatabaseOperator.getNextKeyItem();
                    }
                }
                this.copyKeyLabelLists(keyDatabase);
                return;
            }
            this.copyKeyLabelLists(keyDatabase);
            return;
        }
        catch (CMSKeyDatabaseException cMSKeyDatabaseException) {
            throw cMSKeyDatabaseException;
        }
        catch (KeyDatabaseException keyDatabaseException) {
            throw new CMSKeyDatabaseException();
        }
    }

    public void changeKeyDbPwd(String string, long l) throws CMSKeyDatabaseException {
        this.changeKeyDbPwd(null, string, l);
    }

    public void changeKeyDbPwd(String string, String string2, long l) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.changeKeyDbPwd(string, string2, l);
    }

    public void createNewSelfSignedCertificate(int n, String string, boolean bl, int n2, DNItem dNItem, int n3, String string2, boolean bl2) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.createNewSelfSignedCertificate(n, string, bl, n2, dNItem, n3, string2, bl2);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void createNewCertRequest(String string, int n, DNItem dNItem, String string2, boolean bl) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.createNewCertRequest(string, n, dNItem, string2, bl);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public boolean isPrivateKeyPresent(String string) {
        return this.cmsKeyDbCopy.isPrivateKeyPresent(string);
    }

    public void buildKeyLabelList() throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.buildKeyLabelList();
        this.copyKeyLabelLists(this.cmsKeyDbCopy);
    }

    public void classifyKeyLabels() {
        this.myCertLabelList = null;
        this.caCertLabelList = null;
        if (this.keyLabelList == null) {
            return;
        }
        int n = this.keyLabelList.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.keyLabelList.elementAt(n2);
            if (this.isPrivateKeyPresent(string)) {
                this.addMyCertLabel(string);
            } else {
                this.addCaCertLabel(string);
            }
            ++n2;
        }
    }

    public void refreshKeyLabelList() throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.refreshKeyLabelList();
        this.copyKeyLabelLists(this.cmsKeyDbCopy);
    }

    public KeyItem getKeyItemByLabel(String string) throws CMSKeyDatabaseException {
        return this.cmsKeyDbCopy.getKeyItemByLabel(string);
    }

    public KeyItem[] getKeyItemListByLabel(String string) throws CMSKeyDatabaseException {
        return this.cmsKeyDbCopy.getKeyItemListByLabel(string);
    }

    public Vector getKeyItemsByPublicKey(BERObject bERObject) throws CMSKeyDatabaseException {
        return this.cmsKeyDbCopy.getKeyItemsByPublicKey(bERObject);
    }

    public KeyItem getDefaultKeyItem() throws CMSKeyDatabaseException {
        return this.cmsKeyDbCopy.getDefaultKeyItem();
    }

    public synchronized KeyItem getFirstKeyItem() throws CMSKeyDatabaseException {
        return this.cmsKeyDbCopy.getFirstKeyItem();
    }

    public synchronized KeyItem getNextKeyItem() throws CMSKeyDatabaseException {
        return this.cmsKeyDbCopy.getNextKeyItem();
    }

    public void deleteKeyByLabel(String string) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.deleteKeyByLabel(string);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void insertKey(KeyItem keyItem) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.insertKey(keyItem);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void setDefaultKey(String string) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.setDefaultKey(string);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void setKeyTrust(String string, boolean bl) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.setKeyTrust(string, bl);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void exportToPFXFile(String string, String string2, String[] stringArray) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.exportToPFXFile(string, string2, stringArray);
    }

    public void importFromPFXFile(String string, String string2) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.importFromPFXFile(string, string2);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void receiveCertificate(String string, boolean bl, boolean bl2) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.receiveCertificate(string, bl, bl2);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void addCACertificate(String string, String string2, boolean bl) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.addCACertificate(string, string2, bl);
        this.makeCopyFromKdb(this.cmsKeyDbCopy);
    }

    public void extractCertificate(String string, String string2, boolean bl) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.extractCertificate(string, string2, bl);
    }

    public void extractCertificateRequest(String string, String string2) throws CMSKeyDatabaseException {
        this.cmsKeyDbCopy.extractCertificateRequest(string, string2);
    }

    public PrivateKeyInfoItem decryptPrivateKey(EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem) throws CMSKeyDatabaseException {
        return this.cmsKeyDbCopy.decryptPrivateKey(encryptedPrivateKeyInfoItem);
    }

    public EncryptedPrivateKeyInfoItem encryptPrivateKey(PrivateKeyInfoItem privateKeyInfoItem) throws CMSKeyDatabaseException {
        return this.cmsKeyDbCopy.encryptPrivateKey(privateKeyInfoItem);
    }

    public void addSiteCertificate(String string, String string2, boolean bl) throws CMSKeyDatabaseException {
        throw new CMSKeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_OP_NULL"));
    }

    public String toString() {
        return this.paramString();
    }

    public String paramString() {
        return String.valueOf(super.paramString()) + ", cmsKeyDbCopy=" + this.cmsKeyDbCopy;
    }
}

