/* */
   signal on Syntax name lab0
   rc = RxFuncAdd( "SysLoadFuncs", "REXXUTIL", "SYSLOADFUNCS" )
   rc = SysLoadFuncs()
lab0:
   signal on Syntax name lab1
   call RXFuncAdd "VRLoadFuncs", "VROBJ", "VRLoadFuncs"
   call VRLoadFuncs
lab1:
   signal on Syntax
   signal on syntax name lab2
   call RxFuncAdd 'WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs' 
   rc = WPToolsLoadFuncs()
lab2:
   signal on syntax

   parse arg CDDrive, ReadME
   errlogloc = Value( "TMP", , "OS2ENVIRONMENT" ) || "\ecspmpdf-err.log"
   if (ReadME="") then parse var CDDrive CDDrive" "ReadME
   if (translate(ReadME)="README") then do
      "start "GetEditor()" "CDDrive"\ThirdParty\pmpdf\PMPDF.readme"
      "@exit"
      return
   end
   if (translate(ReadME)="ERRLOG") then do
      "start "GetEditor()" "errlogloc
      "@exit"
      return
   end

      ErrMsg =  "** Install started Date: " || Date('S') || "  Time: " || Time()
      call lineout errlogloc, ErrMsg
      call lineout errlogloc

   GhostscriptDir = ReadME
   if (GhostscriptDir="") then do
      say "No Ghostscript directory entered"
      ErrMsg =  "No Ghostscript directory entered"
      call lineout errlogloc, ErrMsg
      call lineout errlogloc
      "@exit"
      return
   end
    drvpathnam = GhostscriptDir"\bin\gsos2.exe"
    IF STREAM(drvpathnam,"C","QUERY EXISTS")="" then do
       say "Can't find Ghostscript \bin\gsos2.exe"
      ErrMsg =  GhostscriptDir " directory path bad. Can't find \bin\gsos2.exe"
      call lineout errlogloc, ErrMsg
      call lineout errlogloc
      "@exit"
      return
   end


   TmpDir  = Value( "TMP", , "OS2ENVIRONMENT" )
   TmpFile  = SysTempFileName( strip(TmpDir,"T","\")"\Wise@@@@.tmp","@" )
   if (TmpFile="") then do
      say "Can't create temp file"
      "@exit"
      return
   end

   /* Find a temporary directory that's big enough */
   zipFile = CDDrive"\ThirdParty\pmpdf\pmpdf.zip"
   "@call eCSProcessBP.exe "zipFile" "CDDrive" "TmpFile" PERMANENT >nul:"

   TmpDir = linein(TmpFile)
   call lineout TmpFile
   call VRDeleteFile TmpFile

   if (TmpDir<>"" & VRFileExists(TmpDir"\install\pdfinst.cmd")=1) then do
      NewDir = Directory(TmpDir)
      rc = SysCreateObject("WPFolder", "PDFDOCS", TmpDir, "OBJECTID=<WP_PDFFOLDER>", "REPLACE")
      rc=SysCreateShadow("<WP_PDFFOLDER>", "<WP_DATAFOLDER>")
      call  pmpdfinst  errlogloc TmpDir GhostscriptDir " " TmpDir"\pdfdocs" TmpDir"\install" SysBootdrive()"\OS2\DLL\PRINTERS"
/*   "@call "TmpDir"\install\pdfinst.cmd " errlogloc GhostscriptDir " " TmpDir"\pdfdocs" TmpDir"\install" SysBootdrive()"\OS2\DLL\PRINTERS"  */
      NewDir = Directory(NewDir)
      '@call 'SysBootdrive()'\TVoice\WiseProg\WiseManager\MessageBox "PMPDF - PDF creator for eCS", "PMPDF - PDF creator for eCS Installation Completed", "Choose Proceed to continue", "I", 1, 1, 3'

   end
   "@exit"
return

GetEditor: procedure
   RetString = "e"
   szClass = ""
   iRetco = WPToolsQueryObject("<WP_SYSED>", "szClass", "szTitle", "szSetupString", "szLocation")
   if (szClass="") then return RetString
   parse var szSetupString pre"EXENAME="RetString";"rest
   if (VRFileExists(RetString)=0) then return "e"
return RetString

pmpdfinst:
arg errlog dirpmpdf gs pdf pdr prdrv
inputfile=pdr'\pdf.rsp'
if gs = "" then do
ErrMsg =  "No Ghostscript directory path entered"
call lineout errlog, ErrMsg
call lineout errlog
exit 1
end
if pdf = "" then do
ErrMsg =  "No PDF file save directory path entered"
call lineout errlog, ErrMsg
call lineout errlog
exit 2
end
rc = SysFileTree(pdf,files)
if files.0='0' then do
ErrMsg =  "PDF file save directory not found"
call lineout errlog, ErrMsg
call lineout errlog
exit 4
end
rc = SysFileTree(pdr'\pdfwrite.pdr',files)
if files.0='0' then do
ErrMsg =  pdr'\pdfwrite.pdr' "PDF driver not found"
call lineout errlog, ErrMsg
call lineout errlog
exit 5
end
rc = SysFileTree(prdrv'\pscript.drv',files)
if files.0='0' then do
ErrMsg =  prdrv'\pscript.drv' "Postscript driver not found"
call lineout errlog, ErrMsg
call lineout errlog
exit 6
end
rc = SysFileTree(gs'\bin\gsos2.exe',files)
if files.0='0' then do
ErrMsg =  gs " directory path bad. Can't find \bin\gsos2.exe"
call lineout errlog, ErrMsg
call lineout errlog
exit 3
end

dirpmpdf = Strip(dirpmpdf)
gs    = Strip(gs)
pdf   = Strip(pdf)
prdrv = Strip(prdrv)

rc = stream(inputfile, 'c', 'open read')
i = 0
DO while lines(inputfile)
 i = i + 1
 line.i = linein(inputfile)
END
line.0 = i
rc = stream(inputfile, 'c', 'close')

/* delete the inputfile */
rc = SysFileDelete(inputfile)
DO i = 1 TO line.0
IF Pos('SRCPATH', line.i) >< 0 THEN
  DO
   IF i = 3 THEN
    DO
     line.i = '      SRCPATH='||pdr
    END
   ELSE IF i = 11 THEN
    DO
     line.i = '      SRCPATH='||prdrv
    END
   END
rc = LineOut(inputfile, line.i)
END /* all lines processed */
rc = stream(inputfile, 'c', 'close')

string = Strip(gs||';'||pdf||"0"x)
call SysIni 'SYSTEM','PM_PDF','INITIALIZATION',string

ErrMsg =  " **** also check " || dirpmpdf || "\RINSTPRN.LOG for errors"
call lineout errlog, ErrMsg
call lineout errlog
'@rinstprn /R:'pdr'\pdf.rsp'
return