/*
 * validdrv.cmd
 *
 * REXX exec to check if there are *.dr* files on the disk.
 * If the specified drive isn't ready, the name of the second panel
 * is returned; otherwise, if the *.dr* files do not exist, the name
 * of the third panel is returned; otherwise, the name of the first panel
 * is returned.
 *
 * Written 3/29/96 by Kelly Ganci
 */

parse arg goodPanel driveNotReadyPanel fileNotFoundPanel fileName .

/* If the user only enters a letter add the :\ */
filelen = length(fileName)
if (filelen = 1) then
    fileName = fileName":\"

/* Ensure that the last character is a back slash \ */
filelen = length(fileName);
lastchar = substr(fileName,filelen)
if (lastchar \= "\") then
  fileName = fileName"\"


/* check for .drv and .dr_ printer driver files */
fileName = fileName"*.dr*"

if pos(':', fileName) = 2 then
do
  call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
  call RxFuncAdd 'SysDriveInfo', 'RexxUtil', 'SysDriveInfo'

  drive = substr(fileName, 1, pos(':', fileName))

  /* check to see if the drive is ready */
  driveInfo = SysDriveInfo(drive)

  if ((driveInfo = '.') |,
      (driveInfo = ''))then
      return driveNotReadyPanel


  /* check to see if the file exists */
  SysFileTree(fileName, 'file', 'F');
  if (file.0 > 0)then
      return goodPanel
  else
      return fileNotFoundPanel
end
else
  return driveNotReadyPanel
