/* 
 * validfn.cmd
 *
 * REXX exec to check if a file exists.  If the specified drive isn't ready,
 * the exec returns the name of the second panel; otherwise, if the file
 * doesn't exist, the exec returns the name of the third panel; otherwise, 
 * it returns the name of the first. 
 * 
 * Written 3/29/96 by Charles Burkett
 */

parse arg goodPanel driveNotReadyPanel fileNotFoundPanel fileName . 

if ((fileName == '') |,
    (pos('?', fileName) > 0) |,
    (pos('*', fileName) > 0)) then
  return fileNotFoundPanel

if pos(':', fileName) > 0 then
do
  call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

  drive = substr(fileName, 1, pos(':', fileName))

  /* check to see if the drive is ready */
  driveInfo = SysDriveInfo(drive)
  if ((driveInfo == '.') |,
      (driveInfo == '')) then
    return driveNotReadyPanel
end

/* check to see if the file exists */
fExists = Stream(fileName, 'c', 'query exists');
if (fExists == '') then
  return fileNotFoundPanel
else
  return goodPanel

