/* Ŀ
 * Program:    settcpcfg.cmd                         
 * Author:     Joachim Benjamins / Mensys BV         
 * Created:   31 May 2001  01:03                     
 * Last edit: 04 Jun 2001                            
 * 
 */

/* Ŀ
 * The purpose of settcpcfg.cmd is to evalate the    
 * environment variables as set by the TCPCFG.SGS    
 * WiseGuide. It will setup these values in the      
 * appropriate directories. (\MPTN\BIN & \ETC)       
 * 
 */


/***************************************************************************/
/*                    initialisation of the program                        */
/***************************************************************************/

'@echo off'                                        /* skip screen messages */

IF LoadRexxUtil() THEN RETURN 0        /* make sure REXX library is loaded */

/* 
We'll have to parse these variables, in this order: 
settcpcfg.cmd %dhcp% %ipaddr% %netmask% &quot.%resolvdomain%&quot. %dns1% %dns2% %localhost_state% %ipgate_state% 

For a detailed description, see header of TCPCFG.SGS

dhcp = 0 - manual config
dhcp = 1 - dhcp enabled
dhcp = 2 - dialup config

*/

Parse Arg dhcp_enabled ipaddr netmask resolvdomain dns1 dns2 localhost ipgate default ddns safe_dhcp

SIGNAL ON Error                  /* foutmeldingen worden zelf afgehandeld  */
SIGNAL ON Halt                              /* CTRL-BREAK wordt afgevangen */

LogFile = "settcpcfg.log"

/* fixup (empty) strings from SGUIDE.EXE */

IF localhost >< 1 THEN localhost = 0
IF ipgate >< 1 THEN ipgate = 0
IF ddns >< 1 THEN ddns = 0
IF safe_dhcp >< 1 THEN safe_dhcp = 0

IF dhcp_enabled < 0 | dhcp_enabled > 2 THEN
 DO
  SAY ' '
  SAY '[settcpcfg.cmd] is supposed to be called from eCSGuide TCPCFG.SGS'
  SAY 'and not from the commandline, use [startguide.cmd] to start the '
  SAY 'TCP/IP setup eCSGuide'
  SAY ' ' 
  SIGNAL EndProg
 END

/* assume ETC is on bootdrive! - perhaps another way of determining bootdrive 
   should be used, this will likely fail when booted from CD */

etcpad = VALUE('ETC',,'OS2ENVIRONMENT')

resolvfile=etcpad||'\resolv2'
bootdrive=Left(etcpad,2)
setupfile=bootdrive||'\mptn\bin\setup.cmd'
dhcpfile =etcpad||'\dhcpcd.cfg'
hostfile =etcpad||'\hosts'

/* testing - remove these lines to let 'real' updating take place */

resolvfile = 'test-resolvfile'
setupfile  = 'test-setupfile'
dhcpfile = 'test-dhcpcd.cfg'

/***************************************************************************/
/*                       Manual Configuration                              */
/***************************************************************************/


IF dhcp_enabled = 0 THEN
  DO /* manual configuration to be set */

/* we have to create a file similar to this: 

route -fh
arp -f
ifconfig lan0 192.168.0.60 netmask 255.255.255.0 metric 1 mtu 1500
REM ifconfig lan1 metric 1 mtu 1500
REM ifconfig lan2 metric 1 mtu 1500
REM ifconfig lan3 metric 1 mtu 1500
REM ifconfig lan4 metric 1 mtu 1500
REM ifconfig lan5 metric 1 mtu 1500
REM ifconfig lan6 metric 1 mtu 1500
REM ifconfig lan7 metric 1 mtu 1500
ifconfig lo 127.0.0.1
route add default 192.168.0.33 -hopcount 1
ipgate off

*/

rc = SysFileDelete(setupfile) /* delete the setup file first */
rc = stream(setupfile, 'c', 'open write')

  text = 'route -fh'
  rc = lineout(setupfile, text,)
  text = 'arp -f'
  rc = lineout(setupfile, text,)
  text = 'ifconfig lan0 '||ipaddr||' netmask '||netmask||' metric 1 mtu 1500'
  rc = lineout(setupfile, text,)

/* for easy of use we'll skip the remmed out lines */

IF localhost = 1 THEN 
 DO
  text = 'ifconfig lo 127.0.0.1'
 END
  ELSE 
 DO
  text = 'REM ifconfig lo 127.0.0.1'
 END
  rc = lineout(setupfile, text,)

/* setup default route */

IF default >< '0.0.0.0' THEN 
 DO
  text = 'route add default '||default||' - hopcount 1'
  rc = lineout(setupfile, text,)
 END

IF ipgate = 1 THEN 
 DO
  text = 'ipgate on'
 END
  ELSE 
 DO
  text = 'ipgate off'
 END
  rc = lineout(setupfile, text,)

rc = stream(setupfile, 'c', 'close') /* close the file */

/* configure the DNS values */

rc = SysFileDelete(resolvfile) /* delete resolv file first */
rc = stream(resolvfile, 'c', 'open write') /* and create a new */
  text = 'domain '||resolvdomain
  rc = lineout(resolvfile, text,)
  text = 'nameserver '||dns1
  rc = lineout(resolvfile, text,)
  text = 'nameserver '||dns2
  rc = lineout(resolvfile, text,)
rc = stream(resolvfile, 'c', 'close') /* close the file */

/* now update DHCPCD.CFG in \MPTN\ETC */
/* all options will be disabled */

CALL UpdateDHCPfile

END /* manual config */

/***************************************************************************/
/*                         DHCP Configuration                              */
/***************************************************************************/

IF dhcp_enabled = 1 THEN
  DO /* DHCP configuration to be set */

/* we have to create a file similar to this: 

route -fh
arp -f
REM ifconfig lan0 metric 1 mtu 1500
REM ifconfig lan1 metric 1 mtu 1500
REM ifconfig lan2 metric 1 mtu 1500
REM ifconfig lan3 metric 1 mtu 1500
REM ifconfig lan4 metric 1 mtu 1500
REM ifconfig lan5 metric 1 mtu 1500
REM ifconfig lan6 metric 1 mtu 1500
REM ifconfig lan7 metric 1 mtu 1500
dhcpstrt -i lan0
ifconfig lo 127.0.0.1
route add default 192.168.0.33 -hopcount 1
ipgate off

*/

rc = SysFileDelete(setupfile) /* delete the setup file first */
rc = stream(setupfile, 'c', 'open write')

  text = 'route -fh'
  rc = lineout(setupfile, text,)
  text = 'arp -f'
  rc = lineout(setupfile, text,)
  text = 'dhcpstart -i lan0'
  rc = lineout(setupfile, text,)

/* for easy of use we'll skip the remmed out lines */

IF localhost = 1 THEN 
 DO
  text = 'ifconfig lo 127.0.0.1'
 END
  ELSE 
 DO
  text = 'REM ifconfig lo 127.0.0.1'
 END
  rc = lineout(setupfile, text,)

/* setup default route */

IF default >< '0.0.0.0' THEN 
 DO
  text = 'route add default '||default||' - hopcount 1'
  rc = lineout(setupfile, text,)
 END

IF ipgate = 1 THEN 
 DO
  text = 'ipgate on'
 END
  ELSE 
 DO
  text = 'ipgate off'
 END
  rc = lineout(setupfile, text,)

rc = stream(setupfile, 'c', 'close') /* close the file */

/* now update DHCPCD.CFG in \MPTN\ETC */

CALL UpdateDHCPfile

/* final settings */

IF ddns = 1 THEN 
 DO 
  /* here i need to put something that creates a shadow of 
     \MPTN\BIN\DDNSCFG.EXE in the startupfolder
  */
 END
  ELSE
 DO 
  /* here i need to put something that checks and if necesarry deletes the shadow of 
     \MPTN\BIN\DDNSCFG.EXE in the startupfolder
  */
 END

END /* end DHCP configuration */

/***************************************************************************/
/*                        DialUp Configuration                             */
/***************************************************************************/

IF dhcp_enabled = 2 THEN
  DO /* DialUp configuration to be set */

rc = SysFileDelete(setupfile) /* delete the setup file first */
rc = stream(setupfile, 'c', 'open write')

  text = 'route -fh'
  rc = lineout(setupfile, text,)
  text = 'arp -f'
  rc = lineout(setupfile, text,)

/* for easy of use we'll skip the remmed out lines */

IF localhost = 1 THEN 
 DO
  text = 'ifconfig lo 127.0.0.1'
 END
  ELSE 
 DO
  text = 'REM ifconfig lo 127.0.0.1'
 END
  rc = lineout(setupfile, text,)

IF ipgate = 1 THEN 
 DO
  text = 'ipgate on'
 END
  ELSE 
 DO
  text = 'ipgate off'
 END
  rc = lineout(setupfile, text,)

rc = stream(setupfile, 'c', 'close') /* close the file */

/* now update DHCPCD.CFG in \MPTN\ETC */
/* all options will be disabled */

CALL UpdateDHCPfile

END /* end DialUp Configuration */

SIGNAL EndProg  /* end of program */


/****************************************************************************/
/* PROCEDURE: UpdateDHCPfile                                                */
/****************************************************************************/

UpdateDHCPfile: PROCEDURE EXPOSE LogFile ddns dhcp_enabled ipgate dhcpfile safe_dhcp 

/* now update DHCPCD.CFG in \MPTN\ETC */

rc = stream(dhcpfile, 'c', 'open read')
tempfile = dhcpfile||'.ecs' /* create a new file */
rc = SysFileDelete(tempfile) /* which we want empty */
rc = stream(tempfile, 'c', 'open write')

previousset = 0
ddnsset = 0
interfaceset = 0

do while lines(dhcpfile) <> 0         /* until end of file */

  Line = linein(dhcpfile)        /* get a line of the file */
  Line = Strip(Line)

   SELECT
    WHEN Pos('PREVIOUSCFG', Translate(line)) >< 0 THEN /* valid entry */
     DO 
       txt = '#previouscfg'
       IF safe_dhcp = 1 THEN txt = 'previouscfg'
       previousset = 1
     END
    WHEN Pos('INTERFACE', Translate(word(line,1))) >< 0 THEN /* valid entry */
     DO 
       txt = '#interface lan0'
       IF dhcp_enabled = 1 THEN txt = 'interface lan0'
       interfaceset = 1
     END
    WHEN Pos('UPDATEDNS', Translate(word(line,1))) >< 0 THEN /* valid entry */
     DO 
       hashpos = Pos('#', line)
        txt = line
        IF hashpos = 1 THEN txt = Right(line, Length(line) - 1) /* remove hash */
        IF ddns = 0 THEN txt = '#'||txt /* ddns disabled - add hash */
        IF ddns = 1 THEN ddnsset = 1       
      END
     OTHERWISE
       txt = line
    END /* select statements */

    rc = lineout(tempfile, txt,) /* write the generated line to the tempfile */

END /* do while lines loop */

  rc = stream(dhcpfile, 'c', 'close')

IF interfaceset = 0 & dhcp_enabled = 1 THEN /* apparently text was not in template file */
 DO 
  txt = 'interface lan0'
  rc = LineOut(tempfile, txt, ) 
 END

IF previousset = 0 & safe_dhcp = 1 THEN /* apparently text was not in template file */
 DO 
  txt = 'previouscfg'
  rc = LineOut(tempfile, txt, ) 
 END

IF ddnsset = 0 & ddns = 1 THEN /* ditto - string from the template out of \cid\samples */
 DO 
  txt = 'updateDNSA "nsupdate -h%s -d%s -s"d;a;*;a;a;%s;s;%s;3110400;q" -q"'
  rc = LineOut(tempfile, txt, ) 
 END

  rc = stream(tempfile, 'c', 'close')
  copy tempfile dhcpfile
  /* rc = SysFileDelete(tempfile) */

RETURN

/****************************************************************************/
/* PROCEDURE: PutScreen(tekst)                                              */
/****************************************************************************/

PutScreen: PROCEDURE EXPOSE LogFile
PARSE ARG text
SAY text
CALL LineOut LogFile, text
RETURN


/****************************************************************************/
/* PROCEDURE: LoadRexxUtil                                                  */
/****************************************************************************/

LoadRexxUtil:

IF RxFuncQuery('SysLoadFuncs') <> 0 THEN
    DO
        IF RxFuncAdd('SysLoadFuncs','RexxUtil','SysLoadFuncs') THEN RETURN 1
        CALL SysLoadFuncs
    END
RETURN 0

/****************************************************************************/
/* LABEL:   Halt                                                            */
/****************************************************************************/

Halt:
ErrTxt = 'program interrupted by user at '||Time()||' on '||Date()
CALL PutScreen ErrTxt
SIGNAL EndProg
EXIT


/****************************************************************************/
/* FUNCTIE: Error()                                                         */
/****************************************************************************/

ERROR:
SIGNAL EndProg
EXIT


/****************************************************************************/
/* LABEL:   EndProg                                                         */
/****************************************************************************/

EndProg:

ErrTxt = 'Program exit on:'||Date()||' - '||Time()
CALL PutScreen ErrTxt
rc = stream(LogFile, 'c', 'close')                    /* close message-file */

EXIT                                           /* definitive end of program */
