/* startguide: REXX variable setting tool  */
/* (c) 2001, Joachim Benjamins / Mensys BV */

/* the only way to pass variables to the SGUIDE parser 
   is by putting these in the OS/2 Environment as 'global variables' 
   This script abuses this. It scans some system files to derive
   the current TCP/IP configuration and sets this in the OS2ENVIRONMENT
   It then invokes the WiseGuide and finally restores the environment */


IF LoadRexxUtil() THEN RETURN 0               /* load external libraries */

 n = SETLOCAL()        /* saves all environment settings    */
 
etcpad = VALUE('ETC',,'OS2ENVIRONMENT')

/* assume ETC is on bootdrive! - perhaps another way of determining bootdrive 
   should be used - this will likely go wrong when booted from CD */

resolvfile=etcpad||'\resolv2'
bootdrive=Left(etcpad,2)
setupfile=bootdrive||'\mptn\bin\setup.cmd'
dhcpfile=etcpad||'\dhcpcd.cfg'

/* we are not interested in more than two defined nameservers. The rest will be ignored */

rc = getresolv()

p = SetValue('resolvdomain', resolv.name)
p = SetValue('dns1', resolv.1)
p = SetValue('dns2', resolv.2)

rc = getdhcp()

/* ddns active ? */
txt = 'disabled'
IF setup.ddns = 1 THEN txt = 'enabled'
p = SetValue('ddns_state', txt)

/* safe previous DHCP configuration ? */
txt = 'disabled'
IF setup.safe_dhcp = 1 THEN txt = 'enabled'
p = SetValue('safe_dhcp_state', txt)

rc = getsetup()

DO i = 0 TO setup.0
ipdummy = 'ip_lan'||i
netdummy = 'net_lan'||i

p = SetValue(ipdummy, setup.lan.i.ip)
p = SetValue(netdummy, setup.lan.i.mask)
END /* i = 1 to no of LAN adapters */

/* localhost active ? */
txt = 'disabled'
IF setup.local = 1 THEN txt = 'enabled'
p = SetValue('localhost_state', txt)
p = SetValue('localhost_value',setup.local)

/* DHCP enabled ? */
IF setup.dhcp = 1 THEN 
 DO
  p = SetValue('config_method', 'DHCP')
  p = SetValue('ddns', 'selected')
 END
ELSE
 DO
  p = SetValue('config_method', 'manual')
 END

/* IP Forwarding enabled ? */
txt = 'disabled'
IF setup.ipforward = 1 THEN txt = 'enabled'
p = SetValue('ipgate_state', txt)
p = SetValue('ipgate_value',setup.ipforward)

/* preset some variables */

p = SetValue('default_route', setup.default)

/* start the WiseGuide */

'sguide tcpcfg.sgs'

/* WiseGuide has finished, restore environment */

 n = ENDLOCAL()  /* restores initial environment */

/* close this cmd file */

exit

/* all procedures follow below */

/* ------ */
SETVALUE: PROCEDURE /* put value in environment variable */
Parse Arg name, value

p = VALUE(name, value, 'OS2ENVIRONMENT')

RETURN 0

/* ------ */
GETRESOLV: PROCEDURE EXPOSE resolvfile resolv. 

rc = stream(resolvfile, 'c', 'open read')

resolv. = '0.0.0.0'
resolv.name = 'Not Defined'
n=1

do while lines(resolvfile) <> 0         /* until end of file */

  Line = linein(resolvfile)        /* get a line of the file */
   IF Pos('DOMAIN',Translate(line)) <> 0 THEN resolv.name = word(line,2)
   IF Pos('NAMESERVER',Translate(line)) <> 0 THEN 
    DO
     resolv.n = word(line,2)
     n = n + 1
    END

end /* do while lines */

rc = stream(resolvfile, 'c', 'close')

RETURN 0

/* ------ */
GETSETUP: PROCEDURE EXPOSE setupfile setup. 

/* this is my setup.cmd 

route -fh
arp -f
ifconfig lo 127.0.0.1 up
ifconfig lan0 192.168.0.60 netmask 255.255.255.0 metric 0 mtu 1500
REM ifconfig lan1
REM ifconfig lan2
REM ifconfig lan3
REM ifconfig lan4
REM ifconfig lan5
REM ifconfig lan6
REM ifconfig lan7
route add -net 192.168 192.168.0.33 -hopcount 1
route add default 192.168.0.33 -hopcount 1

- this is from eCS Prev 3.20 - 

ifconfig lan0 192.168.0.60 netmask 255.255.255.0 metric 1 mtu 1500
REM ifconfig lan1 metric 1 mtu 1500
REM ifconfig lan2 metric 1 mtu 1500
REM ifconfig lan3 metric 1 mtu 1500
REM ifconfig lan4 metric 1 mtu 1500
REM ifconfig lan5 metric 1 mtu 1500
REM ifconfig lan6 metric 1 mtu 1500
REM ifconfig lan7 metric 1 mtu 1500
ifconfig lo 127.0.0.1
route add default 192.168.0.33 -hopcount 1
ipgate off

- this is for DHCP -

route -fh
arp -f
ifconfig lo 127.0.0.1
REM ifconfig lan0 192.168.0.222 netmask 255.255.255.0 metric 0
REM ifconfig lan1 metric 1 mtu 1500
REM ifconfig lan2 metric 1 mtu 1500
REM ifconfig lan3 metric 1 mtu 1500
REM ifconfig lan4 metric 1 mtu 1500
REM ifconfig lan5 metric 1 mtu 1500
REM ifconfig lan6 metric 1 mtu 1500
REM ifconfig lan7 metric 1 mtu 1500 
dhcpstrt -i lan0
route add default 192.168.0.33 -hopcount 1
route add -net 192.168 192.168.0.33 -hopcount 1
ipgate off

*/

rc = stream(setupfile, 'c', 'open read')

setup. = '0.0.0.0'
setup.local = 0
setup.dhcp = 0
setup.ipforward = 0
setup.default = '0.0.0.0'

do while lines(setupfile) <> 0         /* until end of file */

  Line = linein(setupfile)        /* get a line of the file */

   SELECT
    WHEN TRANSLATE(word(line,1)) = 'IFCONFIG' THEN /* valid entry */
     DO 
       IF Translate(word(line,2)) = 'LO' THEN setup.local = 1
       IF Left(Translate(word(line,2)),3) = 'LAN' THEN 
        DO
         nic_nr = Right(word(line,2),1)
         ip_add = word(line,3)
         netmask = word(line,5)
         setup.lan.nic_nr.ip = ip_add
         setup.lan.nic_nr.mask = netmask
        END
      END /* (sub)select */
    WHEN Translate(word(line,1)) = 'DHCPSTART' THEN 
      DO
       nic_nr = Right(word(line,3),1)
       setup.dhcp = 1
      END
    WHEN Translate(word(line,3)) = 'DEFAULT' THEN 
      DO
       setup.default = word(line,4)
      END
    WHEN Translate(word(line,1)) = 'IPGATE' THEN 
      DO
       IF Translate(word(line,2)) = 'ON' THEN setup.ipforward = 1
      END
    OTHERWISE 
      NOP;
   END /* other select, more detection might be added */

end /* do while lines */

setup.0 = 0

rc = stream(setupfile, 'c', 'close')

RETURN 0


/* ------ */
GETDHCP: PROCEDURE EXPOSE dhcpfile setup. 

rc = stream(dhcpfile, 'c', 'open read')

setup.ddns = 0
setup.safe_dhcp = 0

IF SysFileSearch('updateDNS', dhcpfile, 'lines.') = 0 & lines.0 > 0 THEN
  DO line = 1 TO lines.0
    IF Pos('UPDATEDNS',Translate(lines.line)) = 1 THEN setup.ddns = 1
  END

IF SysFileSearch('previouscfg', dhcpfile, 'lines.') = 0 & lines.0 > 0 THEN
  DO line = 1 TO lines.0
    IF Pos('PREVIOUSCFG',Translate(lines.line)) = 1 THEN setup.safe_dhcp = 1
  END

rc = stream(dhcpfile, 'c', 'close')

RETURN 0

/* make sure the rexx util libraries are in memory */

LoadRexxUtil:

IF RxFuncQuery('SysLoadFuncs') <> 0 THEN
    DO
        IF RxFuncAdd('SysLoadFuncs','RexxUtil','SysLoadFuncs') THEN RETURN 1
        CALL SysLoadFuncs
    END
RETURN 0
