/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class DefaultCellEditor
implements TableCellEditor,
TreeCellEditor,
Serializable {
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected JComponent editorComponent;
    protected EditorDelegate delegate;
    protected int clickCountToStart = 1;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;

    public DefaultCellEditor(JCheckBox jCheckBox) {
        this.editorComponent = jCheckBox;
        this.delegate = new EditorDelegate(this){

            public Object getCellEditorValue() {
                return new Boolean(((JCheckBox)DefaultCellEditor.this.editorComponent).isSelected());
            }

            public void setValue(Object object) {
                super.setValue(object);
                if (object instanceof Boolean) {
                    ((JCheckBox)DefaultCellEditor.this.editorComponent).setSelected((Boolean)object);
                } else if (object instanceof String) {
                    Boolean bl = new Boolean((String)object);
                    ((JCheckBox)DefaultCellEditor.this.editorComponent).setSelected(bl);
                } else {
                    ((JCheckBox)DefaultCellEditor.this.editorComponent).setSelected(false);
                }
            }

            public boolean startCellEditing(EventObject eventObject) {
                return eventObject instanceof AWTEvent;
            }

            public boolean stopCellEditing() {
                return true;
            }
        };
        ((JCheckBox)this.editorComponent).addActionListener(this.delegate);
    }

    public DefaultCellEditor(JComboBox jComboBox) {
        this.editorComponent = jComboBox;
        this.delegate = new EditorDelegate(this){

            public Object getCellEditorValue() {
                return ((JComboBox)DefaultCellEditor.this.editorComponent).getSelectedItem();
            }

            public void setValue(Object object) {
                super.setValue(object);
                ((JComboBox)DefaultCellEditor.this.editorComponent).setSelectedItem(object);
            }

            public boolean startCellEditing(EventObject eventObject) {
                return eventObject instanceof AWTEvent;
            }

            public boolean stopCellEditing() {
                return true;
            }
        };
        ((JComboBox)this.editorComponent).addItemListener(this.delegate);
    }

    public DefaultCellEditor(JTextField jTextField) {
        this.editorComponent = jTextField;
        this.clickCountToStart = 2;
        this.delegate = new EditorDelegate(this){

            public Object getCellEditorValue() {
                return ((JTextField)DefaultCellEditor.this.editorComponent).getText();
            }

            public void setValue(Object object) {
                super.setValue(object);
                if (object != null) {
                    ((JTextField)DefaultCellEditor.this.editorComponent).setText(object.toString());
                } else {
                    ((JTextField)DefaultCellEditor.this.editorComponent).setText("");
                }
            }

            public boolean startCellEditing(EventObject eventObject) {
                if (eventObject == null) {
                    DefaultCellEditor.this.editorComponent.requestFocus();
                }
                return true;
            }

            public boolean stopCellEditing() {
                return true;
            }
        };
        ((JTextField)this.editorComponent).addActionListener(this.delegate);
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(class$javax$swing$event$CellEditorListener != null ? class$javax$swing$event$CellEditorListener : (class$javax$swing$event$CellEditorListener = DefaultCellEditor.class$("javax.swing.event.CellEditorListener")), cellEditorListener);
    }

    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
        this.fireEditingCanceled();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$CellEditorListener != null ? class$javax$swing$event$CellEditorListener : DefaultCellEditor.class$("javax.swing.event.CellEditorListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n + 1]).editingCanceled(this.changeEvent);
            }
            n -= 2;
        }
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$CellEditorListener != null ? class$javax$swing$event$CellEditorListener : DefaultCellEditor.class$("javax.swing.event.CellEditorListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n + 1]).editingStopped(this.changeEvent);
            }
            n -= 2;
        }
    }

    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.delegate.setValue(object);
        return this.editorComponent;
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, false);
        this.delegate.setValue(string);
        return this.editorComponent;
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent && ((MouseEvent)eventObject).getClickCount() < this.clickCountToStart) {
            return false;
        }
        return this.delegate.isCellEditable(eventObject);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(class$javax$swing$event$CellEditorListener != null ? class$javax$swing$event$CellEditorListener : (class$javax$swing$event$CellEditorListener = DefaultCellEditor.class$("javax.swing.event.CellEditorListener")), cellEditorListener);
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        boolean bl = true;
        if (this.isCellEditable(eventObject) && (eventObject == null || ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart)) {
            bl = this.delegate.startCellEditing(eventObject);
        }
        return bl;
    }

    public boolean stopCellEditing() {
        boolean bl = this.delegate.stopCellEditing();
        if (bl) {
            this.fireEditingStopped();
        }
        return bl;
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        protected Object value;

        protected EditorDelegate() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DefaultCellEditor.this.fireEditingStopped();
        }

        public void cancelCellEditing() {
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            DefaultCellEditor.this.fireEditingStopped();
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public boolean startCellEditing(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            return true;
        }
    }
}

