/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class BasicMenuBarUI
extends MenuBarUI {
    protected JMenuBar menuBar = null;
    protected ContainerListener containerListener;
    protected ChangeListener changeListener;

    protected ChangeListener createChangeListener() {
        return new ChangeHandler();
    }

    protected ContainerListener createContainerListener() {
        return new ContainerHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuBarUI();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    protected void installDefaults() {
        if (this.menuBar.getLayout() == null || this.menuBar.getLayout() instanceof UIResource) {
            this.menuBar.setLayout(new DefaultMenuLayout(this.menuBar, 0));
        }
        this.menuBar.setOpaque(true);
        LookAndFeel.installBorder(this.menuBar, "MenuBar.border");
        LookAndFeel.installColorsAndFont(this.menuBar, "MenuBar.background", "MenuBar.foreground", "MenuBar.font");
    }

    protected void installKeyboardActions() {
        this.menuBar.registerKeyboardAction(new TakeFocus(this.menuBar), KeyStroke.getKeyStroke(121, 0, false), 2);
    }

    protected void installListeners() {
        this.containerListener = this.createContainerListener();
        this.changeListener = this.createChangeListener();
        int n = 0;
        while (n < this.menuBar.getMenuCount()) {
            JMenu jMenu = this.menuBar.getMenu(n);
            if (jMenu != null) {
                jMenu.getModel().addChangeListener(this.changeListener);
            }
            ++n;
        }
        this.menuBar.addContainerListener(this.containerListener);
    }

    public void installUI(JComponent jComponent) {
        this.menuBar = (JMenuBar)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuBar);
    }

    protected void uninstallKeyboardActions() {
        this.menuBar.unregisterKeyboardAction(KeyStroke.getKeyStroke(121, 0, false));
    }

    protected void uninstallListeners() {
        this.menuBar.removeContainerListener(this.containerListener);
        int n = 0;
        while (n < this.menuBar.getMenuCount()) {
            JMenu jMenu = this.menuBar.getMenu(n);
            if (jMenu != null) {
                jMenu.getModel().removeChangeListener(this.changeListener);
            }
            ++n;
        }
        this.containerListener = null;
        this.changeListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.menuBar = null;
    }

    private class ChangeHandler
    implements ChangeListener {
        ChangeHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n = 0;
            int n2 = BasicMenuBarUI.this.menuBar.getMenuCount();
            while (n < n2) {
                JMenu jMenu = BasicMenuBarUI.this.menuBar.getMenu(n);
                if (jMenu != null && jMenu.isSelected()) {
                    BasicMenuBarUI.this.menuBar.getSelectionModel().setSelectedIndex(n);
                    break;
                }
                ++n;
            }
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        ContainerHandler() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof JMenu) {
                ((JMenu)component).getModel().addChangeListener(BasicMenuBarUI.this.changeListener);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof JMenu) {
                ((JMenu)component).getModel().removeChangeListener(BasicMenuBarUI.this.changeListener);
            }
        }
    }

    private static class TakeFocus
    extends AbstractAction {
        JMenuBar menuBar;

        TakeFocus(JMenuBar jMenuBar) {
            super("takeFocus");
            this.menuBar = jMenuBar;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            JMenu jMenu = this.menuBar.getMenu(0);
            if (jMenu != null) {
                MenuElement[] menuElementArray = new MenuElement[]{this.menuBar, jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray);
            }
        }

        public boolean isEnabled() {
            return this.menuBar.isEnabled();
        }
    }
}

