/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sslight;

import com.ibm.sslight.SSLCert;
import com.ibm.sslight.SSLConnection;
import com.ibm.sslight.SSLContext;
import com.ibm.sslight.SSLException;
import com.ibm.sslight.SSLSession;
import com.ibm.sslight.SSLSocket;
import com.ibm.sslight.Util;
import java.io.IOException;

class SSLClient
extends SSLConnection {
    static final int CERT_REQ = 32;
    static final int HELLO_REQ = 64;
    static final int HELLO_DONE = 128;
    private int server_port;
    private boolean auth;

    int install(boolean bl) {
        if (!bl || this.handshake_state == 64) {
            this.handshake_state = 2;
            if (!bl || !SSLSession.reinstall(this.session, this)) {
                this.session = SSLSession.allocate(this.context.context_id, this.context.cm_list, this.context.cs_list, this.sock.getInetAddress().getAddress(), this.server_port, this.context.timeout[1]);
            }
            return this.sendClientHello();
        }
        return 0;
    }

    boolean uninstall(boolean bl) {
        return SSLSession.uninstall(this.session, this, bl);
    }

    int alert(byte by, byte by2) {
        this.sendAlert((byte)2, (byte)40);
        return -1;
    }

    int handshake(byte[] byArray, byte by, int n, int n2, int n3) {
        switch (by) {
            case 0: {
                if ((0x40 & this.handshake_state) != 0) {
                    return this.reopen();
                }
                return 0;
            }
            case 2: {
                if ((2 & this.handshake_state) == 0) break;
                return this.serverHello(byArray, n, n2);
            }
            case 11: {
                if ((4 & this.handshake_state) == 0) break;
                return this.serverCertificate(byArray, n, n2);
            }
            case 12: {
                if ((8 & this.handshake_state) == 0) break;
                return this.serverKeyExchange(byArray, n, n2);
            }
            case 13: {
                if ((0x20 & this.handshake_state) == 0) break;
                return this.serverCertificateRequest(byArray, n, n2);
            }
            case 14: {
                if ((0x80 & this.handshake_state) == 0) break;
                return this.serverHelloDone(byArray, n, n2);
            }
            case 20: {
                if ((0x10 & this.handshake_state) == 0) break;
                if (this.finished(byArray, n, n2) == 0) {
                    SSLSession.install(this.session, this);
                    this.reset();
                    this.handshake_state = 64;
                    return 0;
                }
                return -1;
            }
        }
        this.ssl_e = new SSLException(2, 1018, byArray, n, n2);
        this.sendAlert((byte)2, (byte)10);
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private int serverKeyExchange(byte[] var1_1, int var2_2, int var3_3) {
        block11: {
            var5_5 = var2_2 + 4;
            var7_6 = 0;
            this.key_exchange = new byte[3][];
            var9_7 = (SSLConnection.cipherSuite[this.session.cipher_suite & 255] & 3840) == 256 ? 2 : 3;
            try {
                block12: {
                    block13: {
                        block14: {
                            block15: {
                                block10: {
                                    for (var4_4 = var3_3 - 4; var4_4 >= 3 && (var6_8 = (int)Util.msbf(var1_1, var5_5, 2)) >= 1 && var6_8 <= 65535; var4_4 -= var6_8 + 2) {
                                        var8_9 = var1_1[var5_5 += 2] == 0 ? 0 : 1;
                                        this.key_exchange[var7_6] = new byte[var6_8 + var8_9];
                                        System.arraycopy(var1_1, var5_5, this.key_exchange[var7_6], var8_9, var6_8);
                                        var5_5 += var6_8;
                                        if (++var7_6 < var9_7) continue;
                                    }
                                    if (var7_6 != var9_7) break block12;
                                    var10_10 = var3_3 - 4 - var4_4;
                                    var11_12 = null;
                                    if (this.session.peer_cert == null) {
                                        v0 = 0;
                                    } else {
                                        var11_12 = this.session.peer_cert[0];
                                        v0 = var6_8 = var11_12.alg == 1 ? var11_12.keyL : 40;
                                    }
                                    if (v0 == var4_4 - 2) {
                                        var4_4 = (int)Util.msbf(var1_1, var5_5, 2);
                                        var5_5 += 2;
                                    }
                                    if (var6_8 != var4_4) break block13;
                                    if ((SSLConnection.cipherSuite[this.session.cipher_suite & 255] & 61440) != 0 && this.key_exchange[0].length - (this.key_exchange[0][0] == 0 ? 1 : 0) > 64) break block14;
                                    var12_13 = true;
                                    if (var6_8 == 0) break block15;
                                    var13_14 = new byte[36];
                                    this.paramHash(var1_1, var2_2 + 4, var10_10, var13_14, 0, var11_12.alg == 1 ? 1 : 0);
                                    if (var11_12.alg != 1) break block15;
                                    var14_15 = Util.util23(false, 1, var11_12.key(), var1_1, var5_5, var6_8);
                                    if (var14_15 == null || var14_15.length != 36) ** GOTO lbl-1000
                                    var15_16 = 0;
                                    var16_17 = 0;
                                    var17_18 = 36;
                                    while (--var17_18 >= 0) {
                                        if (var14_15[var15_16++] == var13_14[var16_17++]) continue;
                                        v1 = false;
                                        break block10;
                                    }
                                    v1 = true;
                                }
                                if (!v1) lbl-1000:
                                // 2 sources

                                {
                                    v2 = false;
                                } else {
                                    v2 = var12_13 = true;
                                }
                            }
                            if (var12_13) {
                                this.register(var1_1, var2_2, var3_3);
                                this.handshake_state = this.handshake_state & 32 | 128;
                                return 0;
                            }
                            this.ssl_e = new SSLException(2, 1023);
                        }
                        this.sendAlert((byte)2, (byte)40);
                        return -1;
                    }
                    this.ssl_e = new SSLException(1, 1015, var1_1, var2_2, var3_3, var5_5 - var2_2 - 1);
                    break block11;
                }
                this.ssl_e = new SSLException(1, 1015, var1_1, var2_2, var3_3, var5_5 - var2_2 - 1);
            }
            catch (Exception var10_11) {
                this.ssl_e = new SSLException(8, 1009, var10_11);
            }
        }
        this.sendAlert((byte)2, (byte)47);
        return -1;
    }

    private int serverHelloDone(byte[] byArray, int n, int n2) {
        this.register(byArray, n, n2);
        if (this.auth && (this.conn_cert == null ? this.sendAlert((byte)1, (byte)41) == -1 : this.sendCertificate() == -1)) {
            return -1;
        }
        if (this.sendClientKeyExchange() == 0) {
            if (this.conn_cert != null && this.sendCertificateVerify() == -1) {
                return -1;
            }
            this.update();
            this.handshake_state = 1;
            return this.sendFinished(true);
        }
        return -1;
    }

    private int serverCertificate(byte[] byArray, int n, int n2) {
        if (this.certificate(byArray, n, n2) == -1) {
            return -1;
        }
        SSLCert sSLCert = this.session.peer_cert[0];
        int n3 = SSLConnection.cipherSuite[this.session.cipher_suite & 0xFF];
        int n4 = n3 >>> 16;
        int n5 = 0;
        do {
            if ((n4 & 0x7F) == 1 && sSLCert.alg == 1) {
                n5 = 1;
                if ((n3 & 0xF00) != 256 || (n3 & 0xF000) != 0 && sSLCert.keyL > 64) break;
                n5 = 2;
                break;
            }
            if ((n4 & 0x7F) != 2 || sSLCert.alg == 1) continue;
            n5 = 1;
            break;
        } while ((n4 >>>= 8) != 0);
        if (n5 == 0) {
            this.ssl_e = new SSLException(2, 1004);
            this.sendAlert((byte)2, (byte)47);
            return -1;
        }
        this.handshake_state = n5 == 1 ? 40 : 168;
        this.register(byArray, n, n2);
        return 0;
    }

    private int serverCertificateRequest(byte[] byArray, int n, int n2) {
        if (this.session.peer_cert == null) {
            this.ssl_e = new SSLException(2, 1005);
            this.sendAlert((byte)2, (byte)40);
            return -1;
        }
        int n3 = n2 - 4;
        int n4 = n + 4;
        int n5 = 0;
        int n6 = SSLConnection.cipherSuite[this.session.cipher_suite & 0xFF];
        try {
            if (n3 > 1) {
                byte by;
                if ((by = byArray[n4++]) > 0 && by <= 255 && --n3 > by) {
                    byte by2 = 0;
                    do {
                        byte by3 = byArray[n4 + by2];
                        if (!((n6 & 0xF00) == 256 && (by3 == 1 || by3 == 2) || (n6 & 0xF00) == 768 && (this.session.peer_cert[0].alg == 1 && by3 == 1 || this.session.peer_cert[0].alg != 1 && by3 == 2))) {
                            throw new SSLException(2, 1020);
                        }
                        if (by2 >= 4) continue;
                        n5 |= by3 << 8 * by2;
                    } while (++by2 < by);
                    if ((n3 -= by) >= 5 && (n3 -= 2) <= 65535 && (int)Util.msbf(byArray, n4 += by, 2) == n3) {
                        Object[] objectArray = (Object[])this.context.getCert(n5, byArray, n4 + 2, n3);
                        if (objectArray != null) {
                            this.conn_cert = (SSLCert[])objectArray[0];
                            this.conn_key = (byte[][])objectArray[1];
                        }
                        this.auth = true;
                        this.handshake_state = 128;
                        this.register(byArray, n, n2);
                        return 0;
                    }
                    throw new SSLException(1, 1015, byArray, n, n2, n4 - n);
                }
                throw new SSLException(1, 1014, byArray, n, n2, n4 - n);
            }
            throw new SSLException(1, 1014, byArray, n, n2, n4 - n);
        }
        catch (SSLException sSLException) {
            this.ssl_e = sSLException;
        }
        catch (Exception exception) {
            this.ssl_e = new SSLException(8, 1009, exception);
        }
        this.sendAlert((byte)2, (byte)47);
        return -1;
    }

    private int serverHello(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n2 - 4;
        int n5 = n + 4;
        byte[] byArray2 = null;
        byte by = 0;
        short s = -1;
        if (n4 >= 35) {
            if (byArray[n5] == 3 && byArray[n5 + 1] == 0) {
                this.peerRandom(byArray, n5 + 2, 32);
                n5 += 34;
                n4 -= 34;
                n3 = byArray[n5++];
                if (n3 >= 0 && n3 <= 32 && --n4 >= n3) {
                    if (n3 > 0) {
                        byArray2 = new byte[n3];
                        System.arraycopy(byArray, n5, byArray2, 0, n3);
                        n5 += n3;
                        n4 -= n3;
                    }
                    if (n4 == 3) {
                        s = (short)Util.msbf(byArray, n5, 2);
                        n4 -= 2;
                        by = byArray[n5 += 2];
                    } else if (n4 > 3) {
                        this.ssl_e = new SSLException(1, 1014, byArray, n, n2, n5 - n);
                    } else if (n4 < 3) {
                        this.ssl_e = new SSLException(1, 1015, byArray, n, n2, n5 - n);
                    }
                } else {
                    this.ssl_e = new SSLException(1, 1014, byArray, n, n2, n5 - n - 1);
                }
            }
        } else {
            this.ssl_e = new SSLException(1, 1015, byArray, n, n2);
        }
        if (s != -1) {
            this.register(byArray, n, n2);
            try {
                if (this.session.session_id != null) {
                    if (byArray2 != null) {
                        SSLSession sSLSession = this.session;
                        if (sSLSession.session_id != null && sSLSession.session_id.length == byArray2.length) {
                            boolean bl;
                            block26: {
                                byte[] byArray3 = sSLSession.session_id;
                                int n6 = 0;
                                int n7 = 0;
                                int n8 = byArray2.length;
                                while (--n8 >= 0) {
                                    if (byArray3[n6++] == byArray2[n7++]) continue;
                                    bl = false;
                                    break block26;
                                }
                                bl = true;
                            }
                            if (bl || false) {
                                if (this.session.cipher_suite != s || this.session.compression_method != by || (SSLConnection.cipherSuite[s & 0xFF] & 0xFFFF0000) == 0 && !this.context.handleNoPeerCertificate()) {
                                    throw new SSLException(2, 1019);
                                }
                                this.update();
                                this.handshake_state = 1;
                                return 0;
                            }
                        }
                    }
                    SSLSession.uninstall(this.session, this, false);
                    this.session = new SSLSession(this.context.context_id, this.sock.getInetAddress().getAddress(), this.server_port, this.context.timeout[1]);
                }
                n3 = 0;
                while (n3 < this.context.cs_list.length && this.context.cs_list[n3] != s) {
                    ++n3;
                }
                if (n3 == this.context.cs_list.length) {
                    throw new SSLException(2, 1025, byArray, n, n2);
                }
                if ((SSLConnection.cipherSuite[s & 0xFF] & 0xFFFF0000) == 0 && !this.context.handleNoPeerCertificate()) {
                    throw new SSLException(2, 1002);
                }
                n3 = 0;
                while (n3 < this.context.cm_list.length && this.context.cm_list[n3] != by) {
                    ++n3;
                }
                if (n3 == this.context.cm_list.length) {
                    throw new SSLException(2, 1026, byArray, n, n2);
                }
                this.session.session_id = byArray2;
                this.session.compression_method = by;
                this.session.cipher_suite = s;
                this.handshake_state = (SSLConnection.cipherSuite[s & 0xFF] & 0xFFFF0000) != 0 ? 4 : 8;
                return 0;
            }
            catch (SSLException sSLException) {
                this.ssl_e = sSLException;
            }
            catch (Exception exception) {
                this.ssl_e = new SSLException(8, 1009, exception);
            }
        }
        this.sendAlert((byte)2, (byte)47);
        return -1;
    }

    private int sendClientHello() {
        this.out.enable(false);
        byte[] byArray = this.context.cm_list;
        short[] sArray = this.context.cs_list;
        this.helloRandom();
        byte by = (byte)(this.session.session_id == null ? 0 : this.session.session_id.length);
        int n = 35 + by + 2 + 2 * sArray.length + 1 + byArray.length;
        int n2 = this.register(null, 0, 4 + n);
        int n3 = n2 + 4;
        byte[] byArray2 = this.handshake;
        byArray2[n3++] = 3;
        byArray2[n3++] = 0;
        System.arraycopy(this.random[0], 0, byArray2, n3, 32);
        n3 += 32;
        byArray2[n3++] = by;
        if (byArray2[n3++] != 0) {
            System.arraycopy(this.session.session_id, 0, byArray2, n3, by);
            n3 += by;
        }
        int n4 = 2 * sArray.length;
        int n5 = n3;
        int n6 = 2;
        do {
            byArray2[n5++] = (byte)(n4 >>> --n6 * 8);
        } while (n6 > 0);
        n3 += 2;
        n4 = 0;
        while (n4 < sArray.length) {
            n5 = sArray[n4];
            n6 = n3;
            int n7 = 2;
            do {
                byArray2[n6++] = (byte)(n5 >>> --n7 * 8);
            } while (n7 > 0);
            ++n4;
            n3 += 2;
        }
        byArray2[n3++] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, n3, byArray.length);
        n3 += byArray.length;
        return this.sendHandshake((byte)1, byArray2, n2, n, true);
    }

    private int sendCertificateVerify() {
        int n = this.conn_cert[0].alg == 1 ? 1 : 0;
        byte[] byArray = new byte[20 * ((n ^ 1) + 1) + 16 * n];
        this.handshakeHash(null, byArray, 0, n);
        if (n == 1) {
            byArray = Util.util23(true, 1, this.conn_key, byArray, 0, 36);
        }
        int n2 = this.register(null, 0, byArray.length + 2 + 4);
        int n3 = byArray.length;
        byte[] byArray2 = this.handshake;
        int n4 = n2 + 4;
        int n5 = 2;
        do {
            byArray2[n4++] = (byte)(n3 >>> --n5 * 8);
        } while (n5 > 0);
        System.arraycopy(byArray, 0, this.handshake, n2 + 6, byArray.length);
        if (this.sendHandshake((byte)15, this.handshake, n2, byArray.length + 2, false) == 0) {
            return 0;
        }
        return -1;
    }

    private int sendClientKeyExchange() {
        byte[] byArray = null;
        byte[] byArray2 = null;
        if ((SSLConnection.cipherSuite[this.session.cipher_suite & 0xFF] & 0xF00) == 256) {
            byArray = new byte[48];
            byArray[0] = 3;
            byArray[1] = 0;
            Util.random(byArray, 2, 46);
            SSLCert sSLCert = this.session.peer_cert[0];
            byArray2 = Util.util23(true, 2, this.key_exchange == null ? sSLCert.key() : this.key_exchange, byArray, 0, 48);
        }
        int n = this.register(null, 0, 4 + byArray2.length);
        System.arraycopy(byArray2, 0, this.handshake, n + 4, byArray2.length);
        this.key_exchange = null;
        if (this.sendHandshake((byte)16, this.handshake, n, byArray2.length, false) == 0) {
            this.blockHash(byArray, byArray, 0);
            this.session.master_secret = byArray;
            return 0;
        }
        return -1;
    }

    SSLClient(SSLSocket sSLSocket, boolean bl, SSLContext sSLContext, int n, boolean bl2) throws IOException, SSLException {
        this.server_port = n;
        this.install(sSLSocket, bl, 0, sSLContext, bl2);
    }
}

