/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sslight;

import com.ibm.sslight.SSLConnection;
import com.ibm.sslight.SSLException;
import com.ibm.sslight.SSLInputStream;
import com.ibm.sslight.SSLOutputStream;
import com.ibm.sslight.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

class SSLRecordLayer
implements Runnable {
    static final int INPUT = 0;
    static final int OUTPUT = 1;
    static final int DATA = 75;
    static final int HEAD = 70;
    private int dataL = 8192;
    private byte[] data = new byte[10315];
    private byte[] idata = this.data;
    private byte[] cdata;
    private byte[] mac = new byte[80];
    SSLConnection conn;
    private int hash;
    private int hash_size;
    private int cipher;
    private int block_size;
    private int cm;
    private byte[] k;
    private byte[] iv;
    private int role;
    private int data_len;
    private long seq;
    private Inflater unzip;
    private InputStream in;
    private SSLInputStream ssl_in;
    private byte[] mac_result;
    private boolean sync;
    private boolean header_done;
    private int data_start = 75;
    private int data_error;
    private boolean term;
    private boolean closing;
    private boolean enabled;
    private Thread thread;
    private Deflater zip;
    private OutputStream out;
    private SSLOutputStream ssl_out;
    private byte data_type;

    SSLRecordLayer(SSLConnection sSLConnection, OutputStream outputStream, InputStream inputStream, boolean bl) {
        this.conn = sSLConnection;
        if (inputStream != null) {
            this.role = 0;
            this.in = inputStream;
            this.ssl_in = new SSLInputStream(this);
            this.mac_result = new byte[20];
            this.sync = bl;
            if (!this.sync) {
                this.thread = new Thread(this);
                this.thread.setDaemon(true);
                this.thread.start();
                return;
            }
        } else {
            this.role = 1;
            this.out = outputStream;
            this.ssl_out = new SSLOutputStream(this);
        }
    }

    void computeMac(int n, byte[] byArray, int n2, byte by) {
        byte[] byArray2 = this.data;
        int n3 = 73;
        int n4 = 2;
        do {
            byArray2[n3++] = (byte)(n >>> --n4 * 8);
        } while (n4 > 0);
        this.data[72] = by;
        long l = this.seq;
        byte[] byArray3 = this.data;
        int n5 = 64;
        int n6 = 8;
        do {
            byArray3[n5++] = (byte)(l >>> --n6 * 8);
        } while (n6 > 0);
        if (this.hash == 1) {
            Util.util11(this.data, 0, n + 75, this.mac, 64);
            Util.util11(this.mac, 0, 80, byArray, n2);
        } else {
            Util.util06(this.data, 4, n + 71, this.mac, 60);
            Util.util06(this.mac, 0, 80, byArray, n2);
        }
        ++this.seq;
    }

    private int bulkCipher(int n) {
        if (this.cipher != 0) {
            if (this.cipher == 16) {
                Util.util14(this.k, this.data, 75, n, this.data, 75);
            } else if (this.role == 1) {
                int n2 = ++n;
                if (n % 8 != 0) {
                    n = (n / 8 + 1) * 8;
                }
                this.data[75 + n - 1] = (byte)(n - n2);
                boolean bl = this.cipher == 48 || this.cipher == 80;
            } else {
                boolean bl = this.cipher == 48 || this.cipher == 80;
                --n;
                n -= this.data[75 + n];
            }
        }
        return n;
    }

    void update(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        int n2;
        byte by = this.conn.session.compression_method;
        this.cm = by;
        if (by != 0) {
            if (this.role == 1) {
                this.zip = new Deflater(this.cm & 0xF, true);
            } else {
                this.unzip = new Inflater(true);
            }
            this.cdata = new byte[75 + this.data.length - 1024];
            this.idata = this.cdata;
        } else {
            this.idata = this.data;
        }
        int n3 = SSLConnection.cipherSuite[this.conn.session.cipher_suite & 0xFF];
        this.cipher = n3 & 0xF0;
        int n4 = this.block_size = byArray3 != null ? byArray3.length : 0;
        if (this.cipher == 16) {
            this.k = Util.util13(byArray2, 0, byArray2.length);
        } else {
            boolean bl = this.cipher == 48 || this.cipher == 80;
        }
        this.iv = byArray3;
        this.hash = n3 & 0xF;
        this.hash_size = byArray.length;
        if (this.hash_size == 16) {
            n2 = 48;
            n = 0;
        } else {
            n2 = 40;
            n = 4;
        }
        System.arraycopy(byArray, 0, this.mac, 0, this.hash_size);
        System.arraycopy(SSLConnection.Pad2, 0, this.mac, this.hash_size, n2);
        System.arraycopy(byArray, 0, this.data, n, this.hash_size);
        System.arraycopy(SSLConnection.Pad1, 0, this.data, n + this.hash_size, n2);
        this.seq = 0L;
    }

    int close() {
        int n = 0;
        if (this.role == 0) {
            this.closing = true;
            SSLRecordLayer sSLRecordLayer = this;
            synchronized (sSLRecordLayer) {
                this.closing = false;
                if (this.ssl_in != null) {
                    this.ssl_in = null;
                    this.notifyAll();
                }
            }
        }
        SSLRecordLayer sSLRecordLayer = this;
        synchronized (sSLRecordLayer) {
            if (this.ssl_out != null) {
                try {
                    if (this.data_len != 0) {
                        this.send();
                    }
                }
                catch (Exception exception) {
                    n = -1;
                }
                this.ssl_out = null;
                this.notifyAll();
            }
        }
        return n;
    }

    private void send() throws IOException {
        int n = this.data_len;
        if (n == 0) {
            return;
        }
        if (this.cm != 0) {
            this.zip.setInput(this.idata, 75, n);
            this.zip.finish();
            n = this.zip.deflate(this.data, 75, this.dataL + 1024);
            this.zip.reset();
        }
        if (this.hash != 0) {
            this.computeMac(n, this.data, 75 + n, this.data_type);
            n += this.hash_size;
        }
        if (this.cipher != 0) {
            n = this.bulkCipher(n);
        }
        this.data[70] = this.data_type;
        this.data[71] = 3;
        this.data[72] = 0;
        byte[] byArray = this.data;
        int n2 = 73;
        int n3 = 2;
        do {
            byArray[n2++] = (byte)(n >>> --n3 * 8);
        } while (n3 > 0);
        this.out.write(this.data, 70, n + 5);
        this.data_len = 0;
    }

    synchronized SSLOutputStream getSSLOutputStream() throws IOException {
        if (this.ssl_out == null) {
            throw new IOException();
        }
        return this.ssl_out;
    }

    synchronized void enable(boolean bl) {
        this.enabled = bl;
        if (this.enabled) {
            this.notifyAll();
        }
    }

    synchronized void write(byte by, byte[] byArray, int n, int n2, boolean bl) throws IOException {
        while (!this.enabled && by == 23 && this.ssl_out != null) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                throw new IOException();
            }
        }
        if (this.ssl_out == null) {
            throw new IOException();
        }
        if (byArray == null) {
            this.send();
            this.out.flush();
            return;
        }
        if (this.data_len != 0 && this.data_type != by) {
            this.send();
        }
        this.data_type = by;
        while (n2 > 0) {
            int n3 = this.dataL - this.data_len;
            if (n2 < n3) {
                n3 = n2;
            }
            n2 -= n3;
            System.arraycopy(byArray, n, this.idata, 75 + this.data_len, n3);
            this.data_len += n3;
            if (!bl && this.data_len < this.dataL) continue;
            this.send();
        }
    }

    final int receive(byte[] byArray, int n, int n2, int n3) throws IOException, InterruptedException, SSLException {
        if (n3 == -1 && this.in.available() < n2) {
            return 0;
        }
        int n4 = 0;
        while (!this.term) {
            int n5;
            try {
                n5 = this.in.read(byArray, n4 + n, n2 - n4);
            }
            catch (InterruptedIOException interruptedIOException) {
                n5 = 0;
            }
            catch (SocketException socketException) {
                if (socketException.getMessage().startsWith("Interrupted system call")) continue;
                throw socketException;
            }
            if (n5 > 0) {
                if ((n4 += n5) == n2) {
                    return n2;
                }
            } else if (n5 == -1) {
                return -1;
            }
            if (n4 == 0 && this.closing) {
                return 0;
            }
            if (n3 <= 0 || (n3 -= 100) > 0) continue;
            throw new SSLException();
        }
        throw new InterruptedException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        int n = 0;
        try {
            while (true) {
                n = this.receiveRecord(0);
                SSLRecordLayer sSLRecordLayer = this;
                synchronized (sSLRecordLayer) {
                    if (this.term) {
                        return;
                    }
                    this.notifyAll();
                    if (n < 0) {
                        this.data_error = n;
                        return;
                    }
                    if (this.ssl_in != null) {
                        this.data_len = n;
                        while (this.data_len > 0) {
                            this.wait();
                            if (!this.term) continue;
                        }
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    int receiveRecord(int n) {
        SSLException sSLException;
        int n2;
        block31: {
            int n3 = 0;
            n2 = 0;
            sSLException = null;
            try {
                while (true) {
                    byte[] byArray;
                    int n4;
                    int n5;
                    if (!this.header_done) {
                        n5 = this.receive(this.data, 70, 5, n);
                        if (n5 == -1) {
                            n2 = -2;
                            break block31;
                        }
                        if (n5 == 0) {
                            return 0;
                        }
                        this.header_done = true;
                    }
                    int n6 = this.data[70];
                    if (n3 != 0 && n3 != n6) {
                        n2 = 10;
                        sSLException = new SSLException(2, 1018, this.data, 70, 5);
                        break block31;
                    }
                    if (!(n6 == 23 && this.enabled || n6 == 20 || n6 == 21 || n6 == 22)) {
                        if ((n6 & 0x80) != 0 && (n4 = (int)Util.msbf(this.data, 70, 2) & Short.MAX_VALUE) > 5 && n4 <= Short.MAX_VALUE) {
                            byArray = new byte[n4];
                            int n7 = 0;
                            while (n7 < 3) {
                                byArray[n7] = this.data[72 + n7];
                                ++n7;
                            }
                            this.header_done = false;
                            n5 = this.receive(byArray, 3, n4 - 3, n);
                            if (n5 == -1) {
                                n2 = -2;
                            } else {
                                if (n5 == 0) {
                                    return 0;
                                }
                                if (this.conn.handleHandshakeV2(byArray, n4) != -1) continue;
                            }
                        } else {
                            n2 = 10;
                            sSLException = new SSLException(2, 1018, this.data, 70, 5);
                        }
                        break block31;
                    }
                    n4 = (int)Util.msbf(this.data, 73, 2);
                    if (this.data[71] != 3 || this.data[72] != 0) {
                        n2 = 10;
                        sSLException = new SSLException(1, 1030, this.data, 70, 5);
                        break block31;
                    }
                    if (n4 > this.dataL) {
                        n5 = (this.hash != 0 ? 1024 : 0) + (this.cm != 0 ? 1024 : 0);
                        if (n4 > 16384 + n5) {
                            n2 = 10;
                            sSLException = new SSLException(1, 1014, this.data, 70, 5);
                            break block31;
                        }
                        this.dataL = 16384;
                        this.idata = new byte[75 + 16384 + 1024 + 1024];
                        System.arraycopy(this.data, 0, this.idata, 0, 75);
                        this.data = this.idata;
                        if (this.cm != 0) {
                            this.cdata = new byte[17483];
                            this.idata = this.cdata;
                        }
                    }
                    if ((n5 = this.receive(this.data, 75, n4, n)) == -1) {
                        n2 = -2;
                        break block31;
                    }
                    if (n5 == 0) {
                        return 0;
                    }
                    this.header_done = false;
                    if (this.cipher != 0) {
                        n5 = this.bulkCipher(n5);
                    }
                    if (this.hash != 0) {
                        boolean bl;
                        block32: {
                            if ((n5 -= this.hash_size) < 0) {
                                n2 = 10;
                                sSLException = new SSLException(1, 1015, this.data, 70, 5);
                                break block31;
                            }
                            this.computeMac(n5, this.mac_result, 0, (byte)n6);
                            byArray = this.data;
                            int n8 = 75 + n5;
                            byte[] byArray2 = this.mac_result;
                            int n9 = 0;
                            int n10 = this.hash_size;
                            while (--n10 >= 0) {
                                if (byArray[n8++] == byArray2[n9++]) continue;
                                bl = false;
                                break block32;
                            }
                            bl = true;
                        }
                        if (!bl) {
                            n2 = 20;
                            sSLException = new SSLException(1, 20, this.data, 70, 5);
                            break block31;
                        }
                    }
                    if (this.cm != 0) {
                        this.unzip.setInput(this.data, 75, n5);
                        n5 = this.unzip.inflate(this.idata, 75, this.dataL);
                        if (n5 == 0) {
                            throw new DataFormatException();
                        }
                        this.unzip.reset();
                    }
                    if (n6 == 23) {
                        return 75 + n5;
                    }
                    n3 = this.conn.handleData((byte)n6, this.idata, 75, n5);
                    if (n3 <= 0) break;
                }
                return n3;
            }
            catch (DataFormatException dataFormatException) {
                n2 = 30;
                sSLException = new SSLException(1, 30);
            }
            catch (InterruptedException interruptedException) {
                return 0;
            }
            catch (SSLException sSLException2) {
                return -3;
            }
            catch (Exception exception) {
                n2 = -1;
            }
        }
        return this.conn.handleException(n2, sSLException);
    }

    synchronized SSLInputStream getSSLInputStream() throws IOException {
        if (this.ssl_in == null || this.data_error == -1) {
            throw new IOException();
        }
        return this.ssl_in;
    }

    synchronized void terminate() {
        if (this.term) {
            return;
        }
        this.term = true;
        this.ssl_in = null;
        if (!this.sync) {
            this.notifyAll();
        }
    }

    synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        long l = Long.MAX_VALUE;
        while (true) {
            if (this.ssl_in == null) {
                throw new IOException();
            }
            if (this.data_len > 0) {
                if (n2 > this.data_len - this.data_start) {
                    n2 = this.data_len - this.data_start;
                }
                System.arraycopy(this.idata, this.data_start, byArray, n, n2);
                if ((this.data_start += n2) == this.data_len) {
                    this.data_len = 0;
                    this.data_start = 75;
                    if (!this.sync) {
                        this.notifyAll();
                    }
                }
                return n2;
            }
            if (this.data_error != 0) {
                if (this.data_error == -2 || this.data_error == -3) {
                    return -1;
                }
                throw new IOException();
            }
            try {
                if (!this.sync || this.closing) {
                    if (this.conn.sock.timeout != 0) {
                        if ((int)(System.currentTimeMillis() - l) > this.conn.sock.timeout) {
                            throw new InterruptedIOException();
                        }
                        l = System.currentTimeMillis();
                        this.wait(this.conn.sock.timeout);
                        continue;
                    }
                    this.wait();
                    continue;
                }
                this.data_len = this.receiveRecord(0);
                if (this.data_len >= 0) continue;
                this.data_error = this.data_len;
                this.data_len = 0;
            }
            catch (InterruptedException interruptedException) {
                throw new IOException();
            }
        }
    }

    synchronized int available() throws IOException {
        if (this.ssl_in == null) {
            throw new IOException();
        }
        if (this.sync && this.data_len == 0 && this.data_error == 0 && (this.data_len = this.receiveRecord(-1)) < 0) {
            this.data_error = this.data_len;
            this.data_len = 0;
        }
        if (this.data_error != 0) {
            if (this.data_error == -2 || this.data_error == -3) {
                return -1;
            }
            throw new IOException();
        }
        if (this.data_len > 0) {
            return this.data_len - this.data_start;
        }
        return 0;
    }
}

