/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sslight;

import com.ibm.sslight.SSLCert;
import com.ibm.sslight.SSLConnection;
import com.ibm.sslight.SSLException;

public class SSLSession {
    public static final int CLIENT = 0;
    public static final int SERVER = 1;
    int context_id;
    byte compression_method;
    short cipher_suite;
    byte[] session_id;
    SSLCert[] peer_cert;
    byte[] master_secret;
    boolean is_resumable = true;
    private SSLSession next;
    private SSLSession priv;
    private int role;
    private int ref;
    private boolean cached;
    private long time;
    private static int[] cache = new int[2];
    private static SSLSession[] first;
    private static int[] passive;
    private byte[] ip_addr;
    private int ip_port;
    private static long id_time;
    private static int id_number;

    private boolean verify(byte[] byArray, short[] sArray) {
        int n = 0;
        while (n < sArray.length && sArray[n] != this.cipher_suite) {
            ++n;
        }
        if (n == sArray.length) {
            return false;
        }
        if (byArray == null) {
            return this.compression_method == 0;
        }
        n = 0;
        while (n < byArray.length && byArray[n] != this.compression_method) {
            ++n;
        }
        return n != byArray.length;
    }

    final boolean compare(byte[] byArray) {
        block5: {
            block4: {
                boolean bl;
                block3: {
                    if (this.session_id == null || this.session_id.length != byArray.length) break block4;
                    byte[] byArray2 = this.session_id;
                    int n = 0;
                    int n2 = 0;
                    int n3 = byArray.length;
                    while (--n3 >= 0) {
                        if (byArray2[n++] == byArray[n2++]) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
                if (bl) break block5;
            }
            return false;
        }
        return true;
    }

    static synchronized byte[] newSessionId() {
        byte[] byArray = new byte[16];
        if (id_time == 0L) {
            id_time = System.currentTimeMillis() / 1000L;
        }
        long l = id_time;
        int n = 4;
        int n2 = 8;
        do {
            byArray[n++] = (byte)(l >>> --n2 * 8);
        } while (n2 > 0);
        int n3 = id_number++;
        int n4 = 12;
        n = 4;
        do {
            byArray[n4++] = (byte)(n3 >>> --n * 8);
        } while (n > 0);
        return byArray;
    }

    static void remove(SSLSession sSLSession, boolean bl) {
        if (bl) {
            sSLSession.is_resumable = false;
            if (sSLSession.ref == 0) {
                int n = sSLSession.role;
                passive[n] = passive[n] - 1;
            }
        }
        if (sSLSession.cached) {
            sSLSession.cached = false;
            if (sSLSession.priv != null) {
                sSLSession.priv.next = sSLSession.next;
            } else {
                SSLSession.first[sSLSession.role] = sSLSession.next;
            }
            if (sSLSession.next != null) {
                sSLSession.next.priv = sSLSession.priv;
            }
        }
    }

    static synchronized void install(SSLSession sSLSession, SSLConnection sSLConnection) {
        int n = sSLSession.role;
        if (sSLSession.cached && sSLSession.ref == 0) {
            int n2 = n;
            passive[n2] = passive[n2] - 1;
        }
        if (sSLConnection != null) {
            sSLConnection.session_ref = true;
            ++sSLSession.ref;
        }
        if (sSLSession.session_id == null) {
            sSLSession.is_resumable = false;
        }
        if (!sSLSession.cached && sSLSession.is_resumable) {
            sSLSession.cached = true;
            if (first[n] != null) {
                SSLSession.first[n].priv = sSLSession;
            }
            sSLSession.next = first[n];
            sSLSession.priv = null;
            SSLSession.first[n] = sSLSession;
        }
    }

    static synchronized boolean uninstall(SSLSession sSLSession, SSLConnection sSLConnection, boolean bl) {
        int n = sSLSession.role;
        if (System.currentTimeMillis() >= sSLSession.time) {
            bl = false;
        }
        boolean bl2 = sSLSession.is_resumable = sSLSession.is_resumable && bl;
        if (!sSLConnection.session_ref) {
            return false;
        }
        sSLConnection.session_ref = false;
        --sSLSession.ref;
        if (!sSLSession.is_resumable) {
            SSLSession.remove(sSLSession, false);
        } else if (sSLSession.cached && sSLSession.ref == 0) {
            int n2 = n;
            passive[n2] = passive[n2] + 1;
            if (passive[n2] > cache[n]) {
                SSLSession.setCacheSize(n, cache[n]);
            }
        }
        return sSLSession.is_resumable;
    }

    SSLSession(int n, byte by, short s, int n2) throws SSLException {
        this.role = 1;
        this.time = System.currentTimeMillis() + (long)n2;
        this.session_id = SSLSession.newSessionId();
        this.compression_method = by;
        this.cipher_suite = s;
        this.context_id = n;
    }

    static synchronized SSLSession resume(byte[] byArray, int n, byte[] byArray2, short[] sArray) {
        if (byArray == null) {
            return null;
        }
        long l = System.currentTimeMillis();
        SSLSession sSLSession = first[1];
        while (sSLSession != null) {
            if (l >= sSLSession.time) {
                SSLSession.remove(sSLSession, true);
            } else if (sSLSession.session_id != null && sSLSession.session_id.length == byArray.length) {
                boolean bl;
                block7: {
                    byte[] byArray3 = sSLSession.session_id;
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = byArray.length;
                    while (--n4 >= 0) {
                        if (byArray3[n2++] == byArray[n3++]) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
                if (bl && n == sSLSession.context_id && sSLSession.verify(byArray2, sArray)) {
                    return sSLSession;
                }
            }
            sSLSession = sSLSession.next;
        }
        return null;
    }

    SSLSession(int n, byte[] byArray, int n2, int n3) {
        this.role = 0;
        this.time = System.currentTimeMillis() + (long)n3;
        this.ip_addr = byArray;
        this.ip_port = n2;
        this.context_id = n;
    }

    static synchronized SSLSession allocate(int n, byte[] byArray, short[] sArray, byte[] byArray2, int n2, int n3) {
        if (byArray2 == null) {
            return null;
        }
        long l = System.currentTimeMillis();
        SSLSession sSLSession = first[0];
        while (sSLSession != null) {
            if (l >= sSLSession.time) {
                SSLSession.remove(sSLSession, true);
            } else if (sSLSession.ip_port == n2 || sSLSession.ip_port == 0 || n2 == 0) {
                boolean bl;
                block7: {
                    byte[] byArray3 = sSLSession.ip_addr;
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = byArray2.length;
                    while (--n6 >= 0) {
                        if (byArray3[n4++] == byArray2[n5++]) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
                if (bl && n == sSLSession.context_id && sSLSession.verify(byArray, sArray)) {
                    return sSLSession;
                }
            }
            sSLSession = sSLSession.next;
        }
        return new SSLSession(n, byArray2, n2, n3);
    }

    static synchronized boolean reinstall(SSLSession sSLSession, SSLConnection sSLConnection) {
        if (!sSLSession.is_resumable || System.currentTimeMillis() >= sSLSession.time) {
            SSLSession.uninstall(sSLSession, sSLConnection, false);
        }
        return sSLSession.is_resumable;
    }

    public synchronized void close() {
        this.is_resumable = false;
        if (this.cached) {
            SSLSession.remove(this, true);
        }
    }

    public static synchronized void setCacheSize(int n, int n2) {
        if (n == 0 || n == 1) {
            if (n2 < 0) {
                n2 = 0;
            }
            if (passive[n] > n2) {
                SSLSession sSLSession = null;
                long l = System.currentTimeMillis();
                SSLSession sSLSession2 = first[n];
                while (sSLSession2 != null) {
                    if (l >= sSLSession2.time) {
                        SSLSession.remove(sSLSession2, true);
                    }
                    sSLSession = sSLSession2;
                    sSLSession2 = sSLSession2.next;
                }
                sSLSession2 = sSLSession;
                while (passive[n] > n2 && sSLSession2 != null) {
                    SSLSession.remove(sSLSession2, true);
                    sSLSession2 = sSLSession2.priv;
                }
            }
            SSLSession.cache[n] = n2;
        }
    }

    public static synchronized int getCacheSize(int n) {
        if (n == 0 || n == 1) {
            return cache[n];
        }
        return 0;
    }

    public static synchronized int getCached(int n) {
        if (n == 0 || n == 1) {
            return passive[n];
        }
        return 0;
    }

    static {
        SSLSession.cache[0] = 100;
        SSLSession.cache[1] = 100;
        first = new SSLSession[2];
        passive = new int[2];
    }
}

