/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.ncod.services.common;

import com.ibm.eNetwork.ncod.services.common.Paintable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.StringTokenizer;

public class Caption
implements Paintable {
    public static final int DEFAULT_LENGTH = 50;
    private String label;
    private int length = 50;
    private boolean resizable = true;
    private boolean showing = true;
    private boolean selected = false;

    public Caption() {
        this("");
    }

    public Caption(String string) {
        this.label = string;
    }

    public Caption setLabel(String string) {
        this.label = string;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public Caption setLength(int n) {
        this.length = n > 0 ? n : 50;
        return this;
    }

    public int getLength() {
        return this.length;
    }

    public Caption setResizable(boolean bl) {
        this.resizable = bl;
        return this;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public Caption show() {
        this.showing = true;
        return this;
    }

    public Caption hide() {
        this.showing = false;
        return this;
    }

    public boolean isShowing() {
        return this.showing;
    }

    public Caption select() {
        this.selected = true;
        return this;
    }

    public Caption deselect() {
        this.selected = false;
        return this;
    }

    public boolean selected() {
        return this.selected;
    }

    public Dimension size() {
        return new Dimension(this.length, 20);
    }

    public void paint(Graphics graphics) {
        Color color = graphics.getColor();
        Color color2 = color.brighter().brighter().brighter();
        Color color3 = color.darker().darker().darker();
        color3.darker().darker();
        Rectangle rectangle = graphics.getClipRect();
        Font font = graphics.getFont();
        font = new Font(font.getName(), font.getStyle() & 0xFFFFFFFE, font.getSize());
        graphics.setFont(font);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n = 3 + fontMetrics.getAscent();
        StringTokenizer stringTokenizer = new StringTokenizer(this.label, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            graphics.setColor(Color.black);
            graphics.drawString(string, 4, n);
            n += fontMetrics.getHeight();
        }
        graphics.setColor(color);
        graphics.drawRect(1, 1, rectangle.width - 3, rectangle.height - 3);
        graphics.drawRect(2, 2, rectangle.width - 5, rectangle.height - 5);
        graphics.setColor(color2);
        graphics.drawLine(0, 0, rectangle.width - 1, 0);
        graphics.drawLine(0, 1, 0, rectangle.height - 1);
        graphics.setColor(color3);
        graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
        graphics.drawLine(0, rectangle.height - 1, rectangle.width - 2, rectangle.height - 1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.getClass().getName()) + "[");
        stringBuffer.append("label=" + this.label);
        stringBuffer.append(",length=" + this.length);
        if (this.resizable) {
            stringBuffer.append(",resizable");
        }
        if (this.showing) {
            stringBuffer.append(",showing");
        }
        if (this.selected) {
            stringBuffer.append(",selected");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

