/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.ncod.services.common;

import com.ibm.eNetwork.ncod.services.common.AWT;
import com.ibm.eNetwork.ncod.services.common.Caption;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;

public class CaptionBar
extends Canvas {
    private static final int MINIMUM_CAPTION_LENGTH = 12;
    private static final int DRAG_AREA_OFFSET = 3;
    private Vector captions = new Vector();
    private boolean dragPossible = false;
    private boolean dragging = false;
    private int prevX;
    private int captionDragged;
    private boolean realTimeDrag = false;
    private int captionSelected;
    private int captionOn;
    private int clickCount;
    private Image buffer;
    private Graphics bufg;
    private Dimension bufsize;

    public Caption addCaption(String string) {
        return this.addCaption(string, 50);
    }

    public Caption addCaption(String string, int n) {
        Caption caption = new Caption().setLabel(string).setLength(n);
        return this.addCaption(caption);
    }

    public Caption addCaption(Caption caption) {
        this.captions.addElement(caption);
        if (this.captions.size() == 1) {
            caption.select();
        }
        int n = this.captions.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += ((Caption)this.captions.elementAt(n3)).getLength();
            ++n3;
        }
        Dimension dimension = this.size();
        if (n2 > dimension.width) {
            this.resize(n2, dimension.height);
        }
        this.repaint();
        return caption;
    }

    public int captionCount() {
        return this.captions.size();
    }

    public Caption getCaption(int n) {
        if (n < 0 || n >= this.captions.size()) {
            return null;
        }
        return (Caption)this.captions.elementAt(n);
    }

    public CaptionBar removeCaption(int n) {
        this.captions.removeElementAt(n);
        this.repaint();
        return this;
    }

    public CaptionBar setContinuousDrag(boolean bl) {
        this.realTimeDrag = bl;
        return this;
    }

    public boolean getContinuousDrag() {
        return this.realTimeDrag;
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        return new Dimension(100, 20);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Object object;
        Dimension dimension = this.size();
        Graphics graphics2 = this.bufg;
        Color color = this.getBackground();
        try {
            if (this.buffer == null || this.bufsize.width != dimension.width || this.bufsize.height != dimension.height) {
                if (this.buffer != null) {
                    this.buffer.flush();
                    this.buffer = null;
                    this.bufg.dispose();
                }
                this.bufsize = this.size();
                this.buffer = this.createImage(this.bufsize.width, this.bufsize.height);
                graphics2 = this.bufg = this.buffer.getGraphics();
            }
            this.bufg.setColor(color);
            this.bufg.clearRect(0, 0, this.bufsize.width, this.bufsize.height);
        }
        catch (Exception exception) {
            graphics2 = graphics;
        }
        int n = 0;
        int n2 = this.captions.size();
        graphics2.setColor(color);
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        int n3 = 0;
        while (n3 < n2) {
            object = (Caption)this.captions.elementAt(n3);
            if (((Caption)object).isShowing()) {
                ((Caption)object).getLabel();
                int n4 = ((Caption)object).getLength();
                Graphics graphics3 = graphics2.create(n, 0, n4, dimension.height);
                graphics3.setColor(color);
                ((Caption)object).paint(graphics3);
                graphics3.dispose();
                n += n4;
            }
            ++n3;
        }
        if (n < dimension.width) {
            object = this.getBackground().brighter().brighter().brighter();
            Color color2 = this.getBackground().darker().darker().darker();
            graphics2.setColor((Color)object);
            graphics2.drawLine(n, 0, dimension.width - 2, 0);
            graphics2.drawLine(n, 1, n, dimension.height - 1);
            graphics2.setColor(color2);
            graphics2.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
            graphics2.drawLine(n, dimension.height - 1, dimension.width - 2, dimension.height - 1);
        }
        if (this.buffer != null) {
            graphics.drawImage(this.buffer, 0, 0, this);
        }
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 503: {
                int n = this.captions.size();
                int n2 = 0;
                int n3 = 0;
                while (n3 < n) {
                    Caption caption = (Caption)this.captions.elementAt(n3);
                    if (caption.isShowing() && caption.isResizable() && event.x >= (n2 += caption.getLength()) - 3 && event.x <= n2 + 3) {
                        AWT.setCursor(this, 11);
                        this.dragPossible = true;
                        this.captionDragged = n3;
                        this.prevX = n2;
                        return true;
                    }
                    ++n3;
                }
                if (this.dragPossible) {
                    AWT.setCursor(this, 0);
                    this.dragPossible = false;
                }
                return true;
            }
            case 501: {
                if (this.dragPossible) {
                    this.dragging = true;
                }
                int n = this.captions.size();
                int n4 = 0;
                int n5 = 0;
                while (n5 < n) {
                    Caption caption = (Caption)this.captions.elementAt(n5);
                    if (caption.isShowing()) {
                        int n6 = caption.getLength();
                        if (event.x >= n4 && event.x < n4 + n6) {
                            this.captionOn = n5;
                            this.clickCount = event.clickCount;
                            break;
                        }
                        n4 += caption.getLength();
                    }
                    ++n5;
                }
                return true;
            }
            case 506: {
                if (this.dragging) {
                    Caption caption = (Caption)this.captions.elementAt(this.captionDragged);
                    int n = event.x - this.prevX;
                    int n7 = caption.getLength();
                    if (n > 0) {
                        caption.setLength(n7 + n);
                        this.prevX = event.x;
                        this.repaint();
                    } else if (n < 0 && n7 > 12) {
                        if (n7 + n >= 10) {
                            caption.setLength(n7 + n);
                            this.prevX = event.x;
                        } else {
                            caption.setLength(12);
                        }
                        this.repaint();
                    }
                    if (this.realTimeDrag) {
                        event.clickCount = this.clickCount;
                        event.arg = new Integer(this.captionDragged);
                        return false;
                    }
                }
                return true;
            }
            case 502: {
                if (this.dragging) {
                    AWT.setCursor(this, 0);
                    this.dragPossible = false;
                    this.dragging = false;
                    if (!this.realTimeDrag) {
                        event.id = 506;
                        event.clickCount = this.clickCount;
                        event.arg = new Integer(this.captionDragged);
                        return false;
                    }
                } else {
                    int n = this.captions.size();
                    int n8 = 0;
                    int n9 = 0;
                    while (n9 < n) {
                        Caption caption = (Caption)this.captions.elementAt(n9);
                        if (caption.isShowing()) {
                            int n10 = caption.getLength();
                            if (event.x >= n8 && event.x < n8 + n10) {
                                if (n9 != this.captionOn || n9 == this.captionSelected) break;
                                ((Caption)this.captions.elementAt(this.captionSelected)).deselect();
                                caption.select();
                                this.captionSelected = n9;
                                break;
                            }
                            n8 += caption.getLength();
                        }
                        ++n9;
                    }
                    this.repaint();
                    event.id = 501;
                    event.arg = new Integer(this.captionSelected);
                    return false;
                }
                return true;
            }
            case 505: {
                if (this.dragging || !this.dragPossible) break;
                AWT.setCursor(this, 0);
                this.dragPossible = false;
                this.dragging = false;
                break;
            }
        }
        return super.handleEvent(event);
    }

    public String toString() {
        int n = this.captions.size();
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.getClass().getName()) + "[");
        stringBuffer.append("count=" + n);
        stringBuffer.append(",captions={");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(((Caption)this.captions.elementAt(n2)).getLabel());
            if (n2 < n - 1) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        stringBuffer.append("}");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

