/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.ncod.services.common;

import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.Panel;
import java.util.Enumeration;
import java.util.Vector;

public class FocusPanel
extends Panel {
    public static final int TAB_KEY = 9;
    public static final int ENTER_KEY = 10;
    public Vector components;
    protected int focus;
    private int count;
    private int nextKey;
    private int previousKey;
    private int enterKey;
    private boolean standard = false;
    private boolean checkEnterEvent = true;

    public FocusPanel() {
        this(9, 0, 10);
        this.standard = true;
    }

    public FocusPanel(int n, int n2, int n3) {
        this.nextKey = n;
        this.previousKey = n2;
        this.enterKey = n3;
        this.components = new Vector();
    }

    public void addComponent(Component component) {
        this.components.addElement(component);
    }

    public void removeComponent(Component component) {
        this.components.removeElement(component);
    }

    public void setFocus(Component component) {
        if (this.components.indexOf(component) != -1) {
            this.focus = this.components.indexOf(component);
        }
    }

    public boolean keyDown(Event event, int n) {
        if (!this.components.isEmpty()) {
            if (n == this.nextKey) {
                this.count = 0;
                if (event.shiftDown() && this.standard) {
                    this.previous_Focus();
                } else {
                    this.next_Focus();
                }
                return true;
            }
            if (n == this.previousKey && !this.standard) {
                this.count = 0;
                this.previous_Focus();
                return true;
            }
            if (n == this.enterKey) {
                Component component = (Component)this.components.elementAt(this.focus);
                if (component instanceof Button) {
                    this.deliverEvent(new Event(component, 1001, component));
                } else if (this.checkEnterEvent) {
                    int n2 = 0;
                    while (n2 < this.components.size()) {
                        component = (Component)this.components.elementAt(n2);
                        if (component instanceof Button && component.isShowing() && component.isEnabled()) {
                            this.deliverEvent(new Event(component, 1001, component));
                            return true;
                        }
                        ++n2;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void disableEnterEvent() {
        this.checkEnterEvent = false;
    }

    private void next_Focus() {
        ++this.focus;
        ++this.count;
        if (this.focus >= this.components.size()) {
            this.focus = 0;
        }
        if (this.count <= this.components.size()) {
            Component component = (Component)this.components.elementAt(this.focus);
            if (component.isShowing() && component.isEnabled()) {
                component.requestFocus();
                return;
            }
            this.next_Focus();
        }
    }

    private void previous_Focus() {
        --this.focus;
        ++this.count;
        if (this.focus < 0) {
            this.focus = this.components.size() - 1;
        }
        if (this.count <= this.components.size()) {
            Component component = (Component)this.components.elementAt(this.focus);
            if (component.isShowing() && component.isEnabled()) {
                component.requestFocus();
                return;
            }
            this.previous_Focus();
        }
    }

    private void checkComponents(Component component) {
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            Component component2 = (Component)enumeration.nextElement();
            if (component2 != component) continue;
            this.setFocus(component);
        }
    }

    public boolean gotFocus(Event event, Object object) {
        if (event.target == this && this.isEnabled()) {
            --this.focus;
            this.count = 0;
            this.next_Focus();
            return true;
        }
        return false;
    }

    public boolean handleEvent(Event event) {
        if (event.id != 503 && event.id != 1005) {
            this.checkComponents((Component)event.target);
        }
        return super.handleEvent(event);
    }

    public void resetFocus() {
        this.focus = -1;
        this.count = 0;
        this.next_Focus();
    }
}

