/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.ncod.services.common;

import com.ibm.eNetwork.ncod.services.common.Caption;
import com.ibm.eNetwork.ncod.services.common.CaptionBar;
import com.ibm.eNetwork.ncod.services.common.ListboxCaption;
import com.ibm.eNetwork.ncod.services.common.Sorter;
import java.awt.Color;
import java.util.Vector;

public class ListboxColumn {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int DEFAULT_ALIGNMENT = 0;
    private Vector data = new Vector();
    private CaptionBar bar;
    private Caption caption;
    private boolean sortable;
    private Sorter sorter;
    private int alignment;
    private Color background;
    private Color foreground;

    public ListboxColumn(CaptionBar captionBar, Caption caption) {
        this.bar = captionBar;
        this.caption = caption;
        this.sortable = false;
        this.sorter = null;
        this.alignment = 0;
        this.foreground = null;
        this.background = null;
    }

    public ListboxColumn setLabel(String string) {
        this.caption.setLabel(string);
        this.bar.repaint();
        return this;
    }

    public String getLabel() {
        return this.caption.getLabel();
    }

    public ListboxColumn setResizable(boolean bl) {
        this.caption.setResizable(bl);
        return this;
    }

    public boolean isResizable() {
        return this.caption.isResizable();
    }

    public ListboxColumn setWidth(int n) {
        this.caption.setLength(n);
        this.bar.repaint();
        return this;
    }

    public int getWidth() {
        return this.caption.getLength();
    }

    public ListboxColumn setSorter(Sorter sorter) {
        this.sortable = sorter != null;
        ((ListboxCaption)this.caption).setSortable(this.sortable);
        this.sorter = sorter;
        return this;
    }

    public Sorter getSorter() {
        return this.sorter;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    protected ListboxColumn setState(boolean bl) {
        ((ListboxCaption)this.caption).setState(bl);
        this.bar.repaint();
        return this;
    }

    protected boolean getState() {
        return ((ListboxCaption)this.caption).getState();
    }

    public ListboxColumn setAlignment(int n) {
        this.alignment = n;
        return this;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public ListboxColumn show() {
        this.caption.show();
        this.bar.repaint();
        return this;
    }

    public ListboxColumn hide() {
        this.caption.hide();
        this.bar.repaint();
        return this;
    }

    public boolean isShown() {
        return this.caption.isShowing();
    }

    public boolean selected() {
        return this.caption.selected();
    }

    public ListboxColumn setBackground(Color color) {
        this.background = color;
        return this;
    }

    public Color getBackground() {
        return this.background;
    }

    public ListboxColumn setForeground(Color color) {
        this.foreground = color;
        return this;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public int size() {
        return this.data.size();
    }

    protected ListboxColumn addElement(Object object) {
        this.data.addElement(object);
        return this;
    }

    protected ListboxColumn removeElementAt(int n) {
        this.data.removeElementAt(n);
        return this;
    }

    public ListboxColumn setElementAt(Object object, int n) {
        this.data.setElementAt(object, n);
        return this;
    }

    public ListboxColumn insertElementAt(Object object, int n) {
        this.data.insertElementAt(object, n);
        return this;
    }

    protected ListboxColumn removeAllElements() {
        this.data.removeAllElements();
        return this;
    }

    public Object elementAt(int n) {
        return this.data.elementAt(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.getClass().getName()) + "[");
        stringBuffer.append("data=" + this.data);
        stringBuffer.append(",caption=" + this.caption.getLabel());
        stringBuffer.append(",sortable=" + this.sortable);
        stringBuffer.append(",sorter=" + this.sorter);
        stringBuffer.append(",alignment=");
        switch (this.alignment) {
            case 0: {
                stringBuffer.append("LEFT");
                break;
            }
            case 1: {
                stringBuffer.append("CENTER");
                break;
            }
            case 2: {
                stringBuffer.append("RIGHT");
                break;
            }
            default: {
                stringBuffer.append("unknown");
            }
        }
        stringBuffer.append(",background=" + this.background);
        stringBuffer.append(",foreground=" + this.foreground);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

