/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.ncod.services.common;

import com.ibm.eNetwork.ncod.services.common.ListboxColumn;
import com.ibm.eNetwork.ncod.services.common.MultiColumnListbox;
import com.ibm.eNetwork.ncod.services.common.Paintable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;
import java.util.BitSet;
import java.util.Vector;

public class ListboxView
extends Panel {
    private MultiColumnListbox parent;
    private int place;
    private int showing;
    private int lastplace = -1;
    private Image buffer;
    private Graphics bufg;
    private Dimension bufsize;

    public ListboxView(MultiColumnListbox multiColumnListbox) {
        this.parent = multiColumnListbox;
        this.setLayout(null);
    }

    public ListboxView setPlace(int n) {
        if (this.place != n) {
            this.lastplace = this.place;
            this.place = n;
            this.repaint();
        }
        return this;
    }

    public int getPlace() {
        return this.place;
    }

    public int getShowing() {
        return this.showing;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
        System.gc();
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        Dimension dimension = this.size();
        int n3 = this.parent.getRowHeight();
        Graphics graphics2 = this.bufg;
        try {
            if (this.buffer == null || this.bufsize.width != dimension.width || this.bufsize.height != dimension.height) {
                if (this.buffer != null) {
                    this.buffer.flush();
                    this.buffer = null;
                    this.bufg.dispose();
                }
                this.bufsize = dimension;
                this.buffer = this.createImage(this.bufsize.width, this.bufsize.height);
                graphics2 = this.bufg = this.buffer.getGraphics();
            }
            this.bufg.setColor(this.getBackground());
            this.bufg.clearRect(0, 0, this.bufsize.width, this.bufsize.height);
        }
        catch (Exception exception) {
            graphics2 = graphics;
        }
        Vector vector = this.parent.columns;
        int n4 = 0;
        if (vector.size() != 0 && ((ListboxColumn)vector.firstElement()).size() != 0) {
            n2 = ((ListboxColumn)vector.firstElement()).size();
            this.showing = dimension.height / n3;
            n = this.place;
            while (n < n2) {
                this.paintRow(graphics2, n);
                if ((n4 += n3) > dimension.height) break;
                ++n;
            }
        }
        if (n4 < dimension.height) {
            n2 = dimension.width;
            n = dimension.height - n4;
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(0, n4, n2, n);
        }
        if (this.buffer != null) {
            graphics.drawImage(this.buffer, 0, 0, this);
        }
        this.parent.resetVerticalScrollbar();
    }

    public ListboxView paintRow(int n) {
        if (this.buffer == null) {
            this.repaint();
        } else {
            this.paintRow(this.bufg, n);
            try {
                this.getGraphics().drawImage(this.buffer, 0, 0, this);
            }
            catch (Exception exception) {
                this.repaint();
            }
        }
        return this;
    }

    protected ListboxView paintRow(Graphics graphics, int n) {
        Object object;
        if (n < this.place || n > this.place + this.showing) {
            return this;
        }
        Object[] objectArray = this.parent.getRow(n);
        if (objectArray.length < 1) {
            return this;
        }
        Vector vector = this.parent.columns;
        BitSet bitSet = this.parent.selected;
        Dimension dimension = this.size();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        int n2 = this.parent.getRowHeight();
        int n3 = 0;
        int n4 = (n - this.place) * n2;
        int n5 = 0;
        while (n5 < vector.size()) {
            object = (ListboxColumn)vector.elementAt(n5);
            if (((ListboxColumn)object).isShown()) {
                int n6 = ((ListboxColumn)object).getWidth();
                if (n3 + n6 > dimension.width) {
                    n6 = dimension.width - n3;
                }
                Graphics graphics2 = graphics.create(n3, n4, n6, n2);
                graphics2.setFont(this.getFont());
                Color color = null;
                if (bitSet.get(n)) {
                    color = this.parent.getSelectionBackground();
                    if (color == null) {
                        color = Color.gray;
                    }
                    graphics2.setColor(color);
                    graphics2.fillRect(0, 0, n6, n2);
                    if (this.parent.hasFocus()) {
                        color = this.parent.getSelectionForeground();
                        if (color == null) {
                            color = MultiColumnListbox.DEFAULT_SELECTED_FOREGROUND;
                        }
                        graphics2.setColor(color);
                        if (n5 == 0) {
                            graphics2.drawLine(1, 1, 1, n2 - 2);
                            graphics2.drawLine(1, 1, n6 - 1, 1);
                            graphics2.drawLine(1, n2 - 2, n6 - 1, n2 - 2);
                        } else if (n5 == vector.size() - 1) {
                            graphics2.drawLine(0, 1, n6 - 2, 1);
                            graphics2.drawLine(0, n2 - 2, n6 - 2, n2 - 2);
                            graphics2.drawLine(n6 - 2, 1, n6 - 2, n2 - 2);
                            graphics2.setColor(color);
                            graphics2.drawLine(n6 - 3, 2, n6 - 3, n2 - 3);
                            graphics2.drawLine(n6 - 1, 1, n6 - 1, n2 - 2);
                        } else {
                            graphics2.drawLine(0, 1, n6, 1);
                            graphics2.drawLine(0, n2 - 2, n6, n2 - 2);
                        }
                    }
                    if ((color = this.parent.getSelectionForeground()) == null) {
                        color = Color.black;
                    }
                    graphics2.setColor(color);
                } else {
                    color = ((ListboxColumn)object).getBackground();
                    if (color == null) {
                        color = this.getBackground();
                    }
                    graphics2.setColor(color);
                    graphics2.fillRect(0, 0, n6, n2);
                    color = ((ListboxColumn)object).getForeground();
                    if (color == null) {
                        color = this.getForeground();
                    }
                    graphics2.setColor(color);
                }
                if (this.parent.vsep || this.parent.hsep) {
                    graphics2.clipRect(0, 0, n6 - (this.parent.vsep ? 3 : 2), n2 - (this.parent.hsep ? 1 : 0));
                }
                if (objectArray[n5] instanceof Paintable) {
                    ((Paintable)objectArray[n5]).paint(graphics2);
                } else {
                    String string = this.parent.paintHook(objectArray[n5].toString(), n, n5);
                    int n7 = 0;
                    switch (((ListboxColumn)object).getAlignment()) {
                        case 1: {
                            n7 = (n6 - fontMetrics.stringWidth(string)) / 2;
                            break;
                        }
                        case 2: {
                            n7 = n6 - 4 - fontMetrics.stringWidth(string);
                            break;
                        }
                        default: {
                            n7 = 2;
                        }
                    }
                    graphics2.drawString(string, n7, fontMetrics.getAscent() + 2);
                }
                if (bitSet.get(n) && n5 == vector.size() - 1) {
                    color = this.parent.getSelectionBackground();
                    if (color == null) {
                        color = MultiColumnListbox.DEFAULT_SELECTED_BACKGROUND;
                    }
                    graphics2.setColor(color);
                    graphics2.drawLine(n6 - 3, 2, n6 - 3, n2 - 3);
                    graphics2.drawLine(n6 - 4, 2, n6 - 4, n2 - 3);
                    graphics2.drawLine(n6 - 1, 0, n6 - 1, n2 - 1);
                    graphics2.drawLine(n6, 0, n6, n2 - 1);
                }
                graphics2.dispose();
                if (this.parent.vsep) {
                    graphics.setColor(Color.black);
                    graphics.drawLine(n3 + n6 - 1, n4, n3 + n6 - 1, n4 + n2 - 1);
                }
                if (this.parent.hsep) {
                    graphics.setColor(Color.black);
                    graphics.drawLine(n3, n4 + n2 - 1, n3 + n6 - 1, n4 + n2 - 1);
                }
                if ((n3 += n6) > dimension.width) break;
            }
            ++n5;
        }
        if (n3 < dimension.width) {
            object = null;
            if (bitSet.get(n)) {
                object = this.parent.getSelectionBackground();
                if (object == null) {
                    object = Color.gray;
                }
                graphics.setColor((Color)object);
            } else {
                graphics.setColor(this.getBackground());
            }
            graphics.fillRect(n3, n4, dimension.width - n3, n2);
            if (this.parent.hsep) {
                graphics.setColor(Color.black);
                graphics.drawLine(n3, n4 + n2 - 1, dimension.width - 1, n4 + n2 - 1);
            }
        }
        return this;
    }
}

