/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.ncod.services.common;

import com.ibm.eNetwork.ncod.services.common.Caption;
import com.ibm.eNetwork.ncod.services.common.CaptionBar;
import com.ibm.eNetwork.ncod.services.common.ListboxCaption;
import com.ibm.eNetwork.ncod.services.common.ListboxCaptionBar;
import com.ibm.eNetwork.ncod.services.common.ListboxColumn;
import com.ibm.eNetwork.ncod.services.common.ListboxView;
import com.ibm.eNetwork.ncod.services.common.Paintable;
import com.ibm.eNetwork.ncod.services.common.Scroller;
import com.ibm.eNetwork.ncod.services.common.Sorter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Toolkit;
import java.util.BitSet;
import java.util.Vector;

public class MultiColumnListbox
extends Panel {
    public static final Object DEFAULT_KEY = null;
    public static final int DEFAULT_ROW_HEIGHT = 20;
    public static final int DEFAULT_CAPTIONBAR_HEIGHT = 20;
    public static final Color DEFAULT_SELECTED_BACKGROUND = new Color(0, 0, 128);
    public static final Color DEFAULT_SELECTED_FOREGROUND = Color.white;
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.lightGray;
    protected ListboxCaptionBar bar;
    private ListboxView listarea;
    private Scroller vbar;
    private Scroller hbar;
    private boolean showcapbar = true;
    private int lastcaption;
    private int capbarheight = 20;
    protected int rowheight = 20;
    protected Vector columns;
    private Vector keys;
    protected BitSet selected;
    private boolean multipleSelectionsOK = false;
    private boolean showhbar = true;
    private boolean showborder = false;
    private boolean selectable = true;
    protected boolean vsep = false;
    protected boolean hsep = false;
    private Color selectedbackground;
    private Color selectedforeground;
    private int mousedownrow;
    private int lastselected = -1;
    private long clicktime;
    private int MessageCol = 4;
    private int horzPlace;
    private boolean inFocus = false;
    private int clickCount;

    public MultiColumnListbox() {
        this.setLayout(null);
        this.setForeground(Color.black);
        this.listarea = new ListboxView(this);
        this.add(this.listarea);
        this.vbar = new Scroller(1);
        this.vbar.disable();
        this.add(this.vbar);
        this.hbar = new Scroller(0);
        this.hbar.disable();
        this.add(this.hbar);
        this.bar = new ListboxCaptionBar();
        this.bar.setContinuousDrag(false);
        this.bar.setBackground(Color.lightGray);
        this.add(this.bar);
        this.columns = new Vector();
        this.keys = new Vector();
        this.selected = new BitSet();
        this.selectedbackground = DEFAULT_SELECTED_BACKGROUND;
        this.selectedforeground = DEFAULT_SELECTED_FOREGROUND;
        this.setCaptionBarBackground(DEFAULT_BACKGROUND_COLOR);
        this.setScrollbarBackground(DEFAULT_BACKGROUND_COLOR);
        this.setBackground(DEFAULT_BACKGROUND_COLOR);
    }

    public void setSelectable(boolean bl) {
        if (this.selectable != bl) {
            this.selectable = bl;
            if (!bl) {
                this.deselectAllRows();
            }
        }
    }

    public void hideVScrollBar() {
    }

    public void showVScrollBar() {
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public MultiColumnListbox setHorizontalInc(int n) {
        this.hbar.setPageIncrement(n);
        return this;
    }

    public int getHorizontalInc() {
        return this.hbar.getPageIncrement();
    }

    public MultiColumnListbox setCaptionBarBackground(Color color) {
        this.bar.setBackground(color);
        return this;
    }

    public Color setCaptionBarBackground() {
        return this.bar.getBackground();
    }

    public MultiColumnListbox setCaptionBarForeground(Color color) {
        this.bar.setForeground(color);
        return this;
    }

    public Color getCaptionBarForeground() {
        return this.bar.getForeground();
    }

    public MultiColumnListbox setScrollbarBackground(Color color) {
        this.hbar.setBackground(color);
        this.vbar.setBackground(color);
        return this;
    }

    public Color getScrollbarBackground() {
        return this.hbar.getBackground();
    }

    public MultiColumnListbox setScrollbarForeground(Color color) {
        this.hbar.setForeground(color);
        this.vbar.setForeground(color);
        return this;
    }

    public Color getScrollbarForeground() {
        return this.hbar.getForeground();
    }

    public MultiColumnListbox autoSizeColumn(int n) {
        try {
            FontMetrics fontMetrics;
            int n2;
            ListboxColumn listboxColumn = (ListboxColumn)this.columns.elementAt(n);
            int n3 = listboxColumn.size();
            int n4 = 0;
            Font font = this.bar.getFont();
            if (listboxColumn.getState()) {
                font = new Font(font.getName(), font.getStyle(), font.getSize());
            }
            if ((n2 = (fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font)).stringWidth(listboxColumn.getLabel()) + 38) > n4) {
                n4 = n2;
            }
            fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
            int n5 = 0;
            while (n5 < n3) {
                Object object = listboxColumn.elementAt(n5);
                int n6 = 0;
                n6 = object instanceof Paintable ? ((Paintable)object).size().width : fontMetrics.stringWidth(object.toString()) + 24;
                if (n6 > n4) {
                    n4 = n6;
                }
                ++n5;
            }
            listboxColumn.setWidth(n4);
            this.bar.repaint();
            this.listarea.repaint();
        }
        catch (Exception exception) {}
        return this;
    }

    private MultiColumnListbox horizontalScrollAdjustment() {
        Dimension dimension = this.size();
        int n = this.vbar.preferredSize().width;
        int n2 = this.hbar.preferredSize().height;
        int n3 = 0;
        int n4 = 0;
        this.autoSizeColumn(this.MessageCol);
        int n5 = this.hbar.getValue();
        int n6 = 0;
        while (n6 <= this.MessageCol) {
            n4 += this.bar.getCaption(n6).getLength();
            ++n6;
        }
        int n7 = 0;
        while (n7 < n5) {
            n3 += n4 / 4;
            ++n7;
        }
        int n8 = this.capbarheight;
        if (this.showcapbar) {
            this.bar.reshape(-n3, 0, dimension.width + n3, this.capbarheight);
            this.bar.repaint();
        } else {
            n8 = 0;
        }
        this.listarea.repaint();
        this.listarea.reshape(-n3, n8, dimension.width + n3 - n, dimension.height - n8 - (this.showhbar ? n2 : 0));
        return this;
    }

    protected MultiColumnListbox resetVerticalScrollbar() {
        int n = this.listarea.getPlace();
        int n2 = this.listarea.getShowing();
        int n3 = 0;
        int n4 = 0;
        if (this.columns.size() > 0 && (n4 = ((ListboxColumn)this.columns.firstElement()).size() - this.listarea.getShowing()) < 0) {
            n4 = 0;
        }
        this.vbar.setValues(n, n2, n3, n4);
        this.vbar.setPageIncrement(n2 != 0 ? n2 : 1);
        if (n4 == 0) {
            this.vbar.disable();
        } else {
            this.vbar.enable();
        }
        return this;
    }

    protected MultiColumnListbox resetHorizontalScrollbar() {
        int n = this.hbar.getValue();
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.bar.captionCount();
        int n6 = n;
        while (n6 < n5) {
            Caption caption = this.bar.getCaption(n6);
            if (caption.isShowing()) {
                ++n4;
            }
            ++n6;
        }
        this.hbar.setValues(n, n2, n3, n4 - 1);
        if (n4 - n3 == 0) {
            this.hbar.disable();
        } else {
            this.hbar.enable();
        }
        return this;
    }

    public MultiColumnListbox showCaptionBar() {
        if (!this.showcapbar) {
            this.showcapbar = true;
            this.bar.show();
            this.resize(this.size());
        }
        return this;
    }

    public MultiColumnListbox hideCaptionBar() {
        if (this.showcapbar) {
            this.showcapbar = false;
            this.bar.hide();
            this.resize(this.size());
        }
        return this;
    }

    public boolean captionBarShowing() {
        return this.showcapbar;
    }

    public MultiColumnListbox setCaptionBarHeight(int n) {
        if (n > 0 && n != this.capbarheight) {
            this.capbarheight = n;
            this.resize(this.size());
        }
        return this;
    }

    public int getCaptionBarHeight() {
        return this.capbarheight;
    }

    public MultiColumnListbox setContinuousDrag(boolean bl) {
        this.bar.setContinuousDrag(bl);
        return this;
    }

    public boolean getContinuousDrag() {
        return this.bar.getContinuousDrag();
    }

    public MultiColumnListbox setRowHeight(int n) {
        if (this.rowheight != n) {
            this.rowheight = n;
            this.listarea.repaint();
        }
        return this;
    }

    public int getRowHeight() {
        return this.rowheight;
    }

    public MultiColumnListbox selectColumn(int n) {
        if (n < 0 || n > this.columns.size() - 1) {
            return this;
        }
        this.bar.getCaption(n).select();
        this.bar.repaint();
        this.sort();
        return this;
    }

    public MultiColumnListbox makeRowVisible(int n) {
        if (this.columns.size() == 0) {
            return this;
        }
        if (n < 0 || n > ((ListboxColumn)this.columns.firstElement()).size() - 1) {
            return this;
        }
        int n2 = this.listarea.getPlace();
        int n3 = this.listarea.getShowing();
        if (n < n2 || n > n2 + n3) {
            this.listarea.setPlace(n);
            this.resetVerticalScrollbar();
        }
        return this;
    }

    public MultiColumnListbox makeColumnVisible(int n) {
        int n2 = this.bar.captionCount();
        if (n2 == 0 || n < 0 || n >= n2) {
            return this;
        }
        this.hbar.setValue(n);
        this.resize(this.size());
        return this;
    }

    public int countColumns() {
        return this.columns.size();
    }

    public MultiColumnListbox sort() {
        if (this.columns.size() == 0 || ((ListboxColumn)this.columns.firstElement()).size() < 2) {
            return this;
        }
        this.bar.setSortValid(true);
        int n = 0;
        while (n < this.columns.size()) {
            ListboxColumn listboxColumn = (ListboxColumn)this.columns.elementAt(n);
            if (listboxColumn.selected()) {
                Sorter sorter = listboxColumn.getSorter();
                if (sorter == null) break;
                if (listboxColumn.getState()) {
                    sorter.setSortOrder(1);
                } else {
                    sorter.setSortOrder(0);
                }
                int[] nArray = sorter.sort(this.getColumn(n));
                Object[][] objectArray = new Object[nArray.length][this.columns.size()];
                Object[] objectArray2 = new Object[nArray.length];
                BitSet bitSet = new BitSet(this.selected.size());
                int n2 = 0;
                while (n2 < nArray.length) {
                    objectArray[n2] = this.getRow(nArray[n2]);
                    objectArray2[n2] = this.keys.elementAt(nArray[n2]);
                    if (this.selected.get(nArray[n2])) {
                        bitSet.set(n2);
                    }
                    ++n2;
                }
                this.selected = bitSet;
                int n3 = 0;
                while (n3 < nArray.length) {
                    this.replaceRow(objectArray[n3], n3);
                    this.keys.setElementAt(objectArray2[n3], n3);
                    ++n3;
                }
                break;
            }
            ++n;
        }
        return this;
    }

    public boolean allowsMultipleSelections() {
        return this.multipleSelectionsOK;
    }

    public MultiColumnListbox setMultipleSelections(boolean bl) {
        this.multipleSelectionsOK = bl;
        return this;
    }

    public MultiColumnListbox showBorder() {
        return this;
    }

    public MultiColumnListbox hideBorder() {
        return this;
    }

    public boolean borderShown() {
        return this.showborder;
    }

    public MultiColumnListbox selectRow(int n) {
        ListboxColumn listboxColumn = (ListboxColumn)this.columns.firstElement();
        if (listboxColumn != null && n >= 0 && n < listboxColumn.size()) {
            if (!this.multipleSelectionsOK) {
                this.deselectAllRows();
            }
            this.selected.set(n);
            this.listarea.repaint();
            this.lastselected = n;
        }
        return this;
    }

    public MultiColumnListbox selectAllRows() {
        if (this.multipleSelectionsOK) {
            int n = 0;
            while (n < this.selected.size()) {
                this.selected.set(n);
                ++n;
            }
            this.listarea.repaint();
            this.lastselected = 0;
        }
        return this;
    }

    public MultiColumnListbox selectRowByKey(Object object) {
        int n = 0;
        while (n < this.keys.size()) {
            if (object.equals(this.keys.elementAt(n))) {
                if (!this.multipleSelectionsOK) {
                    this.deselectAllRows();
                }
                this.selected.set(n);
                this.lastselected = n;
                break;
            }
            ++n;
        }
        this.listarea.repaint();
        return this;
    }

    public MultiColumnListbox deselectRow(int n) {
        ListboxColumn listboxColumn = (ListboxColumn)this.columns.firstElement();
        if (listboxColumn != null && n >= 0 && n < listboxColumn.size()) {
            if (!this.multipleSelectionsOK) {
                this.deselectAllRows();
            } else {
                this.selected.clear(n);
                if (this.lastselected == n) {
                    this.lastselected = -1;
                }
            }
            this.listarea.repaint();
        }
        return this;
    }

    public MultiColumnListbox deselectAllRows() {
        int n = 0;
        while (n < this.selected.size()) {
            this.selected.clear(n);
            ++n;
        }
        this.listarea.repaint();
        this.lastselected = -1;
        return this;
    }

    public MultiColumnListbox deselectRowByKey(Object object) {
        int n = 0;
        while (n < this.keys.size()) {
            if (object.equals(this.keys.elementAt(n))) {
                if (!this.multipleSelectionsOK) {
                    this.deselectAllRows();
                    break;
                }
                this.selected.clear(n);
                if (this.lastselected != n) break;
                this.lastselected = -1;
                break;
            }
            ++n;
        }
        this.listarea.repaint();
        return this;
    }

    public int countRows() {
        if (this.columns.size() < 1) {
            return 0;
        }
        return ((ListboxColumn)this.columns.firstElement()).size();
    }

    public MultiColumnListbox showHorizontalSeparator() {
        if (!this.hsep) {
            this.hsep = true;
            this.listarea.repaint();
        }
        return this;
    }

    public MultiColumnListbox hideHorizontalSeparator() {
        if (this.hsep) {
            this.hsep = false;
            this.listarea.repaint();
        }
        return this;
    }

    public boolean horizontalSeparatorShown() {
        return this.hsep;
    }

    public MultiColumnListbox showVerticalSeparator() {
        if (!this.vsep) {
            this.vsep = true;
            this.listarea.repaint();
        }
        return this;
    }

    public MultiColumnListbox hideVerticalSeparator() {
        if (this.vsep) {
            this.vsep = false;
            this.listarea.repaint();
        }
        return this;
    }

    public boolean verticalSeparatorShown() {
        return this.vsep;
    }

    public ListboxColumn addColumn(String string) {
        Caption caption = new ListboxCaption(this.bar).setLabel(string);
        this.bar.addCaption(caption);
        ListboxColumn listboxColumn = new ListboxColumn(this.bar, caption);
        this.columns.addElement(listboxColumn);
        if (this.columns.size() > 1) {
            ListboxColumn listboxColumn2 = (ListboxColumn)this.columns.lastElement();
            int n = ((ListboxColumn)this.columns.firstElement()).size();
            int n2 = 0;
            while (n2 < n) {
                listboxColumn2.addElement("");
                ++n2;
            }
        }
        this.repaint();
        this.resetHorizontalScrollbar();
        return listboxColumn;
    }

    public MultiColumnListbox addColumns(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.addColumn(stringArray[n]);
            ++n;
        }
        return this;
    }

    public MultiColumnListbox deleteColumn(int n) {
        if (n < 0 || n > this.columns.size() - 1) {
            return this;
        }
        this.bar.removeCaption(n);
        this.columns.removeElementAt(n);
        if (this.columns.size() == 0) {
            this.keys.removeAllElements();
            this.selected = new BitSet();
        }
        this.repaint();
        this.resetHorizontalScrollbar();
        return this;
    }

    public ListboxColumn getColumnInfo(int n) {
        if (n < 0 || n > this.columns.size() - 1) {
            return null;
        }
        return (ListboxColumn)this.columns.elementAt(n);
    }

    public MultiColumnListbox addRow(Object[] objectArray) {
        return this.addRow(objectArray, null);
    }

    public MultiColumnListbox addRow(Object[] objectArray, Object object) {
        Object object2;
        int n;
        int n2 = this.columns.size();
        int n3 = n = objectArray == null ? 0 : objectArray.length;
        if (n2 == 0) {
            return this;
        }
        int n4 = 0;
        while (n4 < n2) {
            object2 = (ListboxColumn)this.columns.elementAt(n4);
            if (n4 < n) {
                ((ListboxColumn)object2).addElement(objectArray[n4]);
            } else {
                ((ListboxColumn)object2).addElement("");
            }
            ++n4;
        }
        this.keys.addElement(object);
        object2 = new BitSet(this.selected.size());
        ((BitSet)object2).or(this.selected);
        this.selected = object2;
        int n5 = ((ListboxColumn)this.columns.firstElement()).size();
        int n6 = n5 - 1;
        int n7 = this.listarea.getPlace();
        int n8 = this.listarea.getShowing();
        if (n6 == 0 || n6 >= n7 && n6 < n7 + n8) {
            this.listarea.repaint();
        } else {
            this.resetVerticalScrollbar();
        }
        return this;
    }

    public MultiColumnListbox addRows(Object[][] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.addRow(objectArray[n], null);
            ++n;
        }
        return this;
    }

    public MultiColumnListbox addRows(Object[][] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return this;
        }
        int n = 0;
        while (n < objectArray.length) {
            Object object = n < objectArray2.length ? objectArray2[n] : null;
            this.addRow(objectArray[n], object);
            ++n;
        }
        return this;
    }

    public MultiColumnListbox insertRow(Object[] objectArray, int n) {
        return this.insertRow(objectArray, null, n);
    }

    public MultiColumnListbox insertRow(Object[] objectArray, Object object, int n) {
        Object object2;
        int n2 = objectArray == null ? 0 : objectArray.length;
        int n3 = this.columns.size();
        if (this.columns.size() == 0) {
            return this;
        }
        int n4 = ((ListboxColumn)this.columns.firstElement()).size() - 1;
        if (n < 0) {
            n = 0;
        } else if (n > n4 - 1) {
            n = n4 - 1;
        }
        int n5 = 0;
        while (n5 < n3) {
            object2 = (ListboxColumn)this.columns.elementAt(n5);
            if (n5 < n2) {
                ((ListboxColumn)object2).insertElementAt(objectArray[n5], n);
            } else {
                ((ListboxColumn)object2).insertElementAt("", n);
            }
            ++n5;
        }
        this.keys.insertElementAt(object, n);
        object2 = new BitSet(n4 + 2);
        int n6 = n4;
        while (n6 >= n) {
            if (this.selected.get(n6)) {
                ((BitSet)object2).set(n6 + 1);
            } else {
                ((BitSet)object2).clear(n6 + 1);
            }
            --n6;
        }
        ((BitSet)object2).clear(n);
        ((BitSet)object2).or(this.selected);
        this.selected = object2;
        int n7 = ((ListboxColumn)this.columns.firstElement()).size();
        int n8 = n7 - 1;
        int n9 = this.listarea.getPlace();
        int n10 = this.listarea.getShowing();
        if (n8 >= n9 && n8 < n9 + n10) {
            this.listarea.repaint();
        } else {
            this.resetVerticalScrollbar();
        }
        return this;
    }

    public MultiColumnListbox insertRows(Object[][] objectArray, int n) {
        if (objectArray == null) {
            return this;
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            this.insertRow(objectArray[n2], null, n);
            ++n2;
        }
        return this;
    }

    public MultiColumnListbox insertRows(Object[][] objectArray, Object[] objectArray2, int n) {
        if (objectArray == null) {
            return this;
        }
        int n2 = objectArray2 == null ? 0 : objectArray2.length;
        int n3 = objectArray.length - 1;
        while (n3 >= 0) {
            if (n3 < n2) {
                this.insertRow(objectArray[n3], null, n);
            } else {
                this.insertRow(objectArray[n3], objectArray2[n3], n);
            }
            --n3;
        }
        return this;
    }

    public MultiColumnListbox replaceRow(Object[] objectArray, int n) {
        int n2;
        int n3 = this.columns.size();
        int n4 = n2 = objectArray == null ? 0 : objectArray.length;
        if (n3 == 0) {
            return this;
        }
        if (n < 0 || n > ((ListboxColumn)this.columns.firstElement()).size() - 1) {
            return this;
        }
        int n5 = 0;
        while (n5 < n3) {
            ListboxColumn listboxColumn = (ListboxColumn)this.columns.elementAt(n5);
            if (n5 < n2) {
                listboxColumn.setElementAt(objectArray[n5], n);
            } else {
                listboxColumn.setElementAt("", n);
            }
            ++n5;
        }
        int n6 = this.listarea.getPlace();
        int n7 = this.listarea.getShowing();
        if (n >= n6 && n < n6 + n7) {
            this.listarea.repaint();
        }
        return this;
    }

    public MultiColumnListbox replaceColumn(Object[] objectArray, int n) {
        if (n < 0 || n > this.columns.size() - 1) {
            return this;
        }
        ListboxColumn listboxColumn = (ListboxColumn)this.columns.elementAt(n);
        int n2 = listboxColumn.size();
        int n3 = objectArray == null ? 0 : objectArray.length;
        int n4 = 0;
        while (n4 < n2) {
            if (n4 < n3) {
                listboxColumn.setElementAt(objectArray[n4], n4);
            } else {
                listboxColumn.setElementAt("", n4);
            }
            ++n4;
        }
        this.listarea.repaint();
        return this;
    }

    public MultiColumnListbox deleteRow(int n) {
        if (this.columns.size() < 1) {
            return this;
        }
        int n2 = ((ListboxColumn)this.columns.firstElement()).size();
        if (n < 0 || n > n2 - 1) {
            return this;
        }
        int n3 = 0;
        while (n3 < this.columns.size()) {
            ListboxColumn listboxColumn = (ListboxColumn)this.columns.elementAt(n3);
            listboxColumn.removeElementAt(n);
            ++n3;
        }
        int n4 = this.listarea.getPlace();
        int n5 = this.listarea.getShowing();
        if (n >= n4 && n < n4 + n5) {
            this.listarea.repaint();
        } else {
            this.resetVerticalScrollbar();
        }
        this.keys.removeElementAt(n);
        BitSet bitSet = new BitSet(n2 - 1);
        int n6 = 0;
        while (n6 < n) {
            if (this.selected.get(n6)) {
                bitSet.set(n6);
            }
            ++n6;
        }
        int n7 = n + 1;
        while (n7 < n2) {
            if (this.selected.get(n7)) {
                bitSet.set(n7);
            }
            ++n7;
        }
        this.selected = bitSet;
        return this;
    }

    public MultiColumnListbox deleteRows(int n, int n2) {
        if (this.columns.size() < 1) {
            return this;
        }
        int n3 = ((ListboxColumn)this.columns.firstElement()).size();
        if (n2 <= 0 || n < 0 || n >= n3) {
            return this;
        }
        int n4 = 0;
        while (n4 < n2) {
            this.deleteRow(n);
            ++n4;
        }
        return this;
    }

    public int getSelectedIndex() {
        int n = 0;
        while (n < this.selected.size()) {
            if (this.selected.get(n)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int[] getSelectedIndexes() {
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        while (n < this.selected.size()) {
            if (this.selected.get(n)) {
                vector.addElement(new Integer(n));
            }
            ++n;
        }
        int[] nArray = new int[vector.size()];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = (Integer)vector.elementAt(n2);
            ++n2;
        }
        return nArray;
    }

    public Object[] getSelectedRow() {
        int n = 0;
        while (n < this.selected.size()) {
            if (this.selected.get(n)) {
                return this.getRow(n);
            }
            ++n;
        }
        return new Object[0];
    }

    public Object[][] getSelectedRows() {
        int[] nArray = this.getSelectedIndexes();
        Object[][] objectArray = new Object[nArray.length][this.getRow(0).length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = this.getRow(nArray[n]);
            ++n;
        }
        return objectArray;
    }

    public Object[] getColumn(int n) {
        if (n < 0 || n > this.columns.size() - 1) {
            return null;
        }
        ListboxColumn listboxColumn = (ListboxColumn)this.columns.elementAt(n);
        Object[] objectArray = new Object[listboxColumn.size()];
        int n2 = 0;
        while (n2 < listboxColumn.size()) {
            objectArray[n2] = listboxColumn.elementAt(n2);
            ++n2;
        }
        return objectArray;
    }

    public Object[] getRow(int n) {
        if (this.columns.size() == 0 || n < 0 || n > ((ListboxColumn)this.columns.firstElement()).size() - 1) {
            return null;
        }
        Object[] objectArray = new Object[this.columns.size()];
        int n2 = 0;
        while (n2 < this.columns.size()) {
            ListboxColumn listboxColumn = (ListboxColumn)this.columns.elementAt(n2);
            objectArray[n2] = listboxColumn.elementAt(n);
            ++n2;
        }
        return objectArray;
    }

    public Object[] getKeys() {
        if (this.columns.size() == 0 || ((ListboxColumn)this.columns.firstElement()).size() == 0) {
            return null;
        }
        int n = ((ListboxColumn)this.columns.firstElement()).size();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = this.getRowKey(n2);
            ++n2;
        }
        return objectArray;
    }

    public Object[] getRowByKey(Object object) {
        int n = 0;
        while (n < this.keys.size()) {
            if (object.equals(this.keys.elementAt(n))) {
                return this.getRow(n);
            }
            ++n;
        }
        return null;
    }

    public int getIndexByKey(Object object) {
        int n = 0;
        while (n < this.keys.size()) {
            if (object.equals(this.keys.elementAt(n))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public MultiColumnListbox setRowKey(Object object, int n) {
        if (this.columns.size() == 0 || n < 0 || n > this.keys.size() - 1) {
            return this;
        }
        this.keys.setElementAt(object, n);
        return this;
    }

    public Object getRowKey(int n) {
        if (this.columns.size() == 0 || n < 0 || n > this.keys.size() - 1) {
            return null;
        }
        return this.keys.elementAt(n);
    }

    public MultiColumnListbox clear() {
        this.bar.setSortValid(false);
        int n = 0;
        while (n < this.columns.size()) {
            ((ListboxColumn)this.columns.elementAt(n)).removeAllElements();
            ++n;
        }
        this.keys.removeAllElements();
        this.selected = new BitSet();
        this.listarea.setPlace(0).repaint();
        return this;
    }

    public MultiColumnListbox showHorizontalScrollbar() {
        if (!this.showhbar) {
            this.showhbar = true;
            this.resize(this.size());
        }
        return this;
    }

    public MultiColumnListbox hideHorizontalScrollbar() {
        if (this.showhbar) {
            this.showhbar = false;
            this.resize(this.size());
        }
        return this;
    }

    public boolean horizontalScrollbarShowing() {
        return this.showhbar;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        int n5 = this.vbar.preferredSize().width;
        int n6 = this.hbar.preferredSize().height;
        int n7 = 0;
        int n8 = this.hbar.getValue();
        int n9 = 0;
        while (n9 < n8) {
            n7 += this.bar.getCaption(n9).getLength();
            ++n9;
        }
        int n10 = this.capbarheight;
        if (this.showcapbar) {
            this.bar.reshape(-n7, 0, n3 + n7, this.capbarheight);
            this.bar.repaint();
        } else {
            n10 = 0;
        }
        this.listarea.reshape(-n7, n10, n3 + n7 - n5, n4 - n10 - (this.showhbar ? n6 : 0));
        this.vbar.reshape(n3 - n5, n10, n5, n4 - n10 - (this.showhbar ? n6 : 0));
        this.vbar.repaint();
        if (this.showhbar) {
            this.hbar.reshape(0, n4 - n6, n3 - n5, n6);
            this.repaint();
        }
        super.reshape(n, n2, n3, n4);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        return new Dimension(100, 50);
    }

    public MultiColumnListbox setSelectionBackground(Color color) {
        if (!this.selectedbackground.equals(color)) {
            this.selectedbackground = color;
            this.repaint();
        }
        return this;
    }

    public Color getSelectionBackground() {
        return this.selectedbackground;
    }

    public MultiColumnListbox setSelectionForeground(Color color) {
        if (!this.selectedforeground.equals(color)) {
            this.selectedforeground = color;
            this.repaint();
        }
        return this;
    }

    public Color getSelectionForeground() {
        return this.selectedforeground;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.listarea.repaint();
    }

    public boolean lostFocus(Event event, Object object) {
        this.inFocus = false;
        this.repaint();
        return super.lostFocus(event, object);
    }

    public boolean gotFocus(Event event, Object object) {
        this.inFocus = true;
        this.repaint();
        return super.gotFocus(event, object);
    }

    public boolean hasFocus() {
        return this.inFocus;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 1005) {
            return this.lostFocus(event, event.arg);
        }
        if (event.id == 1004) {
            return this.gotFocus(event, event.arg);
        }
        if (event.id == 401 && (event.key == 9 || event.key == 10)) {
            return false;
        }
        if (event.id == 403) {
            return this.handleKeyEvents(event);
        }
        if (event.target == this.vbar || event.target == this.hbar) {
            return this.handleScrollEvents(event);
        }
        if (event.target == this.bar) {
            return this.handleCaptionBarEvents(event);
        }
        if (event.target == this.listarea) {
            return this.handleSelectionEvents(event);
        }
        return event.target instanceof MultiColumnListbox || event.target instanceof CaptionBar || event.target instanceof ListboxView;
    }

    protected boolean handleKeyEvents(Event event) {
        if (this.columns.size() == 0) {
            return true;
        }
        if (this.horizontalScrollbarShowing()) {
            switch (event.key) {
                case 1006: 
                case 1007: {
                    event.target = this.hbar;
                    this.hbar.deliverEvent(event);
                    return true;
                }
            }
        }
        if (!this.selectable) {
            return true;
        }
        int n = ((ListboxColumn)this.columns.firstElement()).size();
        if (n == 0) {
            return true;
        }
        int n2 = this.listarea.getPlace();
        int n3 = this.listarea.getShowing();
        boolean bl = (event.modifiers & 1) != 0;
        boolean bl2 = (event.modifiers & 2) != 0;
        switch (event.key) {
            case 1004: {
                int n4 = this.lastselected;
                if (n4 == -1) {
                    n4 = 0;
                    this.selectRow(n4);
                    this.makeRowVisible(n4);
                } else if (n4 > 0) {
                    if (!bl && !bl2) {
                        this.deselectAllRows();
                    }
                    this.selectRow(--n4);
                    this.makeRowVisible(n4);
                } else {
                    return true;
                }
                event.target = this;
                event.id = 701;
                event.arg = new Integer(n4);
                return false;
            }
            case 1005: {
                int n5 = this.lastselected;
                if (n5 == -1) {
                    n5 = 0;
                    this.selectRow(n5);
                    this.makeRowVisible(n5);
                } else if (n5 < n - 1) {
                    if (!bl && !bl2) {
                        this.deselectAllRows();
                    }
                    this.selectRow(++n5);
                    if (n5 > n2 + n3 - 1) {
                        ++n2;
                        this.listarea.repaint();
                    }
                } else {
                    return true;
                }
                if (n5 < n2 || n5 > n2 + n3 - 1) {
                    this.makeRowVisible(n5);
                }
                event.target = this;
                event.id = 701;
                event.arg = new Integer(n5);
                return false;
            }
            case 1002: 
            case 1003: {
                int n6 = n2;
                if (event.key == 1002) {
                    if ((n6 -= n3) < 0) {
                        n6 = 0;
                    }
                } else if ((n6 += n3) > n - 1) {
                    n6 = n - 1;
                }
                this.deliverEvent(new Event(this.vbar, 605, new Integer(n6)));
                break;
            }
            case 1000: 
            case 1001: {
                if (!bl && !bl2) {
                    this.deselectAllRows();
                }
                if (event.key == 1000) {
                    if (this.getSelectedIndex() != 0) {
                        this.selectRow(0);
                    }
                    if (n2 > 0) {
                        this.makeRowVisible(0);
                    }
                } else {
                    if (this.getSelectedIndex() != n - 1) {
                        this.selectRow(n - 1);
                    }
                    if (n2 + n3 < n - 1) {
                        this.makeRowVisible(n - 1);
                    }
                }
                event.target = this;
                event.id = 701;
                event.arg = new Integer(this.lastselected);
                return false;
            }
        }
        return true;
    }

    protected boolean handleScrollEvents(Event event) {
        if (this.columns.size() == 0) {
            return true;
        }
        if (event.target == this.vbar) {
            int n = this.listarea.getPlace();
            this.listarea.getShowing();
            ((ListboxColumn)this.columns.firstElement()).size();
            int n2 = n;
            switch (event.id) {
                case 601: 
                case 602: 
                case 603: 
                case 604: 
                case 605: {
                    n2 = (Integer)event.arg;
                    break;
                }
            }
            if (n != n2) {
                this.listarea.setPlace(n2);
            }
        } else {
            switch (event.id) {
                case 601: 
                case 602: 
                case 603: 
                case 604: 
                case 605: {
                    this.horizontalScrollAdjustment();
                    break;
                }
            }
        }
        return true;
    }

    protected boolean handleCaptionBarEvents(Event event) {
        if (event.arg == null) {
            return true;
        }
        this.listarea.getPlace();
        this.listarea.getShowing();
        switch (event.id) {
            case 501: {
                int n = (Integer)event.arg;
                CaptionBar captionBar = (CaptionBar)event.target;
                ListboxCaption listboxCaption = (ListboxCaption)captionBar.getCaption(n);
                ListboxColumn listboxColumn = (ListboxColumn)this.columns.elementAt(n);
                if (listboxColumn.isSortable()) {
                    if (n == this.lastcaption) {
                        listboxCaption.setState(!listboxCaption.getState());
                        captionBar.repaint();
                        if (listboxCaption.getState()) {
                            listboxColumn.getSorter().setSortOrder(0);
                        } else {
                            listboxColumn.getSorter().setSortOrder(1);
                        }
                    }
                    this.lastcaption = n;
                    this.sort();
                    this.listarea.repaint();
                }
                event.target = this;
                return false;
            }
            case 506: {
                if (event.clickCount > 1) {
                    this.autoSizeColumn((Integer)event.arg);
                } else {
                    this.listarea.repaint();
                }
                event.target = this;
                return false;
            }
        }
        return true;
    }

    public boolean handleSelectionEvents(Event event) {
        if (!this.selectable) {
            return true;
        }
        if (this.columns.size() < 1) {
            return true;
        }
        int n = this.listarea.getPlace();
        this.listarea.getShowing();
        this.size();
        if (this.showcapbar) {
            event.y -= this.bar.size().height;
        }
        switch (event.id) {
            case 501: {
                int n2 = event.y / this.rowheight + n;
                long l = System.currentTimeMillis();
                this.clickCount = this.clickCount > 1 && n2 != this.mousedownrow ? 1 : (l - this.clicktime < 400L ? ++this.clickCount : 1);
                this.mousedownrow = n2;
                this.clicktime = l;
                return true;
            }
            case 502: {
                int n3 = event.y / this.rowheight + n;
                if (n3 < ((ListboxColumn)this.columns.firstElement()).size()) {
                    if (n3 != this.mousedownrow) {
                        return true;
                    }
                    event.clickCount = this.clickCount;
                    int n4 = 701;
                    if (this.multipleSelectionsOK) {
                        if ((event.modifiers & 1) != 0) {
                            if (this.lastselected == -1) {
                                this.selectRow(n3);
                            } else {
                                int n5;
                                if ((event.modifiers & 2) == 0) {
                                    int[] nArray = this.getSelectedIndexes();
                                    n5 = 0;
                                    while (n5 < nArray.length) {
                                        int n6 = nArray[n5];
                                        if (this.lastselected < n3) {
                                            if (n6 < this.lastselected || n6 > n3) {
                                                this.deselectRow(n6);
                                            }
                                        } else if (n6 < n3 || n6 > this.lastselected) {
                                            this.deselectRow(n6);
                                        }
                                        ++n5;
                                    }
                                }
                                int n7 = this.lastselected;
                                if (this.lastselected < n3) {
                                    n5 = n7;
                                    while (n5 <= n3) {
                                        this.selectRow(n5);
                                        ++n5;
                                    }
                                } else {
                                    n5 = n3;
                                    while (n5 <= n7) {
                                        this.selectRow(n5);
                                        ++n5;
                                    }
                                    this.lastselected = n3;
                                }
                            }
                        } else if ((event.modifiers & 2) != 0) {
                            if (this.selected.get(n3)) {
                                this.deselectRow(n3);
                                n4 = 702;
                            } else {
                                this.selectRow(n3);
                            }
                        } else if (this.selected.get(n3) && this.getSelectedIndex() == -1) {
                            this.deselectRow(n3);
                            n4 = 702;
                        } else {
                            this.deselectAllRows();
                            this.selectRow(n3);
                        }
                    } else {
                        if (this.selected.get(n3) && event.modifiers == 0 && event.clickCount == 1) {
                            this.deselectRow(n3);
                            n4 = 702;
                        } else if (!this.selected.get(n3)) {
                            this.deselectAllRows();
                            this.selectRow(n3);
                        }
                        if (event.modifiers != 0) {
                            this.lastselected = n3;
                        }
                    }
                    if (n4 == 701 && (event.modifiers & 1) == 0) {
                        this.lastselected = n3;
                    }
                    event.target = this;
                    event.id = 502;
                    event.arg = new Integer(n3);
                    return false;
                }
                return true;
            }
            case 506: {
                return true;
            }
        }
        return super.handleEvent(event);
    }

    protected String paintHook(String string, int n, int n2) {
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.getClass().getName()) + "[");
        stringBuffer.append("multipleSelectionsOK=" + this.multipleSelectionsOK);
        stringBuffer.append(",showhbar=" + this.showhbar);
        stringBuffer.append(",vsep=" + this.vsep);
        stringBuffer.append(",hsep=" + this.hsep);
        stringBuffer.append(",selectedbackground=" + this.selectedbackground);
        stringBuffer.append(",selectedforeground=" + this.selectedforeground);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

