/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.ncod.services.common;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class Scroller
extends Canvas
implements Runnable {
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 0;
    public static final int DEFAULT_ORIENTATION = 1;
    public static final int DEFAULT_SCROLL_DELAY = 125;
    protected static final int UP = 0;
    protected static final int DOWN = 1;
    protected static final int LEFT = 2;
    protected static final int RIGHT = 3;
    private static final int WIDTH = 16;
    private static final int MINIMUM_HANDLE_SIZE = 5;
    private int orientation = 1;
    private int value;
    private int visible = 1;
    private int min;
    private int max = 1;
    private int line = 1;
    private int page = 1;
    private int delay = 125;
    private boolean topdown = false;
    private boolean bottomdown = false;
    private int offset1;
    private int offset2;
    private int lastoffset;
    private boolean scrolling = false;
    private Image buffer;
    private Graphics bufg;
    private Dimension bufsize;
    private Image back;
    private Graphics backg;
    private Dimension backsize;
    private Thread thread;
    private int scrollType;

    public Scroller() {
        this(1);
    }

    public Scroller(int n) {
        this.orientation = n;
    }

    public Scroller(int n, int n2, int n3, int n4, int n5) {
        this.orientation = n;
        this.setValues(n2, n3, n4, n5);
    }

    public void run() {
        Container container = this.getParent();
        try {
            Thread.sleep(500L);
            while (true) {
                Object object;
                int n = this.value;
                switch (this.scrollType) {
                    case 603: {
                        this.setValue(this.value - this.page);
                        break;
                    }
                    case 604: {
                        this.setValue(this.value + this.page);
                        break;
                    }
                    case 601: {
                        this.setValue(this.value - this.line);
                        break;
                    }
                    case 602: {
                        this.setValue(this.value + this.line);
                        break;
                    }
                }
                if (this.value != n) {
                    object = new Event(this, this.scrollType, new Integer(this.value));
                    ((Component)container).deliverEvent((Event)object);
                } else {
                    object = this.thread;
                    this.thread = null;
                    ((Thread)object).stop();
                }
                Thread.sleep(this.delay);
            }
        }
        catch (InterruptedException interruptedException) {
            this.thread = null;
            return;
        }
    }

    public Scroller setScrollDelay(int n) {
        this.delay = n;
        return this;
    }

    public int getScrollDelay() {
        return this.delay;
    }

    public Scroller setOrientation(int n) {
        if (this.orientation != n) {
            this.orientation = n;
            this.repaint();
        }
        return this;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Scroller setValue(int n) {
        if (this.value != n) {
            this.value = n < this.min ? this.min : (n > this.max ? this.max : n);
            this.repaint();
        }
        return this;
    }

    public int getValue() {
        return this.value;
    }

    public Scroller setValues(int n, int n2, int n3, int n4) {
        this.setMinimum(n3);
        this.setMaximum(n4);
        this.setValue(n);
        this.setVisible(n2);
        return this;
    }

    public Scroller setMinimum(int n) {
        if (this.min != n) {
            this.min = n > this.max ? this.max : n;
            this.repaint();
        }
        return this;
    }

    public int getMinimum() {
        return this.min;
    }

    public Scroller setMaximum(int n) {
        if (this.max != n) {
            this.max = n < this.min ? this.min : n;
            this.repaint();
        }
        return this;
    }

    public int getMaximum() {
        return this.max;
    }

    public Scroller setLineIncrement(int n) {
        if (this.line != n) {
            this.line = n;
            this.repaint();
        }
        return this;
    }

    public Scroller setUnitIncrement(int n) {
        return this.setLineIncrement(n);
    }

    public int getLineIncrement() {
        return this.line;
    }

    public int getUnitIncrement() {
        return this.getLineIncrement();
    }

    public Scroller setPageIncrement(int n) {
        if (this.page != n) {
            this.page = n;
            this.repaint();
        }
        return this;
    }

    public Scroller setBlockIncrement(int n) {
        return this.setPageIncrement(n);
    }

    public int getPageIncrement() {
        return this.page;
    }

    public int getBlockIncrement() {
        return this.getPageIncrement();
    }

    public Scroller setVisible(int n) {
        if (this.visible != n) {
            this.visible = n > this.max - this.min ? this.max - this.min : (n < 0 ? 0 : n);
            this.repaint();
        }
        return this;
    }

    public int getVisible() {
        return this.visible;
    }

    public int getVisibleAmout() {
        return this.getVisible();
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        if (this.orientation == 1) {
            return new Dimension(16, 100);
        }
        return new Dimension(100, 16);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        Dimension dimension = this.size();
        Graphics graphics2 = this.bufg;
        try {
            if (this.buffer == null || this.bufsize.width != dimension.width || this.bufsize.height != dimension.height) {
                if (this.buffer != null) {
                    this.buffer.flush();
                    this.bufg.dispose();
                }
                this.bufsize = dimension;
                this.buffer = this.createImage(this.bufsize.width, this.bufsize.height);
                graphics2 = this.bufg = this.buffer.getGraphics();
            }
            this.bufg.setColor(this.getBackground());
            this.bufg.fillRect(0, 0, this.bufsize.width, this.bufsize.height);
        }
        catch (Exception exception) {
            graphics2 = graphics;
        }
        graphics2.clipRect(0, 0, dimension.width, dimension.height);
        if (this.orientation == 1) {
            n4 = dimension.width;
            n3 = dimension.height;
        } else {
            n4 = dimension.height;
            n3 = dimension.width;
        }
        this.paintBackground(graphics2);
        Graphics graphics3 = graphics2.create(0, 0, n4, n4);
        this.paintButton(graphics3, this.orientation == 1 ? 0 : 2);
        graphics3.dispose();
        if (this.isEnabled()) {
            int n5;
            int n6;
            int n7;
            int n8;
            double d = n3 - 2 * n4;
            double d2 = this.max - this.min + this.visible;
            double d3 = d / d2;
            int n9 = n4 + (int)(d3 * (double)(this.value - this.min));
            int n10 = (int)((double)this.visible * d3);
            if (n10 < 5) {
                n10 = 5;
            }
            if (this.orientation == 1) {
                n8 = 0;
                n7 = n9;
                n6 = n4;
                n5 = n10;
            } else {
                n8 = n9;
                n7 = 0;
                n6 = n10;
                n5 = n4;
            }
            graphics3 = graphics2.create(n8, n7, n6, n5);
            this.paintHandle(graphics3);
            graphics3.dispose();
            this.offset1 = n9;
            this.offset2 = n9 + n10;
        } else {
            this.offset2 = -1;
            this.offset1 = -1;
        }
        if (this.orientation == 1) {
            n2 = 0;
            n = n3 - n4;
        } else {
            n2 = n3 - n4;
            n = 0;
        }
        graphics3 = graphics2.create(n2, n, n4, n4);
        this.paintButton(graphics3, this.orientation == 1 ? 1 : 3);
        graphics3.dispose();
        if (this.buffer != null) {
            graphics.drawImage(this.buffer, 0, 0, this);
        }
    }

    public Scroller paintBackground(Graphics graphics) {
        Dimension dimension = this.preferredSize();
        int n = this.orientation == 0 ? dimension.height : dimension.width;
        Color color = this.getBackground();
        Color color2 = color.brighter().brighter().brighter();
        Color color3 = color.darker();
        Rectangle rectangle = graphics.getClipRect();
        Graphics graphics2 = this.backg;
        try {
            int n2;
            if (this.back == null || this.backsize.width != n) {
                if (this.back != null) {
                    this.back.flush();
                    this.backg.dispose();
                }
                this.backsize = new Dimension(n, n);
                this.back = this.createImage(this.backsize.width, this.backsize.height);
                graphics2 = this.backg = this.back.getGraphics();
            }
            this.backg.setColor(color);
            this.backg.fillRect(0, 0, this.backsize.width, this.backsize.height);
            graphics2.setColor(color);
            graphics2.fillRect(0, 0, n, n);
            graphics2.setColor(color2);
            boolean bl = true;
            int n3 = 0;
            while (n3 < n) {
                n2 = 0;
                while (n2 < n) {
                    if (bl) {
                        graphics2.drawLine(n3, n2 + 1, n3, n2 + 1);
                    } else {
                        graphics2.drawLine(n3, n2, n3, n2);
                    }
                    n2 += 2;
                }
                bl = !bl;
                ++n3;
            }
            if (this.orientation == 0) {
                n2 = rectangle.width / n + 1;
                int n4 = 0;
                while (n4 < n2) {
                    graphics.drawImage(this.back, n4 * n, 0, this);
                    ++n4;
                }
                graphics.setColor(color3);
                graphics.drawLine(0, 0, rectangle.width - 1, 0);
                graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
            } else {
                n2 = rectangle.height / n + 1;
                int n5 = 0;
                while (n5 < n2) {
                    graphics.drawImage(this.back, 0, n5 * n, this);
                    ++n5;
                }
                graphics.setColor(color3);
                graphics.drawLine(0, 0, 0, rectangle.height - 1);
                graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
            }
        }
        catch (Exception exception) {}
        return this;
    }

    public Scroller paintButton(Graphics graphics, int n) {
        Rectangle rectangle = graphics.getClipRect();
        Color color = this.getBackground();
        Color color2 = color.brighter().brighter().brighter();
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 0: 
            case 2: {
                this.paintHandle(graphics, this.topdown);
                if (!this.topdown) break;
                n3 = 1;
                n2 = 1;
                break;
            }
            case 1: 
            case 3: {
                this.paintHandle(graphics, this.bottomdown);
                if (!this.bottomdown) break;
                n3 = 1;
                n2 = 1;
                break;
            }
            default: {
                this.paintHandle(graphics);
            }
        }
        if (this.isEnabled()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(color2);
        }
        int n4 = rectangle.width / 2;
        int n5 = rectangle.width / 3;
        switch (n) {
            case 0: {
                int n6 = 0;
                while (n6 < n5 - 1) {
                    graphics.drawLine(n4 - n6 - 1 + n2, n5 + n6 + 1 + n3, n4 + n6 - 1 + n2, n5 + n6 + 1 + n3);
                    ++n6;
                }
                break;
            }
            case 1: {
                int n7 = 0;
                while (n7 < n5 - 1) {
                    graphics.drawLine(n4 - n7 - 1 + n2, 2 * n5 - n7 + n3, n4 + n7 - 1 + n2, 2 * n5 - n7 + n3);
                    ++n7;
                }
                break;
            }
            case 2: {
                int n8 = 0;
                while (n8 < n5 - 1) {
                    graphics.drawLine(n5 + n8 + n2, n4 - n8 - 1 + n3, n5 + n8 + n2, n4 + n8 - 1 + n3);
                    ++n8;
                }
                break;
            }
            case 3: {
                int n9 = 0;
                while (n9 < n5 - 1) {
                    graphics.drawLine(2 * n5 - n9 + n2, n4 - n9 - 1 + n3, 2 * n5 - n9 + n2, n4 + n9 - 1 + n3);
                    ++n9;
                }
                break;
            }
        }
        return this;
    }

    public Scroller paintHandle(Graphics graphics) {
        return this.paintHandle(graphics, false);
    }

    private Scroller paintHandle(Graphics graphics, boolean bl) {
        Rectangle rectangle = graphics.getClipRect();
        Color color = this.getBackground();
        Color color2 = color.brighter().brighter().brighter();
        Color color3 = color.darker().darker().darker();
        Color color4 = color3.darker();
        graphics.setColor(color);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        int n = 0;
        int n2 = 0;
        if (bl) {
            n2 = 1;
            n = 1;
        }
        graphics.setColor(color2);
        graphics.drawLine(2 + n, 1 + n2, rectangle.width - 2 + n, 1 + n2);
        graphics.drawLine(1 + n, 1 + n2, 1 + n, rectangle.height - 3 + n2);
        graphics.setColor(color3);
        graphics.drawLine(rectangle.width - 2 + n, 2 + n2, rectangle.width - 2 + n, rectangle.height - 2 + n2);
        graphics.drawLine(1 + n, rectangle.height - 2 + n2, rectangle.width - 3 + n, rectangle.height - 2 + n2);
        graphics.setColor(color4);
        graphics.drawLine(n, rectangle.height - 1 + n2, rectangle.width - 2 + n, rectangle.height - 1 + n2);
        graphics.drawLine(rectangle.width - 1 + n, 1 + n2, rectangle.width - 1 + n, rectangle.height - 1 + n2);
        return this;
    }

    public boolean handleEvent(Event event) {
        Dimension dimension = this.size();
        switch (event.id) {
            case 403: {
                switch (event.key) {
                    case 1004: 
                    case 1006: {
                        if (this.orientation == 1) {
                            if (event.key == 1006) {
                                return true;
                            }
                            event.y = 0;
                            break;
                        }
                        if (event.key == 1004) {
                            return true;
                        }
                        event.x = 0;
                        break;
                    }
                    case 1005: 
                    case 1007: {
                        if (this.orientation == 1) {
                            if (event.key == 1007) {
                                return true;
                            }
                            event.y = dimension.height - 1;
                            break;
                        }
                        if (event.key == 1005) {
                            return true;
                        }
                        event.x = dimension.width - 1;
                        break;
                    }
                    case 1002: {
                        if (this.orientation == 1) {
                            event.y = this.offset1 - 1;
                            break;
                        }
                        event.x = this.offset1 - 1;
                        break;
                    }
                    case 1003: {
                        if (this.orientation == 1) {
                            event.y = this.offset2 + 1;
                            break;
                        }
                        event.x = this.offset2 + 1;
                        break;
                    }
                    case 1000: 
                    case 1001: {
                        int n = this.value;
                        if (event.key == 1000) {
                            this.setValue(this.min);
                        } else {
                            this.setValue(this.max);
                        }
                        if (this.value != n) {
                            event.id = 605;
                            event.arg = new Integer(this.value);
                            return false;
                        }
                    }
                    default: {
                        return true;
                    }
                }
            }
            case 501: {
                int n;
                int n2;
                int n3;
                if (this.orientation == 1) {
                    n3 = dimension.width;
                    n2 = dimension.height;
                    n = event.y;
                } else {
                    n3 = dimension.height;
                    n2 = dimension.width;
                    n = event.x;
                }
                if (n >= this.offset1 && n <= this.offset2) {
                    this.scrolling = true;
                    this.lastoffset = n;
                    return true;
                }
                if (n < n3) {
                    int n4 = this.value;
                    this.setValue(this.value - this.line);
                    if (this.value != n4) {
                        event.id = 601;
                        event.arg = new Integer(this.value);
                        this.topdown = true;
                    }
                } else if (n >= n3 && n < this.offset1) {
                    int n5 = this.value;
                    this.setValue(this.value - this.page);
                    if (this.value != n5) {
                        event.id = 603;
                        event.arg = new Integer(this.value);
                    }
                } else if (n > n2 - n3) {
                    int n6 = this.value;
                    this.setValue(this.value + this.line);
                    if (this.value != n6) {
                        event.id = 602;
                        event.arg = new Integer(this.value);
                        this.bottomdown = true;
                    }
                } else if (n > this.offset2 && n < n2 - n3) {
                    int n7 = this.value;
                    this.setValue(this.value + this.page);
                    if (this.value != n7) {
                        event.id = 604;
                        event.arg = new Integer(this.value);
                    }
                }
                this.scrollType = event.id;
                if (this.thread == null) {
                    this.thread = new Thread(this);
                    this.thread.start();
                }
                return false;
            }
            case 506: {
                if (this.scrolling) {
                    int n;
                    int n8;
                    int n9;
                    if (this.orientation == 1) {
                        n9 = dimension.height;
                        n8 = dimension.width;
                        n = event.y - n8;
                    } else {
                        n9 = dimension.width;
                        n8 = dimension.height;
                        n = event.x - n8;
                    }
                    int n10 = n9 - 2 * n8;
                    int n11 = this.max - this.min + 1;
                    double d = (double)n10 / (double)n11;
                    int n12 = (int)((double)n / d) + this.min;
                    int n13 = this.value;
                    this.setValue(n12);
                    if (this.value != n13) {
                        event.id = 605;
                        event.arg = new Integer(this.value);
                        return false;
                    }
                }
                return true;
            }
            case 502: {
                if (this.thread != null) {
                    this.thread.stop();
                    this.thread = null;
                }
                this.bottomdown = false;
                this.topdown = false;
                this.scrolling = false;
                this.repaint();
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("[");
        stringBuffer.append("orientation=");
        switch (this.orientation) {
            case 1: {
                stringBuffer.append("VERTICAL");
                break;
            }
            case 0: {
                stringBuffer.append("HORIZONTAL");
                break;
            }
            default: {
                stringBuffer.append("unknown");
            }
        }
        stringBuffer.append(",value=" + this.value);
        stringBuffer.append(",visible=" + this.visible);
        stringBuffer.append(",min=" + this.min);
        stringBuffer.append(",max=" + this.max);
        stringBuffer.append(",line=" + this.line);
        stringBuffer.append(",page=" + this.page);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

