/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common;

import com.ibm.eNetwork.onDemand.common.nativecode.NTRegistry;
import com.ibm.eNetwork.onDemand.common.nativecode.RegistryValue;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Vector;

public class BaseDirectory {
    public static final String AIX_System = "AIX";
    public static final String NT_System = "WindowsNT";
    public static final String OS2_System = "OS2";
    public static final String OS390_System = "OS390";
    public static final String OS400_System = "OS400";
    public static final String SUN_System = "Solaris";
    private static final String AIX_Platform = "AIX";
    private static final String AS400_Platform = "OS/400";
    private static final String CS390_Platform = "OS/390";
    private static final String NT_Platform = "Windows NT";
    private static final String OS2_Platform = "OS/2";
    private static final String SUN_Platform = "Solaris";
    private static final String AIX_CfgPath = "/usr/lpp/orion/config";
    private static final String CS390_CfgPath = "/usr/lpp/orion/config";
    private static final String WINNT_CfgKey = "SOFTWARE\\IBM\\eNetwork On-Demand Server\\CurrentVersion";
    private static final String WINNT_CfgReg = "ETC";
    private static final String OS2_CfgPath = "D:\\orion\\config";
    private static final String AS400_CfgPath = "/usr/lpp/orion/config";
    private static final String SUN_CfgPath = "/usr/lpp/orion/config";
    private static final String AIX_LogDirFile = "logBaseDir";
    private static final String CS390_LogDirFile = "logBaseDir";
    private static final String WINNT_LogKey = "SOFTWARE\\IBM\\eNetwork On-Demand Server\\CurrentVersion";
    private static final String WINNT_LogReg = "ETC";
    private static final String OS2_LogDirFile = "D:\\orion\\log";
    private static final String AS400_LogDirFile = "logBaseDir";
    private static final String SUN_LogDirFile = "logBaseDir";
    private static String osName = "";

    public static String getOSName() throws IOException {
        String string = null;
        try {
            string = System.getProperty("os.name");
        }
        catch (SecurityException securityException) {
            throw new IOException("Security Exception: getProperty(os.name)");
        }
        if (string.equals("AIX")) {
            return "AIX";
        }
        if (string.equals(AS400_Platform)) {
            return OS400_System;
        }
        if (string.equals(CS390_Platform)) {
            return OS390_System;
        }
        if (string.equals(NT_Platform)) {
            return NT_System;
        }
        if (string.equals(OS2_Platform)) {
            return OS2_System;
        }
        if (string.equals("Solaris")) {
            return "Solaris";
        }
        return null;
    }

    public static String getConfigBaseDirectory() throws IOException {
        osName = BaseDirectory.getOSName();
        return BaseDirectory.getConfigBaseDirectory(osName);
    }

    public static String getConfigBaseDirectory(String string) throws IOException {
        Serializable serializable;
        String string2 = null;
        if (string.equals("AIX")) {
            string2 = new String("/usr/lpp/orion/config");
        } else if (string.equals(OS390_System)) {
            string2 = new String("/usr/lpp/orion/config");
        } else if (string.equals(NT_System)) {
            RegistryValue registryValue;
            NTRegistry nTRegistry;
            serializable = null;
            try {
                nTRegistry = new NTRegistry();
                registryValue = new RegistryValue();
                registryValue.Key = "SOFTWARE\\IBM\\eNetwork On-Demand Server\\CurrentVersion";
                registryValue.Name = "ETC";
                serializable = nTRegistry.getValue(registryValue);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                serializable = null;
                throw new IOException("JavaNTRegistry.dll not found");
            }
            catch (SecurityException securityException) {
                serializable = null;
                throw new IOException("JavaNTRegistry.dll could not be loaded");
            }
            if (serializable == null || ((Vector)serializable).size() != 1) {
                throw new IOException("eNetwork On-Demand Server Not found in NT Registry");
            }
            nTRegistry = ((Vector)serializable).elementAt(0);
            if (nTRegistry == null || !(nTRegistry instanceof RegistryValue)) {
                throw new IOException("Invalid entry in NT Registry for eNetwork On-Demand Server");
            }
            registryValue = (RegistryValue)((Object)nTRegistry);
            string2 = new String((String)registryValue.Value);
        } else if (string.equals(OS2_System)) {
            string2 = new String(OS2_CfgPath);
        } else if (string.equals(OS400_System)) {
            string2 = new String("/usr/lpp/orion/config");
        } else if (string.equals("Solaris")) {
            string2 = new String("/usr/lpp/orion/config");
        }
        if (string2 != null) {
            serializable = new File(string2);
            if (((File)serializable).exists()) {
                string2 = String.valueOf(string2) + System.getProperty("file.separator");
            } else {
                throw new IOException("Directory does not exist: " + string2);
            }
        }
        return string2;
    }

    public static String getLogBaseDirectory() throws IOException {
        osName = BaseDirectory.getOSName();
        return BaseDirectory.getLogBaseDirectory(osName);
    }

    public static String getLogBaseDirectory(String string) throws IOException {
        Object object;
        String string2 = null;
        if (string.equals("AIX")) {
            RandomAccessFile randomAccessFile;
            object = new String(BaseDirectory.getConfigBaseDirectory(string));
            String string3 = new String(String.valueOf(object) + "logBaseDir");
            try {
                randomAccessFile = new RandomAccessFile(string3, "r");
            }
            catch (IOException iOException) {
                return object;
            }
            string2 = randomAccessFile.readLine();
            randomAccessFile.close();
        } else if (string.equals(OS390_System)) {
            RandomAccessFile randomAccessFile;
            object = new String(BaseDirectory.getConfigBaseDirectory(string));
            String string4 = new String(String.valueOf(object) + "logBaseDir");
            try {
                randomAccessFile = new RandomAccessFile(string4, "r");
            }
            catch (IOException iOException) {
                return object;
            }
            string2 = randomAccessFile.readLine();
            randomAccessFile.close();
        } else if (string.equals(NT_System)) {
            RegistryValue registryValue;
            NTRegistry nTRegistry;
            object = null;
            try {
                nTRegistry = new NTRegistry();
                registryValue = new RegistryValue();
                registryValue.Key = "SOFTWARE\\IBM\\eNetwork On-Demand Server\\CurrentVersion";
                registryValue.Name = "ETC";
                object = nTRegistry.getValue(registryValue);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                object = null;
                throw new IOException("JavaNTRegistry.dll not found");
            }
            catch (SecurityException securityException) {
                object = null;
                throw new IOException("JavaNTRegistry.dll could not be loaded");
            }
            if (object == null || ((Vector)object).size() != 1) {
                throw new IOException("eNetwork On-Demand Server Not found in NT Registry");
            }
            nTRegistry = ((Vector)object).elementAt(0);
            if (nTRegistry == null || !(nTRegistry instanceof RegistryValue)) {
                throw new IOException("Invalid entry in NT Registry for eNetwork On-Demand Server");
            }
            registryValue = (RegistryValue)((Object)nTRegistry);
            string2 = new String((String)registryValue.Value);
        } else if (string.equals(OS2_System)) {
            string2 = new String(OS2_LogDirFile);
        } else if (string.equals(OS400_System)) {
            RandomAccessFile randomAccessFile;
            object = new String(BaseDirectory.getConfigBaseDirectory(string));
            String string5 = new String(String.valueOf(object) + "logBaseDir");
            try {
                randomAccessFile = new RandomAccessFile(string5, "r");
            }
            catch (IOException iOException) {
                return object;
            }
            string2 = randomAccessFile.readLine();
            randomAccessFile.close();
        } else if (string.equals("Solaris")) {
            RandomAccessFile randomAccessFile;
            object = new String(BaseDirectory.getConfigBaseDirectory(string));
            String string6 = new String(String.valueOf(object) + "logBaseDir");
            try {
                randomAccessFile = new RandomAccessFile(string6, "r");
            }
            catch (IOException iOException) {
                return object;
            }
            string2 = randomAccessFile.readLine();
            randomAccessFile.close();
        }
        if (string2 != null) {
            object = new File(string2 = string2.trim());
            if (((File)object).exists()) {
                string2 = String.valueOf(string2) + System.getProperty("file.separator");
            } else {
                throw new IOException("Directory does not exist: " + string2);
            }
        }
        return string2;
    }
}

