/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common;

import com.ibm.eNetwork.onDemand.common.CBData;
import com.ibm.eNetwork.onDemand.common.TraceLevels;
import com.ibm.eNetwork.onDemand.common.dataStructures.Queue;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.lang.reflect.Method;
import java.util.Hashtable;
import netscape.security.PrivilegeManager;

public class CallbackManager
implements Runnable,
TraceLevels {
    protected Hashtable hashClients = new Hashtable();
    protected Queue queue = new Queue();
    protected Thread thread;

    public static CallbackManager getCallbackManager() {
        return null;
    }

    protected CallbackManager() {
        PolicyEngine.assertPermission(PermissionID.THREAD);
        PrivilegeManager.enablePrivilege("UniversalThreadAccess");
        this.thread = new Thread(this);
        this.thread.start();
        PolicyEngine.revertPermission(PermissionID.THREAD);
    }

    public void run() {
        PolicyEngine.assertPermission(PermissionID.THREAD);
        PrivilegeManager.enablePrivilege("UniversalThreadAccess");
        try {
            CBData cBData = null;
            while (true) {
                Queue queue = this.queue;
                synchronized (queue) {
                    while (this.queue.isEmpty()) {
                        this.queue.wait();
                    }
                }
                cBData = (CBData)this.queue.deQueue();
                this.processMethodCall(cBData);
            }
        }
        catch (Exception exception) {
            System.err.println("Severe Error: CallbackManager has failed! run()" + exception);
            PolicyEngine.revertPermission(PermissionID.THREAD);
            return;
        }
    }

    protected void processMethodCall(CBData cBData) {
        PolicyEngine.assertPermission(PermissionID.REFLECTION);
        try {
            Hashtable hashtable = (Hashtable)this.hashClients.get(cBData.oCaller);
            Method method = (Method)hashtable.get(cBData.sName);
            method.invoke(cBData.oCaller, cBData.oParams);
        }
        catch (Exception exception) {
            System.err.println("Severe Error: Callback failed! processMethodCall() " + exception);
        }
        PolicyEngine.revertPermission(PermissionID.REFLECTION);
    }

    public void registerMethod(Object object, String string) throws NoSuchMethodException {
        PolicyEngine.assertPermission(PermissionID.REFLECTION);
        if (object == null || string == null || string.compareTo("") == 0) {
            throw new NoSuchMethodException(string);
        }
        Class<?> clazz = object.getClass();
        Method[] methodArray = clazz.getMethods();
        if (methodArray == null) {
            throw new NoSuchMethodException(string);
        }
        int n = methodArray.length;
        if (n < 1) {
            return;
        }
        --n;
        String string2 = null;
        try {
            while (n > -1) {
                string2 = methodArray[n].getName();
                if (string2 != null && string2.compareTo(string) == 0) {
                    this.hashMethod(object, string, methodArray[n]);
                    return;
                }
                --n;
            }
        }
        catch (Exception exception) {
            System.err.println("Severe Error: Method not registered! " + exception);
            throw new NoSuchMethodException(string);
        }
        PolicyEngine.revertPermission(PermissionID.REFLECTION);
    }

    protected void hashMethod(Object object, String string, Method method) {
        Hashtable<String, Method> hashtable = (Hashtable<String, Method>)this.hashClients.get(object);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Method>();
            this.hashClients.put(object, hashtable);
        }
        hashtable.put(string, method);
    }

    public void doMethod(Object object, String string, Object[] objectArray) {
        try {
            CBData cBData = new CBData(object, string, objectArray);
            this.queue.enQueue(cBData);
            return;
        }
        catch (Exception exception) {
            System.err.println("Severe Error: Method not queued! " + exception);
            return;
        }
    }

    public void doMethod(Object object, String string, Object object2) {
        Object[] objectArray = new Object[]{object2};
        this.doMethod(object, string, objectArray);
    }

    public void doMethod(Object object, String string, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object2, object3};
        this.doMethod(object, string, objectArray);
    }

    public void doMethod(Object object, String string, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object2, object3, object4};
        this.doMethod(object, string, objectArray);
    }

    public void doMethod(Object object, String string, Object object2, Object object3, Object object4, Object object5) {
        Object[] objectArray = new Object[]{object2, object3, object4, object5};
        this.doMethod(object, string, objectArray);
    }

    public void doMethod(Object object, String string, Object object2, Object object3, Object object4, Object object5, Object object6) {
        Object[] objectArray = new Object[]{object2, object3, object4, object5, object6};
        this.doMethod(object, string, objectArray);
    }

    public void doMethod(Object object, String string, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        Object[] objectArray = new Object[]{object2, object3, object4, object5, object6, object7};
        this.doMethod(object, string, objectArray);
    }

    public void doMethod(Object object, String string, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        Object[] objectArray = new Object[]{object2, object3, object4, object5, object6, object7, object8};
        this.doMethod(object, string, objectArray);
    }

    public void doMethod(Object object, String string) {
        this.doMethod(object, string, null);
    }
}

