/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common;

import com.ibm.eNetwork.onDemand.common.TimerListener;
import com.ibm.eNetwork.onDemand.common.TraceLevels;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.util.Enumeration;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class Timer
implements Runnable,
TraceLevels {
    protected int iDelay;
    protected Vector vListeners;
    private Thread timerThread;
    protected boolean bStop = false;

    public Timer(int n) {
        this.iDelay = n;
        PolicyEngine.assertPermission(PermissionID.THREAD);
        PrivilegeManager.enablePrivilege("UniversalThreadAccess");
        this.vListeners = new Vector();
        this.timerThread = new Thread(this);
        this.timerThread.setDaemon(true);
        this.timerThread.start();
        PolicyEngine.revertPermission(PermissionID.THREAD);
    }

    public synchronized void addTimerListener(TimerListener timerListener) {
        if (this.vListeners.indexOf(timerListener) == -1) {
            this.vListeners.addElement(timerListener);
        }
    }

    public synchronized boolean removeTimerListener(TimerListener timerListener) {
        if (this.vListeners.indexOf(timerListener) != -1) {
            return this.vListeners.removeElement(timerListener);
        }
        return false;
    }

    public void run() {
        PolicyEngine.assertPermission(PermissionID.THREAD);
        PrivilegeManager.enablePrivilege("UniversalThreadAccess");
        try {
            while (!this.bStop) {
                Thread.sleep(this.iDelay);
                if (this.vListeners.isEmpty()) continue;
                Enumeration enumeration = this.vListeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((TimerListener)enumeration.nextElement()).timerFired();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Timer.run: " + interruptedException);
        }
        PolicyEngine.revertPermission(PermissionID.THREAD);
    }

    public void stop() {
        this.bStop = true;
    }
}

