/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.audio;

import com.ibm.eNetwork.onDemand.common.ResourceLoader;
import com.ibm.eNetwork.onDemand.common.TraceLevels;
import com.ibm.eNetwork.onDemand.common.audio.SunAudioClip;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Component;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class AudioLoader
extends ResourceLoader
implements TraceLevels {
    Component component;
    boolean boolApplet;

    public AudioLoader(Component component) {
        this.component = component;
        this.boolApplet = component instanceof Applet;
    }

    protected Object get(URL uRL) {
        AudioClip audioClip = null;
        if (this.hashtable.containsKey(uRL)) {
            audioClip = (AudioClip)this.hashtable.get(uRL);
        } else {
            if (this.boolApplet) {
                Applet applet = (Applet)this.component;
                audioClip = applet.getAudioClip(uRL);
            } else {
                try {
                    audioClip = new SunAudioClip(uRL);
                }
                catch (Exception exception) {
                    System.err.println("AudioLoader.get: " + exception);
                }
            }
            this.hashtable.put(uRL, audioClip);
        }
        return audioClip;
    }

    protected Object get(InputStream inputStream) {
        SunAudioClip sunAudioClip = null;
        try {
            sunAudioClip = new SunAudioClip(inputStream);
        }
        catch (Exception exception) {
            System.err.println("AudioLoader.get: " + exception);
        }
        return sunAudioClip;
    }

    public AudioClip getAudio(Class clazz, String string) {
        try {
            SunAudioClip sunAudioClip = new SunAudioClip(this.getResourceStream(clazz, string));
            this.hashtable.put(clazz + string, sunAudioClip);
            return sunAudioClip;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }

    public Vector getAudio(Vector vector) {
        return this.getAudio(null, vector);
    }

    public Vector getAudio(Class clazz, Vector vector) {
        Vector<AudioClip> vector2 = new Vector<AudioClip>();
        if (vector.isEmpty()) {
            return null;
        }
        String string = "";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (this.hashtable.containsKey(clazz + string)) {
                vector2.addElement((AudioClip)this.hashtable.get(clazz + string));
                continue;
            }
            AudioClip audioClip = this.getAudio(clazz, string);
            vector2.addElement(audioClip);
        }
        return vector2;
    }

    public AudioClip getAudio(String string) {
        return this.getAudio(null, string);
    }

    public AudioClip getAudio(URL uRL) {
        return (AudioClip)this.get(uRL);
    }

    public AudioClip removeAudio(String string) {
        return this.removeAudio(null, string);
    }

    public AudioClip removeAudio(Class clazz, String string) {
        return (AudioClip)this.removeFromBuffer(clazz + string);
    }

    public AudioClip removeAudio(URL uRL) {
        return (AudioClip)this.removeFromBuffer(uRL);
    }
}

