/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.dataStructures;

import com.ibm.eNetwork.onDemand.common.TraceLevels;
import com.ibm.eNetwork.onDemand.common.dataStructures.EmptyListException;
import com.ibm.eNetwork.onDemand.common.dataStructures.InvalidCurrentNodeException;
import com.ibm.eNetwork.onDemand.common.dataStructures.ListException;
import com.ibm.eNetwork.onDemand.common.dataStructures.ListNode;

public class List
implements TraceLevels {
    private ListNode _head;
    private ListNode _tail;
    private ListNode _current;
    private long _size;

    public List insertAtStart(Object object) {
        ListNode listNode = new ListNode(object);
        if (this._head == null) {
            this._head = listNode;
            this._tail = listNode;
        } else {
            listNode._lnNext = this._head;
            this._head._lnPrev = listNode;
            this._head = listNode;
        }
        ++this._size;
        this._current = listNode;
        return this;
    }

    public List insertAtEnd(Object object) {
        ListNode listNode = new ListNode(object);
        if (this._tail == null) {
            this._head = listNode;
            this._tail = listNode;
        } else {
            listNode._lnPrev = this._tail;
            this._tail._lnNext = listNode;
            this._tail = listNode;
        }
        ++this._size;
        this._current = listNode;
        return this;
    }

    public List insertBefore(Object object) throws InvalidCurrentNodeException {
        ListNode listNode = new ListNode(object);
        if (this._current == null) {
            throw new InvalidCurrentNodeException();
        }
        if (this._current == this._head) {
            this.insertAtStart(object);
            return this;
        }
        listNode._lnNext = this._current;
        listNode._lnPrev = this._current._lnPrev;
        listNode._lnPrev._lnNext = listNode;
        this._current._lnPrev = listNode;
        this._current = listNode;
        ++this._size;
        return this;
    }

    public List insertAfter(Object object) throws InvalidCurrentNodeException {
        ListNode listNode = new ListNode(object);
        if (this._current == null) {
            throw new InvalidCurrentNodeException();
        }
        if (this._current == this._tail) {
            this.insertAtEnd(object);
            return this;
        }
        listNode._lnNext = this._current._lnNext;
        listNode._lnPrev = this._current;
        this._current._lnNext = listNode;
        listNode._lnNext._lnPrev = listNode;
        this._current = listNode;
        ++this._size;
        return this;
    }

    public boolean find(Object object) throws InvalidCurrentNodeException {
        ListNode listNode = this._current;
        if (this._current == null) {
            throw new InvalidCurrentNodeException();
        }
        do {
            if (listNode._data != object) continue;
            this._current = listNode;
            return true;
        } while ((listNode = listNode._lnNext) != null);
        return false;
    }

    public List gotoHead() throws EmptyListException {
        if (this._size == 0L) {
            throw new EmptyListException();
        }
        this._current = this._head;
        return this;
    }

    public List gotoTail() throws EmptyListException {
        if (this._size == 0L) {
            throw new EmptyListException();
        }
        this._current = this._tail;
        return this;
    }

    public long size() {
        return this._size;
    }

    public boolean isEmpty() {
        return this._size == 0L;
    }

    public List next() throws InvalidCurrentNodeException {
        if (this._current == null) {
            throw new InvalidCurrentNodeException();
        }
        this._current = this._current._lnNext;
        return this;
    }

    public List previous() throws InvalidCurrentNodeException {
        if (this._current == null) {
            throw new InvalidCurrentNodeException();
        }
        this._current = this._current._lnPrev;
        return this;
    }

    public Object data() throws InvalidCurrentNodeException {
        if (this._current == null) {
            throw new InvalidCurrentNodeException();
        }
        return this._current._data;
    }

    public List deleteFromStart() throws EmptyListException {
        if (this._size == 0L) {
            throw new EmptyListException();
        }
        if (this._size == 1L) {
            this._head = null;
            this._tail = null;
            this._current = null;
            this._size = 0L;
            return this;
        }
        this._head._lnNext._lnPrev = null;
        if (this._current == this._head) {
            this._current = this._head._lnNext;
        }
        this._head = this._current;
        --this._size;
        return this;
    }

    public List deleteFromEnd() throws EmptyListException {
        if (this._size == 0L) {
            throw new EmptyListException();
        }
        if (this._size == 1L) {
            this._head = null;
            this._tail = null;
            this._current = null;
            this._size = 0L;
            return this;
        }
        this._tail._lnPrev._lnNext = null;
        if (this._current == this._tail) {
            this._current = this._tail._lnPrev;
        }
        this._tail = this._current;
        --this._size;
        return this;
    }

    public List delete() throws EmptyListException {
        if (this._size == 0L) {
            throw new EmptyListException();
        }
        if (this._size == 1L) {
            this._head = null;
            this._tail = null;
            this._current = null;
            this._size = 0L;
            return this;
        }
        if (this._current == this._head) {
            this.deleteFromStart();
            return this;
        }
        if (this._current == this._tail) {
            this.deleteFromEnd();
            return this;
        }
        this._current._lnPrev._lnNext = this._current._lnNext;
        this._current._lnNext._lnPrev = this._current._lnPrev;
        this._current = null;
        --this._size;
        return this;
    }

    public boolean currentNodeValid() {
        return this._current != null;
    }

    public List clear() {
        if (this._size == 0L) {
            return this;
        }
        try {
            this.gotoHead();
            while (this._size > 0L) {
                this.deleteFromStart();
            }
        }
        catch (ListException listException) {
            System.err.println("ERROR :" + listException);
            System.err.println("Thrown in List class Clear method");
        }
        return this;
    }
}

