/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.dataStructures;

import com.ibm.eNetwork.onDemand.common.TraceLevels;
import com.ibm.eNetwork.onDemand.services.config.Keyword;
import com.ibm.eNetwork.onDemand.services.config.PersistentKeyword;
import com.ibm.eNetwork.onDemand.services.config.User;
import java.applet.Applet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class OOCSRegistry
extends PersistentKeyword
implements TraceLevels {
    protected static final String DELIMITER = "/\\";
    protected static final int DEFAULT_CACHE_SIZE = 30;
    protected static final boolean DEBUG = false;
    RegistryCache cache;

    public OOCSRegistry(String string, String string2, User user, Applet applet) {
        super(string, string2, user, applet);
        this.init();
    }

    public OOCSRegistry(String string, String string2, User user, Applet applet, String string3) {
        super(string, string2, user, applet, string3);
        this.init();
    }

    protected void init() {
        this.cache = new RegistryCache();
    }

    public static void main(String[] stringArray) {
        User user = new User("rob", "studly");
        OOCSRegistry oOCSRegistry = new OOCSRegistry("reg", "test", user, new Applet());
        oOCSRegistry.createEntry("TextSettings", "Text1", "blah");
        oOCSRegistry.createEntry("TextSettings\\Folder1", "Text1", "blah blah blah");
        oOCSRegistry.createEntry("TextSettings\\Folder2", "Text1", "Instance1", "raaa raaa raaa");
        oOCSRegistry.createEntry("TextSettings\\Folder2", "Text1", "Instance2", "reee reee reee");
        oOCSRegistry.createEntry("IntSettings\\Folder1", "Int1", 12345);
        oOCSRegistry.createEntry("IntSettings\\Folder1", "Int2", 67890);
        oOCSRegistry.createEntry("BoolSettings", "Bool1", true);
        oOCSRegistry.createEntry("BoolSettings", "Bool2", false);
        oOCSRegistry.createEntry("TextSettings", "Text2", "doh!");
        String string = oOCSRegistry.getEntry("TextSettings", "Text1", "Default value");
        System.err.println("Value is " + string);
        string = oOCSRegistry.getEntry("TextSettings\\Folder1", "Text1", "Default value");
        System.err.println("Value is " + string);
        string = oOCSRegistry.getEntry("TextSettings\\Folder2", "Text1", "Variant1", "Default value");
        System.err.println("Value is " + string);
        string = oOCSRegistry.getEntry("TextSettings\\Folder2", "Text1", "Variant2", "Default value");
        System.err.println("Value is " + string);
        int n = oOCSRegistry.getEntry("TextSettings\\Folder2", "Text1", -1);
        System.err.println("Value is " + n);
        n = oOCSRegistry.getEntry("IntSettings\\Folder1", "Int1", -1);
        System.err.println("Value is " + n);
        float f = oOCSRegistry.getEntry("IntSettings\\Folder1", "Int2", -1.0f);
        System.err.println("Value is " + f);
        boolean bl = oOCSRegistry.getEntry("BoolSettings", "Bool1", false);
        System.err.println("Value is " + bl);
        oOCSRegistry.removeEntry("BoolSettings", "Bool1");
        bl = oOCSRegistry.getEntry("BoolSettings", "Bool1", false);
        System.err.println("Value is " + bl);
        if (oOCSRegistry.write("config.agent.server", 0, 0, 0) != 0) {
            System.err.println("Write to file failed");
        }
        OOCSRegistry oOCSRegistry2 = new OOCSRegistry("reg", "test", user, new Applet());
        oOCSRegistry2.read("config.agent.server", 0, 0, 0);
        bl = oOCSRegistry2.getEntry("BoolSettings", "Bool2", true);
        System.err.println("Value is " + bl);
    }

    /*
     * Unable to fully structure code
     */
    public Keyword createFolderKeyword(String var1_1) {
        var2_2 = this;
        var3_3 = null;
        var4_4 = new StringTokenizer(var1_1, "/\\");
        if (var4_4.hasMoreTokens()) ** GOTO lbl14
        return null;
lbl-1000:
        // 1 sources

        {
            var5_5 = (String)var4_4.nextElement();
            var3_3 = var2_2.get(var5_5, "");
            if (var3_3 == null) {
                var3_3 = var2_2.createKeyword(0, var5_5, "", "");
            } else if (var3_3.getType() != 0) {
                return null;
            }
            var2_2 = var3_3;
lbl14:
            // 2 sources

            ** while (var4_4.hasMoreTokens())
        }
lbl15:
        // 1 sources

        this.cache.put(var1_1, (Keyword)var2_2);
        return var2_2;
    }

    public Keyword findFolderKeyword(String string) {
        OOCSRegistry oOCSRegistry = this;
        Keyword keyword = this.cache.get(string);
        if (keyword == null) {
            oOCSRegistry = this;
            StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = (String)stringTokenizer.nextElement();
                keyword = oOCSRegistry.get(string2, "");
                if (!this.isFolderKeyword(keyword)) {
                    return null;
                }
                oOCSRegistry = keyword;
            }
        }
        if (keyword != null) {
            this.cache.put(string, keyword);
        }
        return keyword;
    }

    protected Keyword findFolderKeyword(String[] stringArray, int n) {
        if (stringArray == null || n > stringArray.length - 1 || n < 0) {
            return null;
        }
        OOCSRegistry oOCSRegistry = this;
        Keyword keyword = null;
        int n2 = 0;
        while (n2 <= n) {
            if (stringArray[n2] == null) {
                return null;
            }
            keyword = oOCSRegistry.get(stringArray[n2], "");
            if (!this.isFolderKeyword(keyword)) {
                return null;
            }
            oOCSRegistry = keyword;
        }
        return keyword;
    }

    protected Keyword findFolderKeyword(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            return this.findFolderKeyword(stringArray, stringArray.length - 1);
        }
        return null;
    }

    protected final boolean isFolderKeyword(Keyword keyword) {
        if (keyword == null) {
            return false;
        }
        return keyword.getType() == 0;
    }

    protected String[] parseFolderName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER);
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        while (n2 < n) {
            if (stringTokenizer.hasMoreTokens()) {
                stringArray[n2] = stringTokenizer.nextToken();
            }
            ++n2;
        }
        return stringArray;
    }

    public boolean removeFolder(String string) {
        String[] stringArray = this.parseFolderName(string);
        if (stringArray == null) {
            return false;
        }
        Keyword keyword = this.findFolderKeyword(stringArray, stringArray.length - 2);
        if (!this.isFolderKeyword(keyword)) {
            return false;
        }
        if (stringArray[stringArray.length - 1] == null) {
            return false;
        }
        Keyword keyword2 = keyword.get(stringArray[stringArray.length - 1], "");
        if (!this.isFolderKeyword(keyword2)) {
            return false;
        }
        keyword.deleteKeyword(keyword2);
        this.cache.remove(string);
        return true;
    }

    public boolean isFolder(String string) {
        return this.findFolderKeyword(string) != null;
    }

    protected Keyword createEntryKeyword(String string, String string2, String string3) {
        Keyword keyword = this.createFolderKeyword(string);
        if (keyword == null) {
            return null;
        }
        Keyword keyword2 = keyword.createKeyword(1, string2, string3, "");
        if (keyword2 == null) {
            return null;
        }
        return keyword2;
    }

    public boolean createEntry(String string, String string2, String string3) {
        return this.createEntry(string, string2, "", string3);
    }

    public boolean createEntry(String string, String string2, String string3, String string4) {
        Keyword keyword = this.createEntryKeyword(string, string2, string3);
        if (keyword == null) {
            return false;
        }
        keyword.setValue(string4);
        return true;
    }

    public boolean createEntry(String string, String string2, String string3, int n) {
        Keyword keyword = this.createEntryKeyword(string, string2, string3);
        if (keyword == null) {
            return false;
        }
        keyword.setValue(Integer.toString(n));
        return true;
    }

    public boolean createEntry(String string, String string2, int n) {
        return this.createEntry(string, string2, "", n);
    }

    public boolean createEntry(String string, String string2, String string3, boolean bl) {
        Keyword keyword = this.createEntryKeyword(string, string2, string3);
        if (keyword == null) {
            return false;
        }
        keyword.setValue(new Boolean(bl).toString());
        return true;
    }

    public boolean createEntry(String string, String string2, boolean bl) {
        return this.createEntry(string, string2, "", bl);
    }

    public boolean createEntry(String string, String string2, String string3, float f) {
        Keyword keyword = this.createEntryKeyword(string, string2, string3);
        if (keyword == null) {
            return false;
        }
        keyword.setValue(Float.toString(f));
        return true;
    }

    public boolean createEntry(String string, String string2, float f) {
        return this.createEntry(string, string2, "", f);
    }

    public boolean removeEntry(String string, String string2) {
        return this.removeEntry(string, string2, "");
    }

    public boolean removeEntry(String string, String string2, String string3) {
        Keyword keyword = this.findFolderKeyword(string);
        if (keyword == null) {
            return false;
        }
        Keyword keyword2 = keyword.get(string2, string3);
        if (string2 == null) {
            return false;
        }
        return keyword.deleteKeyword(keyword2);
    }

    protected Keyword findEntryKeyword(String string, String string2, String string3) {
        Keyword keyword = this.findFolderKeyword(string);
        if (keyword == null) {
            return null;
        }
        Keyword keyword2 = keyword.get(string2, string3);
        if (keyword2 == null || keyword2.getType() != 1) {
            return null;
        }
        return keyword2;
    }

    public boolean isEntry(String string, String string2) {
        return this.isEntry(string, string2, "");
    }

    public boolean isEntry(String string, String string2, String string3) {
        Keyword keyword = this.findEntryKeyword(string, string2, string3);
        return keyword != null;
    }

    public boolean setEntry(String string, String string2, String string3) {
        return this.setEntry(string, string2, "", string3);
    }

    public boolean setEntry(String string, String string2, String string3, String string4) {
        Keyword keyword = this.findEntryKeyword(string, string2, string3);
        if (keyword == null) {
            return false;
        }
        keyword.setValue(string4);
        return true;
    }

    public boolean setEntry(String string, String string2, int n) {
        return this.setEntry(string, string2, "", n);
    }

    public boolean setEntry(String string, String string2, String string3, int n) {
        Keyword keyword = this.findEntryKeyword(string, string2, string3);
        if (keyword == null) {
            return false;
        }
        keyword.setValue(Integer.toString(n));
        return true;
    }

    public boolean setEntry(String string, String string2, boolean bl) {
        return this.setEntry(string, string2, "", bl);
    }

    public boolean setEntry(String string, String string2, String string3, boolean bl) {
        Keyword keyword = this.findEntryKeyword(string, string2, string3);
        if (keyword == null) {
            return false;
        }
        keyword.setValue(new Boolean(bl).toString());
        return true;
    }

    public boolean setEntry(String string, String string2, long l) {
        return this.setEntry(string, string2, "", l);
    }

    public boolean setEntry(String string, String string2, String string3, long l) {
        Keyword keyword = this.findEntryKeyword(string, string2, string3);
        if (keyword == null) {
            return false;
        }
        keyword.setValue(Long.toString(l));
        return true;
    }

    public boolean setEntry(String string, String string2, double d) {
        return this.setEntry(string, string2, "", d);
    }

    public boolean setEntry(String string, String string2, String string3, double d) {
        Keyword keyword = this.findEntryKeyword(string, string2, string3);
        if (keyword == null) {
            return false;
        }
        keyword.setValue(Double.toString(d));
        return true;
    }

    public boolean setEntry(String string, String string2, float f) {
        return this.setEntry(string, string2, "", f);
    }

    public boolean setEntry(String string, String string2, String string3, float f) {
        Keyword keyword = this.findEntryKeyword(string, string2, string3);
        if (keyword == null) {
            return false;
        }
        keyword.setValue(Float.toString(f));
        return true;
    }

    public String getEntry(String string, String string2, String string3) {
        return this.getEntry(string, string2, "", string3);
    }

    public String getEntry(String string, String string2, String string3, String string4) {
        Keyword keyword = this.findEntryKeyword(string, string2, string3);
        if (keyword == null) {
            return string4;
        }
        return keyword.getValue();
    }

    public int getEntry(String string, String string2, int n) {
        return this.getEntry(string, string2, "", n);
    }

    public int getEntry(String string, String string2, String string3, int n) {
        Keyword keyword = this.findFolderKeyword(string);
        if (keyword == null) {
            return n;
        }
        try {
            int n2 = keyword.getIntValue(string2, string3);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public boolean getEntry(String string, String string2, boolean bl) {
        return this.getEntry(string, string2, "", bl);
    }

    public boolean getEntry(String string, String string2, String string3, boolean bl) {
        Keyword keyword = this.findFolderKeyword(string);
        if (keyword == null) {
            return bl;
        }
        return keyword.getBooleanValue(string2, string3);
    }

    public float getEntry(String string, String string2, long l) {
        return this.getEntry(string, string2, "", l);
    }

    public float getEntry(String string, String string2, String string3, long l) {
        Keyword keyword = this.findFolderKeyword(string);
        if (keyword == null) {
            return l;
        }
        try {
            return keyword.getLongValue(string2, string3);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public double getEntry(String string, String string2, double d) {
        return this.getEntry(string, string2, "", d);
    }

    public double getEntry(String string, String string2, String string3, double d) {
        Keyword keyword = this.findFolderKeyword(string);
        if (keyword == null) {
            return d;
        }
        try {
            return keyword.getDoubleValue(string2, string3);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public float getEntry(String string, String string2, float f) {
        return this.getEntry(string, string2, "", f);
    }

    public float getEntry(String string, String string2, String string3, float f) {
        Keyword keyword = this.findFolderKeyword(string);
        if (keyword == null) {
            return f;
        }
        try {
            return keyword.getFloatValue(string2, string3);
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    class RegistryCache {
        Hashtable htCache;
        Vector vCache;
        int nCacheSize = 30;

        RegistryCache() {
            this(30);
            this.init();
        }

        RegistryCache(int n) {
            OOCSRegistry.this = OOCSRegistry.this;
            this.nCacheSize = n;
            this.init();
        }

        void init() {
            this.htCache = new Hashtable(this.nCacheSize);
            this.vCache = new Vector(this.nCacheSize);
        }

        Keyword get(String string) {
            Keyword keyword = (Keyword)this.htCache.get(string);
            return keyword;
        }

        synchronized void put(String string, Keyword keyword) {
            if (this.htCache.contains(string)) {
                return;
            }
            if (this.vCache.size() >= this.nCacheSize) {
                this.trim();
            }
            this.htCache.put(string, keyword);
            this.vCache.addElement(string);
        }

        synchronized boolean remove(String string) {
            if (!this.htCache.contains(string)) {
                return false;
            }
            int n = this.vCache.indexOf(string);
            if (n == -1) {
                return false;
            }
            this.vCache.removeElementAt(n);
            this.htCache.remove(string);
            return false;
        }

        void trim() {
            while (this.vCache.size() > this.nCacheSize) {
                String string = (String)this.vCache.elementAt(0);
                this.vCache.removeElementAt(0);
                this.htCache.remove(string);
            }
        }
    }
}

