/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.dataStructures;

import com.ibm.eNetwork.onDemand.common.Assert;
import com.ibm.eNetwork.onDemand.common.TraceLevels;
import com.ibm.eNetwork.onDemand.common.gui.common.Scheme;
import com.ibm.eNetwork.onDemand.common.gui.common.Text;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewScheme;
import com.ibm.eNetwork.onDemand.common.gui.treeView.addableToTreeView;
import com.ibm.eNetwork.onDemand.common.sort.Comparable;
import com.ibm.eNetwork.onDemand.common.sort.SortAlgorithm;
import java.util.Enumeration;
import java.util.Vector;

public class TreeNode
implements addableToTreeView,
Comparable,
TraceLevels {
    public static boolean DEBUG;
    protected TreeNode tnParent;
    protected Vector vChildren;
    protected Object tnData;
    public Object oState;
    protected TreeViewScheme scheme;
    protected Text text;

    public TreeNode() {
        this.init();
    }

    public TreeNode(String string, TreeViewScheme treeViewScheme) {
        this();
        if (treeViewScheme != null) {
            this.setScheme(treeViewScheme);
        } else {
            if (DEBUG) {
                new Assert(this, "Creating default scheme for " + string);
            }
            this.scheme = this.createDefaultScheme();
        }
        this.setText(string);
    }

    public TreeNode(Text text, TreeViewScheme treeViewScheme) {
        this();
        if (treeViewScheme != null) {
            this.setScheme(treeViewScheme);
        } else {
            if (DEBUG) {
                new Assert(this, "Creating default scheme for " + text);
            }
            this.scheme = this.createDefaultScheme();
        }
        this.setText(text);
    }

    public TreeNode(String string, TreeViewScheme treeViewScheme, Object object) {
        this(string, treeViewScheme);
        this.setData(object);
    }

    public TreeNode(Text text, TreeViewScheme treeViewScheme, Object object) {
        this(text, treeViewScheme);
        this.setData(object);
    }

    protected void init() {
    }

    public void setText(String string) {
        if (this.text == null) {
            this.text = new Text();
        }
        this.text.addText(string, 0);
    }

    public void setText(Text text) {
        this.text = text;
    }

    public void setText(int n, String string) {
        this.text.addText(string, n);
    }

    public Text getText() {
        if (this.text == null) {
            this.text = new Text();
        }
        return this.text;
    }

    public void setScheme(Scheme scheme) {
        try {
            this.scheme = (TreeViewScheme)scheme;
            return;
        }
        catch (Exception exception) {
            System.err.println("TreeNode: Scheme not set");
            return;
        }
    }

    protected TreeViewScheme createDefaultScheme() {
        TreeViewScheme treeViewScheme = new TreeViewScheme();
        treeViewScheme.registerPosition(0);
        return treeViewScheme;
    }

    public String getLabel() {
        return this.getText().getText(0);
    }

    public String toString() {
        return this.getText().getText(0);
    }

    public String getTextAtPos(int n) {
        Text text = this.getText();
        if (text == null) {
            return null;
        }
        return text.getText(n);
    }

    public TreeNode getParent() {
        return this.tnParent;
    }

    public void setParent(TreeNode treeNode) {
        this.tnParent = treeNode;
    }

    public boolean addChildToFront(TreeNode treeNode) {
        boolean bl = false;
        if (this.vChildren == null) {
            this.vChildren = new Vector();
            bl = true;
        }
        if (treeNode != null) {
            if (bl) {
                this.vChildren.addElement(treeNode);
            } else {
                this.vChildren.insertElementAt(treeNode, 0);
            }
            treeNode.setParent(this);
            return true;
        }
        if (DEBUG && treeNode == null) {
            new Assert(this, "addChild() Child node parameter is null!");
        }
        return false;
    }

    public boolean addChildAfterSibling(TreeNode treeNode, TreeNode treeNode2) {
        if (this.vChildren == null) {
            return false;
        }
        if (treeNode != null && treeNode2 != null) {
            int n = this.vChildren.indexOf(treeNode2);
            if (n == -1) {
                return false;
            }
            this.vChildren.insertElementAt(treeNode, n);
            treeNode.setParent(this);
            return true;
        }
        if (DEBUG && treeNode == null) {
            new Assert(this, "addChild() Child node parameter is null!");
        }
        return false;
    }

    public boolean addChildAt(TreeNode treeNode, int n) {
        if (n < 0 || this.vChildren == null) {
            return false;
        }
        if (treeNode != null) {
            this.vChildren.insertElementAt(treeNode, n);
            treeNode.setParent(this);
            return true;
        }
        if (DEBUG && treeNode == null) {
            new Assert(this, "addChild() Child node parameter is null!");
        }
        return false;
    }

    public boolean addChild(TreeNode treeNode) {
        if (this.vChildren == null) {
            this.vChildren = new Vector();
        }
        if (treeNode != null) {
            this.vChildren.addElement(treeNode);
            treeNode.setParent(this);
            return true;
        }
        if (DEBUG && treeNode == null) {
            new Assert(this, "addChild() Child node parameter is null!");
        }
        return false;
    }

    public boolean addChild(TreeNode treeNode, SortAlgorithm sortAlgorithm) throws Exception {
        return this.addChild(treeNode, sortAlgorithm, null, true);
    }

    public boolean addChild(TreeNode treeNode, SortAlgorithm sortAlgorithm, Object object, boolean bl) throws Exception {
        if (this.vChildren == null) {
            this.vChildren = new Vector();
        }
        if (treeNode != null && sortAlgorithm != null) {
            sortAlgorithm.insert(this.vChildren, treeNode, object, bl);
            treeNode.setParent(this);
            return true;
        }
        if (DEBUG) {
            if (treeNode == null) {
                new Assert(this, "addChild() Child node parameter is null!");
            }
            if (sortAlgorithm == null) {
                new Assert(this, "addChild() Sorter parameter is null!");
            }
        }
        return false;
    }

    public void sortChildren(SortAlgorithm sortAlgorithm) throws Exception {
        this.sortChildren(sortAlgorithm, null);
    }

    public void sortChildren(SortAlgorithm sortAlgorithm, Object object) throws Exception {
        this.sortChildren(sortAlgorithm, object, true);
    }

    public void sortChildren(SortAlgorithm sortAlgorithm, Object object, boolean bl) throws Exception {
        if (this.vChildren == null) {
            return;
        }
        sortAlgorithm.sort(this.vChildren, object, bl);
    }

    public TreeNode removeChildAt(int n) {
        TreeNode treeNode = null;
        if (this.vChildren != null) {
            if (n < this.vChildren.size() && n > -1) {
                treeNode = (TreeNode)this.vChildren.elementAt(n);
                if (treeNode != null) {
                    treeNode.setParent(null);
                } else if (DEBUG) {
                    new Assert(this, "removeChildAt() Null child found!");
                }
                this.vChildren.removeElementAt(n);
                return treeNode;
            }
            if (DEBUG) {
                new Assert(this, "removeChildAt() Index out of bounds");
            }
        }
        if (this.vChildren.size() == 0) {
            this.vChildren = null;
        }
        return treeNode;
    }

    public TreeNode removeChild(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        int n = this.vChildren.indexOf(treeNode);
        return this.removeChildAt(n);
    }

    public void removeSelf() {
        if (this.tnParent != null) {
            this.tnParent.removeChild(this);
        }
    }

    public void removeAllChildren(boolean bl) {
        if (this.vChildren != null) {
            Enumeration enumeration = this.vChildren.elements();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = (TreeNode)enumeration.nextElement();
                if (treeNode != null) {
                    treeNode.setParent(null);
                    if (!bl) continue;
                    treeNode.removeAllChildren(true);
                    continue;
                }
                if (!DEBUG) continue;
                new Assert(this, "removeAllChildren(" + bl + ") null child found");
            }
            this.vChildren.removeAllElements();
            this.vChildren = null;
        }
    }

    public void removeAllChildren() {
        this.removeAllChildren(false);
    }

    public Enumeration getChildren() {
        if (this.vChildren == null) {
            return null;
        }
        return this.vChildren.elements();
    }

    public TreeNode getFirstChild() {
        return this.getChildAt(0);
    }

    public TreeNode getChildAt(int n) {
        TreeNode treeNode = null;
        if (this.vChildren != null && n < this.vChildren.size() && n > -1 && (treeNode = (TreeNode)this.vChildren.elementAt(n)) == null && DEBUG) {
            System.err.println("ASSERT TreeNode.getChildAt(): Null child found at index " + n);
        }
        return treeNode;
    }

    public int getIndexOfChild(TreeNode treeNode) {
        if (this.vChildren == null) {
            return -1;
        }
        return this.vChildren.indexOf(treeNode);
    }

    public TreeNode getNextSibling() {
        int n = 0;
        if (this.tnParent == null) {
            return null;
        }
        n = this.tnParent.getIndexOfChild(this);
        if (n == -1) {
            if (DEBUG) {
                System.err.println("ASSERT TreeNode.getNextSibling(): Nodes parent reports it is not the parent!");
            }
            return null;
        }
        return this.tnParent.getChildAt(n + 1);
    }

    public addableToTreeView getParentNode() {
        return this.getParent();
    }

    public addableToTreeView getNextNode() {
        return this.getNextSibling();
    }

    public addableToTreeView getChildNode() {
        return this.getFirstChild();
    }

    public boolean hasChild() {
        return this.getChildNode() != null;
    }

    public void setState(Object object) {
        this.oState = object;
    }

    public Object getState() {
        return this.oState;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public void setData(Object object) {
        if (DEBUG && this.tnData != null && DEBUG) {
            System.err.println("TreeNode: overwriting data object!");
        }
        this.tnData = object;
    }

    public Object getData() {
        return this.tnData;
    }

    public int compareTo(Comparable comparable, Object object) {
        String string = this.getLabel();
        if (string == null) {
            return -1;
        }
        String string2 = ((TreeNode)comparable).getLabel();
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }
}

