/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.common.images.ImageLoader;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.Hashtable;
import javax.accessibility.Accessible;

public class MenuPanel
extends Panel {
    static final String cStmt1 = Copyright.COPYRIGHT_97_98;
    protected static final String DEFAULT_DOWN_ARROW_IMAGE = "images/arrow.gif";
    protected static final String EXCEPTION_DEBUG_MSG = "<<EXCEPTION>> ";
    MenuBar menubar;
    protected Image downArrowImage;
    protected int menuLabelWidth = 10;
    protected int menuLabelHeight = 6;
    private Insets menuLabelInsets;
    protected boolean debug = false;
    protected static String sClassName = "MenuPanel : ";
    private ImageLoader il;
    protected MouseListener mouseListener;
    protected String displayingPopupMenuString;

    public MenuPanel() {
        this.commonConstructor(null, null, this.debug);
    }

    public MenuPanel(MenuBar menuBar) {
        this.commonConstructor(menuBar, null, this.debug);
    }

    public MenuPanel(MenuBar menuBar, Image image) {
        this.commonConstructor(menuBar, image, this.debug);
    }

    public MenuPanel(MenuBar menuBar, Image image, boolean bl) {
        this.commonConstructor(menuBar, image, bl);
    }

    private void commonConstructor(MenuBar menuBar, Image image, boolean bl) {
        this.debug = bl;
        this.downArrowImage = image;
        if (this.debug) {
            System.out.println(String.valueOf(sClassName) + "common constructor debug = " + this.debug);
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setForeground(SystemColor.menuText);
        this.setBackground(SystemColor.menu);
        if (this.downArrowImage == null) {
            try {
                Copyright copyright = new Copyright();
                this.il = new ImageLoader(this);
                if (this.debug) {
                    System.out.println(String.valueOf(sClassName) + "Load default image = " + copyright.getClass() + " " + DEFAULT_DOWN_ARROW_IMAGE);
                }
                this.downArrowImage = this.il.getImage(copyright.getClass(), DEFAULT_DOWN_ARROW_IMAGE);
            }
            catch (Exception exception) {
                if (this.debug) {
                    System.out.println(String.valueOf(sClassName) + "Could not load default image = " + DEFAULT_DOWN_ARROW_IMAGE);
                }
            }
        } else if (this.debug) {
            System.out.println(String.valueOf(sClassName) + "Use image parameter");
        }
        this.menuLabelInsets = new Insets(this.menuLabelHeight, this.menuLabelWidth, this.menuLabelHeight, this.menuLabelWidth + 3);
        if (menuBar != null) {
            this.setMenuBar(menuBar);
        }
    }

    public void paint(Graphics graphics) {
        if (this.debug) {
            System.out.println(String.valueOf(sClassName) + "paint()");
        }
        if (graphics != null) {
            super.paint(graphics);
            return;
        }
        if (this.debug) {
            System.out.println(String.valueOf(sClassName) + "paint() called with null graphics.");
        }
    }

    public void setDownArrowImage(Image image) {
        this.downArrowImage = image;
    }

    public void setMenuBar(MenuBar menuBar) {
        String string = "setMenuBar() ";
        if (this.debug) {
            System.out.println(String.valueOf(sClassName) + string);
        }
        this.removeAll();
        this.menubar = menuBar;
        int n = 0;
        while (n < menuBar.getMenuCount()) {
            Menu menu = menuBar.getMenu(n);
            String string2 = menu.getLabel();
            MenuLabel menuLabel = new MenuLabel(this, string2, this.downArrowImage, this.menuLabelInsets, this.debug);
            menuLabel.setDebug(this.debug);
            PopupMenu popupMenu = new PopupMenu(string2);
            MenuItem[] menuItemArray = new MenuItem[menu.getItemCount()];
            int n2 = 0;
            while (n2 < menu.getItemCount()) {
                menuItemArray[n2] = menu.getItem(n2);
                ++n2;
            }
            int n3 = 0;
            while (n3 < menuItemArray.length) {
                popupMenu.add(menuItemArray[n3]);
                ++n3;
            }
            menuLabel.add(popupMenu);
            menuLabel.addMouseListener(new MenuMouse());
            if (this.debug) {
                System.out.println(String.valueOf(sClassName) + string + "add label " + string2);
            }
            this.constrain(this, menuLabel, n, 0, 1, 0, 0, 18, 0.0, 0.0, 0, 0, 5, 1, 5, 1);
            ++n;
        }
        if (menuBar.getMenuCount() > 1) {
            this.constrain(this, new Panel(), menuBar.getMenuCount(), 0, 1, 0, 2, 18, 1.0, 0.0, 0, 0, 5, 1, 5, 1);
        }
    }

    protected void setDisplayingPopupMenu(String string) {
        MenuLabel menuLabel = this.findMenuLabel(this.displayingPopupMenuString);
        if (menuLabel != null) {
            menuLabel.setButtonToggle(false);
        }
        this.displayingPopupMenuString = string;
    }

    protected void constrain(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, int n7, int n8, int n9, int n10, int n11, int n12) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = n5;
        gridBagConstraints.anchor = n6;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.ipadx = n7;
        gridBagConstraints.ipady = n8;
        if (n9 + n11 + n10 + n12 > 0) {
            gridBagConstraints.insets = new Insets(n9, n10, n11, n12);
        }
        ((GridBagLayout)container.getLayout()).setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    protected MenuLabel findMenuLabel(String string) {
        String string2 = "findMenuLabel() ";
        if (string == null) {
            return null;
        }
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof MenuLabel) {
                MenuLabel menuLabel = (MenuLabel)componentArray[n];
                if (this.debug) {
                    System.out.println(String.valueOf(sClassName) + string2 + "menu label = " + menuLabel.getLabelString());
                }
                if (string.equals(menuLabel.getLabelString())) {
                    if (this.debug) {
                        System.out.println(String.valueOf(sClassName) + string2 + "match! = " + menuLabel.getLabelString());
                    }
                    return menuLabel;
                }
            }
            ++n;
        }
        return null;
    }

    public void setPopupMenuToMenuLabel(String string, PopupMenu popupMenu) {
        MenuLabel menuLabel = this.findMenuLabel(string);
        if (menuLabel != null) {
            if (this.debug) {
                System.out.println(String.valueOf(sClassName) + "setPopupMenuToMenuLabel() found a matching label for " + popupMenu);
            }
            if (popupMenu == null) {
                popupMenu = new PopupMenu();
            }
            menuLabel.add(popupMenu);
            return;
        }
        if (this.debug) {
            System.out.println(String.valueOf(sClassName) + "setPopupMenuToMenuLabel() couldn't find " + string);
        }
    }

    public void cleanupMenuLabels() {
        if (this.debug) {
            System.out.println(String.valueOf(sClassName) + "cleanupMenuLabels()");
        }
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            MenuLabel menuLabel;
            if (componentArray[n] instanceof MenuLabel && (menuLabel = (MenuLabel)componentArray[n]).isMenuLabelEnabled()) {
                menuLabel.setButtonToggle(false);
                menuLabel.repaint(menuLabel.getButtonDown());
            }
            ++n;
        }
    }

    public MenuBar getMenuBar() {
        if (this.debug) {
            System.out.println(String.valueOf(sClassName) + "getMenuBar()");
        }
        Component[] componentArray = this.getComponents();
        MenuBar menuBar = new MenuBar();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof MenuLabel) {
                MenuLabel menuLabel = (MenuLabel)componentArray[n];
                PopupMenu popupMenu = menuLabel.getPopupMenu();
                Menu menu = new Menu(menuLabel.getLabelString());
                MenuItem[] menuItemArray = new MenuItem[popupMenu.getItemCount()];
                int n2 = 0;
                while (n2 < menuItemArray.length) {
                    menuItemArray[n2] = popupMenu.getItem(n2);
                    ++n2;
                }
                int n3 = 0;
                while (n3 < menuItemArray.length) {
                    menu.add(menuItemArray[n3]);
                    ++n3;
                }
                menuBar.add(menu);
            }
            ++n;
        }
        return menuBar;
    }

    public void refresh() {
        Menu menu;
        Accessible accessible;
        if (this.debug) {
            System.out.println(String.valueOf(sClassName) + "refresh()");
        }
        Hashtable<String, Menu> hashtable = new Hashtable<String, Menu>();
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = componentArray[n];
            if (component instanceof MenuLabel) {
                accessible = (MenuLabel)component;
                menu = ((MenuLabel)accessible).getPopupMenu();
                if (menu == null) {
                    menu = new PopupMenu();
                }
                hashtable.put(((MenuPanelImageButton)accessible).getLabelString(), menu);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.menubar.getMenuCount()) {
            Object object;
            accessible = this.menubar.getMenu(n2);
            menu = (Menu)hashtable.get(((MenuItem)accessible).getLabel());
            if (menu == null) {
                object = new MenuLabel(this, ((MenuItem)accessible).getLabel(), this.downArrowImage, this.menuLabelInsets, this.debug);
                ((MenuPanelImageButton)object).setDebug(this.debug);
                menu = new PopupMenu();
                ((MenuLabel)object).add((PopupMenu)menu);
                this.add((Component)object);
                ((Component)object).addMouseListener(new MenuMouse());
            }
            object = new MenuItem[((Menu)accessible).getItemCount()];
            int n3 = 0;
            while (n3 < ((Menu)accessible).getItemCount()) {
                object[n3] = ((Menu)accessible).getItem(n3);
                ++n3;
            }
            int n4 = 0;
            while (n4 < ((MenuItem[])object).length) {
                menu.add((MenuItem)object[n4]);
                ++n4;
            }
            ++n2;
        }
        this.invalidate();
    }

    protected void unShowPopupMenu(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof MenuLabel) {
            this.cleanupMenuLabels();
            MenuLabel menuLabel = (MenuLabel)object;
            if (this.debug) {
                System.out.println(String.valueOf(sClassName) + "unShowPopupMenu() " + menuLabel.getButtonToggle());
            }
            menuLabel.getButtonToggle();
        }
    }

    protected void showPopupMenu(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof MenuLabel) {
            MenuLabel menuLabel = (MenuLabel)object;
            if (this.debug) {
                System.out.println(String.valueOf(sClassName) + "showPopupMenu pop = " + menuLabel.getButtonToggle());
            }
            if (menuLabel.getButtonToggle()) {
                menuLabel.showPopupMenu();
            }
        }
    }

    void Menu_mouseClick(MouseEvent mouseEvent) {
        if (this.debug) {
            System.out.println(String.valueOf(sClassName) + "Menu_mouseClick()");
        }
        this.showPopupMenu(mouseEvent);
    }

    void Menu_mouseMotion(MouseEvent mouseEvent) {
        if (this.debug) {
            System.out.println(String.valueOf(sClassName) + "Menu_mouseMotion()");
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (this.debug) {
            System.out.println(String.valueOf(sClassName) + "addMouseListener() ");
        }
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
    }

    public void removeActionListener(MouseListener mouseListener) {
        if (this.debug) {
            System.out.println(String.valueOf(sClassName) + "removeMouseListener() ");
        }
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (this.mouseListener != null && aWTEvent instanceof MouseEvent) {
            if (this.debug) {
                System.out.println(String.valueOf(sClassName) + "processEvent() " + aWTEvent);
            }
            switch (aWTEvent.getID()) {
                case 501: {
                    if (this.mouseListener == null) break;
                    this.mouseListener.mousePressed((MouseEvent)aWTEvent);
                    return;
                }
                case 502: {
                    if (this.mouseListener == null) break;
                    this.mouseListener.mouseReleased((MouseEvent)aWTEvent);
                    return;
                }
                case 500: {
                    if (this.mouseListener == null) break;
                    this.mouseListener.mouseClicked((MouseEvent)aWTEvent);
                    return;
                }
                case 504: {
                    if (this.mouseListener == null) break;
                    this.mouseListener.mouseEntered((MouseEvent)aWTEvent);
                    return;
                }
                case 505: {
                    if (this.mouseListener == null) break;
                    this.mouseListener.mouseExited((MouseEvent)aWTEvent);
                    return;
                }
            }
        }
    }

    protected void setDebug(boolean bl) {
        this.debug = bl;
    }

    protected boolean getDebug() {
        return this.debug;
    }

    class MenuLabel
    extends MenuPanelImageButton {
        private String sClassName = "MenuLabel : ";
        private boolean debug = false;
        PopupMenu pm;
        MenuPanel aMenuPanel;

        public MenuLabel(MenuPanel menuPanel2, String string, Image image, Insets insets, boolean bl) {
            super(string, image, insets, bl);
            MenuPanel.this = MenuPanel.this;
            this.aMenuPanel = menuPanel2;
            this.setButtonToggle(false);
            this.debug = bl;
            if (this.debug) {
                System.out.println(String.valueOf(this.sClassName) + "constructor for " + string + " debug = " + this.debug);
            }
        }

        public void add(PopupMenu popupMenu) {
            String string = "add() ";
            if (popupMenu != null) {
                if (this.debug) {
                    System.out.println(String.valueOf(this.sClassName) + string + "label = " + this.getLabelString() + " popup = " + popupMenu);
                }
                super.add(popupMenu);
            } else {
                popupMenu = new PopupMenu();
                if (this.debug) {
                    System.out.println(String.valueOf(this.sClassName) + string + "null popup label = " + this.getLabelString());
                }
            }
            this.pm = popupMenu;
            this.isMenuLabelEnabled();
        }

        public PopupMenu getPopupMenu() {
            return this.pm;
        }

        public void showPopupMenu() {
            block11: {
                String string = "showPopupMenu() ";
                if (this.debug) {
                    System.out.println(String.valueOf(this.sClassName) + string);
                }
                if (this.isMenuLabelEnabled()) {
                    if (this.debug) {
                        System.out.println(String.valueOf(this.sClassName) + string + "popup menu = " + this.pm);
                    }
                    this.setButtonToggle(true);
                    try {
                        this.pm.show(this, 0, this.getSize().height);
                    }
                    catch (Exception exception) {
                        if (this.debug) {
                            System.out.println(String.valueOf(this.sClassName) + string + MenuPanel.EXCEPTION_DEBUG_MSG + " exception = " + exception);
                        }
                        try {
                            this.add(this.pm);
                            this.pm.show(this, 0, this.getSize().height);
                            break block11;
                        }
                        catch (Exception exception2) {
                            this.setButtonToggle(false);
                            if (this.debug) {
                                System.out.println(String.valueOf(this.sClassName) + string + MenuPanel.EXCEPTION_DEBUG_MSG + " second exception = " + exception2);
                            }
                            break block11;
                        }
                    }
                }
                this.setButtonToggle(false);
                if (this.debug) {
                    System.out.println(String.valueOf(this.sClassName) + string + " null popup menu ");
                }
            }
            if (this.getButtonToggle()) {
                this.aMenuPanel.setDisplayingPopupMenu(this.getLabelString());
            }
        }

        protected boolean isMenuLabelEnabled() {
            boolean bl = true;
            if (this.pm == null || this.pm.getItemCount() == 0) {
                bl = false;
            }
            this.setButtonEnabled(bl);
            return bl;
        }
    }

    class MenuMouse
    implements MouseListener {
        private String sClassName = "MenuMouse : ";

        public void mouseReleased(MouseEvent mouseEvent) {
            if (MenuPanel.this.debug) {
                System.out.println(String.valueOf(this.sClassName) + "mouseReleased()");
            }
            if (mouseEvent.getSource() instanceof MenuLabel) {
                ((MenuLabel)mouseEvent.getSource()).mouseReleased(mouseEvent);
            }
            if (MenuPanel.this.mouseListener != null) {
                MenuPanel.this.mouseListener.mouseReleased(mouseEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (MenuPanel.this.debug) {
                System.out.println(String.valueOf(this.sClassName) + "mousePressed()");
            }
            if (mouseEvent.getSource() instanceof MenuLabel) {
                ((MenuLabel)mouseEvent.getSource()).mousePressed(mouseEvent);
            }
            MenuPanel.this.Menu_mouseClick(mouseEvent);
            if (MenuPanel.this.mouseListener != null) {
                MenuPanel.this.mouseListener.mousePressed(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (MenuPanel.this.debug) {
                System.out.println(String.valueOf(this.sClassName) + "mouseEntered()");
            }
            if (mouseEvent.getSource() instanceof MenuLabel) {
                ((MenuLabel)mouseEvent.getSource()).mouseEntered(mouseEvent);
            }
            if (MenuPanel.this.mouseListener != null) {
                MenuPanel.this.mouseListener.mouseEntered(mouseEvent);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (MenuPanel.this.debug) {
                System.out.println(String.valueOf(this.sClassName) + "mouseExited()");
            }
            if (mouseEvent.getSource() instanceof MenuLabel) {
                ((MenuLabel)mouseEvent.getSource()).mouseExited(mouseEvent);
            }
            if (MenuPanel.this.mouseListener != null) {
                MenuPanel.this.mouseListener.mouseExited(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (MenuPanel.this.debug) {
                System.out.println(String.valueOf(this.sClassName) + "mouseClicked()");
            }
            if (mouseEvent.getSource() instanceof MenuLabel) {
                ((MenuLabel)mouseEvent.getSource()).mouseClicked(mouseEvent);
            }
            MenuPanel.this.Menu_mouseClick(mouseEvent);
            if (MenuPanel.this.mouseListener != null) {
                MenuPanel.this.mouseListener.mouseClicked(mouseEvent);
            }
        }

        MenuMouse() {
            MenuPanel.this = MenuPanel.this;
        }
    }

    class MenuPanelImageButton
    extends Canvas
    implements MouseListener {
        protected Image labelImage;
        protected Image disabledLabelImage;
        protected int imageWidth = -1;
        protected int imageHeight = -1;
        private Insets buttonInsets = new Insets(2, 2, 2, 2);
        protected String labelString = "";
        protected int heightLabelString;
        protected int widthLabelString;
        protected int ascentLabelString;
        protected boolean buttonDown = false;
        private boolean buttonEnabled = false;
        private boolean buttonToggle = false;
        private Color buttonDownLabelStringColor = Color.blue;
        private Color labelStringColor = Color.black;
        private Color disabledLabelStringColor = Color.gray;
        private Color disabledLabelStringColorHighlight = Color.white;
        protected boolean debug = false;
        protected final String sClassName = "MenuPanelImageButton : ";

        public MenuPanelImageButton() {
            this("", null, null, false);
        }

        public MenuPanelImageButton(String string) {
            this(string, null, null, false);
        }

        public MenuPanelImageButton(String string, Image image) {
            this(string, image, null, false);
        }

        public MenuPanelImageButton(String string, Image image, Insets insets, boolean bl) {
            MenuPanel.this = MenuPanel.this;
            this.debug = bl;
            this.setLabelString(string);
            this.setlabelImage(image);
            this.setButtonInsets(insets);
            this.setForeground(SystemColor.menuText);
            this.setBackground(Color.lightGray);
        }

        public void setButtonToggle(boolean bl) {
            this.buttonToggle = bl;
            if (this.debug) {
                System.out.println("MenuPanelImageButton : setButtonToggle() " + this.buttonToggle + " for toggle label = " + this.labelString);
            }
        }

        public void switchButtonToggle() {
            this.buttonToggle = !this.buttonToggle;
            if (this.debug) {
                System.out.println("MenuPanelImageButton : switchButtonToggle() " + this.buttonToggle + " for toggle label = " + this.labelString);
            }
        }

        public boolean getButtonToggle() {
            if (this.debug) {
                System.out.println("MenuPanelImageButton : getButtonToggle() " + this.buttonToggle + " for toggle label = " + this.labelString);
            }
            return this.buttonToggle;
        }

        public void setLabelString(String string) {
            if (string != null) {
                this.labelString = string;
                return;
            }
            this.labelString = "";
        }

        public String getLabelString() {
            return this.labelString;
        }

        public void setButtonInsets(Insets insets) {
            if (insets != null) {
                if (this.debug) {
                    System.out.println("MenuPanelImageButton : setButtonInsets() " + insets);
                }
                this.buttonInsets = insets;
            }
        }

        public void setlabelImage(Image image) {
            this.labelImage = image;
        }

        protected void measure() {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            if (fontMetrics == null) {
                return;
            }
            this.heightLabelString = fontMetrics.getHeight();
            this.ascentLabelString = fontMetrics.getAscent();
            this.widthLabelString = fontMetrics.stringWidth(this.labelString);
            if (this.labelImage != null) {
                this.imageWidth = this.labelImage.getWidth(this);
                this.imageHeight = this.labelImage.getHeight(this);
                this.disabledLabelImage = this.createImage(new FilteredImageSource(this.labelImage.getSource(), new DisableImageFilter()));
            }
        }

        public void setButton(String string) {
            this.setLabelString(string);
            this.measure();
            this.repaint();
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.measure();
        }

        public void setForeground(Color color) {
            super.setForeground(color);
            this.labelStringColor = color;
            this.invalidate();
            this.repaint();
        }

        public void setButtonEnabled(boolean bl) {
            if (bl != this.buttonEnabled) {
                this.buttonEnabled = bl;
                this.invalidate();
                this.repaint();
            }
        }

        public boolean getButtonEnabled() {
            return this.buttonEnabled;
        }

        public void addNotify() {
            super.addNotify();
            this.measure();
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.widthLabelString + this.buttonInsets.left + this.imageWidth / 2 + this.buttonInsets.right, this.heightLabelString + this.buttonInsets.top + this.buttonInsets.bottom);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public boolean getButtonDown() {
            return this.buttonDown;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.debug) {
                System.out.println("MenuPanelImageButton : mouseReleased() " + this.buttonDown);
            }
            this.buttonDown = false;
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.paint(graphics);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.debug) {
                System.out.println("MenuPanelImageButton : mousePressed() " + this.buttonDown);
            }
            this.buttonDown = true;
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.paint(graphics);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.debug) {
                System.out.println("MenuPanelImageButton : mouseEntered() " + this.buttonDown);
            }
            this.buttonDown = false;
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.paint(graphics);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (this.debug) {
                System.out.println("MenuPanelImageButton : mouseExited() " + this.buttonDown);
            }
            this.buttonDown = false;
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.paint(graphics);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.debug) {
                System.out.println("MenuPanelImageButton : mouseClicked() " + this.buttonDown);
            }
            this.repaint();
        }

        public void repaint(boolean bl) {
            this.buttonDown = bl;
            super.repaint();
        }

        public void repaint() {
            this.buttonDown = false;
            super.repaint();
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = this.ascentLabelString + this.buttonInsets.top + 1;
            int n2 = this.buttonInsets.left;
            if (this.debug) {
                System.out.println("MenuPanelImageButton : paint() label = " + this.labelString + " x = " + n2 + " y = " + n + " ascentLabelString = " + this.ascentLabelString);
            }
            if (this.labelImage != null) {
                if (this.imageWidth < 0 || this.imageHeight < 0) {
                    this.measure();
                }
                if (this.debug) {
                    System.out.println("MenuPanelImageButton : paint() image width = " + this.imageWidth + " image height = " + this.imageHeight + " label height = " + this.heightLabelString + " label width = " + this.widthLabelString);
                }
                int n3 = n2 + this.widthLabelString + 1;
                int n4 = n - 2;
                if (this.debug) {
                    System.out.println("MenuPanelImageButton : paint() parent width = " + dimension.width + " parent height = " + dimension.height + " x image = " + n3 + " y image = " + n4);
                }
                Image image = this.createImage(dimension.width, dimension.height);
                graphics = image.getGraphics();
                if (this.buttonEnabled) {
                    graphics.drawImage(this.labelImage, n3, n4, this);
                } else if (this.disabledLabelImage != null) {
                    graphics.drawImage(this.disabledLabelImage, n3, n4, this);
                }
                graphics.clipRect(this.getLocation().x, this.getLocation().y, this.getSize().width, this.getSize().height);
                graphics = this.getGraphics();
                graphics.drawImage(image, 0, 0, this);
            }
            if (this.buttonDown && this.buttonEnabled) {
                this.switchButtonToggle();
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(Color.black);
            }
            if (this.debug) {
                System.out.println("MenuPanelImageButton : paint() down = " + this.buttonDown + " toggle = " + this.buttonToggle);
            }
            graphics.drawLine(dimension.width - 1, dimension.height - 1, 0, dimension.height - 1);
            graphics.drawLine(dimension.width - 1, dimension.height - 1, dimension.width - 1, 0);
            if (!this.buttonDown || !this.buttonEnabled) {
                graphics.setColor(Color.gray);
                graphics.drawLine(dimension.width - 2, dimension.height - 2, 1, dimension.height - 2);
                graphics.drawLine(dimension.width - 2, dimension.height - 2, dimension.width - 2, 1);
            }
            if (this.buttonDown && this.buttonEnabled) {
                graphics.setColor(Color.black);
                graphics.drawLine(0, 0, 0, dimension.height);
                graphics.drawLine(0, 0, dimension.width, 0);
            } else {
                graphics.setColor(Color.white);
                graphics.drawLine(0, 0, 0, dimension.height - 2);
                graphics.drawLine(0, 0, dimension.width - 2, 0);
            }
            if (this.buttonDown && this.buttonEnabled) {
                graphics.setColor(Color.gray);
                graphics.drawLine(1, 1, 1, dimension.height - 2);
                graphics.drawLine(1, 1, dimension.width - 2, 1);
            }
            if (!this.buttonEnabled) {
                graphics.setColor(this.disabledLabelStringColorHighlight);
                graphics.drawString(this.labelString, n2 + 1, n + 1);
                graphics.setColor(this.disabledLabelStringColor);
            } else if (this.buttonDown) {
                graphics.setColor(this.buttonDownLabelStringColor);
            } else {
                graphics.setColor(this.labelStringColor);
            }
            if (this.debug) {
                System.out.println("MenuPanelImageButton : paint() label = " + this.labelString);
            }
            graphics.drawString(this.labelString, n2, n);
        }

        protected void setDebug(boolean bl) {
            this.debug = bl;
        }

        protected boolean getDebug() {
            return this.debug;
        }
    }

    class DisableImageFilter
    extends RGBImageFilter {
        public DisableImageFilter() {
            MenuPanel.this = MenuPanel.this;
            this.canFilterIndexColorModel = false;
        }

        public int filterRGB(int n, int n2, int n3) {
            if ((n % 2 ^ n2 % 2) == 1) {
                return n3 & 0xFFFFFF;
            }
            return n3;
        }
    }
}

