/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.animatedProgressPanel;

import com.ibm.eNetwork.onDemand.common.TraceLevels;
import com.ibm.eNetwork.onDemand.common.gui.animationCanvas.AnimationCanvas;
import com.ibm.eNetwork.onDemand.common.gui.statusBar.StatusBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Hashtable;

public class AnimatedProgressPanelLayout
implements LayoutManager,
TraceLevels {
    protected Hashtable hash = new Hashtable();
    protected static final int XOFFSET = 3;
    protected static final int YOFFSET = 3;
    public static final String STATUS_BAR = "sb";
    public static final String ANIM_CANVAS = "ac";
    protected AnimationCanvas ac;
    protected StatusBar sb;

    public void addLayoutComponent(String string, Component component) {
        this.hash.put(string, component);
    }

    public void removeLayoutComponent(Component component) {
        this.hash.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public Dimension minimumLayoutSize(Container container) {
        try {
            StatusBar statusBar = (StatusBar)this.hash.get(STATUS_BAR);
            AnimationCanvas animationCanvas = (AnimationCanvas)this.hash.get(ANIM_CANVAS);
            Dimension dimension = animationCanvas.getPreferredSize();
            dimension.width += 6;
            dimension.height += 9;
            dimension.height += statusBar.getPreferredSize().height;
            return dimension;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return new Dimension(150, 150);
        }
    }

    public void layoutContainer(Container container) {
        try {
            Dimension dimension = container.getSize();
            this.resizeCanvas((AnimationCanvas)this.hash.get(ANIM_CANVAS), dimension);
            this.resizeStatusBar((StatusBar)this.hash.get(STATUS_BAR), dimension);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void resizeStatusBar(StatusBar statusBar, Dimension dimension) {
        try {
            this.sb = statusBar;
            Dimension dimension2 = statusBar.getPreferredSize();
            statusBar.setBounds(3, dimension.height - dimension2.height - 3, dimension.width - 6, dimension2.height);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void resizeCanvas(AnimationCanvas animationCanvas, Dimension dimension) {
        try {
            this.ac = animationCanvas;
            Dimension dimension2 = animationCanvas.getPreferredSize();
            animationCanvas.setBounds((dimension.width - 6) / 2 - dimension2.width / 2, 3, dimension2.width, dimension2.height);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public String toString() {
        return "AnimatedProgressPanelLayout";
    }
}

