/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.animationCanvas;

import com.ibm.eNetwork.onDemand.common.Timer;
import com.ibm.eNetwork.onDemand.common.TimerListener;
import com.ibm.eNetwork.onDemand.common.gui.common.DBCanvas;
import com.ibm.eNetwork.onDemand.common.gui.eNoDGUIMetrics;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class AnimationCanvas
extends DBCanvas
implements TimerListener {
    protected static Timer timer = null;
    protected int iSpeed = 500;
    protected int iStep = 1;
    protected int iImageIndex;
    protected int iMaxIndex;
    protected Image image;
    protected Vector vImages;
    protected static Rectangle area = null;
    protected Dimension dimSize;
    protected boolean bPainting = false;

    public AnimationCanvas(int n, int n2, Vector vector) {
        this.cfcColor.addColor(eNoDGUIMetrics.dialogBackgroundColor, 0);
        this.setAttribs();
        this.iSpeed = n;
        this.iStep = n2;
        this.vImages = vector;
        this.iMaxIndex = vector.size() - 1;
        this.dimSize = this.calcPreferredSize();
        timer = new Timer(n);
    }

    protected Dimension calcPreferredSize() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Image image = null;
        Enumeration enumeration = this.vImages.elements();
        while (enumeration.hasMoreElements()) {
            image = (Image)enumeration.nextElement();
            n = image.getWidth(this);
            n3 = image.getHeight(this);
            n2 = Math.max(n, n2);
            n4 = Math.max(n3, n4);
        }
        area = new Rectangle(0, 0, n2, n4);
        return new Dimension(n2, n4);
    }

    public Dimension getPreferredSize() {
        return this.dimSize;
    }

    public void start() {
        timer.addTimerListener(this);
    }

    public void stop() {
        timer.removeTimerListener(this);
    }

    public synchronized void draw(Graphics graphics) {
        this.image = (Image)this.vImages.elementAt(this.iImageIndex);
        if (this.image == null) {
            return;
        }
        this.ifcImage.addImage(this.image, 0);
        this.ifcImage.drawImage(0, graphics, area);
    }

    public void timerFired() {
        if (this.bPainting) {
            return;
        }
        this.bPainting = true;
        this.incrementImagePosition(this.iStep);
        Graphics graphics = this.getGraphics();
        this.update(graphics);
        this.bPainting = false;
    }

    protected void incrementImagePosition(int n) {
        this.iImageIndex += n;
        if (this.iImageIndex > this.iMaxIndex) {
            this.iImageIndex = this.iImageIndex - this.iMaxIndex - 1;
        }
    }

    protected void finalize() throws Throwable {
        if (timer != null) {
            timer.stop();
        }
        super.finalize();
    }
}

