/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.attribView;

import com.ibm.eNetwork.onDemand.common.gui.attribView.AttribFieldEvent;
import com.ibm.eNetwork.onDemand.common.gui.attribView.AttribFieldEventListener;
import com.ibm.eNetwork.onDemand.common.gui.attribView.AttribView;
import com.ibm.eNetwork.onDemand.common.gui.attribView.AttribViewCanvas;
import com.ibm.eNetwork.onDemand.common.gui.attribView.AttribViewNode;
import com.ibm.eNetwork.onDemand.common.gui.common.Controler;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedCanvas;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeView;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;

public class AttribViewControler
extends Controler
implements MouseListener,
MouseMotionListener {
    protected AttribViewCanvas avc;
    protected AttribView av;
    protected Cursor curEast = new Cursor(11);
    protected Cursor curNorm;
    protected TreeView tv;

    public AttribViewControler(TreeView treeView, AttribView attribView) {
        this.av = attribView;
        this.tv = treeView;
    }

    public void register(ExtendedCanvas extendedCanvas) {
        try {
            AttribViewCanvas attribViewCanvas = (AttribViewCanvas)extendedCanvas;
            attribViewCanvas.addMouseListener(this);
            attribViewCanvas.addMouseMotionListener(this);
            this.avc = attribViewCanvas;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void unregister(ExtendedCanvas extendedCanvas) {
        try {
            AttribViewCanvas attribViewCanvas = (AttribViewCanvas)extendedCanvas;
            attribViewCanvas.removeMouseListener(this);
            attribViewCanvas.removeMouseMotionListener(this);
            this.avc = null;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            boolean bl = this.avc.setDragging(false);
            if (bl) {
                this.av.fieldSizesChanged();
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        try {
            if (this.curNorm == null) {
                this.curNorm = this.avc.getCursor();
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        try {
            Point point = mouseEvent.getPoint();
            if (this.avc.isDraggablepoint(point)) {
                this.avc.setDragging(true);
                return;
            }
            AttribViewNode attribViewNode = (AttribViewNode)this.avc.findOnMouseDown(point.x, point.y);
            if (attribViewNode != null && attribViewNode.getSortable()) {
                int n = this.avc.selectNode(attribViewNode);
                this.createEvent(attribViewNode, n);
            }
            this.tv.requestFocus();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    protected boolean isMyEvent(AWTEvent aWTEvent) {
        try {
            if (aWTEvent instanceof AttribFieldEvent) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected boolean sendEvent(AWTEvent aWTEvent) {
        try {
            Enumeration enumeration = this.hListeners.elements();
            AttribFieldEvent attribFieldEvent = (AttribFieldEvent)aWTEvent;
            while (enumeration.hasMoreElements()) {
                AttribFieldEventListener attribFieldEventListener = (AttribFieldEventListener)enumeration.nextElement();
                attribFieldEvent.sendEvent(attribFieldEventListener);
            }
        }
        catch (Exception exception) {}
        return true;
    }

    protected boolean createEvent(AttribViewNode attribViewNode, int n) {
        try {
            AttribFieldEvent attribFieldEvent = new AttribFieldEvent(this.tv, attribViewNode, n, 828);
            this.postEvent(attribFieldEvent);
        }
        catch (Exception exception) {}
        return true;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        try {
            Point point = mouseEvent.getPoint();
            this.avc.drag(point);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        try {
            Point point = mouseEvent.getPoint();
            boolean bl = this.avc.isDraggablepoint(point);
            if (bl) {
                this.avc.setCursor(this.curEast);
                return;
            }
            this.avc.setCursor(this.curNorm);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

