/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.attribView;

import com.ibm.eNetwork.onDemand.common.gui.attribView.AttribField;
import com.ibm.eNetwork.onDemand.common.gui.attribView.AttribViewConstants;
import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.LeftAlignedNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class AttribViewNode
extends LeftAlignedNode
implements AttribViewConstants {
    protected boolean bFirst = false;
    protected boolean bLast = false;
    protected String sLabel;
    protected AttribField afField;
    protected int iIndex = -1;
    protected Image iSelectedImage;
    protected static Image iUp = null;
    protected static Image iDown = null;
    protected Component c;
    protected static int iPixWidthUp = 10;
    protected static int iPixHeightUp = 10;
    protected static int[] pixUp = new int[]{1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, -13548966, -1048577, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, -11906445, -1048577, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, -12430741, 1352468, 1352468, -1048577, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, -12430741, 1352468, 1352468, -1048577, 1352468, 1352468, 1352468, 1352468, 1352468, -12430741, 1352468, 1352468, 1352468, 1352468, -1576961, 1352468, 1352468, 1352468, 1352468, -13548966, 1352468, 1352468, 1352468, 1352468, -1048577, 1352468, 1352468, 1352468, 1352468, -1048577, -1048577, -1576961, -1048577, -1048577, -1576961, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468, 1352468};
    protected static int iPixWidthDown = 10;
    protected static int iPixHeightDown = 10;
    protected static int[] pixDown = new int[]{2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, -14601910, -1574913, -1048577, -1574913, -1048577, -1048577, -1574913, 2582640, 2582640, 2582640, 2582640, -12430741, 2582640, 2582640, 2582640, 2582640, -1574913, 2582640, 2582640, 2582640, 2582640, -14601910, 2582640, 2582640, 2582640, 2582640, -1574913, 2582640, 2582640, 2582640, 2582640, 2582640, -12430741, 2582640, 2582640, -1574913, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, -14075558, 2582640, 2582640, -1574913, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, -14075558, -1048577, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, -12430741, -1574913, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640, 2582640};

    public AttribViewNode(AttribField attribField, Component component) {
        super(attribField.getText(), attribField.getColors(), attribField.getFonts(), attribField.getImage());
        this.afField = attribField;
        this.createSelectedImages(component);
        this.c = component;
    }

    protected void createSelectedImages(Component component) {
        int n;
        int n2;
        int n3;
        if (iUp == null) {
            n3 = SystemColor.control.brighter().getRGB();
            n2 = iPixWidthUp * iPixHeightUp;
            try {
                n = 0;
                while (n < n2) {
                    if (pixUp[n] == -1) {
                        AttribViewNode.pixUp[n] = n3;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
            iUp = ImagesForCanvas.createImage(component, iPixWidthUp, iPixHeightUp, pixUp);
        }
        if (iDown == null) {
            n3 = SystemColor.control.brighter().getRGB();
            n2 = iPixWidthDown * iPixHeightDown;
            try {
                n = 0;
                while (n < n2) {
                    if (pixDown[n] == -1) {
                        AttribViewNode.pixDown[n] = n3;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
            iDown = ImagesForCanvas.createImage(component, iPixWidthUp, iPixHeightDown, pixDown);
        }
    }

    public static void clearImages() {
        if (iDown != null) {
            iDown.flush();
            iDown = null;
        }
        if (iUp != null) {
            iUp.flush();
            iUp = null;
        }
    }

    public AttribViewNode(String string, ColorsForCanvas colorsForCanvas, FontsForCanvas fontsForCanvas, ImagesForCanvas imagesForCanvas) {
        super(string, colorsForCanvas, fontsForCanvas, imagesForCanvas);
    }

    public int setSelected2(boolean bl) {
        int n = 0;
        if (this.getSelected() && bl) {
            if (this.iSelectedImage == iUp) {
                this.iSelectedImage = iDown;
                n = -1;
            } else {
                this.iSelectedImage = iUp;
                n = 1;
            }
        } else if (bl) {
            this.iSelectedImage = iDown;
            n = -1;
        } else {
            this.iSelectedImage = null;
        }
        this.setSelected(bl);
        return n;
    }

    public void draw(Graphics graphics, Rectangle rectangle) {
        super.draw(graphics, rectangle);
        if (this.getSortable()) {
            this.drawSelectedGraphic(graphics, rectangle);
        }
        this.drawOutline(graphics, new Rectangle(rectangle.x, rectangle.y, rectangle.width - 2, rectangle.height - 2));
    }

    protected void drawSelectedGraphic(Graphics graphics, Rectangle rectangle) {
        if (this.iSelectedImage == null) {
            return;
        }
        int n = 0;
        int n2 = this.ifcImage.getImageHeight(this.iSelectedImage);
        int n3 = this.getSize().height;
        n = (n3 - n2) / 2;
        graphics.drawImage(this.iSelectedImage, this.getLocation().x + this.getSize().width - this.ifcImage.getImageWidth(iUp) - this.iHorzSpace, n, null, this.c);
    }

    protected String computeText(int n) {
        try {
            int n2;
            if (!this.getSortable()) {
                return super.computeText(n);
            }
            int n3 = this.getWidth() - this.ifcImage.getImageWidth(n) - 2 * this.iHorzSpace;
            String string = this.getText();
            if (this.iSelectedImage != null) {
                n3 -= this.ifcImage.getImageWidth(this.iSelectedImage) + this.iHorzSpace;
            }
            if ((n2 = this.ffcFont.getStringWidth(string, n)) < n3) {
                return string;
            }
            int n4 = n2 - n3;
            int n5 = this.ffcFont.getFontAverageWidth(n);
            int n6 = (int)((float)n4 / (float)n5 + 3.0f);
            int n7 = string.length() - n6 - 1;
            if (n7 < 1) {
                return "";
            }
            return String.valueOf(string.substring(0, n7)) + "...";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void drawOutline(Graphics graphics, Rectangle rectangle) {
        Color color = this.cfcColor.getColor(0);
        Color color2 = color.brighter();
        Color color3 = color.darker();
        Color color4 = color3.darker();
        graphics.setColor(color2);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
        graphics.setColor(color3);
        graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + 1);
        graphics.setColor(color4);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        graphics.drawLine(rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + 1);
    }

    public void committ() {
        Object object;
        if (this.afField != null) {
            this.ffcFont = this.afField.getFonts();
            this.cfcColor = this.afField.getColors();
            this.ifcImage = this.afField.getImage();
            this.sText = this.afField.getText();
        }
        if (this.ifcImage.getImage(1) == null && (object = this.ifcImage.getImage(0)) != null) {
            this.ifcImage.addImage((Image)object, 1);
        }
        super.committ();
        if (this.afField != null) {
            if (this.afField.getWidth() != -1) {
                this.setSize(this.afField.getWidth(), this.getSize().height);
                return;
            }
            object = this.getSize();
            if (this.getSortable()) {
                ((Dimension)object).width += this.ifcImage.getImageWidth(iUp) + this.iHorzSpace;
            }
            this.setSize(((Dimension)object).width, ((Dimension)object).height);
        }
    }

    protected void setFirst(boolean bl) {
        this.bFirst = bl;
    }

    protected void setLast(boolean bl) {
        this.bLast = bl;
    }

    public AttribField getAttribField() {
        return this.afField;
    }

    public int getIndex() {
        return this.iIndex;
    }

    public void setIndex(int n) {
        this.iIndex = n;
    }

    public boolean getSortable() {
        return this.afField.getSortable();
    }
}

