/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.common;

import com.ibm.eNetwork.onDemand.common.TraceLevels;
import com.ibm.eNetwork.onDemand.common.gui.common.CleanupThread;
import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.dbCanvasImageIndexMap;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public abstract class DBCanvas
extends Canvas
implements dbCanvasImageIndexMap,
TraceLevels {
    protected Graphics gOffscreen;
    protected Image iOffscreen;
    protected Dimension dSize = new Dimension(13333, 1);
    protected static CleanupThread cleanup = null;
    public ImagesForCanvas ifcImage = new ImagesForCanvas();
    public ColorsForCanvas cfcColor = new ColorsForCanvas();

    public abstract void draw(Graphics var1);

    public Graphics startPaint(Graphics graphics) {
        if (this.canUseDoubleBuffering()) {
            return this.gOffscreen;
        }
        return graphics;
    }

    public DBCanvas() {
        if (cleanup == null) {
            cleanup = new CleanupThread();
        }
    }

    public void endPaint(Graphics graphics) {
        if (this.iOffscreen != null) {
            graphics.drawImage(this.iOffscreen, 0, 0, this);
        }
    }

    private boolean canUseDoubleBuffering() {
        Dimension dimension = this.getSize();
        if (dimension.width > 0 && dimension.height > 0) {
            if (this.dSize.width != dimension.width || this.dSize.height != dimension.height) {
                try {
                    if (this.iOffscreen != null) {
                        this.iOffscreen.flush();
                        this.iOffscreen = null;
                    }
                    this.iOffscreen = this.createImage(dimension.width, dimension.height);
                }
                catch (Exception exception) {
                    return false;
                }
                if (this.iOffscreen == null) {
                    return false;
                }
                if (this.gOffscreen != null) {
                    this.gOffscreen.dispose();
                    cleanup.queueGarbageCollection();
                }
                this.gOffscreen = this.iOffscreen.getGraphics();
                if (this.gOffscreen == null) {
                    return false;
                }
                this.dSize = dimension;
                return true;
            }
            return true;
        }
        return false;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        try {
            Graphics graphics2 = this.startPaint(graphics);
            Dimension dimension = this.getSize();
            if (!this.tileBackground(graphics2, dimension.width, dimension.height)) {
                this.paintBackground(graphics2, dimension);
            }
            this.draw(graphics2);
            this.endPaint(graphics);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void paintBackground(Graphics graphics, Dimension dimension) {
        graphics.setColor(this.cfcColor.getColor(0));
        graphics.fillRect(0, 0, dimension.width, dimension.height);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean tileBackground(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Image image = null;
        if (this.ifcImage == null) return false;
        image = this.ifcImage.getImage(2);
        if (image == null) return false;
        n3 = this.ifcImage.getImageWidth(2);
        n4 = this.ifcImage.getImageHeight(2);
        if (n3 == 0 || n4 == 0) {
            return false;
        }
        do {
            n5 = 0;
            do {
                graphics.drawImage(image, n5, n6, this.ifcImage);
            } while ((n5 += n3) < n);
        } while ((n6 += n4) < n2);
        return true;
    }

    public void copyAttribs(ColorsForCanvas colorsForCanvas, ImagesForCanvas imagesForCanvas) {
        this.cfcColor = colorsForCanvas == null ? new ColorsForCanvas() : colorsForCanvas;
        if (imagesForCanvas == null) {
            this.ifcImage = new ImagesForCanvas();
            return;
        }
        this.ifcImage = imagesForCanvas;
    }

    public void setAttribs() {
        this.setColors(this.cfcColor);
        this.setGraphics(this.ifcImage);
    }

    public void setColors(ColorsForCanvas colorsForCanvas) {
        this.cfcColor = colorsForCanvas == null ? new ColorsForCanvas() : colorsForCanvas;
        this.setBackground(this.cfcColor.getColor(0));
        this.setForeground(this.cfcColor.getColor(1));
    }

    public void setGraphics(ImagesForCanvas imagesForCanvas) {
        if (imagesForCanvas == null) {
            this.ifcImage = new ImagesForCanvas();
            return;
        }
        this.ifcImage = imagesForCanvas;
    }

    public void dispose() {
        try {
            this.finalize();
            return;
        }
        catch (Throwable throwable) {
            System.err.println("TreeViewCanvas " + throwable);
            return;
        }
    }

    protected void finalize() throws Throwable {
        if (this.iOffscreen != null) {
            this.iOffscreen.flush();
            this.iOffscreen = null;
        }
        if (this.gOffscreen != null) {
            this.gOffscreen.dispose();
            this.gOffscreen = null;
        }
        super.finalize();
    }
}

