/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.common;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedNode;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class DrawableNode
extends ExtendedNode {
    protected DrawableNode dnNext;
    protected DrawableNode dnPrev;
    public static final int ICON = 0;
    public static final int BACKGROUND = 1;
    protected boolean bPaintBackground = true;
    protected boolean bSelected = false;
    protected boolean bOnScreen = false;

    public DrawableNode(String string, DrawableNode drawableNode, ColorsForCanvas colorsForCanvas, FontsForCanvas fontsForCanvas, ImagesForCanvas imagesForCanvas) {
        super(string, colorsForCanvas, fontsForCanvas, imagesForCanvas);
        this.insertPrevNode(drawableNode);
    }

    public DrawableNode(String string, ColorsForCanvas colorsForCanvas, FontsForCanvas fontsForCanvas, ImagesForCanvas imagesForCanvas) {
        super(string, colorsForCanvas, fontsForCanvas, imagesForCanvas);
    }

    public void insertNextNode(DrawableNode drawableNode) {
        DrawableNode drawableNode2 = this.dnNext;
        this.setNext(drawableNode);
        if (drawableNode != null) {
            drawableNode.setPrev(this);
            if (drawableNode2 != null) {
                drawableNode2.setPrev(drawableNode);
                drawableNode.setNext(drawableNode2);
            }
        }
    }

    public void setNext(DrawableNode drawableNode) {
        this.dnNext = drawableNode;
    }

    public void setPrev(DrawableNode drawableNode) {
        this.dnPrev = drawableNode;
    }

    public void insertPrevNode(DrawableNode drawableNode) {
        DrawableNode drawableNode2 = null;
        if (drawableNode != null) {
            drawableNode2 = drawableNode.getNext();
            drawableNode.setNext(this);
            this.setNext(drawableNode2);
            if (drawableNode2 != null) {
                drawableNode2.setPrev(this);
            }
        }
        this.setPrev(drawableNode);
    }

    public DrawableNode getPrev() {
        return this.dnPrev;
    }

    public DrawableNode getNext() {
        return this.dnNext;
    }

    public boolean removeMe() {
        if (this.dnPrev != null) {
            this.dnPrev.setNext(this.dnNext);
        }
        if (this.dnNext != null) {
            this.dnNext.setPrev(this.dnPrev);
        }
        return true;
    }

    public DrawableNode killMe() {
        DrawableNode drawableNode = this.dnNext;
        this.dnPrev = null;
        this.dnNext = null;
        return drawableNode;
    }

    public void setBackgroundPainting(boolean bl) {
        this.bPaintBackground = bl;
    }

    protected void paintBackground(Graphics graphics, Rectangle rectangle) {
        if (!this.bPaintBackground) {
            return;
        }
        graphics.setColor(this.cfcColor.getColor(0));
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean getSelected() {
        return this.bSelected;
    }

    public void setSelected(boolean bl) {
        this.bSelected = bl;
    }

    public boolean isOnScreen() {
        return this.bOnScreen;
    }

    public void onScreen(boolean bl) {
        this.bOnScreen = bl;
    }
}

