/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.common;

import com.ibm.eNetwork.onDemand.common.gui.common.ImageCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class ImageTextCanvas
extends ImageCanvas {
    Image img;
    String text;
    static final String copyright = "Copyright IBM Corporation 1997. All rights reserved.\nU.S. Government Users Restricted Rights - Use, duplication\nor disclosure restricted by GSA ADP Schedule Contract with\nIBM Corp.\n\n";

    public ImageTextCanvas(String string) {
        this.text = string;
    }

    public ImageTextCanvas(Image image) {
        this.img = image;
    }

    public ImageTextCanvas(Image image, String string) {
        this.img = image;
        this.text = string;
    }

    public void setText(String string) {
        this.text = string;
        this.invalidate();
    }

    public void draw(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.img != null) {
            graphics.drawImage(this.img, 0, 0, dimension.width, dimension.height, 0, 0, this.img.getWidth(null), this.img.getHeight(null), Color.lightGray, this);
            if (this.text != null) {
                graphics.setColor(new Color(0xFFFFFF));
                graphics.setFont(new Font(this.getFont().getName(), 0, 24));
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = (dimension.width - fontMetrics.stringWidth(this.text)) / 2;
                int n2 = (dimension.height + fontMetrics.getAscent()) / 2;
                graphics.drawString(this.text, n, n2);
                return;
            }
        } else {
            graphics.clearRect(0, 0, dimension.width, dimension.height);
        }
    }
}

