/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.common;

import com.ibm.eNetwork.onDemand.common.TraceLevels;
import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.NodeAttribute;
import com.ibm.eNetwork.onDemand.common.gui.common.StorageObject;
import java.awt.PopupMenu;
import java.util.Enumeration;

public abstract class Scheme
extends StorageObject
implements TraceLevels {
    public static final int NO_PLACEMENT = -1;
    public static final int ALL_POSITIONS = -2;
    protected static final int COLORS = 1;
    protected static final int FONTS = 2;
    protected static final int IMAGES = 3;
    protected static final int POPUPMENUS = 4;
    protected static final int CONTROLERS = 5;

    public abstract boolean isValidPosition(int var1);

    public void setDefaults() {
    }

    public boolean isValidRange(int n) {
        return this.isValidPosition(n);
    }

    protected NodeAttribute getNode(int n) {
        return (NodeAttribute)this.get(n);
    }

    protected void addNode(NodeAttribute nodeAttribute, int n) {
        this.add(nodeAttribute, n);
    }

    protected void removeNode(int n) {
        this.remove(n);
    }

    public void setPopupMenu(int n, PopupMenu popupMenu) {
        try {
            if (n == -2) {
                this.setAll(popupMenu, 4);
                return;
            }
            NodeAttribute nodeAttribute = this.getNode(n);
            nodeAttribute.setPopupMenu(popupMenu);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public PopupMenu getPopupMenu(int n) {
        try {
            NodeAttribute nodeAttribute = this.getNode(n);
            PopupMenu popupMenu = nodeAttribute.getPopupMenu();
            return popupMenu;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setColors(int n, ColorsForCanvas colorsForCanvas) {
        try {
            if (n == -2) {
                this.setAll(colorsForCanvas, 1);
                return;
            }
            NodeAttribute nodeAttribute = this.getNode(n);
            nodeAttribute.setColors(colorsForCanvas);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public ColorsForCanvas getColors(int n) {
        try {
            NodeAttribute nodeAttribute = this.getNode(n);
            ColorsForCanvas colorsForCanvas = nodeAttribute.getColors();
            return colorsForCanvas;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setFonts(int n, FontsForCanvas fontsForCanvas) {
        try {
            if (n == -2) {
                this.setAll(fontsForCanvas, 2);
                return;
            }
            NodeAttribute nodeAttribute = this.getNode(n);
            nodeAttribute.setFonts(fontsForCanvas);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public FontsForCanvas getFonts(int n) {
        try {
            NodeAttribute nodeAttribute = this.getNode(n);
            FontsForCanvas fontsForCanvas = nodeAttribute.getFonts();
            return fontsForCanvas;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setImages(int n, ImagesForCanvas imagesForCanvas) {
        try {
            if (n == -2) {
                this.setAll(imagesForCanvas, 3);
                return;
            }
            NodeAttribute nodeAttribute = this.getNode(n);
            nodeAttribute.setImage(imagesForCanvas);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public ImagesForCanvas getImages(int n) {
        try {
            NodeAttribute nodeAttribute = this.getNode(n);
            ImagesForCanvas imagesForCanvas = nodeAttribute.getImage();
            return imagesForCanvas;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void registerPosition(int n) {
        try {
            if (!this.isValidPosition(n)) {
                System.err.println("Invalid position registered");
                return;
            }
            NodeAttribute nodeAttribute = new NodeAttribute();
            this.addNode(nodeAttribute, n);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void unregisterPosition(int n) {
        try {
            if (!this.isValidPosition(n)) {
                System.err.println("Invalid position unregistered");
                return;
            }
            this.removeNode(n);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public String toString() {
        return "[unnamed scheme]";
    }

    protected void setAll(Object object, int n) {
        try {
            Enumeration enumeration = this.elements();
            NodeAttribute nodeAttribute = null;
            while (enumeration.hasMoreElements()) {
                nodeAttribute = (NodeAttribute)enumeration.nextElement();
                switch (n) {
                    case 1: {
                        nodeAttribute.setColors((ColorsForCanvas)object);
                        break;
                    }
                    case 2: {
                        nodeAttribute.setFonts((FontsForCanvas)object);
                        break;
                    }
                    case 3: {
                        nodeAttribute.setImage((ImagesForCanvas)object);
                        break;
                    }
                    case 4: {
                        nodeAttribute.setPopupMenu((PopupMenu)object);
                        break;
                    }
                }
            }
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }

    public void dispose() {
        Enumeration enumeration = this.elements();
        Object var2_2 = null;
        while (enumeration.hasMoreElements()) {
            var2_2 = enumeration.nextElement();
            if (!(var2_2 instanceof StorageObject)) continue;
            ((StorageObject)var2_2).dispose();
        }
        super.dispose();
    }
}

