/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui;

import com.ibm.eNetwork.onDemand.common.gui.eNoDGUIMetrics;
import com.ibm.eNetwork.onDemand.common.gui.eNoDUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class eNoDPanel
extends Panel
implements FocusListener {
    public static final int SOLID = 0;
    public static final int OUTLINE = 1;
    public static final int NONE = 2;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int DEFAULT_STYLE = 2;
    public static final int DEFAULT_THICKNESS = 6;
    public static final int DEFAULT_GAP = 4;
    public static final Color DEFAULT_COLOR = eNoDGUIMetrics.headingsColor;
    public static final Font DEFAULT_FONT = eNoDGUIMetrics.headingsFont;
    public static final int DEFAULT_ALIGNMENT = 0;
    protected int style = 2;
    protected int thickness = 6;
    protected int gap = 4;
    protected Color color = DEFAULT_COLOR;
    protected Font font = DEFAULT_FONT;
    protected String sLabel;
    protected int alignment = 0;
    protected Insets panelInsets;
    protected eNoDUtils util;
    protected long lFocusTime = -1L;
    public static final long TIME_VOID = -1L;

    public eNoDPanel() {
        this.setBackground(eNoDGUIMetrics.applicationBackgroundColor);
    }

    public eNoDPanel(String string) {
        this();
        this.style = 0;
        this.sLabel = string;
    }

    public eNoDPanel(String string, int n) {
        this();
        this.style = 0;
        this.sLabel = string;
        this.gap = n;
    }

    public Insets getInsets() {
        if (this.style == 0 || this.style == 1) {
            int n;
            int n2 = 0;
            if (this.sLabel != null && this.sLabel.length() > 0) {
                try {
                    n = this.getGraphics().getFontMetrics(this.font).getHeight();
                    if (n > this.thickness) {
                        n2 = n - this.thickness;
                    }
                }
                catch (Exception exception) {}
            }
            n = this.thickness + this.gap;
            return new Insets(n + n2, n, n, n);
        }
        if (this.panelInsets != null) {
            return this.panelInsets;
        }
        return super.insets();
    }

    public void setInsets(Insets insets) {
        this.panelInsets = insets;
    }

    public eNoDPanel setStyle(int n) {
        this.style = n;
        this.doLayout();
        this.repaint();
        return this;
    }

    public int getStyle() {
        return this.style;
    }

    public eNoDPanel setGap(int n) {
        if (n > -1) {
            this.gap = n;
            this.doLayout();
            this.repaint();
        }
        return this;
    }

    public int getGap() {
        return this.gap;
    }

    public eNoDPanel setColor(Color color) {
        this.color = color;
        if (this.style == 0 || this.style == 1) {
            this.repaint();
        }
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public eNoDPanel setTextFont(Font font) {
        if (font != null) {
            this.font = font;
            if (this.style == 0 || this.style == 1) {
                this.doLayout();
                this.repaint();
            }
        }
        return this;
    }

    public Font getTextFont() {
        return this.font;
    }

    public eNoDPanel setText(String string) {
        this.sLabel = string;
        if (this.style == 0 || this.style == 1) {
            this.doLayout();
            this.repaint();
        }
        return this;
    }

    public String getText() {
        return this.sLabel;
    }

    public eNoDPanel setAlignment(int n) {
        this.alignment = n;
        if (this.style == 0 || this.style == 1) {
            this.doLayout();
            this.repaint();
        }
        return this;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        Color color = this.getBackground().brighter().brighter().brighter();
        Color color2 = this.getBackground().darker().darker().darker();
        switch (this.style) {
            case 0: 
            case 1: {
                int n3 = 0;
                int n4 = 0;
                Font font = graphics.getFont();
                graphics.setFont(this.font);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n5 = fontMetrics.getAscent();
                if (this.style == 0 || this.style == 1) {
                    n3 = 1;
                } else {
                    n4 = 1;
                }
                int n6 = 0;
                if (this.sLabel != null && this.sLabel.length() > 0 && n5 > this.thickness) {
                    n6 = (n5 - this.thickness) / 2;
                }
                int n7 = this.thickness / 2;
                int n8 = this.thickness / 2 + n6;
                int n9 = n - this.thickness - 1;
                int n10 = n2 - this.thickness - 1 - n6;
                if (this.style == 1) {
                    graphics.setColor(color);
                    graphics.drawRect(n7 + n3, n8 + n3, n9, n10);
                    graphics.setColor(color2);
                    graphics.drawRect(n7 + n4, n8 + n4, n9, n10);
                }
                if (this.sLabel != null && this.sLabel.length() > 0) {
                    int n11;
                    int n12;
                    int n13 = fontMetrics.getHeight();
                    int n14 = fontMetrics.stringWidth(this.sLabel);
                    if (n14 > (n12 = n - 2 * (this.thickness + 5))) {
                        n14 = n12;
                    }
                    switch (this.alignment) {
                        case 1: {
                            n11 = (n - n14) / 2;
                            break;
                        }
                        case 2: {
                            n11 = n - n14 - this.thickness - 5;
                            break;
                        }
                        default: {
                            n11 = this.thickness + 5;
                        }
                    }
                    graphics.clearRect(n11 - 5, 0, n14 + 10, n13);
                    graphics.clipRect(n11, 0, n14, n13);
                    graphics.setColor(this.color);
                    graphics.drawString(this.sLabel, n11, n5);
                    graphics.clipRect(0, 0, n, n2);
                }
                graphics.setFont(font);
                return;
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("eNoDPanel[");
        stringBuffer.append("style=");
        switch (this.style) {
            case 0: {
                stringBuffer.append("SOLID");
                break;
            }
            case 1: {
                stringBuffer.append("OUTLINE");
                break;
            }
            default: {
                stringBuffer.append("unknown");
            }
        }
        stringBuffer.append(",");
        stringBuffer.append("thickness=");
        stringBuffer.append(this.thickness);
        stringBuffer.append(",");
        stringBuffer.append("gap=");
        stringBuffer.append(this.gap);
        stringBuffer.append(",");
        stringBuffer.append(this.color);
        stringBuffer.append(",");
        stringBuffer.append(this.font);
        stringBuffer.append(",");
        stringBuffer.append("sLabel=");
        stringBuffer.append(this.sLabel);
        stringBuffer.append(",");
        stringBuffer.append("alignment=");
        switch (this.alignment) {
            case 0: {
                stringBuffer.append("LEFT");
                break;
            }
            case 1: {
                stringBuffer.append("CENTER");
                break;
            }
            case 2: {
                stringBuffer.append("RIGHT");
                break;
            }
            default: {
                stringBuffer.append("unknown");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.setLayout(new BorderLayout());
        eNoDPanel eNoDPanel2 = new eNoDPanel("This is a test");
        eNoDPanel2.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setBackground(Color.blue);
        eNoDPanel2.add("Center", panel);
        frame.add("Center", eNoDPanel2);
        ((Component)frame).setSize(300, 300);
        ((Component)frame).setVisible(true);
    }

    public void setWaitCursor(boolean bl) {
        this.initUtil();
        this.util.setWaitCursor(this, bl);
    }

    public void clearWaitCursor() {
        this.initUtil();
        this.util.clearWaitCursor();
    }

    public void absoluteClearWaitCursor() {
        this.initUtil();
        this.util.absoluteClearWaitCursor();
    }

    protected void initUtil() {
        if (this.util == null) {
            this.util = new eNoDUtils();
        }
    }

    public long lastFocusTime() {
        return this.lFocusTime;
    }

    public void startChildFocusListener() {
        this.initUtil();
        this.util.hookChildrenFocus(null, this, (FocusListener)this);
    }

    public void stopChildFocusListener() {
        this.initUtil();
        this.util.unHookChildrenFocus(null, this, (FocusListener)this);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.lFocusTime = System.currentTimeMillis();
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

