/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.fancyTextView;

import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.FancyTextAttribute;
import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.StyleCache;
import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.StyleMap;
import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.ableToUseFancyText;
import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.formatter;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;

public class FancyText
implements Serializable,
Cloneable {
    protected transient ableToUseFancyText displayer;
    protected int maxCount;
    protected int count;
    protected char[] chars;
    protected StyleMap styleArray;

    public FancyText(String string) {
        this(string.toCharArray());
    }

    public FancyText(String string, int n, int n2) {
        this(string.substring(n, n + n2 - 1));
    }

    public FancyText(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        this.initialize(cArray2);
    }

    public FancyText(char[] cArray) {
        this.initialize(cArray);
    }

    public void setDisplayer(ableToUseFancyText ableToUseFancyText2) {
        this.displayer = ableToUseFancyText2;
    }

    protected void initialize(char[] cArray) {
        this.initialize(cArray, new StyleMap(cArray.length + 1));
    }

    protected void initialize(char[] cArray, StyleMap styleMap) {
        this.count = cArray.length;
        this.maxCount = Math.max(256, this.enclose(this.count));
        this.chars = new char[this.maxCount];
        System.arraycopy(cArray, 0, this.chars, 0, this.count);
        this.styleArray = styleMap;
    }

    protected void growTo(int n) {
        if (this.maxCount <= n) {
            char[] cArray = this.chars;
            this.maxCount = this.enclose(n);
            this.chars = new char[this.maxCount];
            System.arraycopy(cArray, 0, this.chars, 0, this.count);
        }
    }

    protected int enclose(int n) {
        int n2 = (int)(Math.log(n) / Math.log(2.0));
        return (int)Math.pow(2.0, n2 + 1);
    }

    protected int deleteSpace(char[] cArray, int n, int n2, int n3) {
        int n4 = n - n3;
        int n5 = n2;
        while (n5 < n4) {
            cArray[n5] = cArray[n5 + n3];
            ++n5;
        }
        return n - n3;
    }

    protected int createSpace(char[] cArray, int n, int n2, int n3) {
        int n4 = n + n3;
        String string = new String(cArray);
        StringBuffer stringBuffer = new StringBuffer(string);
        char[] cArray2 = new char[n3];
        stringBuffer.insert(n2, cArray2);
        stringBuffer.getChars(0, n + n3, cArray, 0);
        stringBuffer = null;
        string = null;
        return n4;
    }

    public int length() {
        return this.count;
    }

    public char characterAt(int n) {
        if (this.count <= n) {
            throw new IndexOutOfBoundsException();
        }
        return this.chars[n];
    }

    public void setStyle(FancyTextAttribute fancyTextAttribute, int n, int n2) {
        char[] cArray = new char[n2];
        System.arraycopy(this.chars, n, cArray, 0, n2);
        this.styleArray.setStyle(fancyTextAttribute, n, n2);
        if (this.displayer != null) {
            this.displayer.setStyle(n, cArray);
        }
    }

    public void mergeStyle(FancyTextAttribute fancyTextAttribute, int n, int n2) {
        char[] cArray = new char[n2];
        System.arraycopy(this.chars, n, cArray, 0, n2);
        this.styleArray.mergeStyle(fancyTextAttribute, n, n2);
        if (this.displayer != null) {
            this.displayer.setStyle(n, cArray);
        }
    }

    protected void primAppend(char[] cArray, int n) {
        this.growTo(this.count + n);
        System.arraycopy(cArray, 0, this.chars, this.count, n);
        this.count += n;
    }

    public FancyText append(char c) {
        char[] cArray = new char[]{c};
        return this.append(cArray);
    }

    public FancyText append(char[] cArray) {
        int n = this.count;
        this.primAppend(cArray, cArray.length);
        this.styleArray.append(cArray);
        if (this.displayer != null) {
            this.displayer.insertChars(n, cArray);
        }
        return this;
    }

    public FancyText append(String string) {
        return this.append(string.toCharArray());
    }

    public FancyText append(char[] cArray, FancyTextAttribute fancyTextAttribute) {
        int n = this.count;
        this.primAppend(cArray, cArray.length);
        this.styleArray.append(cArray, fancyTextAttribute);
        if (this.displayer != null) {
            this.displayer.insertChars(n, cArray);
        }
        return this;
    }

    public FancyText append(String string, FancyTextAttribute fancyTextAttribute) {
        return this.append(string.toCharArray(), fancyTextAttribute);
    }

    protected void primInsert(int n, char[] cArray, int n2) {
        this.growTo(this.count + n2);
        this.count = this.createSpace(this.chars, this.count, n, n2);
        System.arraycopy(cArray, 0, this.chars, n, n2);
    }

    public FancyText prepend(String string) {
        if (string != null) {
            this.insert(0, string.toCharArray());
        }
        return this;
    }

    protected FancyText insert(int n, char[] cArray) {
        this.primInsert(n, cArray, cArray.length);
        this.styleArray.insert(n, cArray);
        if (this.displayer != null) {
            this.displayer.insertChars(n, cArray);
        }
        return this;
    }

    protected FancyText insert(int n, char c) {
        char[] cArray = new char[]{c};
        return this.insert(n, cArray);
    }

    protected FancyText insert(int n, String string) {
        return this.insert(n, string.toCharArray());
    }

    protected FancyText insert(int n, char[] cArray, FancyTextAttribute fancyTextAttribute) {
        this.primInsert(n, cArray, cArray.length);
        this.styleArray.insert(n, cArray, fancyTextAttribute);
        if (this.displayer != null) {
            this.displayer.insertChars(n, cArray);
        }
        return this;
    }

    protected FancyText insert(int n, String string, FancyTextAttribute fancyTextAttribute) {
        return this.insert(n, string.toCharArray(), fancyTextAttribute);
    }

    protected void primDelete(int n, char[] cArray, int n2) {
        this.count = this.deleteSpace(this.chars, this.count, n, n2);
    }

    protected FancyText delete(int n, int n2) {
        char[] cArray = new char[n2];
        System.arraycopy(this.chars, n, cArray, 0, n2);
        this.primDelete(n, cArray, n2);
        this.styleArray.delete(n, n2);
        if (this.displayer != null) {
            this.displayer.deleteChars(n, cArray);
        }
        return this;
    }

    protected int measure(formatter formatter2, StyleCache styleCache, int n, int n2) {
        return this.styleArray.measure(formatter2, styleCache, this.chars, n, n2);
    }

    protected synchronized int getWidth(StyleCache styleCache, int n, int n2) {
        return this.styleArray.getWidth(styleCache, this.chars, n, n2);
    }

    protected synchronized void draw(Graphics graphics, Color color, StyleCache styleCache, int n, int n2, int n3, int n4) {
        int n5 = Math.min(n + n2, this.count);
        this.styleArray.drawChars(graphics, color, styleCache, this.chars, n, n5 - n, n3, n4);
    }

    public String toString() {
        return new String(this.chars);
    }
}

