/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.fancyTextView;

import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.StyleCache;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;

public class FancyTextAttribute
implements Serializable {
    static final int NAME = 1;
    static final int BOLD = 2;
    static final int ITALIC = 4;
    static final int SIZE = 8;
    static final int COLOR = 16;
    private int flags;
    private String fontName;
    boolean isBold;
    boolean isItalic;
    private int pointSize;
    private Color color;
    protected boolean bComponent = false;

    public static FancyTextAttribute getBold() {
        FancyTextAttribute fancyTextAttribute = new FancyTextAttribute();
        fancyTextAttribute.setBold(true);
        return fancyTextAttribute;
    }

    public static FancyTextAttribute getItalic() {
        FancyTextAttribute fancyTextAttribute = new FancyTextAttribute();
        fancyTextAttribute.setItalic(true);
        return fancyTextAttribute;
    }

    public FancyTextAttribute() {
        this(0, null, false, false, 0, null);
    }

    public FancyTextAttribute(int n, String string, boolean bl, boolean bl2, int n2, Color color) {
        this.flags = n;
        this.fontName = string;
        this.isBold = bl;
        this.isItalic = bl2;
        this.pointSize = n2;
        this.color = color;
    }

    public FancyTextAttribute(FancyTextAttribute fancyTextAttribute) {
        this(fancyTextAttribute.flags, fancyTextAttribute.fontName, fancyTextAttribute.isBold, fancyTextAttribute.isItalic, fancyTextAttribute.pointSize, fancyTextAttribute.color);
    }

    public void setComponent(boolean bl) {
        this.bComponent = bl;
    }

    public final boolean hasFontName() {
        return (this.flags & 1) != 0;
    }

    public String getFontName() {
        if (this.hasFontName()) {
            return this.fontName;
        }
        return null;
    }

    public void setFontName(String string) {
        this.fontName = string;
        this.flags |= 1;
    }

    public final boolean hasBold() {
        return (this.flags & 2) != 0;
    }

    public void setBold(boolean bl) {
        this.isBold = bl;
        this.flags |= 2;
    }

    public final boolean hasItalic() {
        return (this.flags & 4) != 0;
    }

    public void setItalic(boolean bl) {
        this.isItalic = bl;
        this.flags |= 4;
    }

    public final boolean hasPointSize() {
        return (this.flags & 8) != 0;
    }

    public void setPointSize(int n) {
        this.pointSize = n;
        this.flags |= 8;
    }

    public final boolean hasColor() {
        return (this.flags & 0x10) != 0;
    }

    public void setColor(Color color) {
        this.color = color;
        this.flags |= 0x10;
    }

    public Color getColor() {
        if (this.hasColor()) {
            return this.color;
        }
        return null;
    }

    public Font applyStyle(Font font) {
        String string = this.hasFontName() ? this.fontName : font.getName();
        boolean bl = this.hasBold() ? this.isBold : font.isBold();
        boolean bl2 = this.hasItalic() ? this.isItalic : font.isItalic();
        int n = (bl ? 1 : 0) | (bl2 ? 2 : 0);
        int n2 = this.hasPointSize() ? this.pointSize : font.getSize();
        return new Font(string, n, n2);
    }

    public FancyTextAttribute merge(FancyTextAttribute fancyTextAttribute) {
        FancyTextAttribute fancyTextAttribute2 = new FancyTextAttribute(this);
        int n = (this.flags ^ fancyTextAttribute.flags) & fancyTextAttribute.flags;
        if ((n & 1) != 0) {
            fancyTextAttribute2.setFontName(fancyTextAttribute.fontName);
        }
        if ((n & 2) != 0) {
            fancyTextAttribute2.setBold(fancyTextAttribute.isBold);
        }
        if ((n & 4) != 0) {
            fancyTextAttribute2.setItalic(fancyTextAttribute.isItalic);
        }
        if ((n & 8) != 0) {
            fancyTextAttribute2.setPointSize(fancyTextAttribute.pointSize);
        }
        if ((n & 0x10) != 0) {
            fancyTextAttribute2.setColor(fancyTextAttribute.color);
        }
        return fancyTextAttribute2;
    }

    public int hashCode() {
        int n = this.flags;
        if (this.hasBold()) {
            n += this.isBold ? 1 : 0;
        }
        if (this.hasItalic()) {
            n += this.isItalic ? 2 : 0;
        }
        if (this.hasPointSize()) {
            n += this.pointSize * 4;
        }
        if (this.hasColor()) {
            n -= this.color.hashCode();
        }
        if (this.hasFontName()) {
            n += this.fontName.hashCode();
        }
        return n + (this.isBold ? 1 : 0) - (this.isItalic ? 2 : 0);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FancyTextAttribute)) {
            return false;
        }
        FancyTextAttribute fancyTextAttribute = (FancyTextAttribute)object;
        if (this.flags != fancyTextAttribute.flags) {
            return false;
        }
        if (this.hasBold() && this.isBold != fancyTextAttribute.isBold) {
            return false;
        }
        if (this.hasItalic() && this.isItalic != fancyTextAttribute.isItalic) {
            return false;
        }
        if (this.hasPointSize() && this.pointSize != fancyTextAttribute.pointSize) {
            return false;
        }
        if (this.hasColor() && !this.color.equals(fancyTextAttribute.color)) {
            return false;
        }
        return !this.hasFontName() || this.fontName.equals(fancyTextAttribute.fontName);
    }

    public int drawChars(Graphics graphics, StyleCache styleCache, Color color, char[] cArray, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = styleCache.get(this);
        graphics.setFont(fontMetrics.getFont());
        if (this.hasColor()) {
            graphics.setColor(this.color);
        } else {
            graphics.setColor(color);
        }
        graphics.drawChars(cArray, n, n2, n3, n4);
        return fontMetrics.charsWidth(cArray, n, n2);
    }

    public String toString() {
        if (this.flags == 0) {
            return "FancyTextAttribute []";
        }
        StringBuffer stringBuffer = new StringBuffer("FancyTextAttribute [");
        if ((this.flags & 1) != 0) {
            stringBuffer.append("name=\"").append(this.fontName).append("\" ");
        }
        if ((this.flags & 2) != 0) {
            stringBuffer.append("bold=").append(this.isBold).append(' ');
        }
        if ((this.flags & 4) != 0) {
            stringBuffer.append("italic=").append(this.isItalic).append(' ');
        }
        if ((this.flags & 8) != 0) {
            stringBuffer.append("size=").append(this.pointSize).append(' ');
        }
        if ((this.flags & 0x10) != 0) {
            stringBuffer.append("color=").append(this.color).append(' ');
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, ']');
        return stringBuffer.toString();
    }
}

