/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.fancyTextView;

import com.ibm.eNetwork.onDemand.common.gui.common.DBCanvas;
import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.CRFormatter;
import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.FancyText;
import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.IndexLookup;
import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.KeyControler;
import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.MouseControler;
import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.StyleCache;
import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.Win32KeyControler;
import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.ableToUseFancyText;
import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.formatter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class FancyTextCanvas
extends DBCanvas
implements ableToUseFancyText {
    protected FancyText text;
    protected StyleCache cache;
    protected Point pOrigin;
    protected Point cursor;
    protected int cursorOffset = -1;
    protected int cursorLength;
    protected IndexLookup crs;
    protected IndexLookup indices;
    protected formatter formatter;
    protected KeyControler keyControler;
    protected MouseControler mouseControler = new MouseControler(this);
    protected FontMetrics metrics;
    protected PopupMenu pop;
    protected boolean bReadOnly = false;
    protected TextListener listener;
    protected Component parent;

    public FancyTextCanvas(FancyText fancyText, PopupMenu popupMenu) {
        this.keyControler = new Win32KeyControler(this);
        this.pop = popupMenu;
        this.parent = this.parent;
        this.resetVars(fancyText);
    }

    public void setTextListener(Component component, TextListener textListener) {
        this.listener = textListener;
        this.parent = component;
    }

    public PopupMenu getPopupMenu() {
        return this.pop;
    }

    public void setReadOnly(boolean bl) {
        if (this.bReadOnly != bl) {
            this.bReadOnly = bl;
            if (bl) {
                this.mouseControler.unregisterListener(this);
                this.keyControler.unregisterListener(this);
                return;
            }
            this.mouseControler.registerListener(this);
            this.keyControler.registerListener(this);
        }
    }

    public void setFancyText(FancyText fancyText) {
        this.resetVars(fancyText);
    }

    protected void resetVars(FancyText fancyText) {
        if (this.text != null) {
            this.text.setDisplayer(null);
        }
        this.text = fancyText;
        this.cache = new StyleCache();
        fancyText.setDisplayer(this);
        this.pOrigin = new Point(0, 0);
        this.initCRs();
        this.formatter = new CRFormatter();
        this.cursor = new Point(0, 0);
        this.cursorOffset = 0;
        this.cursorLength = fancyText.length();
        this.flushCache();
    }

    protected void initCRs() {
        int n = 0;
        this.crs = new IndexLookup();
        int n2 = 0;
        while (n2 < this.text.length()) {
            ++n;
            if (this.text.characterAt(n2) == '\n') {
                this.crs.append(n);
                n = 0;
            }
            ++n2;
        }
        this.crs.append(n);
        this.crs.grow(this.crs.size() - 1, 1);
    }

    protected void flushCache() {
        this.indices = null;
    }

    protected void cacheIndices() {
        if (this.indices == null) {
            int n = this.bounds().width;
            int n2 = this.crs.size();
            this.indices = new IndexLookup();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.crs.getOffset(n3);
                int n5 = n4 + this.crs.getLength(n3);
                while (n4 < n5) {
                    int n6 = this.formatter.getNextLineOffset(this.text, this.cache, n4, n5 - n4, n);
                    this.indices.append(n6 - n4);
                    n4 = n6;
                }
                ++n3;
            }
        }
    }

    protected int updateIndices(int n, int n2) {
        int n3 = this.bounds().width;
        int n4 = 0;
        int n5 = n;
        while (n5 < n + n2) {
            int n6 = this.crs.getOffset(n5);
            int n7 = n6 + this.crs.getLength(n5);
            while (n6 < n7) {
                int n8 = this.formatter.getNextLineOffset(this.text, this.cache, n6, n7 - n6, n3);
                this.indices.split(n8);
                n6 = n8;
                ++n4;
            }
            ++n5;
        }
        return n4;
    }

    public FancyText getFancyText() {
        return this.text;
    }

    public int countLines() {
        return this.indices.size();
    }

    public int length() {
        return this.text.length();
    }

    protected FontMetrics getMetrics() {
        if (this.metrics == null) {
            this.metrics = this.getFontMetrics(this.getFont());
        }
        return this.metrics;
    }

    public int getLineFromOffset(int n) {
        this.cacheIndices();
        return this.indices.getIndex(n);
    }

    public int getOffsetFromLine(int n) {
        return this.indices.getOffset(n);
    }

    public Rectangle getLineBounds(int n) {
        int n2 = this.getMetrics().getHeight();
        return new Rectangle(0, n2 * n, this.bounds().width, n2);
    }

    public int getLineBaseline(int n) {
        FontMetrics fontMetrics = this.getMetrics();
        return this.getLineBounds((int)n).y + fontMetrics.getAscent() + fontMetrics.getLeading();
    }

    public int getMaxLineBaseline(int n) {
        FontMetrics fontMetrics = this.getMetrics();
        return this.getLineBounds((int)n).y + fontMetrics.getAscent() + fontMetrics.getLeading();
    }

    public int getLineContaining(int n) {
        return n / this.getMetrics().getHeight();
    }

    public void paintCursor(Graphics graphics, int n, int n2) {
        int n3 = this.indices.getIndex(this.cursorOffset);
        int n4 = this.xBefore(n3, this.cursorOffset);
        if (this.cursorLength > 0) {
            Rectangle rectangle;
            int n5 = this.cursorOffset + this.cursorLength;
            int n6 = this.indices.getIndex(n5);
            int n7 = this.xBefore(n6, n5);
            if (n3 < n) {
                n3 = n;
                n4 = 0;
            }
            graphics.setColor(new Color(166, 202, 240));
            int n8 = n3;
            while (n8 < n6 && n8 <= n2) {
                rectangle = this.getLineBounds(n8);
                graphics.fillRect(n4, rectangle.y, rectangle.width - n4, rectangle.height);
                n4 = 0;
                ++n8;
            }
            if (n6 <= n2) {
                rectangle = this.getLineBounds(n6);
                graphics.fillRect(n4, rectangle.y, n7 - n4, rectangle.height);
                return;
            }
        } else {
            Rectangle rectangle = this.getLineBounds(n3);
            graphics.setColor(Color.black);
            graphics.fillRect(n4, rectangle.y, 1, rectangle.height);
        }
    }

    public void paintLine(Graphics graphics, int n) {
        Color color = this.getForeground();
        this.text.draw(graphics, color, this.cache, this.indices.getOffset(n), this.indices.getLength(n) - 1, 0, this.getLineBaseline(n));
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.metrics = null;
    }

    public void paintText(Graphics graphics) {
        this.cache.setFont(this.getFont());
        this.cacheIndices();
        Point point = this.getOrigin();
        Rectangle rectangle = this.bounds();
        graphics.translate(point.x, point.y);
        rectangle.move(-point.x, -point.y);
        int n = Math.min(this.getLineContaining(rectangle.y), this.indices.size() - 1);
        int n2 = Math.min(this.getLineContaining(rectangle.y + rectangle.height), this.indices.size() - 1);
        this.paintCursor(graphics, n, n2);
        int n3 = n;
        while (n3 <= n2) {
            this.paintLine(graphics, n3);
            ++n3;
        }
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.paintText(graphics);
    }

    public int offsetAfterPoint(Point point) {
        Point point2 = this.getOrigin();
        return this.offsetAfter(new Point(point.x - point2.x, point.y - point2.y));
    }

    public int offsetAfter(Point point) {
        int n;
        int n2 = point.y;
        this.cacheIndices();
        int n3 = this.getLineContaining(n2);
        if (n3 < this.indices.size()) {
            n = point.x;
        } else {
            n = this.bounds().width;
            n3 = this.indices.size() - 1;
        }
        return this.formatter.getCursorOffset(this.text, this.cache, this.indices.getOffset(n3), this.indices.getLength(n3), n);
    }

    public Point pointBefore(int n) {
        this.cacheIndices();
        int n2 = this.indices.getIndex(n);
        int n3 = this.xBefore(n2, n);
        return new Point(n3, this.getLineBaseline(n2));
    }

    protected int xBefore(int n, int n2) {
        int n3 = this.indices.getOffset(n);
        return this.text.getWidth(this.cache, n3, n2 - n3);
    }

    protected int computeLinebreaks(int n, int[] nArray, int n2, int n3) {
        int n4 = this.crs.getOffset(n);
        int n5 = this.crs.getOffset(n + 1);
        int n6 = n2;
        while (n4 < n5) {
            int n7 = this.formatter.getNextLineOffset(this.text, this.cache, n4, n5 - n4, n3);
            nArray[n6++] = n7 - n4;
            n4 = n7;
        }
        return n6;
    }

    public void insertChars(int n, char[] cArray) {
        int n2 = this.bounds().width;
        int n3 = this.crs.getIndex(n);
        int n4 = this.crs.getOffset(n3);
        int n5 = 1;
        int n6 = 0;
        this.cacheIndices();
        this.crs.grow(n3, cArray.length);
        this.indices.grow(this.indices.getIndex(n4), cArray.length);
        int n7 = 0;
        while (n7 < cArray.length) {
            if (cArray[n7] == '\n') {
                this.crs.split(n + n7 + 1);
                ++n5;
            }
            ++n7;
        }
        int n8 = this.crs.getOffset(n3 + n5);
        int[] nArray = new int[n8 - n4];
        n7 = 0;
        while (n7 < n5) {
            n6 = this.computeLinebreaks(n3 + n7, nArray, n6, n2);
            ++n7;
        }
        int[] nArray2 = new int[n6];
        System.arraycopy(nArray, 0, nArray2, 0, n6);
        int n9 = this.indices.getIndex(n4);
        boolean bl = this.indices.replace(n9, 0, nArray2);
        this.invalidate(n9, n6, bl);
    }

    public void deleteChars(int n, char[] cArray) {
        int n2 = this.crs.getIndex(n);
        int n3 = this.crs.getOffset(n2);
        this.crs.getOffset(n2 + 1);
        int n4 = this.indices.getIndex(n3);
        int n5 = 1;
        int n6 = this.bounds().width;
        int n7 = 0;
        while (n7 < cArray.length) {
            this.crs.grow(this.crs.getIndex(n), -1);
            if (cArray[n7] == '\n') {
                ++n5;
                this.crs.join(n2);
            }
            ++n7;
        }
        this.indices.grow(n4, -cArray.length);
        int[] nArray = new int[this.crs.getOffset(n2 + 1) - n3];
        int n8 = this.computeLinebreaks(n2, nArray, 0, n6);
        int[] nArray2 = new int[n8];
        System.arraycopy(nArray, 0, nArray2, 0, n8);
        this.indices.replace(n4, 0, nArray2);
        this.invalidate(n4, n8, n5 != n8);
    }

    public void setStyle(int n, char[] cArray) {
        int n2 = this.crs.getIndex(n);
        int n3 = this.crs.getIndex(n + cArray.length) + 1;
        int[] nArray = new int[this.crs.getOffset(n3) - this.crs.getOffset(n2)];
        int n4 = this.bounds().width;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            n5 = this.computeLinebreaks(n2, nArray, n5, n4);
            ++n6;
        }
        this.invalidate(n2, n5, true);
    }

    public void invalidate(int n, int n2, boolean bl) {
        Point point = this.getOrigin();
        Rectangle rectangle = this.getLineBounds(n);
        if (bl) {
            rectangle = rectangle.union(this.getLineBounds(this.indices.size()));
        }
        rectangle.translate(point.x, point.y);
        if (!bl) {
            rectangle.height = this.bounds().height;
        }
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Dimension preferredSize() {
        return new Dimension(400, 300);
    }

    public Rectangle getPreferredBounds() {
        this.cacheIndices();
        Rectangle rectangle = new Rectangle(0, 0, this.bounds().width, 1);
        rectangle = rectangle.union(this.getLineBounds(this.indices.size() - 1));
        return rectangle;
    }

    public Dimension minimumSize() {
        return new Dimension(20, 20);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.bounds();
        if (rectangle.x != n || rectangle.y != n2 || rectangle.width != n3 || rectangle.height != n4) {
            this.flushCache();
        }
        super.reshape(n, n2, n3, n4);
    }

    void updateCursor() {
        this.cursor = this.pointBefore(this.getCursorOffset());
    }

    public void setLocalCursor(Point point) {
        Point point2 = this.getOrigin();
        this.setCursor(new Point(point.x - point2.x, point.y - point2.y));
    }

    public void setCursor(Point point) {
        this.cursor = point;
        this.setCursor(this.offsetAfter(point));
    }

    public void setCursor(int n) {
        this.setCursor(n, 0);
    }

    public void setCursor(int n, int n2) {
        this.cacheIndices();
        int n3 = this.indices.getIndex(this.cursorOffset);
        int n4 = this.indices.getIndex(this.cursorOffset + this.cursorLength - 1);
        this.cursorOffset = n;
        this.cursorLength = n2;
        this.invalidate(n3, n4 - n3 + 1, false);
        this.invalidate(this.indices.getIndex(n), 1, false);
    }

    public int getCursorOffset() {
        return this.cursorOffset;
    }

    public int getCursorLength() {
        return this.cursorLength;
    }

    public void showCursor() {
    }

    public Point getOrigin() {
        return this.pOrigin;
    }

    public void setOrigin(int n, int n2) {
        this.pOrigin.x = n;
        this.pOrigin.y = n2;
        this.repaint();
    }

    public int getVerticalMultiplier() {
        return 20;
    }

    public int getHorizontalMultiplier() {
        return 1;
    }

    public void insert(int n, char c) {
        char[] cArray = new char[]{c};
        this.insert(n, cArray);
    }

    public void prependString(String string) {
        this.insertString(0, string);
    }

    public void insertString(int n, String string) {
        if (string == null || string.compareTo("") == 1) {
            return;
        }
        char[] cArray = string.toCharArray();
        this.insert(n, cArray);
    }

    public void insert(int n, char[] cArray) {
        this.text.insert(n, cArray);
        this.setCursor(n + cArray.length);
        this.updateCursor();
        this.showCursor();
        this.notifyListener();
    }

    protected void notifyListener() {
        if (this.listener != null) {
            try {
                TextEvent textEvent = new TextEvent(this.parent, 900);
                this.listener.textValueChanged(textEvent);
                return;
            }
            catch (Exception exception) {
                System.err.println("TextEvent notify error: " + exception);
                return;
            }
        }
    }

    public void appendString(String string) {
        if (string != null) {
            this.text.append(string);
            this.setCursor(this.text.length());
            this.updateCursor();
            this.showCursor();
        }
    }

    public void deleteSelection() {
        if (this.cursorLength > 0) {
            this.delete(this.cursorOffset, this.cursorLength);
            this.cursorLength = 0;
            this.showCursor();
        }
    }

    public void delete(int n) {
        this.delete(n, 1);
    }

    public void delete(int n, int n2) {
        if (n >= 0 && n + n2 - 1 < this.text.length()) {
            this.text.delete(n, n2);
            this.setCursor(n);
            this.updateCursor();
        }
        this.showCursor();
        this.notifyListener();
    }

    public void cursorUp() {
        int n = this.getCursorOffset();
        int n2 = this.indices.getIndex(n);
        int n3 = this.cursor.x;
        if (n2 > 0) {
            int n4 = this.getLineBounds((int)(n2 - 1)).y + this.getMetrics().getAscent();
            this.setCursor(new Point(n3, n4));
            this.updateCursor();
            this.cursor.x = n3;
        }
        this.showCursor();
    }

    public void cursorDown() {
        int n = this.getCursorOffset();
        int n2 = this.indices.getIndex(n);
        int n3 = this.cursor.x;
        if (n2 + 1 < this.indices.size()) {
            this.setCursor(new Point(n3, this.getLineBounds((int)(n2 + 1)).y));
            this.updateCursor();
            this.cursor.x = n3;
        }
        this.showCursor();
    }

    public void cursorLeft() {
        int n = this.getCursorOffset();
        if (n > 0) {
            this.setCursor(n - 1);
            this.updateCursor();
        }
        this.showCursor();
    }

    public void cursorRight() {
        int n = this.getCursorOffset();
        if (n < this.text.length()) {
            this.setCursor(n + 1);
            this.updateCursor();
        }
        this.showCursor();
    }

    public void cursorToLineBeginning() {
        this.setCursor(this.getOffsetFromLine(this.getLineFromOffset(this.getCursorOffset())));
        this.updateCursor();
    }

    public void cursorToLineEnd() {
        this.setCursor(this.getOffsetFromLine(this.getLineFromOffset(this.getCursorOffset()) + 1) - 1);
        this.updateCursor();
    }
}

