/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.fancyTextView;

import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.ComponentPanel;
import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.FancyText;
import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.FancyTextAttribute;
import com.ibm.eNetwork.onDemand.common.gui.fancyTextView.FancyTextCanvas;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextListener;
import java.util.Enumeration;
import java.util.Vector;

public class FancyTextView
extends Panel
implements ActionListener {
    protected static String sDefaultText = "";
    protected FancyText text;
    protected FancyTextCanvas canvas;
    protected ComponentPanel componentPanel;
    protected ScrollPane sp;
    protected Menu[] pops;
    protected static int EDIT;
    protected static int COLORS;
    protected static int FONTS;
    protected static int SIZES;
    protected static int STYLES;
    protected static int NUM_MENUS;
    protected String[] fonts;
    protected static final int LARGE = 25;
    protected static final int MEDIUM = 15;
    protected static final int SMALL = 10;
    protected static final Font defaultFont;

    public FancyTextView(FancyText fancyText) {
        this.text = fancyText;
        this.initialize();
    }

    public FancyTextView(FancyText fancyText, Vector vector) {
        this.text = fancyText;
        this.addAttachements(vector);
        this.initialize();
    }

    public FancyText getFancyText() {
        return this.text;
    }

    public FancyTextView(String string) {
        this.text = new FancyText(string);
        this.initialize();
    }

    public FancyTextView() {
        this.text = new FancyText(sDefaultText);
        this.initialize();
    }

    public void setFontSize(int n) {
        Font font = this.canvas.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), n);
        this.canvas.setFont(font2);
    }

    protected void initialize() {
        this.createPopupMenus();
        this.canvas = new FancyTextCanvas(this.text, (PopupMenu)this.pops[EDIT]);
        this.canvas.setFont(defaultFont);
        this.canvas.setBackground(SystemColor.window);
        this.setLayout(new BorderLayout());
        this.sp = new ScrollPane();
        this.sp.add(this.canvas);
        this.canvas.setLocation(0, 0);
        this.canvas.setSize(400, 400);
        this.add("Center", this.sp);
        this.componentPanel = new ComponentPanel();
        this.add("South", (Component)((Object)this.componentPanel));
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.canvas.setSize(n, n2);
        this.sp.invalidate();
        this.sp.layout();
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.canvas.setSize(n3, n4);
        this.sp.invalidate();
        this.sp.layout();
    }

    public void setFancyText(FancyText fancyText) {
        this.text = fancyText;
        this.canvas.setFancyText(fancyText);
    }

    public void clearView() {
        this.clearAttachments();
        this.setFancyText(new FancyText(sDefaultText));
        this.canvas.repaint();
    }

    public void setSelectionStyle(FancyTextAttribute fancyTextAttribute) {
        int n = this.canvas.getCursorOffset();
        int n2 = this.canvas.getCursorLength();
        if (n2 > 0) {
            this.text.setStyle(fancyTextAttribute, n, n2);
        }
    }

    public void mergeSelectionStyle(FancyTextAttribute fancyTextAttribute) {
        int n = this.canvas.getCursorOffset();
        int n2 = this.canvas.getCursorLength();
        if (n2 > 0) {
            this.text.mergeStyle(fancyTextAttribute, n, n2);
        }
    }

    public void addAttachements(Vector vector) {
        Enumeration enumeration = vector.elements();
        Component component = null;
        while (enumeration.hasMoreElements()) {
            component = (Component)enumeration.nextElement();
            this.componentPanel.addAttachment(component);
        }
        ((Container)((Object)this.componentPanel)).invalidate();
        ((Container)((Object)this.componentPanel)).layout();
    }

    public void clearAttachments() {
        this.componentPanel.clearAttachments();
    }

    public Vector getAttachments() {
        return this.componentPanel.getAttachments();
    }

    public void addAttachment(Component component) {
        this.componentPanel.addAttachment(component);
        ((Container)((Object)this.componentPanel)).invalidate();
        ((Container)((Object)this.componentPanel)).layout();
    }

    public ComponentPanel getComponentPanel() {
        return this.componentPanel;
    }

    public PopupMenu getMenuItems() {
        return (PopupMenu)this.pops[EDIT];
    }

    protected void createPopupMenus() {
        this.pops = new Menu[NUM_MENUS];
        this.fonts = this.getToolkit().getFontList();
        this.pops[FancyTextView.FONTS] = new Menu("Font");
        this.pops[FONTS].addActionListener(this);
        int n = 0;
        while (n < this.fonts.length) {
            this.pops[FONTS].add(this.fonts[n]);
            ++n;
        }
        this.pops[FancyTextView.STYLES] = new Menu("Style");
        this.pops[STYLES].addActionListener(this);
        this.pops[STYLES].add("Plain");
        this.pops[STYLES].add("Italic");
        this.pops[STYLES].add("Bold");
        this.pops[FancyTextView.SIZES] = new Menu("Size");
        this.pops[SIZES].addActionListener(this);
        this.pops[SIZES].add("Large");
        this.pops[SIZES].add("Medium");
        this.pops[SIZES].add("Small");
        this.pops[FancyTextView.COLORS] = new Menu("Colors");
        this.pops[COLORS].addActionListener(this);
        this.pops[COLORS].add("Red");
        this.pops[COLORS].add("Green");
        this.pops[COLORS].add("Blue");
        this.pops[COLORS].add("Black");
        this.pops[FancyTextView.EDIT] = new PopupMenu("Edit");
        this.pops[EDIT].addActionListener(this);
        this.pops[EDIT].add(this.pops[COLORS]);
        this.pops[EDIT].add(this.pops[FONTS]);
        this.pops[EDIT].add(this.pops[STYLES]);
        this.pops[EDIT].add(this.pops[SIZES]);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (actionEvent.getSource() instanceof MenuItem) {
            if (string.compareTo("Plain") == 0) {
                this.setSelectionStyle(new FancyTextAttribute());
                return;
            }
            if (string.compareTo("Bold") == 0) {
                this.mergeSelectionStyle(FancyTextAttribute.getBold());
                return;
            }
            if (string.compareTo("Italic") == 0) {
                this.mergeSelectionStyle(FancyTextAttribute.getItalic());
                return;
            }
            if (string.compareTo("Large") == 0) {
                this.setFontSize(25);
                return;
            }
            if (string.compareTo("Medium") == 0) {
                this.setFontSize(15);
                return;
            }
            if (string.compareTo("Small") == 0) {
                this.setFontSize(10);
                return;
            }
            int n = 0;
            while (n < this.fonts.length) {
                if (string.compareTo(this.fonts[n]) == 0) {
                    FancyTextAttribute fancyTextAttribute = new FancyTextAttribute();
                    fancyTextAttribute.setFontName(this.fonts[n]);
                    this.mergeSelectionStyle(fancyTextAttribute);
                    return;
                }
                ++n;
            }
            if (string.compareTo("Red") == 0) {
                FancyTextAttribute fancyTextAttribute = new FancyTextAttribute();
                fancyTextAttribute.setColor(new Color(128, 0, 0));
                this.mergeSelectionStyle(fancyTextAttribute);
                return;
            }
            if (string.compareTo("Green") == 0) {
                FancyTextAttribute fancyTextAttribute = new FancyTextAttribute();
                fancyTextAttribute.setColor(new Color(0, 128, 0));
                this.mergeSelectionStyle(fancyTextAttribute);
                return;
            }
            if (string.compareTo("Blue") == 0) {
                FancyTextAttribute fancyTextAttribute = new FancyTextAttribute();
                fancyTextAttribute.setColor(new Color(0, 0, 128));
                this.mergeSelectionStyle(fancyTextAttribute);
                return;
            }
            if (string.compareTo("Black") == 0) {
                FancyTextAttribute fancyTextAttribute = new FancyTextAttribute();
                fancyTextAttribute.setColor(new Color(0, 0, 0));
                this.mergeSelectionStyle(fancyTextAttribute);
                return;
            }
        }
    }

    public void setReadOnly(boolean bl) {
        this.canvas.setReadOnly(bl);
    }

    public String getString() {
        if (this.text != null) {
            return this.text.toString();
        }
        return "";
    }

    public void prependString(String string) {
        this.canvas.prependString(string);
    }

    public void appendString(String string) {
        this.canvas.appendString(string);
    }

    public void insertString(int n, String string) {
        this.canvas.insertString(n, string);
    }

    public void setTextListener(TextListener textListener) {
        this.canvas.setTextListener(this, textListener);
    }

    static {
        COLORS = 1;
        FONTS = 2;
        SIZES = 3;
        STYLES = 4;
        NUM_MENUS = 5;
        defaultFont = new Font("Helvetica", 0, 15);
    }
}

