/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.fancyTextView;

import java.io.Serializable;

public final class IndexLookup
implements Serializable {
    int maxCount;
    int count = 0;
    int[] lengths;
    int cacheCount;
    int[] cache;

    public IndexLookup() {
        this(256);
    }

    public IndexLookup(int n) {
        this.maxCount = n;
        this.lengths = new int[this.maxCount];
        this.cacheCount = 0;
        this.cache = new int[this.maxCount];
    }

    private void growTo(int n) {
        if (this.maxCount <= n) {
            while (this.maxCount <= n) {
                this.maxCount <<= 1;
            }
            this.resizeArrays();
        }
    }

    private void resizeArrays() {
        int[] nArray = new int[this.maxCount];
        System.arraycopy(this.lengths, 0, nArray, 0, this.count);
        this.lengths = nArray;
        int[] nArray2 = new int[this.maxCount];
        System.arraycopy(this.cache, 0, nArray2, 0, this.cacheCount);
        this.cache = nArray2;
    }

    private int deleteSpace(int[] nArray, int n, int n2, int n3) {
        int n4 = n - n3;
        int n5 = n2;
        while (n5 < n4) {
            nArray[n5] = nArray[n5 + n3];
            ++n5;
        }
        return n4;
    }

    private int createSpace(int[] nArray, int n, int n2, int n3) {
        this.growTo(n + n3);
        int n4 = n + n3 - 1;
        while (n2 < n4) {
            nArray[n4] = nArray[n4 - n3];
            --n4;
        }
        return n + n3;
    }

    private void setCacheCountMax(int n) {
        this.cacheCount = Math.min(this.cacheCount, n);
    }

    public int getIndex(int n) {
        int n2 = 0;
        int n3 = this.count;
        while (n2 < n3) {
            int n4 = n2 + (1 + n3 - n2) / 2;
            if (this.getOffset(n4) <= n) {
                n2 = n4;
                continue;
            }
            n3 = n4 - 1;
        }
        return n2;
    }

    public int getOffset(int n) {
        if (n == 0) {
            return 0;
        }
        if (this.count < n) {
            throw new IndexOutOfBoundsException();
        }
        if (this.cacheCount < n) {
            int n2 = this.getOffset(this.cacheCount);
            int n3 = this.cacheCount;
            while (n3 < n) {
                this.cache[n3] = n2 += this.lengths[n3];
                ++n3;
            }
            this.cacheCount = n;
        }
        return this.cache[n - 1];
    }

    public int size() {
        return this.count;
    }

    public int length() {
        return this.getOffset(this.count);
    }

    public void append(int n) {
        this.growTo(this.count + 1);
        this.lengths[this.count++] = n;
    }

    public void insert(int n, int n2) {
        this.count = this.createSpace(this.lengths, this.count, n, 1);
        this.lengths[n] = n2;
        this.setCacheCountMax(n);
    }

    public void growLast(int n) {
        this.grow(this.count - 1, n);
    }

    public void grow(int n, int n2) {
        this.setLength(n, this.getLength(n) + n2);
    }

    public void delete(int n) {
        this.delete(n, 1);
    }

    public void delete(int n, int n2) {
        this.count = this.deleteSpace(this.lengths, this.count, n, n2);
        this.setCacheCountMax(n);
    }

    public void setLength(int n, int n2) {
        if (this.lengths[n] != n2) {
            this.lengths[n] = n2;
            this.setCacheCountMax(n);
        }
    }

    public int getLength(int n) {
        return this.lengths[n];
    }

    public boolean split(int n) {
        int n2 = this.getIndex(n);
        return this.split(n2, n - this.getOffset(n2));
    }

    public boolean split(int n, int n2) {
        if (n2 == 0) {
            return false;
        }
        int n3 = this.lengths[n] - n2;
        this.count = this.createSpace(this.lengths, this.count, n, 1);
        this.lengths[n] = n2;
        this.lengths[n + 1] = n3;
        if (n < this.cacheCount) {
            this.cacheCount = this.createSpace(this.cache, this.cacheCount, n, 1);
            this.cache[n] = this.getOffset(n) + n2;
        }
        return true;
    }

    public void join(int n) {
        this.join(n, 2);
    }

    public void join(int n, int n2) {
        if (n2 < 2) {
            return;
        }
        this.lengths[n] = this.getOffset(n + n2) - this.getOffset(n);
        this.count = this.deleteSpace(this.lengths, this.count, n + 1, n2 - 1);
        this.cacheCount = this.deleteSpace(this.cache, this.cacheCount, n, n2 - 1);
    }

    private void printLengths() {
        System.out.print("{");
        int n = 0;
        while (n < this.count) {
            System.out.print(this.lengths[n]);
            if (n + 1 < this.count) {
                System.out.print(", ");
            }
            ++n;
        }
        System.out.println("}");
    }

    public boolean replace(int n, int[] nArray) {
        int n2 = this.getIndex(n);
        return this.replace(n2, n - this.getOffset(n2), nArray);
    }

    public boolean replace(int n, int n2, int[] nArray) {
        boolean bl = false;
        int n3 = n;
        int n4 = 0;
        if (n2 > 0) {
            n4 -= this.lengths[n] - n2;
            this.lengths[n] = n2;
            ++n3;
            bl = true;
        }
        int n5 = 0;
        while (n5 < nArray.length) {
            n4 += nArray[n5];
            ++n5;
        }
        return this.replace(n3, nArray, n4) || bl;
    }

    public boolean replace(int n, int[] nArray, int n2) {
        int n3 = this.getOffset(n) + n2;
        boolean bl = false;
        this.split(n3);
        int n4 = this.getIndex(n3);
        int n5 = n4 - n;
        if (n5 < nArray.length) {
            this.count = this.createSpace(this.lengths, this.count, n, nArray.length - n5);
            bl = true;
        } else if (nArray.length < n5) {
            this.count = this.deleteSpace(this.lengths, this.count, n, n5 - nArray.length);
            bl = true;
        }
        this.setCacheCountMax(n);
        int n6 = 0;
        while (n6 < nArray.length) {
            this.lengths[n + n6] = nArray[n6];
            ++n6;
        }
        return bl;
    }
}

