/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.imageButton;

import com.ibm.eNetwork.onDemand.common.Timer;
import com.ibm.eNetwork.onDemand.common.gui.common.DBCanvas;
import com.ibm.eNetwork.onDemand.common.gui.eNoDGUIMetrics;
import com.ibm.eNetwork.onDemand.common.gui.imageButton.ImageButtonPainter;
import com.ibm.eNetwork.onDemand.common.gui.tooltip.Tooltip;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ImageButton
extends DBCanvas
implements MouseListener,
FocusListener,
KeyListener,
ComponentListener {
    public static final int IMAGE_AND_TEXT = 1;
    public static final int IMAGE_ONLY = 2;
    public static final int TEXT_ONLY = 3;
    public static final boolean FLAT_BUTTON = true;
    public static final boolean REGULAR_BUTTON = false;
    public static final boolean TRANSPARENT = true;
    public static final boolean OPAQUE = false;
    public static final int TEXT_SOUTH = 10;
    public static final int TEXT_NORTH = 11;
    public static final int TEXT_WEST = 12;
    public static final int TEXT_EAST = 13;
    protected static Timer timer = null;
    protected ImageButtonPainter ibpPainter;
    protected Tooltip tooltip;
    protected int iViewMode;
    protected boolean boolFlatButton = false;
    protected boolean boolTransparent = false;
    protected String sLabel;
    protected String sTipString;
    protected String sActionCommand;
    protected boolean boolHighlighted = false;
    protected boolean boolSelected = false;
    protected boolean boolInitialized = false;
    protected boolean boolFocused = false;
    protected boolean boolEnabled = true;
    protected boolean boolMousePressed = false;
    protected boolean boolToolTipEnabled = false;
    protected boolean boolFocusTraversable = false;
    protected boolean boolFocusBoxEnabled = true;
    protected boolean boolTooltipWindowToFront = true;
    protected Dimension dMinSize;
    protected ActionListener actionListener;
    int iTooltipDelay;

    public ImageButton() {
        this(null, null, null, "", false, 3, 10, false, true);
    }

    public ImageButton(Image image, Image image2, Image image3, String string, boolean bl, int n, int n2, boolean bl2, boolean bl3, Font font, Color color, Color color2) {
        this(image, image2, image3, string, bl, n, n2, bl2, bl3);
        this.setLabelFont(font);
        this.setLabelColor(color);
        this.setBackground(color2);
    }

    public ImageButton(Image image, Image image2, Image image3, String string, boolean bl, int n, int n2, boolean bl2, boolean bl3) {
        this.setBackground(eNoDGUIMetrics.buttonColor);
        this.ibpPainter = new ImageButtonPainter(this, image, image2, image3, string, bl, n, n2, bl2);
        this.boolTransparent = bl2;
        this.sLabel = string;
        this.sActionCommand = string;
        this.sTipString = string;
        this.iViewMode = n;
        this.boolFocusTraversable = bl3;
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addComponentListener(this);
        this.iTooltipDelay = -1;
    }

    public ImageButton(Image image, String string) {
        this(image, null, null, string, false, 1, 10, false, true);
    }

    public ImageButton(String string) {
        this(null, null, null, string, false, 3, 10, false, true);
    }

    public ImageButton(Image image) {
        this(image, null, null, "", false, 2, 10, false, true);
    }

    public void setSettings(Image image, Image image2, Image image3, String string, boolean bl, int n, int n2, boolean bl2, boolean bl3) {
        this.ibpPainter.setSettings(this, image, image2, image3, string, bl, n, n2, bl2);
        this.boolTransparent = bl2;
        this.sLabel = string;
        this.sActionCommand = string;
        this.sTipString = string;
        this.iViewMode = n;
        this.boolFocusTraversable = bl3;
        this.boolInitialized = false;
    }

    public void setLabelColor(Color color) {
        this.ibpPainter.setLabelColor(color);
    }

    public void setLabelFont(Font font) {
        this.ibpPainter.setLabelFont(font);
    }

    public void setImages(Image image, Image image2, Image image3) {
        this.ibpPainter.setImages(image, image2, image3);
        this.boolInitialized = false;
        this.invalidate();
        this.repaint();
    }

    public Dimension commit() {
        if (this.dMinSize == null) {
            this.dMinSize = this.ibpPainter.computeMinimumSize();
        }
        this.setSize(this.dMinSize);
        return this.dMinSize;
    }

    public void setTextOrientation(int n) {
        this.ibpPainter.setTextOrientation(n);
        this.boolInitialized = false;
        this.invalidate();
        this.repaint();
    }

    public int getTextOrientation() {
        return this.ibpPainter.getTextOrientation();
    }

    protected void init() {
        this.getSize();
        if (this.boolToolTipEnabled) {
            if (timer == null) {
                timer = new Timer(500);
            }
            if (this.tooltip == null) {
                this.tooltip = new Tooltip(this.getTopLevelParent(this), this.sTipString);
                timer.addTimerListener(this.tooltip);
                this.tooltip.setEnabled(true);
                if (this.iTooltipDelay >= 0) {
                    this.tooltip.setDelay(this.iTooltipDelay);
                }
                this.tooltip.setToFront(this.boolTooltipWindowToFront);
            }
        }
        this.boolInitialized = true;
    }

    public void setViewMode(int n) {
        this.iViewMode = n;
        this.ibpPainter.setViewMode(n);
        this.boolInitialized = false;
        this.invalidate();
    }

    public int getViewMode() {
        return this.ibpPainter.getViewMode();
    }

    public void setButtonType(boolean bl) {
        this.boolFlatButton = bl;
        this.ibpPainter.setButtonType(bl);
        this.boolInitialized = false;
        this.invalidate();
    }

    public void setTooltipDelay(int n) {
        if (this.tooltip != null) {
            this.tooltip.setDelay(n);
        }
        this.iTooltipDelay = n;
    }

    public void setTooltipWindowToFront(boolean bl) {
        if (this.tooltip != null) {
            this.tooltip.setToFront(bl);
        }
        this.boolTooltipWindowToFront = bl;
    }

    public void draw(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (!this.boolInitialized) {
            this.init();
        }
        if (this.isEnabled()) {
            if (this.boolSelected) {
                this.ibpPainter.drawSelectedButton(graphics, dimension);
            } else if (this.boolHighlighted) {
                this.ibpPainter.drawHighlightedButton(graphics, dimension);
            } else {
                this.ibpPainter.drawNormalButton(graphics, dimension);
            }
        } else {
            this.ibpPainter.drawDisabledButton(graphics, dimension);
        }
        if (this.boolFocused && this.boolFocusBoxEnabled) {
            graphics.setColor(SystemColor.controlText);
            graphics.drawRect(3, 3, dimension.width - 7, dimension.height - 7);
        }
    }

    public void setFocusBoxEnabled(boolean bl) {
        this.boolFocusBoxEnabled = bl;
    }

    public String getTipString() {
        return this.sTipString;
    }

    public void setTipString(String string) {
        this.sTipString = string;
        this.setTipEnabled(true);
        if (this.tooltip != null) {
            this.tooltip.setLabel(string);
        }
    }

    public void setTipEnabled(boolean bl) {
        this.boolToolTipEnabled = bl;
        if (this.tooltip != null) {
            this.tooltip.setEnabled(bl);
        }
    }

    public boolean getTipEnabled(boolean bl) {
        return this.boolToolTipEnabled;
    }

    public void setEnabled(boolean bl) {
        if (this.boolEnabled == bl) {
            return;
        }
        this.boolEnabled = bl;
        super.setEnabled(bl);
        if (this.boolInitialized) {
            this.repaint();
        }
    }

    public boolean isEnabled() {
        return this.boolEnabled;
    }

    public Dimension getMinimumSize() {
        if (this.dMinSize == null) {
            this.dMinSize = this.ibpPainter.computeMinimumSize();
        }
        return this.dMinSize;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void setLabel(String string) {
        this.sLabel = string;
        this.ibpPainter.setLabel(string);
        if (this.boolInitialized) {
            this.init();
            this.repaint();
        }
    }

    public String getLabel() {
        return this.ibpPainter.getLabel();
    }

    public void setActionCommand(String string) {
        this.sActionCommand = string;
    }

    public String getActionCommand() {
        return this.sActionCommand;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isEnabled() && this.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.boolMousePressed = true;
            this.requestFocus();
            this.boolSelected = true;
            if (this.tooltip != null) {
                this.tooltip.setFastDisplay(false);
                this.tooltip.hideTooltip();
            }
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            this.boolSelected = false;
            if (this.contains(mouseEvent.getX(), mouseEvent.getY()) && this.boolMousePressed && this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.sActionCommand));
            }
            this.repaint();
        }
        this.boolMousePressed = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.sTipString.equals("") && this.boolToolTipEnabled) {
            Point point = this.getLocationOnScreen();
            int n = point.x + this.getSize().width / 2;
            int n2 = point.y + this.getSize().height + 2;
            if (this.tooltip == null) {
                this.tooltip = new Tooltip(this.getTopLevelParent(this), this.sTipString);
                this.tooltip.setEnabled(this.boolToolTipEnabled);
                timer.addTimerListener(this.tooltip);
            }
            this.tooltip.showAfterDelay(n, n2);
        }
        if (this.isEnabled()) {
            if (this.boolMousePressed) {
                this.boolSelected = true;
            } else {
                this.boolHighlighted = true;
            }
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.tooltip != null) {
            this.tooltip.hideTooltip();
        }
        if (this.isEnabled()) {
            this.boolHighlighted = false;
            this.boolSelected = false;
            this.repaint();
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.boolInitialized) {
            this.init();
            this.repaint();
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isEnabled() && (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32)) {
            this.requestFocus();
            this.boolSelected = true;
            if (this.tooltip != null) {
                this.tooltip.hideTooltip();
                this.tooltip.setFastDisplay(false);
            }
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.sActionCommand));
            }
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.isEnabled() && (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32)) {
            this.boolSelected = false;
            this.repaint();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.boolFocused = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.boolFocused = false;
        this.boolHighlighted = false;
        this.boolSelected = false;
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return this.boolFocusTraversable;
    }

    private Frame getTopLevelParent(Component component) {
        Component component2 = component;
        while (component2.getParent() != null) {
            component2 = component2.getParent();
        }
        if (component2 instanceof Frame) {
            return (Frame)component2;
        }
        return null;
    }

    public Insets getInsets() {
        return this.ibpPainter.getInsets();
    }

    public void dispose() {
        try {
            this.finalize();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void finalize() throws Throwable {
        this.ibpPainter.finalize();
        if (this.tooltip != null) {
            timer.removeTimerListener(this.tooltip);
            this.tooltip.finalize();
        }
        super.finalize();
    }

    public void setBackground(Color color) {
        if (this.ibpPainter != null) {
            this.ibpPainter.setBackground(color);
        }
        super.setBackground(color);
    }
}

