/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.imageButton;

import com.ibm.eNetwork.onDemand.common.gui.eNoDGUIMetrics;
import com.ibm.eNetwork.onDemand.common.gui.imageButton.SetDarkColorsToColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class ImageButtonPainter {
    public static final int IMAGE_AND_TEXT = 1;
    public static final int IMAGE_ONLY = 2;
    public static final int TEXT_ONLY = 3;
    public static final int TEXT_SOUTH = 10;
    public static final int TEXT_NORTH = 11;
    public static final int TEXT_WEST = 12;
    public static final int TEXT_EAST = 13;
    protected static final int NORMAL = 21;
    protected static final int HIGHLIGHTED = 22;
    protected static final int DISABLED = 23;
    protected static final int SELECTED = 24;
    Component component;
    Image normalImage;
    Image highlightedImage;
    Image disabledImage;
    String sLabel;
    boolean boolFlatButton = false;
    boolean boolTransparent = false;
    boolean boolCreatedDisabledImage = false;
    int iViewMode;
    int iTextOrientation;
    Color cLabelColor = eNoDGUIMetrics.buttonTextColor;
    Color cBackground = eNoDGUIMetrics.buttonColor;
    Color cHighlight = eNoDGUIMetrics.buttonColorHighlight;
    Color cShadow = eNoDGUIMetrics.buttonColorShadow;
    Color cDkShadow = eNoDGUIMetrics.buttonColorDkShadow;
    Font fLabelFont = eNoDGUIMetrics.buttonFont;

    public ImageButtonPainter(Component component, Image image, Image image2, Image image3, String string, boolean bl, int n, int n2, boolean bl2) {
        this.component = component;
        this.normalImage = image;
        this.highlightedImage = image2 != null ? image2 : image;
        this.disabledImage = image3 != null ? image3 : this.createDisabledImage(image);
        this.boolFlatButton = bl;
        this.boolTransparent = bl2;
        this.sLabel = string;
        this.iViewMode = n;
        this.iTextOrientation = n2;
    }

    public ImageButtonPainter(Component component, Image image, Image image2, Image image3, String string, boolean bl, int n, int n2, boolean bl2, Font font, Color color, Color color2) {
        this(component, image, image2, image3, string, bl, n, n2, bl2);
        this.setLabelFont(font);
        this.setLabelColor(color);
        this.setBackground(color2);
    }

    public void setLabelColor(Color color) {
        if (color != null) {
            this.cLabelColor = color;
        }
    }

    public void setLabelFont(Font font) {
        if (font != null) {
            this.fLabelFont = font;
        }
    }

    public void setSettings(Component component, Image image, Image image2, Image image3, String string, boolean bl, int n, int n2, boolean bl2) {
        this.component = component;
        this.normalImage = image;
        this.highlightedImage = image2 != null ? image2 : image;
        this.disabledImage = image3 != null ? image3 : this.createDisabledImage(image);
        this.boolFlatButton = bl;
        this.boolTransparent = bl2;
        this.sLabel = string;
        this.iViewMode = n;
        this.iTextOrientation = n2;
    }

    public void setImages(Image image, Image image2, Image image3) {
        this.normalImage = image;
        this.highlightedImage = image2 != null ? image2 : image;
        if (image3 != null) {
            this.disabledImage = image3;
            return;
        }
        this.disabledImage = this.createDisabledImage(image);
    }

    public void setButtonType(boolean bl) {
        this.boolFlatButton = bl;
    }

    public void setLabel(String string) {
        this.sLabel = string;
    }

    public String getLabel() {
        return this.sLabel;
    }

    public void drawNormalButton(Graphics graphics, Dimension dimension) {
        graphics.setColor(this.cBackground);
        graphics.setFont(this.fLabelFont);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (!this.boolFlatButton) {
            graphics.setColor(this.cHighlight);
            graphics.drawLine(0, 0, 0, dimension.height - 1);
            graphics.drawLine(0, 0, dimension.width - 1, 0);
            graphics.setColor(this.cHighlight);
            graphics.drawLine(1, 1, dimension.width - 2, 1);
            graphics.drawLine(1, 1, 1, dimension.height - 2);
            graphics.setColor(this.cDkShadow);
            graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
            graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
            graphics.setColor(this.cShadow);
            graphics.drawLine(1, dimension.height - 2, dimension.width - 2, dimension.height - 2);
            graphics.drawLine(dimension.width - 2, dimension.height - 2, dimension.width - 2, 1);
        }
        switch (this.iViewMode) {
            case 1: {
                switch (this.iTextOrientation) {
                    case 12: {
                        this.drawWestTextImageButton(graphics, new Rectangle(4, 4, dimension.width - 8, dimension.height - 8), this.normalImage, this.sLabel, 21);
                        return;
                    }
                    case 13: {
                        this.drawEastTextImageButton(graphics, new Rectangle(4, 4, dimension.width - 8, dimension.height - 8), this.normalImage, this.sLabel, 21);
                        return;
                    }
                    case 10: {
                        this.drawSouthTextImageButton(graphics, new Rectangle(4, 4, dimension.width - 8, dimension.height - 8), this.normalImage, this.sLabel, 21);
                        return;
                    }
                    case 11: {
                        this.drawNorthTextImageButton(graphics, new Rectangle(4, 4, dimension.width - 8, dimension.height - 8), this.normalImage, this.sLabel, 21);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 3: {
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = fontMetrics.stringWidth(this.sLabel);
                graphics.setColor(this.cLabelColor);
                int n2 = (dimension.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                int n3 = (dimension.width - n) / 2;
                graphics.drawString(this.sLabel, n3, n2);
                return;
            }
            case 2: {
                int n = (dimension.width - 10 - this.normalImage.getWidth(this.component)) / 2 + 5;
                int n4 = (dimension.height - 10 - this.normalImage.getHeight(this.component)) / 2 + 5;
                graphics.drawImage(this.normalImage, n, n4, null, this.component);
                return;
            }
            default: {
                return;
            }
        }
    }

    public void drawHighlightedButton(Graphics graphics, Dimension dimension) {
        graphics.setColor(this.cBackground);
        graphics.setFont(this.fLabelFont);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (!this.boolTransparent) {
            graphics.setColor(this.cHighlight);
            graphics.drawLine(0, 0, 0, dimension.height - 1);
            graphics.drawLine(0, 0, dimension.width - 1, 0);
            graphics.setColor(this.cHighlight);
            graphics.drawLine(1, 1, dimension.width - 2, 1);
            graphics.drawLine(1, 1, 1, dimension.height - 2);
            graphics.setColor(this.cDkShadow);
            graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
            graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
            graphics.setColor(this.cShadow);
            graphics.drawLine(1, dimension.height - 2, dimension.width - 2, dimension.height - 2);
            graphics.drawLine(dimension.width - 2, dimension.height - 2, dimension.width - 2, 1);
        }
        switch (this.iViewMode) {
            case 1: {
                switch (this.iTextOrientation) {
                    case 12: {
                        this.drawWestTextImageButton(graphics, new Rectangle(4, 4, dimension.width - 8, dimension.height - 8), this.highlightedImage, this.sLabel, 22);
                        return;
                    }
                    case 13: {
                        this.drawEastTextImageButton(graphics, new Rectangle(4, 4, dimension.width - 8, dimension.height - 8), this.highlightedImage, this.sLabel, 22);
                        return;
                    }
                    case 10: {
                        this.drawSouthTextImageButton(graphics, new Rectangle(4, 4, dimension.width - 8, dimension.height - 8), this.highlightedImage, this.sLabel, 22);
                        return;
                    }
                    case 11: {
                        this.drawNorthTextImageButton(graphics, new Rectangle(4, 4, dimension.width - 8, dimension.height - 8), this.highlightedImage, this.sLabel, 22);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 3: {
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = fontMetrics.stringWidth(this.sLabel);
                graphics.setColor(this.cLabelColor);
                int n2 = (dimension.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                int n3 = (dimension.width - n) / 2;
                graphics.drawString(this.sLabel, n3, n2);
                return;
            }
            case 2: {
                int n = (dimension.width - 10 - this.highlightedImage.getWidth(this.component)) / 2 + 5;
                int n4 = (dimension.height - 10 - this.highlightedImage.getHeight(this.component)) / 2 + 5;
                graphics.drawImage(this.highlightedImage, n, n4, null, this.component);
                return;
            }
            default: {
                return;
            }
        }
    }

    public void drawDisabledButton(Graphics graphics, Dimension dimension) {
        graphics.setColor(this.cBackground);
        graphics.setFont(this.fLabelFont);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (!this.boolFlatButton) {
            graphics.setColor(this.cHighlight);
            graphics.drawLine(0, 0, 0, dimension.height - 1);
            graphics.drawLine(0, 0, dimension.width - 1, 0);
            graphics.setColor(this.cHighlight);
            graphics.drawLine(1, 1, dimension.width - 2, 1);
            graphics.drawLine(1, 1, 1, dimension.height - 2);
            graphics.setColor(this.cDkShadow);
            graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
            graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
            graphics.setColor(this.cShadow);
            graphics.drawLine(1, dimension.height - 2, dimension.width - 2, dimension.height - 2);
            graphics.drawLine(dimension.width - 2, dimension.height - 2, dimension.width - 2, 1);
        }
        switch (this.iViewMode) {
            case 1: {
                switch (this.iTextOrientation) {
                    case 12: {
                        this.drawWestTextImageButton(graphics, new Rectangle(4, 4, dimension.width - 8, dimension.height - 8), this.disabledImage, this.sLabel, 23);
                        return;
                    }
                    case 13: {
                        this.drawEastTextImageButton(graphics, new Rectangle(4, 4, dimension.width - 8, dimension.height - 8), this.disabledImage, this.sLabel, 23);
                        return;
                    }
                    case 10: {
                        this.drawSouthTextImageButton(graphics, new Rectangle(4, 4, dimension.width - 8, dimension.height - 8), this.disabledImage, this.sLabel, 23);
                        return;
                    }
                    case 11: {
                        this.drawNorthTextImageButton(graphics, new Rectangle(4, 4, dimension.width - 8, dimension.height - 8), this.disabledImage, this.sLabel, 23);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 3: {
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = fontMetrics.stringWidth(this.sLabel);
                int n2 = (dimension.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                int n3 = (dimension.width - n) / 2;
                graphics.setColor(this.cHighlight);
                graphics.drawString(this.sLabel, n3 + 1, n2 + 1);
                graphics.setColor(this.cShadow);
                graphics.drawString(this.sLabel, n3, n2);
                return;
            }
            case 2: {
                int n = (dimension.width - 10 - this.disabledImage.getWidth(this.component)) / 2 + 5;
                int n4 = (dimension.height - 10 - this.disabledImage.getHeight(this.component)) / 2 + 5;
                graphics.drawImage(this.disabledImage, n, n4, null, this.component);
                return;
            }
            default: {
                return;
            }
        }
    }

    public void drawSelectedButton(Graphics graphics, Dimension dimension) {
        graphics.setColor(this.cBackground);
        graphics.setFont(eNoDGUIMetrics.buttonFont);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(this.cShadow);
        graphics.drawLine(0, 0, 0, dimension.height - 1);
        graphics.drawLine(0, 0, dimension.width - 1, 0);
        graphics.setColor(this.cDkShadow);
        graphics.drawLine(1, 1, dimension.width - 2, 1);
        graphics.drawLine(1, 1, 1, dimension.height - 2);
        graphics.setColor(this.cHighlight);
        graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, dimension.height - 1, dimension.width - 1, 0);
        graphics.setColor(this.cHighlight);
        graphics.drawLine(1, dimension.height - 2, dimension.width - 2, dimension.height - 2);
        graphics.drawLine(dimension.width - 2, dimension.height - 2, dimension.width - 2, 1);
        switch (this.iViewMode) {
            case 1: {
                switch (this.iTextOrientation) {
                    case 12: {
                        this.drawWestTextImageButton(graphics, new Rectangle(4, 4, dimension.width - 8, dimension.height - 8), this.highlightedImage, this.sLabel, 24);
                        return;
                    }
                    case 13: {
                        this.drawEastTextImageButton(graphics, new Rectangle(4, 4, dimension.width - 8, dimension.height - 8), this.highlightedImage, this.sLabel, 24);
                        return;
                    }
                    case 10: {
                        this.drawSouthTextImageButton(graphics, new Rectangle(4, 4, dimension.width - 8, dimension.height - 8), this.highlightedImage, this.sLabel, 24);
                        return;
                    }
                    case 11: {
                        this.drawNorthTextImageButton(graphics, new Rectangle(4, 4, dimension.width - 8, dimension.height - 8), this.highlightedImage, this.sLabel, 24);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 3: {
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = fontMetrics.stringWidth(this.sLabel);
                graphics.setColor(this.cLabelColor);
                int n2 = (dimension.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                int n3 = (dimension.width - n) / 2;
                graphics.drawString(this.sLabel, n3 + 2, n2 + 2);
                return;
            }
            case 2: {
                int n = (dimension.width - 10 - this.highlightedImage.getWidth(this.component)) / 2 + 4;
                int n4 = (dimension.height - 10 - this.highlightedImage.getHeight(this.component)) / 2 + 4;
                graphics.drawImage(this.highlightedImage, n + 2, n4 + 2, null, this.component);
                return;
            }
            default: {
                return;
            }
        }
    }

    public int getTextOrientation() {
        return this.iTextOrientation;
    }

    public void setTextOrientation(int n) {
        this.iTextOrientation = n;
    }

    public int getViewMode() {
        return this.iViewMode;
    }

    public void setViewMode(int n) {
        this.iViewMode = n;
    }

    private Image createDisabledImage(Image image) {
        if (image == null) {
            return null;
        }
        Image image2 = null;
        try {
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, true);
            if (pixelGrabber.grabPixels()) {
                int n = pixelGrabber.getHeight();
                int n2 = pixelGrabber.getWidth();
                int[] nArray = (int[])pixelGrabber.getPixels();
                int n3 = 0;
                while (n3 < n) {
                    int n4 = 0;
                    while (n4 < n2) {
                        if ((n4 + n3) % 2 == 0) {
                            nArray[n2 * n3 + n4] = nArray[n2 * n3 + n4] & 0xFFFFFF;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                image2 = this.component.createImage(new MemoryImageSource(n2, n, nArray, 0, n2));
                MediaTracker mediaTracker = new MediaTracker(this.component);
                mediaTracker.addImage(image2, 1);
                mediaTracker.waitForID(1);
            }
        }
        catch (Exception exception) {
            System.err.println("ImageButtonPainter.createDisabledImage: " + exception);
            image2 = null;
        }
        this.boolCreatedDisabledImage = true;
        return image2;
    }

    public static Image createEmbossedDisabledImage(Component component, Image image) {
        if (image == null) {
            return null;
        }
        Image image2 = null;
        try {
            image2 = component.createImage(image.getWidth(component) + 1, image.getHeight(component) + 1);
            Graphics graphics = image2.getGraphics();
            graphics.setColor(eNoDGUIMetrics.buttonColor);
            graphics.fillRect(0, 0, image.getWidth(component) + 1, image.getHeight(component) + 1);
            Image image3 = component.createImage(new FilteredImageSource(image.getSource(), new SetDarkColorsToColor(eNoDGUIMetrics.buttonColorDkShadow)));
            Image image4 = component.createImage(new FilteredImageSource(image.getSource(), new SetDarkColorsToColor(eNoDGUIMetrics.buttonColorHighlight)));
            MediaTracker mediaTracker = new MediaTracker(component);
            mediaTracker.addImage(image3, 1);
            mediaTracker.addImage(image4, 1);
            mediaTracker.waitForID(1);
            graphics.drawImage(image4, 1, 1, null, component);
            graphics.drawImage(image3, 0, 0, null, component);
        }
        catch (Exception exception) {
            System.err.println("ImageButtonPainter.createEmbossedDisabledImage() : " + exception);
            image2 = null;
        }
        return image2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Dimension computeMinimumSize() {
        Dimension dimension = new Dimension(0, 0);
        switch (this.iViewMode) {
            case 1: {
                switch (this.iTextOrientation) {
                    case 10: 
                    case 11: {
                        FontMetrics fontMetrics = this.component.getFontMetrics(eNoDGUIMetrics.buttonFont);
                        dimension.width = Math.max(fontMetrics.stringWidth(this.sLabel), this.normalImage.getWidth(this.component)) + 14;
                        dimension.height = this.normalImage.getHeight(this.component) + fontMetrics.getHeight() + 16;
                        return dimension;
                    }
                    case 12: 
                    case 13: {
                        FontMetrics fontMetrics = this.component.getFontMetrics(eNoDGUIMetrics.buttonFont);
                        dimension.width = fontMetrics.stringWidth(this.sLabel) + this.normalImage.getWidth(this.component) + 2 + 14;
                        dimension.height = Math.max(this.normalImage.getHeight(this.component), fontMetrics.getHeight()) + 16;
                        return dimension;
                    }
                    default: {
                        return dimension;
                    }
                }
            }
            case 3: {
                FontMetrics fontMetrics = this.component.getFontMetrics(eNoDGUIMetrics.buttonFont);
                dimension.width = fontMetrics.stringWidth(this.sLabel) + 12;
                dimension.height = fontMetrics.getHeight() + 8;
                return dimension;
            }
            case 2: {
                dimension.width = this.normalImage.getWidth(this.component) + 10;
                dimension.height = this.normalImage.getHeight(this.component) + 10;
                return dimension;
            }
        }
        return dimension;
    }

    protected void drawWestTextImageButton(Graphics graphics, Rectangle rectangle, Image image, String string, int n) {
        graphics.setFont(eNoDGUIMetrics.buttonFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.stringWidth(string);
        Dimension dimension = new Dimension();
        dimension.width = n2 + image.getWidth(this.component) + 2;
        dimension.height = Math.max(fontMetrics.getHeight(), image.getHeight(this.component));
        int n3 = rectangle.x + (rectangle.width - dimension.width) / 2;
        int n4 = rectangle.y + (rectangle.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        if (n == 24) {
            ++n3;
            ++n4;
        }
        if (n == 23) {
            graphics.setColor(this.cHighlight);
            graphics.drawString(string, n3 + 1, n4 + 1);
            graphics.setColor(this.cShadow);
            graphics.drawString(string, n3, n4);
        } else {
            graphics.setColor(this.cLabelColor);
            graphics.drawString(string, n3, n4);
        }
        n3 = rectangle.x + (rectangle.width - dimension.width) / 2 + n2 + 2;
        n4 = rectangle.y + (rectangle.height - image.getHeight(this.component)) / 2;
        if (n == 24) {
            ++n3;
            ++n4;
        }
        graphics.drawImage(image, n3, n4, null, this.component);
    }

    protected void drawEastTextImageButton(Graphics graphics, Rectangle rectangle, Image image, String string, int n) {
        graphics.setFont(eNoDGUIMetrics.buttonFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.stringWidth(string);
        Dimension dimension = new Dimension();
        dimension.width = n2 + image.getWidth(this.component) + 2;
        dimension.height = Math.max(fontMetrics.getHeight(), image.getHeight(this.component));
        int n3 = rectangle.x + (rectangle.width - dimension.width) / 2;
        int n4 = rectangle.y + (rectangle.height - image.getHeight(this.component)) / 2;
        if (n == 24) {
            ++n3;
            ++n4;
        }
        graphics.drawImage(image, n3, n4, null, this.component);
        n3 = rectangle.x + (rectangle.width - dimension.width) / 2 + image.getWidth(this.component) + 2;
        n4 = rectangle.y + (rectangle.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        if (n == 24) {
            ++n3;
            ++n4;
        }
        if (n == 23) {
            graphics.setColor(this.cHighlight);
            graphics.drawString(string, n3 + 1, n4 + 1);
            graphics.setColor(this.cShadow);
            graphics.drawString(string, n3, n4);
            return;
        }
        graphics.setColor(this.cLabelColor);
        graphics.drawString(string, n3, n4);
    }

    protected void drawSouthTextImageButton(Graphics graphics, Rectangle rectangle, Image image, String string, int n) {
        graphics.setFont(eNoDGUIMetrics.buttonFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.stringWidth(this.sLabel);
        int n3 = rectangle.x + rectangle.width / 2 - n2 / 2;
        int n4 = rectangle.y + rectangle.height - 4;
        if (n == 24) {
            ++n3;
            ++n4;
        }
        if (n == 23) {
            graphics.setColor(this.cHighlight);
            graphics.drawString(string, n3 + 1, n4 + 1);
            graphics.setColor(this.cShadow);
            graphics.drawString(string, n3, n4);
        } else {
            graphics.setColor(this.cLabelColor);
            graphics.drawString(string, n3, n4);
        }
        n3 = rectangle.x + rectangle.width / 2 - image.getWidth(this.component) / 2;
        n4 = rectangle.y + (rectangle.height - fontMetrics.getHeight()) / 2 - image.getHeight(this.component) / 2;
        if (n == 24) {
            ++n3;
            ++n4;
        }
        graphics.drawImage(image, n3, n4, null, this.component);
    }

    protected void drawNorthTextImageButton(Graphics graphics, Rectangle rectangle, Image image, String string, int n) {
        graphics.setFont(eNoDGUIMetrics.buttonFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.stringWidth(this.sLabel);
        int n3 = rectangle.x + rectangle.width / 2 - n2 / 2;
        int n4 = rectangle.y + fontMetrics.getAscent();
        if (n == 24) {
            ++n3;
            ++n4;
        }
        if (n == 23) {
            graphics.setColor(this.cHighlight);
            graphics.drawString(string, n3 + 1, n4 + 1);
            graphics.setColor(this.cShadow);
            graphics.drawString(string, n3, n4);
        } else {
            graphics.setColor(this.cLabelColor);
            graphics.drawString(string, n3, n4);
        }
        n3 = rectangle.x + rectangle.width / 2 - image.getWidth(this.component) / 2;
        n4 = rectangle.y + fontMetrics.getHeight() + 2 + (rectangle.height - (rectangle.y + fontMetrics.getHeight() + 2)) / 2 - image.getHeight(this.component) / 2;
        if (n == 24) {
            ++n3;
            ++n4;
        }
        graphics.drawImage(image, n3, n4, null, this.component);
    }

    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    public void finalize() {
        if (this.boolCreatedDisabledImage) {
            this.disabledImage.flush();
        }
    }

    public void setBackground(Color color) {
        this.cBackground = color;
        this.cHighlight = color.brighter();
        this.cShadow = color.darker();
        this.cDkShadow = this.cShadow.darker();
    }
}

