/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar;

import com.ibm.eNetwork.onDemand.common.Timer;
import com.ibm.eNetwork.onDemand.common.TimerListener;
import com.ibm.eNetwork.onDemand.common.TraceLevels;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.eNoDGUIMetrics;
import com.ibm.eNetwork.onDemand.common.gui.imageButton.ImageButton;
import java.awt.Image;
import java.awt.event.MouseEvent;

public class JVCScrollbarButton
extends ImageButton
implements TimerListener,
TraceLevels {
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    protected int iType = 1;
    protected static int iRightWidth = 4;
    protected static int iRightHeight = 7;
    protected static int[] pixRight = new int[]{-16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216, -16777216, 0xFFFFFF, 0xFFFFFF, -16777216, -16777216, -16777216, 0xFFFFFF, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, 0xFFFFFF, -16777216, -16777216, 0xFFFFFF, 0xFFFFFF, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF};
    protected static int iDownWidth = 7;
    protected static int iDownHeight = 4;
    protected static int[] pixDown = new int[]{-16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, 0xFFFFFF, -16777216, -16777216, -16777216, -16777216, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216, -16777216, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF};
    protected static int iLeftWidth = 4;
    protected static int iLeftHeight = 7;
    protected static int[] pixLeft = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216, 0xFFFFFF, 0xFFFFFF, -16777216, -16777216, 0xFFFFFF, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, 0xFFFFFF, -16777216, -16777216, -16777216, 0xFFFFFF, 0xFFFFFF, -16777216, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216};
    protected static int iUpWidth = 7;
    protected static int iUpHeight = 4;
    protected static int[] pixUp = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216, -16777216, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216, -16777216, -16777216, -16777216, -16777216, 0xFFFFFF, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216};
    protected static Timer timer = null;
    protected boolean bTimerStarted = false;
    public static int SCROLL_DELAY = 100;
    protected Image image;

    public JVCScrollbarButton(int n) {
        this.image = this.createButtonImage(n);
        this.setSettings(this.image, null, null, "", false, 2, 10, false, false);
        this.iType = n;
        this.setBackground(eNoDGUIMetrics.scrollbarButtonColor);
        this.commit();
        if (timer == null) {
            timer = new Timer(SCROLL_DELAY);
        }
    }

    protected Image createButtonImage(int n) {
        try {
            int n2 = 0;
            int n3 = 0;
            int[] nArray = null;
            switch (n) {
                case 2: {
                    n2 = iDownWidth;
                    n3 = iDownHeight;
                    nArray = pixDown;
                    break;
                }
                case 3: {
                    n2 = iLeftWidth;
                    n3 = iLeftHeight;
                    nArray = pixLeft;
                    break;
                }
                case 4: {
                    n2 = iRightWidth;
                    n3 = iRightHeight;
                    nArray = pixRight;
                    break;
                }
                default: {
                    n2 = iUpWidth;
                    n3 = iUpHeight;
                    nArray = pixUp;
                }
            }
            Image image = ImagesForCanvas.createImage(this, n2, n3, nArray);
            return image;
        }
        catch (Exception exception) {
            System.err.println("Image for button[] not created");
            return null;
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public int getType() {
        return this.iType;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        timer.addTimerListener(this);
        this.bTimerStarted = true;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.bTimerStarted) {
            timer.addTimerListener(this);
        }
        super.mouseEntered(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.bTimerStarted) {
            timer.removeTimerListener(this);
            this.bTimerStarted = false;
        }
        super.mouseExited(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        timer.removeTimerListener(this);
        this.bTimerStarted = false;
    }

    public void timerFired() {
        MouseEvent mouseEvent = new MouseEvent(this, 0, System.currentTimeMillis(), 0, 1, 1, 1, false);
        super.mousePressed(mouseEvent);
        super.mouseReleased(mouseEvent);
    }

    public void dispose() {
        try {
            this.finalize();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void finalize() throws Throwable {
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
        super.finalize();
    }

    public void requestFocus() {
    }
}

