/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar;

import com.ibm.eNetwork.onDemand.common.TraceLevels;
import com.ibm.eNetwork.onDemand.common.gui.imageButton.ImageButton;
import com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar.JVCScrollbarCanvas;
import com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar.orientations;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Hashtable;

public class JVCScrollbarLayout
implements LayoutManager,
orientations,
TraceLevels {
    protected Hashtable hash = new Hashtable();
    protected int iOrientation = 1;
    public static final String SCROLLBAR_CANVAS = "sbc";
    public static final String TOP_BUTTON = "bTop";
    public static final String BOTTOM_BUTTON = "bBottom";

    public JVCScrollbarLayout(int n) {
        this.iOrientation = n;
    }

    public void addLayoutComponent(String string, Component component) {
        this.hash.put(string, component);
    }

    public void removeLayoutComponent(Component component) {
        this.hash.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        return container.getSize();
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(50, 50);
    }

    public void layoutContainer(Container container) {
        try {
            Dimension dimension = container.getSize();
            ImageButton imageButton = (ImageButton)this.hash.get(TOP_BUTTON);
            ImageButton imageButton2 = (ImageButton)this.hash.get(BOTTOM_BUTTON);
            JVCScrollbarCanvas jVCScrollbarCanvas = (JVCScrollbarCanvas)this.hash.get(SCROLLBAR_CANVAS);
            this.positionTopImageButton(imageButton, dimension);
            this.positionBottomImageButton(imageButton2, dimension);
            this.positionJVCScrollbarCanvas(jVCScrollbarCanvas, imageButton, imageButton2, dimension);
            return;
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(this) + " layout error");
            return;
        }
    }

    protected void positionTopImageButton(ImageButton imageButton, Dimension dimension) {
        if (this.iOrientation == 1) {
            imageButton.setBounds(0, 0, dimension.width, dimension.width);
            return;
        }
        imageButton.setBounds(0, 0, dimension.height, dimension.height);
    }

    protected void positionBottomImageButton(ImageButton imageButton, Dimension dimension) {
        if (this.iOrientation == 1) {
            imageButton.setBounds(0, dimension.height - dimension.width, dimension.width, dimension.width);
            return;
        }
        imageButton.setBounds(dimension.width - dimension.height, 0, dimension.height, dimension.height);
    }

    protected void positionJVCScrollbarCanvas(JVCScrollbarCanvas jVCScrollbarCanvas, ImageButton imageButton, ImageButton imageButton2, Dimension dimension) {
        if (this.iOrientation == 1) {
            jVCScrollbarCanvas.setBounds(0, dimension.width, dimension.width, dimension.height - 2 * dimension.width);
            return;
        }
        jVCScrollbarCanvas.setBounds(dimension.height, 0, dimension.width - 2 * dimension.height, dimension.height);
    }

    public String toString() {
        return "JVCScrollbarLayout";
    }
}

