/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.layoutManagers;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.common.TraceLevels;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Panel;
import java.awt.TextField;
import java.util.Enumeration;
import java.util.Vector;

public class EntryFieldLayout
implements LayoutManager,
LayoutManager2,
TraceLevels {
    private static final String copyright = Copyright.COPYRIGHT_97;
    protected static final boolean DEBUG = false;
    public static final String LABEL = "Label";
    public static final String FIELD = "Field";
    public int nHGap;
    public int nVGap;
    public int nMinWidth;
    public int nHeightLabels;
    public int nHeightFields;
    public boolean bSizesEstablished = false;
    public Vector vLabels;
    public Vector vFields;

    public EntryFieldLayout() {
        this(0, 0);
    }

    public EntryFieldLayout(int n, int n2) {
        this.nHGap = n;
        this.nVGap = n2;
        this.vLabels = new Vector(10);
        this.vFields = new Vector(10);
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        Panel panel = new Panel();
        panel.setLayout(new EntryFieldLayout(5, 5));
        panel.add(new Label("Name"));
        panel.add(new Label("Address"));
        panel.add(new Label("Phone"));
        panel.add(new Label("This is a long label"));
        panel.add(new TextField());
        panel.add(new TextField());
        panel.add(new TextField());
        panel.add(new TextField());
        ((Component)frame).setBackground(Color.lightGray);
        frame.add(panel);
        ((Component)frame).setSize(300, 200);
        frame.show();
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        if (!this.bSizesEstablished) {
            this.establishSizes();
        }
        Dimension dimension = container.getSize();
        if (dimension.width == 0 && dimension.height == 0) {
            return new Dimension(this.nMinWidth * 4, Math.max(this.nHeightLabels, this.nHeightFields));
        }
        return container.getSize();
    }

    public Dimension minimumLayoutSize(Container container) {
        if (!this.bSizesEstablished) {
            this.establishSizes();
        }
        Dimension dimension = new Dimension(this.nMinWidth, Math.max(this.nHeightLabels, this.nHeightFields));
        return dimension;
    }

    protected void establishSizes() {
        Enumeration enumeration = this.vLabels.elements();
        Enumeration enumeration2 = this.vFields.elements();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            Component component2 = (Component)enumeration2.nextElement();
            Dimension dimension = component.getPreferredSize();
            Dimension dimension2 = component2.getPreferredSize();
            this.nMinWidth = Math.max(this.nMinWidth, dimension.width);
            this.nHeightLabels += dimension.height + this.nVGap;
            this.nHeightFields += dimension2.height + this.nVGap;
        }
        this.bSizesEstablished = true;
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        int n = 0;
        if (!this.bSizesEstablished) {
            this.establishSizes();
        }
        Enumeration enumeration = this.vLabels.elements();
        Enumeration enumeration2 = this.vFields.elements();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            Component component2 = (Component)enumeration2.nextElement();
            if (!component.isVisible() || !component2.isVisible()) continue;
            Dimension dimension2 = component.getPreferredSize();
            Dimension dimension3 = component2.getPreferredSize();
            component.setSize(this.nMinWidth, Math.max(dimension2.height, dimension3.height));
            component.setLocation(0, n);
            int n2 = Math.max(dimension.width - this.nMinWidth - this.nHGap, 25);
            int n3 = dimension3.height;
            component2.setSize(n2, n3);
            component2.setLocation(this.nMinWidth + this.nHGap, n);
            n += dimension2.height + this.nVGap;
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        this.tryAddLayoutComponent(component, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryAddLayoutComponent(Component component, Object object) {
        if (object == null) {
            if (component instanceof Label) {
                this.vLabels.addElement(component);
                this.bSizesEstablished = false;
                return true;
            } else {
                if (!(component instanceof TextField)) return false;
                this.vFields.addElement(component);
                this.bSizesEstablished = false;
            }
            return true;
        } else {
            if (!(object instanceof String)) return false;
            if (((String)object).compareTo(LABEL) == 0) {
                this.vLabels.addElement(component);
                this.bSizesEstablished = false;
                return true;
            } else {
                if (((String)object).compareTo(FIELD) != 0) return true;
                this.vFields.addElement(component);
                this.bSizesEstablished = false;
            }
        }
        return true;
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }
}

