/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.layoutManagers;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SpecificGridLayout
implements LayoutManager,
LayoutManager2 {
    int nrows;
    int ncols;
    int hgap;
    int vgap;
    Hashtable hash;

    public SpecificGridLayout(int n, int n2) {
        this(n, n2, 0, 0);
    }

    public SpecificGridLayout(int n, int n2, int n3, int n4) {
        this.nrows = n;
        this.ncols = n2;
        this.hgap = n3;
        this.vgap = n4;
        this.hash = new Hashtable();
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
        Enumeration enumeration = this.hash.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.hash.get(string) != component) continue;
            this.hash.remove(string);
            return;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.hash.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            Dimension dimension = component.getMinimumSize();
            if (dimension.width > n) {
                n = dimension.width;
            }
            if (dimension.height <= n2) continue;
            n2 = dimension.height;
        }
        int n3 = n * this.ncols + this.hgap * (this.ncols - 1) + container.getInsets().left + container.getInsets().right;
        int n4 = n2 * this.nrows + this.vgap * (this.nrows - 1) + container.getInsets().top + container.getInsets().bottom;
        return new Dimension(n3, n4);
    }

    public Dimension preferredLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.hash.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            Dimension dimension = component.getPreferredSize();
            if (dimension.width > n) {
                n = dimension.width;
            }
            if (dimension.height <= n2) continue;
            n2 = dimension.height;
        }
        int n3 = n * this.ncols + this.hgap * (this.ncols - 1) + container.getInsets().left + container.getInsets().right;
        int n4 = n2 * this.nrows + this.vgap * (this.nrows - 1) + container.getInsets().top + container.getInsets().bottom;
        return new Dimension(n3, n4);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getSize().width - insets.left - insets.right;
        int n2 = (n - this.hgap * (this.ncols - 1)) / this.ncols;
        int n3 = container.getSize().height - insets.top - insets.bottom;
        int n4 = (n3 - this.vgap * (this.nrows - 1)) / this.nrows;
        Enumeration enumeration = this.hash.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n5 = Integer.parseInt(stringTokenizer.nextToken().trim());
            int n6 = insets.left + n2 * n5 + this.hgap * n5;
            int n7 = Integer.parseInt(stringTokenizer.nextToken().trim());
            int n8 = insets.top + n4 * n7 + this.vgap * n7;
            Component component = (Component)this.hash.get(string);
            component.setBounds(n6, n8, n2, n4);
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        if (!this.hash.containsKey(object)) {
            this.hash.put(object, component);
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }
}

